-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Sep 13, 2025 at 10:13 AM
-- Server version: 9.1.0
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `pawn_shop`
--

-- --------------------------------------------------------

--
-- Table structure for table `tbladmin`
--

DROP TABLE IF EXISTS `tbladmin`;
CREATE TABLE IF NOT EXISTS `tbladmin` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `AdminName` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `AdminuserName` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `MobileNumber` int NOT NULL,
  `Email` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `Password` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `AdminRegdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tbladmin`
--

INSERT INTO `tbladmin` (`ID`, `AdminName`, `AdminuserName`, `MobileNumber`, `Email`, `Password`, `AdminRegdate`) VALUES
(2, 'Admin', 'admin', 1234567890, 'admin@gmail.com', 'f925916e2754e5e03f75dd58a5733251', '2021-04-19 18:30:00');

-- --------------------------------------------------------

--
-- Table structure for table `tblbankaccounts`
--

DROP TABLE IF EXISTS `tblbankaccounts`;
CREATE TABLE IF NOT EXISTS `tblbankaccounts` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `AccountCode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `BankName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `AccountHolderName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `AccountNumber` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `IFSCCode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `BranchName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `AccountType` enum('Savings','Current','Fixed Deposit','Recurring Deposit') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Savings',
  `Status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Active',
  `Description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `AccountCode` (`AccountCode`),
  UNIQUE KEY `AccountNumber` (`AccountNumber`),
  KEY `idx_bank_name` (`BankName`),
  KEY `idx_account_holder` (`AccountHolderName`),
  KEY `idx_status` (`Status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblbankpledgepayments`
--

DROP TABLE IF EXISTS `tblbankpledgepayments`;
CREATE TABLE IF NOT EXISTS `tblbankpledgepayments` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BankPledgeID` int NOT NULL,
  `PaymentAmount` decimal(10,2) NOT NULL,
  `PaymentDate` date NOT NULL,
  `PaymentType` enum('Interest','Principal','Penalty','Other') COLLATE utf8mb4_general_ci NOT NULL,
  `PaymentMethod` enum('Cash','Bank Transfer','Cheque','DD') COLLATE utf8mb4_general_ci NOT NULL,
  `TransactionReference` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ReceiptNumber` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `CreatedBy` int NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `BankPledgeID` (`BankPledgeID`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblbankpledgeredemptions`
--

DROP TABLE IF EXISTS `tblbankpledgeredemptions`;
CREATE TABLE IF NOT EXISTS `tblbankpledgeredemptions` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BankPledgeID` int NOT NULL,
  `RedemptionAmount` decimal(10,2) NOT NULL,
  `RedemptionDate` date NOT NULL,
  `RedemptionType` enum('Full','Partial') COLLATE utf8mb4_general_ci NOT NULL,
  `PaymentMethod` enum('Cash','Bank Transfer','Cheque','DD') COLLATE utf8mb4_general_ci NOT NULL,
  `TransactionReference` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `DocumentPath` varchar(500) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `CreatedBy` int NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `BankPledgeID` (`BankPledgeID`),
  KEY `CreatedBy` (`CreatedBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblbankpledges`
--

DROP TABLE IF EXISTS `tblbankpledges`;
CREATE TABLE IF NOT EXISTS `tblbankpledges` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PledgeCode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `PawnTransactionID` int NOT NULL,
  `BankAccountID` int NOT NULL,
  `PledgeAmount` decimal(10,2) NOT NULL,
  `InterestRate` decimal(5,2) NOT NULL,
  `PledgeDate` date NOT NULL,
  `MaturityDate` date NOT NULL,
  `Status` enum('Active','Partially Paid','Redeemed','Defaulted') COLLATE utf8mb4_general_ci DEFAULT 'Active',
  `BankLoanNumber` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `DocumentPath` varchar(500) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `PledgeCode` (`PledgeCode`),
  KEY `PawnTransactionID` (`PawnTransactionID`),
  KEY `BankAccountID` (`BankAccountID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblbulkuploadlogs`
--

DROP TABLE IF EXISTS `tblbulkuploadlogs`;
CREATE TABLE IF NOT EXISTS `tblbulkuploadlogs` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `UploadCode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `FileName` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `TotalRecords` int NOT NULL DEFAULT '0',
  `SuccessfulRecords` int NOT NULL DEFAULT '0',
  `FailedRecords` int NOT NULL DEFAULT '0',
  `ErrorLog` text COLLATE utf8mb4_general_ci,
  `UploadType` enum('Excel','CSV','Manual') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'CSV',
  `Status` enum('Processing','Completed','Failed') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Processing',
  `UploadedBy` int NOT NULL,
  `UploadDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `UploadCode` (`UploadCode`),
  KEY `UploadedBy` (`UploadedBy`),
  KEY `UploadDate` (`UploadDate`),
  KEY `Status` (`Status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblcashflow`
--

DROP TABLE IF EXISTS `tblcashflow`;
CREATE TABLE IF NOT EXISTS `tblcashflow` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TransactionCode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `TransactionType` enum('Income','Expense') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Income',
  `Category` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `Description` text COLLATE utf8mb4_general_ci NOT NULL,
  `Amount` decimal(10,2) NOT NULL,
  `TransactionDate` date NOT NULL,
  `PaymentMethod` enum('Cash','Bank Transfer','Card','Cheque','UPI') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Cash',
  `ReferenceNumber` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `CustomerID` int DEFAULT NULL,
  `PawnTransactionID` int DEFAULT NULL,
  `ReceiptPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `Status` enum('Active','Cancelled') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Active',
  `CreatedBy` int NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `TransactionCode` (`TransactionCode`),
  KEY `CustomerID` (`CustomerID`),
  KEY `PawnTransactionID` (`PawnTransactionID`),
  KEY `TransactionDate` (`TransactionDate`),
  KEY `TransactionType` (`TransactionType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblcustomers`
--

DROP TABLE IF EXISTS `tblcustomers`;
CREATE TABLE IF NOT EXISTS `tblcustomers` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CustomerCode` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `Name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `FatherHusbandName` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `MobileNumber` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `Address` text COLLATE utf8mb4_general_ci,
  `IDProofType` enum('Aadhaar Card','PAN Card','Driving License','Voter ID','Passport') COLLATE utf8mb4_general_ci NOT NULL,
  `IDProofNumber` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `PhotoPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `IDProofPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Status` enum('Active','Inactive') COLLATE utf8mb4_general_ci DEFAULT 'Active',
  `CreatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `NameTamil` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `CustomerCode` (`CustomerCode`),
  KEY `idx_name` (`Name`),
  KEY `idx_mobile` (`MobileNumber`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tblcustomers`
--

INSERT INTO `tblcustomers` (`ID`, `CustomerCode`, `Name`, `FatherHusbandName`, `MobileNumber`, `Address`, `IDProofType`, `IDProofNumber`, `PhotoPath`, `IDProofPath`, `Status`, `CreatedDate`, `UpdatedDate`, `NameTamil`) VALUES
(8, 'CUST0222', 'Jegan Sekar', 'Sekar', '8883888012', 'Ramuni Nagar\r\nV.Karisalkulam', 'Aadhaar Card', '84165', 'uploads/customers/photos/photo_Jegan_Sekar_1756969653.jpg', '', 'Active', '2025-09-04 07:07:33', '2025-09-04 07:07:33', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tblincomeexpenses`
--

DROP TABLE IF EXISTS `tblincomeexpenses`;
CREATE TABLE IF NOT EXISTS `tblincomeexpenses` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TransactionCode` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `Type` enum('Income','Expense') COLLATE utf8mb4_general_ci NOT NULL,
  `Category` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `Description` text COLLATE utf8mb4_general_ci,
  `Amount` decimal(10,2) NOT NULL,
  `TransactionDate` date NOT NULL,
  `PaymentMethod` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Receipt` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `CreatedBy` int NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Status` enum('Active','Inactive') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Active',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `TransactionCode` (`TransactionCode`),
  KEY `Type` (`Type`),
  KEY `Category` (`Category`),
  KEY `TransactionDate` (`TransactionDate`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblloanincreases`
--

DROP TABLE IF EXISTS `tblloanincreases`;
CREATE TABLE IF NOT EXISTS `tblloanincreases` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `IncreaseCode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `PawnTransactionID` int NOT NULL,
  `CustomerID` int NOT NULL,
  `IncreaseAmount` decimal(10,2) NOT NULL,
  `NewTotalLoanAmount` decimal(10,2) NOT NULL,
  `IncreaseDate` date NOT NULL,
  `NewDueDate` date DEFAULT NULL,
  `Reason` text COLLATE utf8mb4_general_ci,
  `ApprovedBy` int NOT NULL,
  `Status` enum('Active','Cancelled') COLLATE utf8mb4_general_ci DEFAULT 'Active',
  `CreatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IsEditable` tinyint(1) NOT NULL DEFAULT '1',
  `EditedBy` int DEFAULT NULL,
  `EditedDate` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `IncreaseCode` (`IncreaseCode`),
  KEY `PawnTransactionID` (`PawnTransactionID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `tblloanincreases_ibfk_3` (`ApprovedBy`),
  KEY `tblloanincreases_ibfk_4` (`EditedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblpawnitems`
--

DROP TABLE IF EXISTS `tblpawnitems`;
CREATE TABLE IF NOT EXISTS `tblpawnitems` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PawnTransactionID` int NOT NULL,
  `ItemSequence` int NOT NULL DEFAULT '1',
  `ItemType` enum('Gold','Silver','Diamond','Platinum','Other') COLLATE utf8mb4_general_ci NOT NULL,
  `ItemDescription` text COLLATE utf8mb4_general_ci NOT NULL,
  `ItemWeight` decimal(8,3) NOT NULL,
  `ItemPurity` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `EstimatedValue` decimal(10,2) NOT NULL,
  `ItemPhotoPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `CreatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `PawnTransactionID` (`PawnTransactionID`),
  KEY `idx_item_sequence` (`ItemSequence`),
  KEY `idx_pawn_item_type` (`ItemType`),
  KEY `idx_pawn_item_weight` (`ItemWeight`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tblpawnitems`
--

INSERT INTO `tblpawnitems` (`ID`, `PawnTransactionID`, `ItemSequence`, `ItemType`, `ItemDescription`, `ItemWeight`, `ItemPurity`, `EstimatedValue`, `ItemPhotoPath`, `CreatedDate`, `UpdatedDate`) VALUES
(4, 10, 1, 'Gold', 'hngbfdfgnb', 10.000, '22', 2300.00, '', '2025-09-13 09:21:09', '2025-09-13 09:21:09'),
(5, 10, 2, 'Gold', 'mhgbfxvc', 10.000, '22', 4000.00, '', '2025-09-13 09:21:09', '2025-09-13 09:21:09'),
(6, 11, 1, 'Gold', 'hfhgh', 10.000, '22', 20000.00, '', '2025-09-13 09:25:11', '2025-09-13 09:25:11'),
(7, 11, 2, 'Gold', 'ring', 4.000, '22', 10000.00, '', '2025-09-13 09:25:11', '2025-09-13 09:25:11'),
(9, 9, 1, 'Gold', 'test', 10.000, '22', 4000.00, '', '2025-09-13 09:42:05', '2025-09-13 09:42:05');

--
-- Triggers `tblpawnitems`
--
DROP TRIGGER IF EXISTS `update_pawn_totals_after_item_delete`;
DELIMITER $$
CREATE TRIGGER `update_pawn_totals_after_item_delete` AFTER DELETE ON `tblpawnitems` FOR EACH ROW BEGIN
    UPDATE `tblpawntransactions` 
    SET 
        `TotalItems` = (SELECT COUNT(*) FROM `tblpawnitems` WHERE `PawnTransactionID` = OLD.PawnTransactionID),
        `TotalWeight` = (SELECT COALESCE(SUM(`ItemWeight`), 0) FROM `tblpawnitems` WHERE `PawnTransactionID` = OLD.PawnTransactionID),
        `TotalEstimatedValue` = (SELECT COALESCE(SUM(`EstimatedValue`), 0) FROM `tblpawnitems` WHERE `PawnTransactionID` = OLD.PawnTransactionID),
        `UpdatedDate` = CURRENT_TIMESTAMP
    WHERE `ID` = OLD.PawnTransactionID;
END
$$
DELIMITER ;
DROP TRIGGER IF EXISTS `update_pawn_totals_after_item_insert`;
DELIMITER $$
CREATE TRIGGER `update_pawn_totals_after_item_insert` AFTER INSERT ON `tblpawnitems` FOR EACH ROW BEGIN
    UPDATE `tblpawntransactions` 
    SET 
        `TotalItems` = (SELECT COUNT(*) FROM `tblpawnitems` WHERE `PawnTransactionID` = NEW.PawnTransactionID),
        `TotalWeight` = (SELECT SUM(`ItemWeight`) FROM `tblpawnitems` WHERE `PawnTransactionID` = NEW.PawnTransactionID),
        `TotalEstimatedValue` = (SELECT SUM(`EstimatedValue`) FROM `tblpawnitems` WHERE `PawnTransactionID` = NEW.PawnTransactionID),
        `UpdatedDate` = CURRENT_TIMESTAMP
    WHERE `ID` = NEW.PawnTransactionID;
END
$$
DELIMITER ;
DROP TRIGGER IF EXISTS `update_pawn_totals_after_item_update`;
DELIMITER $$
CREATE TRIGGER `update_pawn_totals_after_item_update` AFTER UPDATE ON `tblpawnitems` FOR EACH ROW BEGIN
    UPDATE `tblpawntransactions` 
    SET 
        `TotalItems` = (SELECT COUNT(*) FROM `tblpawnitems` WHERE `PawnTransactionID` = NEW.PawnTransactionID),
        `TotalWeight` = (SELECT SUM(`ItemWeight`) FROM `tblpawnitems` WHERE `PawnTransactionID` = NEW.PawnTransactionID),
        `TotalEstimatedValue` = (SELECT SUM(`EstimatedValue`) FROM `tblpawnitems` WHERE `PawnTransactionID` = NEW.PawnTransactionID),
        `UpdatedDate` = CURRENT_TIMESTAMP
    WHERE `ID` = NEW.PawnTransactionID;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `tblpawntransactions`
--

DROP TABLE IF EXISTS `tblpawntransactions`;
CREATE TABLE IF NOT EXISTS `tblpawntransactions` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PawnCode` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `CustomerID` int NOT NULL,
  `ItemType` enum('Gold','Silver','Diamond','Platinum','Other') COLLATE utf8mb4_general_ci NOT NULL,
  `ItemDescription` text COLLATE utf8mb4_general_ci NOT NULL,
  `ItemWeight` decimal(8,3) NOT NULL,
  `ItemPurity` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `EstimatedValue` decimal(10,2) NOT NULL,
  `LoanAmount` decimal(10,2) NOT NULL,
  `InterestRate` decimal(5,2) NOT NULL DEFAULT '2.00',
  `LoanDate` date NOT NULL,
  `DueDate` date NOT NULL,
  `TotalItems` int NOT NULL DEFAULT '1',
  `TotalWeight` decimal(10,3) DEFAULT NULL,
  `TotalEstimatedValue` decimal(12,2) DEFAULT NULL,
  `Status` enum('Active','Redeemed','Auctioned','Extended') COLLATE utf8mb4_general_ci DEFAULT 'Active',
  `ItemPhotoPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `CreatedBy` int NOT NULL,
  `CreatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `OriginalLoanAmount` decimal(10,2) DEFAULT NULL,
  `TotalLoanIncreases` decimal(10,2) DEFAULT '0.00',
  `CurrentLoanAmount` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `PawnCode` (`PawnCode`),
  KEY `CustomerID` (`CustomerID`),
  KEY `CreatedBy` (`CreatedBy`),
  KEY `idx_pawn_code` (`PawnCode`),
  KEY `idx_item_type` (`ItemType`),
  KEY `idx_status` (`Status`),
  KEY `idx_loan_date` (`LoanDate`),
  KEY `idx_loan_amount` (`LoanAmount`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tblpawntransactions`
--

INSERT INTO `tblpawntransactions` (`ID`, `PawnCode`, `CustomerID`, `ItemType`, `ItemDescription`, `ItemWeight`, `ItemPurity`, `EstimatedValue`, `LoanAmount`, `InterestRate`, `LoanDate`, `DueDate`, `TotalItems`, `TotalWeight`, `TotalEstimatedValue`, `Status`, `ItemPhotoPath`, `Notes`, `CreatedBy`, `CreatedDate`, `UpdatedDate`, `OriginalLoanAmount`, `TotalLoanIncreases`, `CurrentLoanAmount`) VALUES
(9, 'PAWN20254233', 8, 'Gold', 'test', 10.000, '22', 4000.00, 23000.00, 2.00, '2025-09-13', '2025-12-13', 1, 10.000, 4000.00, 'Active', '', '', 1, '2025-09-13 09:10:45', '2025-09-13 09:42:05', 23000.00, 0.00, 23000.00),
(10, 'PAWN20255797', 8, 'Gold', 'hngbfdfgnb', 20.000, '', 6300.00, 135000.00, 2.00, '2025-09-13', '2025-12-13', 2, 20.000, 6300.00, 'Active', NULL, '', 1, '2025-09-13 09:20:47', '2025-09-13 09:21:09', 135000.00, 0.00, 135000.00),
(11, 'PAWN20257304', 8, 'Gold', 'hfhgh', 14.000, '', 30000.00, 25000.00, 2.00, '2025-09-13', '2025-12-13', 2, 14.000, 30000.00, 'Active', NULL, '', 1, '2025-09-13 09:25:11', '2025-09-13 09:25:11', 25000.00, 0.00, 25000.00);

-- --------------------------------------------------------

--
-- Table structure for table `tblpaymentcollections`
--

DROP TABLE IF EXISTS `tblpaymentcollections`;
CREATE TABLE IF NOT EXISTS `tblpaymentcollections` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CollectionCode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `PawnTransactionID` int NOT NULL,
  `CustomerID` int NOT NULL,
  `CollectionDate` date NOT NULL,
  `DaysOverdue` int NOT NULL DEFAULT '0',
  `InterestDays` int NOT NULL,
  `InterestAmount` decimal(10,2) NOT NULL,
  `DailyInterestRate` decimal(8,6) DEFAULT '0.000000',
  `PrincipalAmount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `TotalAmountDue` decimal(10,2) NOT NULL,
  `AmountPaid` decimal(10,2) NOT NULL,
  `BalanceAmount` decimal(10,2) NOT NULL,
  `PaymentMethod` enum('Cash','Bank Transfer','Card','Cheque','UPI') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Cash',
  `ReferenceNumber` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Notes` text COLLATE utf8mb4_general_ci,
  `ReceiptPrinted` tinyint(1) NOT NULL DEFAULT '0',
  `CreatedBy` int NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `DiscountAmount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `DailyInterestAmount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `MonthlyInterestAmount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `IsEditable` tinyint(1) NOT NULL DEFAULT '1',
  `EditedBy` int DEFAULT NULL,
  `EditedDate` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `CollectionCode` (`CollectionCode`),
  KEY `PawnTransactionID` (`PawnTransactionID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `CollectionDate` (`CollectionDate`),
  KEY `tblpaymentcollections_ibfk_3` (`EditedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblredemptions`
--

DROP TABLE IF EXISTS `tblredemptions`;
CREATE TABLE IF NOT EXISTS `tblredemptions` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `RedemptionCode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `PawnTransactionID` int NOT NULL,
  `CustomerID` int NOT NULL,
  `RedemptionDate` date NOT NULL,
  `TotalAmountDue` decimal(10,2) NOT NULL,
  `TotalAmountPaid` decimal(10,2) NOT NULL,
  `FinalPaymentAmount` decimal(10,2) NOT NULL,
  `DiscountGiven` decimal(10,2) NOT NULL DEFAULT '0.00',
  `PaymentMethod` enum('Cash','Bank Transfer','Card','Cheque','UPI','No Payment') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Cash',
  `ReferenceNumber` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ReceiverName` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `ReceiverMobileNumber` varchar(15) COLLATE utf8mb4_general_ci NOT NULL,
  `ReceiverIDProofType` enum('Aadhaar Card','PAN Card','Driving License','Voter ID','Passport') COLLATE utf8mb4_general_ci NOT NULL,
  `ReceiverIDProofNumber` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `ReceiverIDProofPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ReceiverPhotoPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ReceiverSignaturePath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `RelationshipToCustomer` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ItemsReturnedDescription` text COLLATE utf8mb4_general_ci NOT NULL,
  `ReturnedItemPhotoPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ReturnCondition` enum('Good','Fair','Damaged') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Good',
  `ReturnNotes` text COLLATE utf8mb4_general_ci,
  `CustomerAuthorization` enum('Self','Authorized Person') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Self',
  `AuthorizationLetter` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Status` enum('Active','Completed','Cancelled') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Completed',
  `ProcessedBy` int NOT NULL,
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IsEditable` tinyint(1) NOT NULL DEFAULT '1',
  `EditedBy` int DEFAULT NULL,
  `EditedDate` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RedemptionCode` (`RedemptionCode`),
  KEY `PawnTransactionID` (`PawnTransactionID`),
  KEY `CustomerID` (`CustomerID`),
  KEY `ProcessedBy` (`ProcessedBy`),
  KEY `EditedBy` (`EditedBy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblshopdetails`
--

DROP TABLE IF EXISTS `tblshopdetails`;
CREATE TABLE IF NOT EXISTS `tblshopdetails` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ShopName` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `ShopNameTamil` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Address` text COLLATE utf8mb4_general_ci,
  `AddressTamil` text COLLATE utf8mb4_general_ci,
  `MobileNumber` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `PhoneNumber` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Email` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Website` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `LicenseNumber` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `GSTNumber` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `LogoPath` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `FooterNote` text COLLATE utf8mb4_general_ci,
  `FooterNoteTamil` text COLLATE utf8mb4_general_ci,
  `IsActive` tinyint(1) NOT NULL DEFAULT '1',
  `CreatedAt` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedAt` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tblusers`
--

DROP TABLE IF EXISTS `tblusers`;
CREATE TABLE IF NOT EXISTS `tblusers` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `UserName` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `FullName` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `UserType` enum('admin','staff') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'staff',
  `MobileNumber` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Email` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Password` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `RegDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `CanEdit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tblusers`
--

INSERT INTO `tblusers` (`ID`, `UserName`, `FullName`, `UserType`, `MobileNumber`, `Email`, `Password`, `RegDate`, `CanEdit`) VALUES
(1, 'admin', 'Admin User', 'admin', '1234567890', 'admin@ihita.com', '0192023a7bbd73250516f069df18b500', '2025-06-09 13:56:57', 1),
(2, 'staff1', 'Staff User', 'staff', '9876543210', 'staff1@ihita.com', '4297f44b13955235245b2497399d7a93', '2025-06-09 13:56:57', 0),
(3, 'jegan', 'Jegan', 'staff', '1234567890', '', '39f7fd5224e736d8f8dada96c85f17f0', '2025-06-09 16:13:05', 0);

-- --------------------------------------------------------

--
-- Stand-in structure for view `vw_pawn_transactions_with_items`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `vw_pawn_transactions_with_items`;
CREATE TABLE IF NOT EXISTS `vw_pawn_transactions_with_items` (
`TransactionID` int
,`PawnCode` varchar(20)
,`CustomerID` int
,`LoanAmount` decimal(10,2)
,`InterestRate` decimal(5,2)
,`LoanDate` date
,`DueDate` date
,`Status` enum('Active','Redeemed','Auctioned','Extended')
,`TotalItems` int
,`TotalWeight` decimal(10,3)
,`TotalEstimatedValue` decimal(12,2)
,`Notes` text
,`CreatedDate` timestamp
,`ItemsSummary` text
,`ActualItemCount` bigint
);

-- --------------------------------------------------------

--
-- Structure for view `vw_pawn_transactions_with_items`
--
DROP TABLE IF EXISTS `vw_pawn_transactions_with_items`;

DROP VIEW IF EXISTS `vw_pawn_transactions_with_items`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `vw_pawn_transactions_with_items`  AS SELECT `pt`.`ID` AS `TransactionID`, `pt`.`PawnCode` AS `PawnCode`, `pt`.`CustomerID` AS `CustomerID`, `pt`.`LoanAmount` AS `LoanAmount`, `pt`.`InterestRate` AS `InterestRate`, `pt`.`LoanDate` AS `LoanDate`, `pt`.`DueDate` AS `DueDate`, `pt`.`Status` AS `Status`, `pt`.`TotalItems` AS `TotalItems`, `pt`.`TotalWeight` AS `TotalWeight`, `pt`.`TotalEstimatedValue` AS `TotalEstimatedValue`, `pt`.`Notes` AS `Notes`, `pt`.`CreatedDate` AS `CreatedDate`, group_concat(concat(`pi`.`ItemType`,': ',`pi`.`ItemDescription`,' (',`pi`.`ItemWeight`,'g)') order by `pi`.`ItemSequence` ASC separator '; ') AS `ItemsSummary`, count(`pi`.`ID`) AS `ActualItemCount` FROM (`tblpawntransactions` `pt` left join `tblpawnitems` `pi` on((`pt`.`ID` = `pi`.`PawnTransactionID`))) GROUP BY `pt`.`ID` ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `tblbankpledgepayments`
--
ALTER TABLE `tblbankpledgepayments`
  ADD CONSTRAINT `tblbankpledgepayments_ibfk_1` FOREIGN KEY (`BankPledgeID`) REFERENCES `tblbankpledges` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblbankpledgepayments_ibfk_2` FOREIGN KEY (`CreatedBy`) REFERENCES `tblusers` (`ID`) ON DELETE RESTRICT;

--
-- Constraints for table `tblbankpledgeredemptions`
--
ALTER TABLE `tblbankpledgeredemptions`
  ADD CONSTRAINT `tblbankpledgeredemptions_ibfk_1` FOREIGN KEY (`BankPledgeID`) REFERENCES `tblbankpledges` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblbankpledgeredemptions_ibfk_2` FOREIGN KEY (`CreatedBy`) REFERENCES `tblusers` (`ID`) ON DELETE RESTRICT;

--
-- Constraints for table `tblbankpledges`
--
ALTER TABLE `tblbankpledges`
  ADD CONSTRAINT `tblbankpledges_ibfk_1` FOREIGN KEY (`PawnTransactionID`) REFERENCES `tblpawntransactions` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblbankpledges_ibfk_2` FOREIGN KEY (`BankAccountID`) REFERENCES `tblbankaccounts` (`ID`) ON DELETE RESTRICT;

--
-- Constraints for table `tblbulkuploadlogs`
--
ALTER TABLE `tblbulkuploadlogs`
  ADD CONSTRAINT `tblbulkuploadlogs_ibfk_1` FOREIGN KEY (`UploadedBy`) REFERENCES `tblusers` (`ID`) ON DELETE RESTRICT;

--
-- Constraints for table `tblcashflow`
--
ALTER TABLE `tblcashflow`
  ADD CONSTRAINT `tblcashflow_ibfk_1` FOREIGN KEY (`CustomerID`) REFERENCES `tblcustomers` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `tblloanincreases`
--
ALTER TABLE `tblloanincreases`
  ADD CONSTRAINT `tblloanincreases_ibfk_1` FOREIGN KEY (`PawnTransactionID`) REFERENCES `tblpawntransactions` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblloanincreases_ibfk_2` FOREIGN KEY (`CustomerID`) REFERENCES `tblcustomers` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblloanincreases_ibfk_3` FOREIGN KEY (`ApprovedBy`) REFERENCES `tblusers` (`ID`),
  ADD CONSTRAINT `tblloanincreases_ibfk_4` FOREIGN KEY (`EditedBy`) REFERENCES `tblusers` (`ID`);

--
-- Constraints for table `tblpawnitems`
--
ALTER TABLE `tblpawnitems`
  ADD CONSTRAINT `tblpawnitems_ibfk_1` FOREIGN KEY (`PawnTransactionID`) REFERENCES `tblpawntransactions` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `tblpawntransactions`
--
ALTER TABLE `tblpawntransactions`
  ADD CONSTRAINT `tblpawntransactions_ibfk_1` FOREIGN KEY (`CustomerID`) REFERENCES `tblcustomers` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblpawntransactions_ibfk_2` FOREIGN KEY (`CreatedBy`) REFERENCES `tblusers` (`ID`);

--
-- Constraints for table `tblpaymentcollections`
--
ALTER TABLE `tblpaymentcollections`
  ADD CONSTRAINT `tblpaymentcollections_ibfk_1` FOREIGN KEY (`PawnTransactionID`) REFERENCES `tblpawntransactions` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblpaymentcollections_ibfk_2` FOREIGN KEY (`CustomerID`) REFERENCES `tblcustomers` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblpaymentcollections_ibfk_3` FOREIGN KEY (`EditedBy`) REFERENCES `tblusers` (`ID`);

--
-- Constraints for table `tblredemptions`
--
ALTER TABLE `tblredemptions`
  ADD CONSTRAINT `tblredemptions_ibfk_1` FOREIGN KEY (`PawnTransactionID`) REFERENCES `tblpawntransactions` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblredemptions_ibfk_2` FOREIGN KEY (`CustomerID`) REFERENCES `tblcustomers` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `tblredemptions_ibfk_3` FOREIGN KEY (`ProcessedBy`) REFERENCES `tblusers` (`ID`),
  ADD CONSTRAINT `tblredemptions_ibfk_4` FOREIGN KEY (`EditedBy`) REFERENCES `tblusers` (`ID`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
