<?php
session_start();

$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found.");
}
include_once($configPath);
include_once(__DIR__ . '/includes/brand.php');

if (!isset($con) || !$con) {
    die("Error: Database connection failed.");
}

if (!isset($_GET['id'])) {
    die("Error: Pawn Transaction ID not provided.");
}

$pawnId = (int)$_GET['id'];

// Get shop details
$shopQuery = mysqli_query($con, "SELECT * FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
$shopDetails = mysqli_fetch_assoc($shopQuery);

// Get pawn transaction details with customer
$query = "SELECT p.*, c.ID as CustomerID, c.Name, c.MobileNumber, c.CustomerCode, c.Address, c.PhotoPath as CustomerPhotoPath,
          COALESCE(u.FullName, u.UserName, 'System User') as CreatedByUser,
          COALESCE(p.TotalItems, 1) as DisplayTotalItems,
          COALESCE(p.TotalWeight, p.ItemWeight) as DisplayTotalWeight,
          COALESCE(p.TotalEstimatedValue, p.EstimatedValue) as DisplayTotalEstimatedValue
          FROM tblpawntransactions p
          JOIN tblcustomers c ON p.CustomerID = c.ID
          LEFT JOIN tblusers u ON p.CreatedBy = u.ID
          WHERE p.ID = $pawnId";
$result = mysqli_query($con, $query);
$pawn = mysqli_fetch_assoc($result);

if (!$pawn) {
    die("Error: Pawn transaction not found.");
}

// Get individual items
$itemsQuery = "SELECT * FROM tblpawnitems WHERE PawnTransactionID = $pawnId ORDER BY ItemSequence";
$itemsResult = mysqli_query($con, $itemsQuery);
$items = [];
while ($item = mysqli_fetch_assoc($itemsResult)) {
    $items[] = $item;
}

// If no items found, create one from main transaction for backward compatibility
if (empty($items) && $pawn['ItemDescription']) {
    $items[] = array(
        'ItemType' => $pawn['ItemType'],
        'ItemDescription' => $pawn['ItemDescription'],
        'ItemWeight' => $pawn['ItemWeight'],
        'ItemPurity' => $pawn['ItemPurity'],
        'EstimatedValue' => $pawn['EstimatedValue'],
        'ItemSequence' => 1
    );
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Pawn Receipt - ' . htmlspecialchars($pawn['PawnCode'])); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        /* Optimized A4 with minimal margins for maximum space utilization */
        @page { size: A4; margin: 6mm 8mm 8mm 8mm; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Times New Roman', Times, serif; font-size: 9pt; line-height: 1.15; color: #333; padding-top: 50mm; }
        .receipt-container { width: 100%; max-width: 210mm; margin: 0 auto; padding: 2mm; border: 1px solid #999; background: #fff; }
        .header { text-align: center; border-bottom: 1px solid #333; padding-bottom: 2px; margin-bottom: 3px; }
        .receipt-title { font-size: 11pt; font-weight: bold; background: #f5f5f5; padding: 2px; border: 1px solid #bbb; color: #495057; }
        .receipt-info { display: flex; justify-content: space-between; margin: 3px 0; font-size: 9pt; background: #f8f9fa; padding: 3px 6px; border: 1px solid #dee2e6; }
        .info-table { width: 100%; border-collapse: collapse; margin: 2px 0; }
        .info-table td { padding: 1px 4px; border-bottom: 1px solid #dee2e6; font-size: 8pt; vertical-align: top; }
        .info-table .label { font-weight: 600; width: 30%; color: #495057; }
        .section-header { font-size: 10pt; font-weight: 600; background: #e9ecef; padding: 2px; margin: 4px 0 2px 0; text-align: center; color: #495057; border: 1px solid #dee2e6; }
        .item-header { background-color: #f8f9fa; font-weight: 600; padding: 2px; text-align: center; font-size: 9pt; color: #495057; }
        .summary-table { border: 1px solid #495057; background-color: #f8f9fa; }
        .highlight-row { background-color: #e3f2fd; font-weight: 600; }
        .due-date-row { background-color: #fff3cd; font-weight: 600; }
        .footer { margin-top: 4px; text-align: center; font-size: 7pt; border-top: 1px solid #dee2e6; padding-top: 3px; color: #6c757d; }
        .signature-section { display: flex; justify-content: space-between; margin-top: 6px; font-size: 8pt; }
        .signature-box { text-align: center; width: 45%; }
        .signature-line { border-bottom: 1px solid #333; height: 15px; margin-bottom: 2px; }
        .customer-photo { max-height: 50px; max-width: 40px; border: 1px solid #ccc; padding: 1px; border-radius: 2px; object-fit: cover; }
        .back-button { position: fixed; top: 10px; left: 10px; padding: 4px 8px; background: #6c757d; color: white; border: none; border-radius: 3px; cursor: pointer; text-decoration: none; font-size: 10px; }
        .print-button { position: fixed; top: 10px; right: 10px; padding: 4px 8px; background: #007bff; color: white; border: none; border-radius: 3px; cursor: pointer; font-size: 10px; }

        /* Compact Pocket Card */
        .pocket-card { width: 85mm; border: 1px dashed #333; padding: 4mm; border-radius: 3px; margin: 8px 0 0 0; page-break-inside: avoid; font-size: 9pt; }
        .pc-title { font-weight: bold; font-size: 10pt; text-align: center; margin-bottom: 3mm; }
        .pc-grid { display: grid; grid-template-columns: 1fr 1.3fr; gap: 3mm; align-items: start; }
        .pc-photo { display: grid; grid-template-columns: 1fr 1fr; gap: 2mm; }
        .pc-photo img { width: 30mm; height: 30mm; object-fit: cover; border: 1px solid #bbb; border-radius: 2px; }
        .pc-row { display: flex; justify-content: space-between; border-bottom: 1px dotted #bbb; padding: 1px 0; font-size: 9pt; }
        .pc-label { font-weight: 600; color: #555; }
        .pc-value { font-weight: 700; color: #222; text-align: right; }
        .cut-here { text-align: center; font-size: 8pt; color: #666; margin-top: 2mm; }

        /* Optimized multi-column layout for items */
        .items-grid { display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 3px; }
        .single-item .items-grid { grid-template-columns: 1fr; }
        .two-items .items-grid { grid-template-columns: 1fr 1fr; }
        
        @media print {
            .no-print { display: none; }
            body { margin: 0; padding-top: 50mm; font-size: 8pt; }
            .receipt-container { border: none; margin: 0; padding: 1mm; }
            .customer-photo { max-height: 40px; max-width: 30px; }
            .pc-photo img { width: 20mm; height: 20mm; }
            .info-table td { padding: 1px 2px; font-size: 7pt; }
            .section-header { font-size: 9pt; padding: 1px; margin: 2px 0 1px 0; }
            .receipt-title { font-size: 10pt; padding: 1px; }
            .receipt-info { padding: 2px 4px; margin: 2px 0; font-size: 8pt; }
        }
    </style>
</head>
<body>
    <a href="pawn_transactions.php" class="back-button no-print">← Back</a>
    <button class="print-button no-print" onclick="window.print()">🖨️ Print</button>
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="receipt-title">Pawn Receipt</div>
        </div>
        <!-- Receipt Info -->
        <div class="receipt-info" style="background: #f8f9fa; padding: 12px; border: 1px solid #dee2e6; margin: 15px 0;">
            <div><strong>Pawn Code:</strong> <?php echo htmlspecialchars($pawn['PawnCode']); ?></div>
            <div><strong>Date:</strong> <?php echo date('d/m/Y', strtotime($pawn['LoanDate'])); ?></div>
        </div>
        <!-- Customer Details -->
        <div class="section-header">Customer Details</div>
        <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 4px;">
            <table class="info-table" style="border: 1px solid #dee2e6;">
                <tr>
                    <td class="label">Customer Name:</td>
                    <td><?php echo htmlspecialchars($pawn['Name']); ?></td>
                </tr>
                <tr>
                    <td class="label">Mobile Number:</td>
                    <td><?php echo htmlspecialchars($pawn['MobileNumber']); ?></td>
                </tr>
                <tr>
                    <td class="label">Customer Code:</td>
                    <td><?php echo htmlspecialchars($pawn['CustomerCode']); ?></td>
                </tr>
            </table>
            </table>
            <?php if (!empty($pawn['CustomerPhotoPath'])) { 
                $customerPhotoPath = ltrim($pawn['CustomerPhotoPath'], '/');
            ?>
            <div style="text-align: center; border: 1px solid #dee2e6; padding: 2px;">
                <div style="font-size: 7pt; font-weight: 600; color: #495057; margin-bottom: 2px;">Customer Photo</div>
                <?php if (file_exists(__DIR__ . '/' . $customerPhotoPath)) { ?>
                    <img src="<?php echo $customerPhotoPath; ?>" alt="Customer Photo" class="customer-photo">
                <?php } else { ?>
                    <span style="font-size: 7pt; color: #666;">Photo not available</span>
                <?php } ?>
            </div>
            <?php } else { ?>
            <div></div>
            <?php } ?>
        </div>
        <!-- Items Details -->
        <div class="section-header">
            Items Details (<?php echo count($items); ?> item<?php echo count($items) > 1 ? 's' : ''; ?>)
        </div>
        
        <div class="items-grid <?php 
            $itemCount = count($items);
            if ($itemCount == 1) echo 'single-item';
            elseif ($itemCount == 2) echo 'two-items';
        ?>">
        <?php foreach ($items as $index => $item) { ?>
            <table class="info-table" style="margin-bottom: 2px; border: 1px solid #dee2e6; font-size: 7pt;">
                <tr>
                    <td colspan="2" class="item-header">
                        Item #<?php echo ($index + 1); ?>
                    </td>
                </tr>
                <tr>
                    <td class="label">Type:</td>
                    <td><?php echo htmlspecialchars($item['ItemType']); ?></td>
                </tr>
                <tr>
                    <td class="label">Description:</td>
                    <td style="font-size: 8pt;"><?php echo htmlspecialchars($item['ItemDescription']); ?></td>
                </tr>
                <?php if (!empty($item['ItemPhotoPath'])) { ?>
                <tr>
                    <td class="label">Photo:</td>
                    <td>
                        <?php 
                        $photoPath = ltrim($item['ItemPhotoPath'], '/');
                        if (file_exists(__DIR__ . '/' . $photoPath)) {
                        ?>
                            <img src="<?php echo $photoPath; ?>" alt="Item Photo" style="max-height:50px; max-width:60px; border:1px solid #ccc; padding:1px; border-radius:2px; object-fit:cover;">
                        <?php } else { ?>
                            <span style="font-size:8pt; color:#666;">No photo</span>
                        <?php } ?>
                    </td>
                </tr>
                <?php } ?>
                <tr>
                    <td class="label">Weight:</td>
                    <td><?php echo number_format($item['ItemWeight'], 3); ?>g</td>
                </tr>
                <tr>
                    <td class="label">Purity:</td>
                    <td><?php echo htmlspecialchars($item['ItemPurity']); ?></td>
                </tr>
                <tr>
                    <td class="label">Est. Value:</td>
                    <td>₹<?php echo number_format($item['EstimatedValue'], 2); ?></td>
                </tr>
            </table>
        <?php } ?>
        </div>
        
        <!-- Totals -->
        <div class="section-header">Transaction Summary</div>
        <table class="info-table summary-table">
            <tr>
                <td class="label">Total Items:</td>
                <td><?php echo count($items); ?></td>
            </tr>
            <tr>
                <td class="label">Total Weight:</td>
                <td><?php echo number_format($pawn['DisplayTotalWeight'], 3); ?> g</td>
            </tr>
            <tr>
                <td class="label">Total Estimated Value:</td>
                <td>₹<?php echo number_format($pawn['DisplayTotalEstimatedValue'], 2); ?></td>
            </tr>
            <tr class="highlight-row">
                <td class="label">Loan Amount:</td>
                <td style="font-size: 16px; font-weight: bold;">₹<?php echo number_format($pawn['LoanAmount'], 2); ?></td>
            </tr>
            <tr>
                <td class="label">Interest Rate:</td>
                <td>15% per year (<?php echo number_format((0.15/365)*100, 4); ?>% per day)</td>
            </tr>
            <tr>
                <td class="label">Loan Date:</td>
                <td><?php echo date('d/m/Y', strtotime($pawn['LoanDate'])); ?></td>
            </tr>
            <tr class="due-date-row">
                <td class="label">Due Date:</td>
                <td style="font-size: 16px; font-weight: bold;"><?php echo date('d/m/Y', strtotime($pawn['DueDate'])); ?></td>
            </tr>
        </table>
        <?php if ($pawn['Notes']) { ?>
        <table class="info-table">
            <tr>
                <td class="label">Notes:</td>
                <td><?php echo htmlspecialchars($pawn['Notes']); ?></td>
            </tr>
        </table>
        <?php } ?>
        <!-- Signatures -->
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Customer Signature</div>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Authorized Signature</div>
            </div>
        </div>
        <!-- Footer -->
        <div class="footer">
            <p><strong><?php echo $shopDetails && ($shopDetails['FooterNote'] || $shopDetails['FooterNoteTamil']) ? htmlspecialchars($shopDetails['FooterNote'] ?: $shopDetails['FooterNoteTamil']) : 'Thank you for your business!'; ?></strong></p>
                <p>This receipt is computer generated. Please verify and retain for your records.</p>
        </div>
        <div class="cut-here">✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ ✂ (Cut here)</div>
    </div>
    
    <!-- Pocket Card (Detachable) -->
    <?php 
        $firstItem = count($items) > 0 ? $items[0] : null; 
        $custPhoto = !empty($pawn['CustomerPhotoPath']) ? ltrim($pawn['CustomerPhotoPath'], '/') : '';
        $itemPhoto = ($firstItem && !empty($firstItem['ItemPhotoPath'])) ? ltrim($firstItem['ItemPhotoPath'], '/') : (!empty($pawn['ItemPhotoPath']) ? ltrim($pawn['ItemPhotoPath'], '/') : '');
    ?>
    <div class="pocket-card">
        <div class="pc-title">Pawn Card</div>
        <div class="pc-grid">
            <div class="pc-photo">
                <div>
                    <?php if ($custPhoto && file_exists(__DIR__ . '/' . $custPhoto)) { ?>
                        <img src="<?php echo $custPhoto; ?>" alt="Customer Photo">
                    <?php } else { ?>
                        <div style="width:30mm;height:30mm;border:1px solid #bbb;border-radius:2px;display:flex;align-items:center;justify-content:center;font-size:8pt;color:#888;">No Photo</div>
                    <?php } ?>
                </div>
                <div>
                    <?php if ($itemPhoto && file_exists(__DIR__ . '/' . $itemPhoto)) { ?>
                        <img src="<?php echo $itemPhoto; ?>" alt="Item Photo">
                    <?php } else { ?>
                        <div style="width:30mm;height:30mm;border:1px solid #bbb;border-radius:2px;display:flex;align-items:center;justify-content:center;font-size:8pt;color:#888;">No Photo</div>
                    <?php } ?>
                </div>
            </div>
            <div>
                <div class="pc-row"><span class="pc-label">Code</span><span class="pc-value"><?php echo htmlspecialchars($pawn['PawnCode']); ?></span></div>
                <div class="pc-row"><span class="pc-label">Customer</span><span class="pc-value" style="font-size:8pt;"><?php echo htmlspecialchars(substr($pawn['Name'], 0, 12) . (strlen($pawn['Name']) > 12 ? '...' : '')); ?></span></div>
                <div class="pc-row"><span class="pc-label">Mobile</span><span class="pc-value"><?php echo htmlspecialchars($pawn['MobileNumber']); ?></span></div>
                <div class="pc-row"><span class="pc-label">Amount</span><span class="pc-value">₹<?php echo number_format($pawn['LoanAmount'], 0); ?></span></div>
                <div class="pc-row"><span class="pc-label">Date</span><span class="pc-value"><?php echo date('d/m/y', strtotime($pawn['LoanDate'])); ?></span></div>
                <div class="pc-row"><span class="pc-label">Due</span><span class="pc-value"><?php echo date('d/m/y', strtotime($pawn['DueDate'])); ?></span></div>
                <?php if ($firstItem) { ?>
                    <div class="pc-row"><span class="pc-label">Item</span><span class="pc-value" style="font-size:8pt;"><?php echo htmlspecialchars(substr($firstItem['ItemType'], 0, 8)); ?></span></div>
                    <div class="pc-row"><span class="pc-label">Weight</span><span class="pc-value"><?php echo number_format($firstItem['ItemWeight'], 1); ?>g</span></div>
                <?php } ?>
                <div class="pc-row"><span class="pc-label">Status</span><span class="pc-value" style="font-size:8pt;"><?php echo htmlspecialchars($pawn['Status']); ?></span></div>
            </div>
        </div>
    </div>
    
    <script>
        // Auto print when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>
