<?php
session_start();
$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) die("Error: Database configuration file not found.");
include_once($configPath);
if (!isset($_SESSION['uid'])) { header('location:logout.php'); exit(); }
$con = $con ?? null;
if (!$con) die("Error: Database connection failed.");

// Filters
$dateFrom = isset($_GET['date_from']) ? mysqli_real_escape_string($con, $_GET['date_from']) : date('Y-m-01');
$dateTo = isset($_GET['date_to']) ? mysqli_real_escape_string($con, $_GET['date_to']) : date('Y-m-t');
$type_filter = isset($_GET['type']) ? mysqli_real_escape_string($con, $_GET['type']) : '';
$category_filter = isset($_GET['category']) ? mysqli_real_escape_string($con, $_GET['category']) : '';
$payment_method_filter = isset($_GET['payment_method']) ? mysqli_real_escape_string($con, $_GET['payment_method']) : '';
$ref_filter = isset($_GET['ref_code']) ? mysqli_real_escape_string($con, $_GET['ref_code']) : '';
$desc_filter = isset($_GET['desc']) ? mysqli_real_escape_string($con, $_GET['desc']) : '';

// Build WHERE conditions for each unioned query
$where = "1=1";
$where .= " AND txn_date BETWEEN '$dateFrom' AND '$dateTo'";
if ($type_filter) $where .= " AND txn_type = '$type_filter'";
if ($category_filter) $where .= " AND category = '$category_filter'";
if ($payment_method_filter) $where .= " AND PaymentMethod = '$payment_method_filter'";
if ($ref_filter) $where .= " AND ref_code LIKE '%$ref_filter%'";
if ($desc_filter) $where .= " AND Description LIKE '%$desc_filter%'";

// Master Query with all fields and a type label for filtering
$masterQuery = "
SELECT 
    TransactionDate as txn_date,
    'Income/Expense' as txn_type,
    Type as category,
    Category as sub_category,
    Description,
    CASE WHEN Type='Income' THEN Amount ELSE 0 END as amount_in,
    CASE WHEN Type='Expense' THEN Amount ELSE 0 END as amount_out,
    0 as discount,
    PaymentMethod,
    TransactionCode as ref_code
FROM tblincomeexpenses
WHERE TransactionDate BETWEEN '$dateFrom' AND '$dateTo'
UNION ALL
SELECT 
    CollectionDate as txn_date,
    'Pawn Collection' as txn_type,
    'Interest' as category,
    '' as sub_category,
    Notes,
    AmountPaid as amount_in,
    0 as amount_out,
    DiscountAmount as discount,
    PaymentMethod,
    CollectionCode as ref_code
FROM tblpaymentcollections
WHERE CollectionDate BETWEEN '$dateFrom' AND '$dateTo'
UNION ALL
SELECT 
    RedemptionDate as txn_date,
    'Pawn Redemption' as txn_type,
    'Redemption' as category,
    '' as sub_category,
    ItemsReturnedDescription,
    FinalPaymentAmount as amount_in,
    0 as amount_out,
    DiscountGiven as discount,
    PaymentMethod,
    RedemptionCode as ref_code
FROM tblredemptions
WHERE RedemptionDate BETWEEN '$dateFrom' AND '$dateTo'
UNION ALL
SELECT 
    PaymentDate as txn_date,
    'Bank Pledge Payment' as txn_type,
    PaymentType as category,
    PaymentMethod as sub_category,
    Notes,
    CASE WHEN PaymentType IN ('Interest','Other') THEN PaymentAmount ELSE 0 END as amount_in,
    CASE WHEN PaymentType IN ('Principal','Penalty') THEN PaymentAmount ELSE 0 END as amount_out,
    0 as discount,
    PaymentMethod,
    ReceiptNumber as ref_code
FROM tblbankpledgepayments
WHERE PaymentDate BETWEEN '$dateFrom' AND '$dateTo'
UNION ALL
SELECT 
    RedemptionDate as txn_date,
    'Bank Pledge Redemption' as txn_type,
    RedemptionType as category,
    PaymentMethod as sub_category,
    Notes,
    RedemptionAmount as amount_in,
    0 as amount_out,
    0 as discount,
    PaymentMethod,
    DocumentPath as ref_code
FROM tblbankpledgeredemptions
WHERE RedemptionDate BETWEEN '$dateFrom' AND '$dateTo'
";

// Wrap as subquery for filtering
$masterQuery = "SELECT * FROM ($masterQuery) as master WHERE $where ORDER BY txn_date DESC, ref_code DESC";

$result = mysqli_query($con, $masterQuery);

// For filter dropdowns: get all unique types, categories, payment methods
$typeOptions = [
    'Income/Expense' => 'Income/Expense',
    'Pawn Collection' => 'Pawn Collection',
    'Pawn Redemption' => 'Pawn Redemption',
    'Bank Pledge Payment' => 'Bank Pledge Payment',
    'Bank Pledge Redemption' => 'Bank Pledge Redemption'
];
$categoryOptions = [];
$paymentMethodOptions = [];
$catRes = mysqli_query($con, "
    SELECT DISTINCT Type as category FROM tblincomeexpenses
    UNION
    SELECT DISTINCT PaymentType FROM tblbankpledgepayments
    UNION
    SELECT 'Interest'
    UNION
    SELECT 'Redemption'
    UNION
    SELECT DISTINCT RedemptionType FROM tblbankpledgeredemptions
");
while($row = mysqli_fetch_row($catRes)) {
    if ($row[0]) $categoryOptions[$row[0]] = $row[0];
}
$payRes = mysqli_query($con, "
    SELECT DISTINCT PaymentMethod FROM tblincomeexpenses WHERE PaymentMethod IS NOT NULL AND PaymentMethod != ''
    UNION
    SELECT DISTINCT PaymentMethod FROM tblpaymentcollections WHERE PaymentMethod IS NOT NULL AND PaymentMethod != ''
    UNION
    SELECT DISTINCT PaymentMethod FROM tblredemptions WHERE PaymentMethod IS NOT NULL AND PaymentMethod != ''
    UNION
    SELECT DISTINCT PaymentMethod FROM tblbankpledgepayments WHERE PaymentMethod IS NOT NULL AND PaymentMethod != ''
    UNION
    SELECT DISTINCT PaymentMethod FROM tblbankpledgeredemptions WHERE PaymentMethod IS NOT NULL AND PaymentMethod != ''
");
while($row = mysqli_fetch_row($payRes)) {
    if ($row[0]) $paymentMethodOptions[$row[0]] = $row[0];
}

// Calculate totals
$totalIn = $totalOut = $totalDiscount = 0;
$rows = [];
if ($result && mysqli_num_rows($result) > 0) {
    while($row = mysqli_fetch_assoc($result)) {
        $totalIn += $row['amount_in'];
        $totalOut += $row['amount_out'];
        $totalDiscount += $row['discount'];
        $rows[] = $row;
    }
}
$netCashflow = $totalIn - $totalOut;

// Opening/Closing balance calculation
$openingQuery = "
SELECT
    SUM(amount_in) as total_in,
    SUM(amount_out) as total_out
FROM (
    SELECT 
        TransactionDate as txn_date,
        CASE WHEN Type='Income' THEN Amount ELSE 0 END as amount_in,
        CASE WHEN Type='Expense' THEN Amount ELSE 0 END as amount_out
    FROM tblincomeexpenses
    WHERE TransactionDate < '$dateFrom'
    UNION ALL
    SELECT 
        CollectionDate as txn_date,
        AmountPaid as amount_in,
        0 as amount_out
    FROM tblpaymentcollections
    WHERE CollectionDate < '$dateFrom'
    UNION ALL
    SELECT 
        RedemptionDate as txn_date,
        FinalPaymentAmount as amount_in,
        0 as amount_out
    FROM tblredemptions
    WHERE RedemptionDate < '$dateFrom'
    UNION ALL
    SELECT 
        PaymentDate as txn_date,
        CASE WHEN PaymentType IN ('Interest','Other') THEN PaymentAmount ELSE 0 END as amount_in,
        CASE WHEN PaymentType IN ('Principal','Penalty') THEN PaymentAmount ELSE 0 END as amount_out
    FROM tblbankpledgepayments
    WHERE PaymentDate < '$dateFrom'
    UNION ALL
    SELECT 
        RedemptionDate as txn_date,
        RedemptionAmount as amount_in,
        0 as amount_out
    FROM tblbankpledgeredemptions
    WHERE RedemptionDate < '$dateFrom'
) as opening
";
$openingRes = mysqli_query($con, $openingQuery);
$openingRow = mysqli_fetch_assoc($openingRes);
$openingBalance = ($openingRow['total_in'] ?? 0) - ($openingRow['total_out'] ?? 0);
$closingBalance = $openingBalance + $netCashflow;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Master Cashflow Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <style>
        .filter-container {
            background: #f8f9fc;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .summary-cards { margin-bottom: 20px; }
        .income-card { border-left: 4px solid #1cc88a; }
        .expense-card { border-left: 4px solid #e74a3b; }
        .discount-card { border-left: 4px solid #f6c23e; }
        .net-card { border-left: 4px solid #36b9cc; }
        .balance-card { border-left: 4px solid #4e73df; }
        .table-sm td, .table-sm th { font-size: 0.95em; }
        .badge-type { font-size: 0.85em; }
        .badge-income { background: #1cc88a; color: #fff; }
        .badge-expense { background: #e74a3b; color: #fff; }
        .badge-collection { background: #36b9cc; color: #fff; }
        .badge-redemption { background: #f6c23e; color: #fff; }
        .badge-bank { background: #4e73df; color: #fff; }
        .badge-category { background: #858796; color: #fff; }
        .badge-payment { background: #6f42c1; color: #fff; }
        .income { color: #1cc88a; font-weight: bold; }
        .expense { color: #e74a3b; font-weight: bold; }
        .discount { color: #f6c23e; font-weight: bold; }
        .table-striped tbody tr:nth-of-type(odd) { background-color: #f8f9fc; }
        @media print {
            .no-print { display: none !important; }
        }
    </style>
</head>
<body id="page-top">
<div id="wrapper">
    <?php include_once('includes/sidebar.php'); ?>
    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <?php include_once('includes/topbar.php'); ?>
            <div class="container-fluid mt-4">
                <div class="d-sm-flex align-items-center justify-content-between mb-4">
                    <h3 class="mb-0">Master Cashflow Report</h3>
                    <div class="no-print">
                        <button onclick="window.print()" class="btn btn-primary btn-sm">
                            <i class="fas fa-print"></i> Print
                        </button>
                    </div>
                </div>
                <!-- Opening/Closing Balance -->
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="card balance-card shadow h-100 py-2">
                            <div class="card-body">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Opening Balance</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($openingBalance, 2); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card balance-card shadow h-100 py-2">
                            <div class="card-body">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Closing Balance</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($closingBalance, 2); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Filter Section -->
                <div class="filter-container no-print">
                    <form class="row" method="get">
                        <div class="col-md-2 mb-2">
                            <label>From</label>
                            <input type="date" name="date_from" class="form-control" value="<?php echo $dateFrom; ?>">
                        </div>
                        <div class="col-md-2 mb-2">
                            <label>To</label>
                            <input type="date" name="date_to" class="form-control" value="<?php echo $dateTo; ?>">
                        </div>
                        <div class="col-md-2 mb-2">
                            <label>Type</label>
                            <select name="type" class="form-control">
                                <option value="">All Types</option>
                                <?php foreach($typeOptions as $k=>$v) { ?>
                                    <option value="<?php echo $k; ?>" <?php if($type_filter==$k) echo 'selected'; ?>><?php echo $v; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-2">
                            <label>Category</label>
                            <select name="category" class="form-control">
                                <option value="">All Categories</option>
                                <?php foreach($categoryOptions as $k=>$v) { ?>
                                    <option value="<?php echo $k; ?>" <?php if($category_filter==$k) echo 'selected'; ?>><?php echo $v; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-2">
                            <label>Payment</label>
                            <select name="payment_method" class="form-control">
                                <option value="">All Methods</option>
                                <?php foreach($paymentMethodOptions as $k=>$v) { ?>
                                    <option value="<?php echo $k; ?>" <?php if($payment_method_filter==$k) echo 'selected'; ?>><?php echo $v; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-2">
                            <label>Reference</label>
                            <input type="text" name="ref_code" class="form-control" value="<?php echo htmlspecialchars($ref_filter); ?>" placeholder="Ref/Code">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label>Description</label>
                            <input type="text" name="desc" class="form-control" value="<?php echo htmlspecialchars($desc_filter); ?>" placeholder="Description">
                        </div>
                        <div class="col-md-2 mb-2 align-self-end">
                            <button type="submit" class="btn btn-primary btn-block"><i class="fas fa-filter"></i> Filter</button>
                        </div>
                        <div class="col-md-2 mb-2 align-self-end">
                            <a href="master-cashflow-report.php" class="btn btn-secondary btn-block"><i class="fas fa-refresh"></i> Clear</a>
                        </div>
                    </form>
                </div>
                <!-- Summary Cards -->
                <div class="row summary-cards">
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card income-card shadow h-100 py-2">
                            <div class="card-body">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total In</div>
                                <div class="h5 mb-0 font-weight-bold income">₹<?php echo number_format($totalIn,2); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card expense-card shadow h-100 py-2">
                            <div class="card-body">
                                <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">Total Out</div>
                                <div class="h5 mb-0 font-weight-bold expense">₹<?php echo number_format($totalOut,2); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card discount-card shadow h-100 py-2">
                            <div class="card-body">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Total Discount</div>
                                <div class="h5 mb-0 font-weight-bold discount">₹<?php echo number_format($totalDiscount,2); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card net-card shadow h-100 py-2">
                            <div class="card-body">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Net Cashflow</div>
                                <div class="h5 mb-0 font-weight-bold <?php echo $netCashflow>=0?'income':'expense'; ?>">
                                    ₹<?php echo number_format($netCashflow,2); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Table -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3 d-flex justify-content-between align-items-center">
                        <h6 class="m-0 font-weight-bold text-primary">Detailed Cashflow</h6>
                        <small class="text-muted">Showing <?php echo count($rows); ?> records</small>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-sm">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Category</th>
                                        <th>Sub Category</th>
                                        <th>Description</th>
                                        <th>Amount In</th>
                                        <th>Amount Out</th>
                                        <th>Discount</th>
                                        <th>Payment</th>
                                        <th>Reference</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (count($rows) > 0) {
                                        foreach($rows as $row) {
                                            $typeBadge = '';
                                            if ($row['txn_type'] == 'Income/Expense') $typeBadge = 'badge-income';
                                            else if ($row['txn_type'] == 'Pawn Collection') $typeBadge = 'badge-collection';
                                            else if ($row['txn_type'] == 'Pawn Redemption') $typeBadge = 'badge-redemption';
                                            else if (strpos($row['txn_type'], 'Bank') !== false) $typeBadge = 'badge-bank';
                                            else $typeBadge = 'badge-category';
                                            $catBadge = 'badge-category';
                                            $payBadge = 'badge-payment';
                                            ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($row['txn_date']); ?></td>
                                                <td><span class="badge badge-type <?php echo $typeBadge; ?>"><?php echo htmlspecialchars($row['txn_type']); ?></span></td>
                                                <td><span class="badge badge-type <?php echo $catBadge; ?>"><?php echo htmlspecialchars($row['category']); ?></span></td>
                                                <td><span class="badge badge-type badge-light"><?php echo htmlspecialchars($row['sub_category']); ?></span></td>
                                                <td><small><?php echo htmlspecialchars($row['Description']); ?></small></td>
                                                <td class="income"><?php echo $row['amount_in'] ? '₹'.number_format($row['amount_in'],2) : '-'; ?></td>
                                                <td class="expense"><?php echo $row['amount_out'] ? '₹'.number_format($row['amount_out'],2) : '-'; ?></td>
                                                <td class="discount"><?php echo $row['discount'] ? '₹'.number_format($row['discount'],2) : '-'; ?></td>
                                                <td><span class="badge badge-type <?php echo $payBadge; ?>"><?php echo htmlspecialchars($row['PaymentMethod']); ?></span></td>
                                                <td><small><?php echo htmlspecialchars($row['ref_code']); ?></small></td>
                                            </tr>
                                            <?php
                                        }
                                    } else {
                                        echo '<tr><td colspan="10" class="text-center">No records found</td></tr>';
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-right">Total</th>
                                        <th class="income">₹<?php echo number_format($totalIn,2); ?></th>
                                        <th class="expense">₹<?php echo number_format($totalOut,2); ?></th>
                                        <th class="discount">₹<?php echo number_format($totalDiscount,2); ?></th>
                                        <th colspan="2"></th>
                                    </tr>
                                    <tr>
                                        <th colspan="5" class="text-right">Net Cashflow (In - Out)</th>
                                        <th colspan="2" class="<?php echo ($totalIn-$totalOut)>=0?'income':'expense'; ?>">
                                            ₹<?php echo number_format($totalIn-$totalOut,2); ?>
                                        </th>
                                        <th colspan="3"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php'); ?>
        </div>
    </div>
    <?php include_once('includes/footer2.php'); ?>
</div>
</body>
</html>
