<?php
session_start();
include_once('includes/config.php');
// Load branding helper
include_once(__DIR__ . '/includes/brand.php');
if(!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

// Get all customers
$query = "SELECT c.*, 
          COUNT(p.ID) as total_pawns,
          SUM(CASE WHEN p.Status = 'Active' THEN 1 ELSE 0 END) as active_pawns,
          SUM(p.LoanAmount) as total_loan_amount
          FROM tblcustomers c 
          LEFT JOIN tblpawntransactions p ON c.ID = p.CustomerID 
          GROUP BY c.ID 
          ORDER BY c.Name ASC";
$result = mysqli_query($con, $query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Manage Customers'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <link href="vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>
<body id="page-top">
<div id="wrapper">
    <?php include_once('includes/sidebar.php'); ?>
    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <?php include_once('includes/topbar.php'); ?>
            <div class="container-fluid">
                <div class="d-sm-flex align-items-center justify-content-between mb-4">
                    <h1 class="h3 mb-0 text-gray-800">Manage Customers</h1>
                    <a href="add-customer.php" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add New Customer
                    </a>
                </div>

                <?php if (isset($_SESSION['msg'])) { ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <i class="fas fa-check-circle"></i> <?php echo $_SESSION['msg']; unset($_SESSION['msg']); ?>
                        <button type="button" class="close" data-dismiss="alert">&times;</button>
                    </div>
                <?php } ?>

                <div class="card shadow mb-4">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="dataTable">
                                <thead>
                                    <tr>
                                        <th>Customer Code</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Total Pawns</th>
                                        <th>Active Pawns</th>
                                        <th>Total Loan Amount</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($customer = mysqli_fetch_assoc($result)) { ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($customer['CustomerCode']); ?></td>
                                            <td><?php echo htmlspecialchars($customer['Name']); ?></td>
                                            <td><?php echo htmlspecialchars($customer['MobileNumber']); ?></td>
                                            <td><?php echo $customer['total_pawns']; ?></td>
                                            <td>
                                                <?php if ($customer['active_pawns'] > 0) { ?>
                                                    <span class="badge badge-warning"><?php echo $customer['active_pawns']; ?></span>
                                                <?php } else { ?>
                                                    <span class="badge badge-success">0</span>
                                                <?php } ?>
                                            </td>
                                            <td>₹<?php echo number_format($customer['total_loan_amount'] ?? 0, 2); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo $customer['Status'] == 'Active' ? 'success' : 'secondary'; ?>">
                                                    <?php echo $customer['Status']; ?>
                                                </span>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="view-customer.php?id=<?php echo $customer['ID']; ?>" class="btn btn-info btn-sm" title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="edit-customer.php?id=<?php echo $customer['ID']; ?>" class="btn btn-primary btn-sm" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="customer-jewel-history-report.php?search_customer=<?php echo urlencode($customer['Name']); ?>" class="btn btn-success btn-sm" title="View History">
                                                        <i class="fas fa-history"></i>
                                                    </a>
                                                    <a href="delete-customer.php?id=<?php echo $customer['ID']; ?>" class="btn btn-danger btn-sm" title="Delete Customer" onclick="return confirm('Are you sure you want to delete this customer and all related records?')">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php'); ?>
        </div>
    </div>
    <?php include_once('includes/footer2.php'); ?>
</div>

<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="vendor/datatables/jquery.dataTables.min.js"></script>
<script src="vendor/datatables/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function() {
    $('#dataTable').DataTable({
        "order": [[ 1, "asc" ]]
    });
});
</script>
</body>
</html>
