<?php
session_start();
include_once('includes/config.php');
include_once(__DIR__ . '/includes/brand.php');

if (!isset($_SESSION['uid']) || !isset($_GET['id'])) {
    header('location:logout.php');
    exit();
}

$increaseId = (int)$_GET['id'];

// Get loan increase details
$query = "SELECT li.*, p.PawnCode, p.ItemDescription, p.ItemType, p.ItemWeight, p.ItemPhotoPath,
          c.Name, c.MobileNumber, c.Address, c.CustomerCode, c.PhotoPath as CustomerPhotoPath,
          u.FullName as ApprovedByName
          FROM tblloanincreases li
          JOIN tblpawntransactions p ON li.PawnTransactionID = p.ID
          JOIN tblcustomers c ON li.CustomerID = c.ID
          JOIN tblusers u ON li.ApprovedBy = u.ID
          WHERE li.ID = $increaseId";

$result = mysqli_query($con, $query);
$increase = mysqli_fetch_assoc($result);

if (!$increase) {
    die("Loan increase record not found!");
}

// Get shop details
$shopQuery = mysqli_query($con, "SELECT * FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
$shopDetails = mysqli_fetch_assoc($shopQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Loan Increase Receipt'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        @page {
            size: A4;
            margin: 20mm 20mm 20mm 20mm;
            margin-top: 50mm;
        }
        
        body {
            font-family: 'Times New Roman', Times, serif;
            font-size: 14pt;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            margin-top: 5cm;
            background: white;
        }
        
        .receipt-container {
            width: 100%;
            max-width: 210mm;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            background: white;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        
        .receipt-title {
            font-size: 18pt;
            font-weight: bold;
            background: #f8f9fa;
            padding: 10px;
            border: 1px solid #dee2e6;
            color: #495057;
        }
        
        .customer-photo {
            max-height: 120px;
            max-width: 100px;
            border: 1px solid #ccc;
            padding: 2px;
            border-radius: 4px;
        }
        
        .receipt-info {
            display: flex;
            justify-content: space-between;
            margin: 8px 0;
            font-size: 10px;
        }
        
        .details-section {
            margin: 10px 0;
        }
        
        .section-title {
            font-weight: bold;
            background: #e8e8e8;
            padding: 3px 5px;
            border-left: 3px solid #d4af37;
            margin-bottom: 5px;
            font-size: 11px;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 2px 0;
            border-bottom: 1px dotted #ccc;
            font-size: 10px;
        }
        
        .detail-label {
            font-weight: bold;
            width: 55%;
        }
        
        .detail-value {
            width: 45%;
            text-align: right;
        }
        
        .amount-section {
            background: #f9f9f9;
            border: 2px solid #d4af37;
            padding: 8px;
            margin: 12px 0;
        }
        
        .total-amount {
            font-size: 14px;
            font-weight: bold;
            text-align: center;
            color: #d4af37;
        }
        
        .signature-section {
            margin-top: 20px;
            display: flex;
            justify-content: space-between;
        }
        
        .signature-box {
            text-align: center;
            width: 48%;
        }
        
        .signature-line {
            border-bottom: 1px solid #000;
            margin-bottom: 3px;
            height: 25px;
        }
        
        .footer {
            margin-top: 15px;
            text-align: center;
            font-size: 9px;
            border-top: 1px solid #ccc;
            padding-top: 8px;
        }
        
        .back-button {
            position: fixed;
            top: 10px;
            left: 10px;
            background: #6c757d;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            text-decoration: none;
        }
        
        .print-button {
            position: fixed;
            top: 10px;
            right: 10px;
            background: #007bff;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            
            body {
                margin: 0;
                padding: 0;
            }
            
            .receipt-container {
                border: none;
                margin: 0;
                padding: 3mm;
            }
        }
    </style>
</head>
<body>
    <a href="due_collection.php?action=increase" class="back-button no-print">← Back</a>
    <button class="print-button no-print" onclick="window.print()">🖨️ Print</button>
    
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="receipt-title">Loan Increase Receipt</div>
        </div>
        
        <!-- Receipt Info -->
        <div class="receipt-info">
            <div><strong>Receipt No:</strong> <?php echo $increase['IncreaseCode']; ?></div>
            <div><strong>Date:</strong> <?php echo date('d/m/Y', strtotime($increase['IncreaseDate'])); ?></div>
            <div><strong>Time:</strong> <?php echo date('h:i A'); ?></div>
        </div>
        
        <!-- Customer Details -->
        <div class="details-section">
            <div class="section-title">Customer Details</div>
            <div class="detail-row">
                <span class="detail-label">Name:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['Name']); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Customer Code:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['CustomerCode']); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Mobile Number:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['MobileNumber']); ?></span>
            </div>
            <?php if (!empty($increase['CustomerPhotoPath'])) { 
                $customerPhotoPath = ltrim($increase['CustomerPhotoPath'], '/');
            ?>
            <div class="detail-row">
                <span class="detail-label">Customer Photo:</span>
                <span class="detail-value">
                    <?php if (file_exists(__DIR__ . '/' . $customerPhotoPath)) { ?>
                        <img src="<?php echo $customerPhotoPath; ?>" alt="Customer Photo" class="customer-photo">
                    <?php } else { ?>
                        <span class="text-muted">Photo not available</span>
                    <?php } ?>
                </span>
            </div>
            <?php } ?>
        </div>
        
        <!-- Pawn Details -->
        <div class="details-section">
            <div class="section-title">Pawn Details</div>
            <div class="detail-row">
                <span class="detail-label">Pawn Code:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['PawnCode']); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Item Type:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['ItemType']); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Item Description:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['ItemDescription']); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Weight:</span>
                <span class="detail-value"><?php echo number_format($increase['ItemWeight'], 3); ?> g</span>
            </div>
            <?php if (!empty($increase['ItemPhotoPath'])) { 
                $itemPhotoPath = ltrim($increase['ItemPhotoPath'], '/');
            ?>
            <div class="detail-row">
                <span class="detail-label">Item Photo:</span>
                <span class="detail-value">
                    <?php if (file_exists(__DIR__ . '/' . $itemPhotoPath)) { ?>
                        <img src="<?php echo $itemPhotoPath; ?>" alt="Item Photo" class="customer-photo">
                    <?php } else { ?>
                        <span class="text-muted">Photo not available</span>
                    <?php } ?>
                </span>
            </div>
            <?php } ?>
        </div>
        
        <!-- Loan Increase Details -->
        <div class="details-section">
            <div class="section-title">Loan Increase Details</div>
            <div class="detail-row">
                <span class="detail-label">Previous Loan Amount:</span>
                <span class="detail-value">₹<?php echo number_format($increase['NewTotalLoanAmount'] - $increase['IncreaseAmount'], 2); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Increase Amount:</span>
                <span class="detail-value">₹<?php echo number_format($increase['IncreaseAmount'], 2); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">New Due Date:</span>
                <span class="detail-value"><?php echo date('d/m/Y', strtotime($increase['NewDueDate'])); ?></span>
            </div>
            <?php if (!empty($increase['Reason'])) { ?>
            <div class="detail-row">
                <span class="detail-label">Reason:</span>
                <span class="detail-value"><?php echo htmlspecialchars($increase['Reason']); ?></span>
            </div>
            <?php } ?>
        </div>
        
        <!-- Amount Section -->
        <div class="amount-section">
            <div class="total-amount">
                New Total Loan Amount<br>
                <span style="font-size: 18px;">₹<?php echo number_format($increase['NewTotalLoanAmount'], 2); ?></span>
            </div>
        </div>
        
        <!-- Signature Section -->
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Customer Signature</div>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Authorized By<br><?php echo htmlspecialchars($increase['ApprovedByName']); ?></div>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <div><strong><?php echo $shopDetails && ($shopDetails['FooterNote'] || $shopDetails['FooterNoteTamil']) ? htmlspecialchars($shopDetails['FooterNote'] ?: $shopDetails['FooterNoteTamil']) : 'Thank you for your business!'; ?></strong></div>
            <div style="margin-top: 5px;">
                <strong>Note:</strong> This receipt is important. Please keep it safe.
            </div>
        </div>
    </div>
    
    <script>
        // Auto print when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
        
        // Close window after printing
        window.onafterprint = function() {
            window.close();
        };
    </script>
</body>
</html>
