<?php
session_start();

$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found.");
}

include_once($configPath);
include_once(__DIR__ . '/includes/brand.php');

if (!isset($con) || !$con) {
    die("Error: Database connection failed.");
}

if (!isset($_GET['id'])) {
    die("Error: Redemption ID not provided.");
}

$redemptionId = (int)$_GET['id'];

// Get redemption details with related data
$query = "SELECT r.*, p.PawnCode, p.ItemDescription, p.ItemWeight, p.ItemType, p.LoanAmount, p.InterestRate, p.LoanDate, p.DueDate, p.ItemPhotoPath,
          c.Name, c.MobileNumber, c.CustomerCode, c.Address, c.PhotoPath as CustomerPhotoPath,
          COALESCE(u.FullName, u.UserName, 'System User') as ProcessedByName
          FROM tblredemptions r
          JOIN tblpawntransactions p ON r.PawnTransactionID = p.ID
          JOIN tblcustomers c ON r.CustomerID = c.ID
          LEFT JOIN tblusers u ON r.ProcessedBy = u.ID
          WHERE r.ID = $redemptionId";

$result = mysqli_query($con, $query);
$redemption = mysqli_fetch_assoc($result);

if (!$redemption) {
    die("Error: Redemption record not found.");
}

// Get shop details
$shopQuery = mysqli_query($con, "SELECT * FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
$shopDetails = mysqli_fetch_assoc($shopQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Jewel Redemption Receipt - ' . htmlspecialchars($redemption['RedemptionCode'])); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        @page { size: A4; margin: 20mm 20mm 20mm 20mm; margin-top: 50mm; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Times New Roman', Times, serif; font-size: 14pt; line-height: 1.6; color: #333; margin-top: 5cm; }
        .receipt-container { width: 100%; max-width: 210mm; margin: 0 auto; padding: 20px; border: 1px solid #ddd; background: #fff; }
        .header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 15px; margin-bottom: 20px; }
        .receipt-title { font-size: 18pt; font-weight: bold; background: #f8f9fa; padding: 10px; border: 1px solid #dee2e6; color: #495057; }
        .receipt-info { display: flex; justify-content: space-between; margin: 15px 0; font-size: 14pt; }
        .section { margin: 15px 0; }
        .section-title { font-weight: bold; background: #e9ecef; padding: 10px; margin: 20px 0 10px 0; text-align: center; color: #495057; border: 1px solid #dee2e6; font-size: 16pt; }
        .info-row { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px dotted #ccc; font-size: 14pt; }
        .info-label { font-weight: bold; width: 55%; }
        .info-value { width: 45%; text-align: right; }
        .amount-section { border: 2px solid #495057; padding: 15px; margin: 20px 0; background: #f8f9fa; }
        .amount-row { display: flex; justify-content: space-between; margin: 8px 0; font-size: 14pt; }
        .total-row { font-weight: bold; font-size: 16pt; border-top: 1px solid #000; padding-top: 8px; background: #495057; color: #fff; padding: 10px; margin-top: 10px; display: flex; justify-content: space-between; }
        .customer-photo { max-height: 120px; max-width: 100px; border: 1px solid #ccc; padding: 2px; border-radius: 4px; }
        .signature-section { display: flex; justify-content: space-between; margin-top: 15px; font-size: 10px; }
        .signature-box { text-align: center; width: 48%; }
        .signature-line { border-bottom: 1px solid #000; height: 25px; margin-bottom: 3px; }
        .footer { margin-top: 15px; text-align: center; font-size: 9px; border-top: 1px dotted #666; padding-top: 8px; }
        .back-button { position: fixed; top: 10px; left: 10px; padding: 8px 15px; background: #6c757d; color: #fff; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; font-size: 12px; }
        .print-button { position: fixed; top: 10px; right: 10px; padding: 8px 15px; background: #007bff; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 12px; }
        @media print { .no-print { display: none; } body { margin: 0; padding: 0; margin-top: 5cm; } .receipt-container { border: none; margin: 0; padding: 3mm; } .customer-photo { max-height: 100px; max-width: 80px; } }
    </style>
</head>
<body>
    <a href="jewel_redemption.php" class="back-button no-print">← Back</a>
    <button class="print-button no-print" onclick="window.print()">🖨️ Print</button>

    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="receipt-title">Jewel Redemption Receipt</div>
        </div>

        <!-- Receipt Info -->
        <div class="receipt-info">
            <div><strong>Redemption No:</strong> <?php echo htmlspecialchars($redemption['RedemptionCode']); ?></div>
            <div><strong>Date:</strong> <?php echo date('d/m/Y', strtotime($redemption['RedemptionDate'])); ?></div>
            <div><strong>Time:</strong> <?php echo date('h:i A'); ?></div>
        </div>

        <!-- Customer Details -->
        <div class="section">
            <div class="section-title">Customer Details</div>
            <div class="info-row">
                <span class="info-label">Name:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['Name']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Customer Code:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['CustomerCode']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Mobile Number:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['MobileNumber']); ?></span>
            </div>
            <?php if (!empty($redemption['CustomerPhotoPath'])) { 
                $customerPhotoPath = ltrim($redemption['CustomerPhotoPath'], '/');
            ?>
            <div class="info-row" style="border-bottom: none; align-items: center;">
                <span class="info-label">Customer Photo:</span>
                <span class="info-value" style="text-align: center;">
                    <?php if (file_exists(__DIR__ . '/' . $customerPhotoPath)) { ?>
                        <img src="<?php echo $customerPhotoPath; ?>" alt="Customer Photo" class="customer-photo">
                    <?php } else { ?>
                        <span class="text-muted">Photo not available</span>
                    <?php } ?>
                </span>
            </div>
            <?php } ?>
        </div>

        <!-- Pawn Details -->
        <div class="section">
            <div class="section-title">Pawn Details</div>
            <div class="info-row">
                <span class="info-label">Pawn Code:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['PawnCode']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Item Type:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ItemType']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Item Description:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ItemDescription']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Weight:</span>
                <span class="info-value"><?php echo number_format($redemption['ItemWeight'], 3); ?> g</span>
            </div>
            <?php if (!empty($redemption['ItemPhotoPath'])) { 
                $itemPhotoPath = ltrim($redemption['ItemPhotoPath'], '/');
            ?>
            <div class="info-row" style="border-bottom: none; align-items: center;">
                <span class="info-label">Item Photo:</span>
                <span class="info-value" style="text-align: center;">
                    <?php if (file_exists(__DIR__ . '/' . $itemPhotoPath)) { ?>
                        <img src="<?php echo $itemPhotoPath; ?>" alt="Item Photo" class="customer-photo">
                    <?php } else { ?>
                        <span class="text-muted">Photo not available</span>
                    <?php } ?>
                </span>
            </div>
            <?php } ?>
        </div>

        <!-- Receiver Details -->
        <div class="section">
            <div class="section-title">Receiver Details</div>
            <div class="info-row">
                <span class="info-label">Receiver Name:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ReceiverName']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Mobile Number:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ReceiverMobileNumber']); ?></span>
            </div>
            <div class="info-row">
                <span class="info-label">Authorization:</span>
                <span class="info-value"><?php echo $redemption['CustomerAuthorization'] == 'Self' ? 'Self Customer' : 'Authorized Person'; ?></span>
            </div>
            <?php if ($redemption['RelationshipToCustomer']) { ?>
            <div class="info-row">
                <span class="info-label">Relationship:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['RelationshipToCustomer']); ?></span>
            </div>
            <?php } ?>
        </div>

        <!-- Payment Summary -->
        <div class="amount-section">
            <div class="amount-row">
                <span>Total Amount Due:</span>
                <span>₹<?php echo number_format($redemption['TotalAmountDue'], 2); ?></span>
            </div>
            <div class="amount-row">
                <span>Already Paid:</span>
                <span>₹<?php echo number_format($redemption['TotalAmountPaid'], 2); ?></span>
            </div>
            <div class="amount-row">
                <span>Final Payment:</span>
                <span>₹<?php echo number_format($redemption['FinalPaymentAmount'], 2); ?></span>
            </div>
            <?php if ($redemption['DiscountGiven'] > 0) { ?>
            <div class="amount-row">
                <span>Discount:</span>
                <span>₹<?php echo number_format($redemption['DiscountGiven'], 2); ?></span>
            </div>
            <?php } ?>
            <div class="total-row">
                <span>Redemption Status:</span>
                <span>Fully Redeemed</span>
            </div>
        </div>

        <!-- Payment Method -->
        <?php if ($redemption['PaymentMethod']) { ?>
        <div class="section">
            <div class="section-title">Payment Details</div>
            <div class="info-row">
                <span class="info-label">Payment Method:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['PaymentMethod']); ?></span>
            </div>
            <?php if ($redemption['ReferenceNumber']) { ?>
            <div class="info-row">
                <span class="info-label">Reference No:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ReferenceNumber']); ?></span>
            </div>
            <?php } ?>
        </div>
        <?php } ?>

        <!-- Return Condition -->
        <?php if ($redemption['ReturnCondition']) { ?>
        <div class="section">
            <div class="section-title">Return Condition</div>
            <div class="info-row">
                <span class="info-label">Item Condition:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ReturnCondition']); ?></span>
            </div>
            <?php if ($redemption['ReturnNotes']) { ?>
            <div class="info-row">
                <span class="info-label">Notes:</span>
                <span class="info-value"><?php echo htmlspecialchars($redemption['ReturnNotes']); ?></span>
            </div>
            <?php } ?>
        </div>
        <?php } ?>

        <!-- Signatures -->
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Receiver Signature</div>
            </div>
            <div class="signature-box">
                <div class="signature-line"></div>
                <div>Authorized Signatory<br><?php echo htmlspecialchars($redemption['ProcessedByName']); ?></div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div><strong><?php
                if ($shopDetails && !empty($shopDetails['FooterNote'])) {
                    echo htmlspecialchars($shopDetails['FooterNote']);
                } elseif ($shopDetails && !empty($shopDetails['FooterNoteTamil'])) {
                    echo htmlspecialchars($shopDetails['FooterNoteTamil']);
                } else {
                    echo 'Thank you for your business!';
                }
            ?></strong></div>
            <div style="margin-top: 5px;">Please retain this receipt for your records.</div>
        </div>
    </div>

    <script>
        // Auto print when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
        // Close window after printing
        window.onafterprint = function() {
            window.close();
        };
    </script>
</body>
</html>
