<?php
// Determine current page for active link highlighting
$currentPage = basename($_SERVER['PHP_SELF']);

// Load brand helper for dynamic brand name
include_once(__DIR__ . '/brand.php');

// Helper to check if current page is in a list
$isActive = function(array $pages) use ($currentPage) {
    return in_array($currentPage, $pages, true);
};

// Groups for collapsible menus
$pawnMenuPages = [
    'pawn_transactions.php',
    'due_collection.php',
    'pawn_report_detailed.php',
    'due_collection_report_detailed.php'
];
$reportsMenuPages = [
    'income-expense-report.php',
    'master-cashflow-report.php',
    'due_collection_report_detailed.php',
    'jewel_redemption_report.php',
    'customer-jewel-history-report.php'
];

$pawnMenuActive = $isActive($pawnMenuPages);
$reportsMenuActive = $isActive($reportsMenuPages);
?>
<!-- Sidebar -->
<ul class="navbar-nav bg-gradient-dark sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="dashboard.php" title="Home">
        <div class="sidebar-brand-icon">
            <i class="fas fa-gem"></i>
        </div>
        <div class="sidebar-brand-text mx-2">
            <div style="font-size: 0.9rem; font-weight: bold;"><?php echo htmlspecialchars($brandName); ?></div>
            
        </div>
    </a>

    <hr class="sidebar-divider my-0">

    <?php if(isset($_SESSION['uid'])): ?>

    <!-- Dashboard -->
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php" title="Home">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>
    </li>

    <!-- Pawn Management Section -->
    <div class="sidebar-heading" title="Pawn management">
        <i class="fas fa-gem mr-1"></i> Pawn Management
    </div>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'customers.php' ? 'active' : ''; ?>" href="customers.php" title="Customers">
            <i class="fas fa-fw fa-users"></i>
            <span>Customers</span>
        </a>
    </li>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'income-expenses.php' ? 'active' : ''; ?>" href="income-expenses.php" title="Income and expenses">
            <i class="fas fa-fw fa-chart-line"></i>
            <span>Income & Expenses</span>
        </a>
    </li>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'bank_accounts.php' ? 'active' : ''; ?>" href="bank_accounts.php" title="Bank accounts">
            <i class="fas fa-fw fa-university"></i>
            <span>Bank Accounts</span>
        </a>
    </li>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'bank_pledge_management.php' ? 'active' : ''; ?>" href="bank_pledge_management.php" title="Bank pledge management">
            <i class="fas fa-fw fa-archive"></i>
            <span>Bank Pledge Management</span>
        </a>
    </li>

    <!-- Pawn Transactions Section -->
    <div class="sidebar-heading" title="Transactions">
        <i class="fas fa-exchange-alt mr-1"></i> Transactions
    </div>
    <li class="nav-item">
        <?php $action = isset($_GET['action']) ? $_GET['action'] : ''; ?>
        <a class="nav-link <?php echo $pawnMenuActive ? '' : 'collapsed'; ?>" href="#" data-toggle="collapse" data-target="#collapsePawn"
            aria-expanded="<?php echo $pawnMenuActive ? 'true' : 'false'; ?>" aria-controls="collapsePawn" title="Pawn transactions">
            <i class="fas fa-gem"></i>
            <span>Pawn Transactions</span>
        </a>
        <div id="collapsePawn" class="collapse <?php echo $pawnMenuActive ? 'show' : ''; ?>" aria-labelledby="headingPawn" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <a class="collapse-item <?php echo $currentPage === 'pawn_transactions.php' ? 'active' : ''; ?>" href="pawn_transactions.php" title="New pawn">New Pawn</a>
                <a class="collapse-item <?php echo ($currentPage === 'due_collection.php' && $action !== 'increase') ? 'active' : ''; ?>" href="due_collection.php" title="Collections">Collections</a>
                <a class="collapse-item <?php echo $currentPage === 'pawn_report_detailed.php' ? 'active' : ''; ?>" href="pawn_report_detailed.php" title="Detailed report">Detailed Report</a>
                <a class="collapse-item <?php echo $currentPage === 'due_collection_report_detailed.php' ? 'active' : ''; ?>" href="due_collection_report_detailed.php" title="Collection report">Collection Report</a>
            </div>
        </div>
    </li>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'due_collection.php' ? 'active' : ''; ?>" href="due_collection.php" title="Collect dues">
            <i class="fas fa-fw fa-hand-holding-usd"></i>
            <span>Due Collection</span>
        </a>
    </li>
    <?php if($_SESSION['usertype'] == 'admin'): ?>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'jewel_redemption.php' ? 'active' : ''; ?>" href="jewel_redemption.php" title="Jewel redemption">
            <i class="fas fa-fw fa-gem"></i>
            <span>Jewel Redemption</span>
        </a>
    </li>
    <?php endif; ?>
    <?php if($_SESSION['usertype'] == 'admin'): ?>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'create-user.php' ? 'active' : ''; ?>" href="create-user.php" title="Create user">
            <i class="fas fa-fw fa-user-plus"></i>
            <span>Create User</span>
        </a>
    </li>
    <?php endif; ?>

    <!-- Reports Section -->
    <div class="sidebar-heading" title="Reports">
        <i class="fas fa-fw fa-chart-area"></i> Reports
    </div>
    <li class="nav-item">
        <a class="nav-link <?php echo $reportsMenuActive ? '' : 'collapsed'; ?>" href="#" data-toggle="collapse" data-target="#collapseReports"
            aria-expanded="<?php echo $reportsMenuActive ? 'true' : 'false'; ?>" aria-controls="collapseReports" title="Reports">
            <i class="fas fa-fw fa-chart-area"></i>
            <span>Reports</span>
        </a>
        <div id="collapseReports" class="collapse <?php echo $reportsMenuActive ? 'show' : ''; ?>" aria-labelledby="headingReports" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header" title="Financial reports">Financial Reports:</h6>
                <a class="collapse-item <?php echo $currentPage === 'income-expense-report.php' ? 'active' : ''; ?>" href="income-expense-report.php" title="Income and expense report">
                    <i class="fas fa-chart-line"></i> Income & Expense Report
                </a>
                <a class="collapse-item <?php echo $currentPage === 'master-cashflow-report.php' ? 'active' : ''; ?>" href="master-cashflow-report.php" title="Master cashflow report">
                    <i class="fas fa-file-invoice-dollar"></i> Master Cashflow Report
                </a>
                <h6 class="collapse-header" title="Collection reports">Collection Reports:</h6>
                <a class="collapse-item <?php echo $currentPage === 'due_collection_report_detailed.php' ? 'active' : ''; ?>" href="due_collection_report_detailed.php" title="Collection report">
                    <i class="fas fa-money-bill-wave"></i> Collection Report
                </a>
                <a class="collapse-item <?php echo $currentPage === 'jewel_redemption_report.php' ? 'active' : ''; ?>" href="jewel_redemption_report.php" title="Redemption report">
                    <i class="fas fa-gem"></i> Redemption Report
                </a>
                <h6 class="collapse-header" title="Customer reports">Customer Reports:</h6>
                <a class="collapse-item <?php echo $currentPage === 'customer-jewel-history-report.php' ? 'active' : ''; ?>" href="customer-jewel-history-report.php" title="Customer jewel history">
                    <i class="fas fa-history"></i> Customer Jewel History
                </a>
            </div>
        </div>
    </li>

    <!-- System Section -->
    <div class="sidebar-heading" title="System">
        <i class="fas fa-cog mr-1"></i> System
    </div>
    <?php if($_SESSION['usertype'] == 'admin'): ?>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'shop_details.php' ? 'active' : ''; ?>" href="shop_details.php" title="Shop details">
            <i class="fas fa-fw fa-store"></i>
            <span>Shop Details</span>
        </a>
    </li>
    <?php endif; ?>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'bulk_pawn_upload.php' ? 'active' : ''; ?>" href="bulk_pawn_upload.php" title="Bulk upload">
            <i class="fas fa-file-excel"></i>
            <span>Bulk Upload</span>
        </a>
    </li>
    <li class="nav-item">
    <a class="nav-link" href="logout.php" title="Logout">
            <i class="fas fa-fw fa-sign-out-alt text-danger"></i>
            <span>Logout</span>
        </a>
    </li>

    <?php else: ?>

    <!-- Authentication Section -->
    <div class="sidebar-heading" title="Authentication">
        <i class="fas fa-lock mr-1"></i> Authentication
    </div>
    <li class="nav-item">
    <a class="nav-link <?php echo $currentPage === 'login.php' ? 'active' : ''; ?>" href="login.php" title="User login">
            <i class="fas fa-fw fa-sign-in-alt"></i>
            <span>User Login</span>
        </a>
    </li>

    <?php endif; ?>

    <!-- Sidebar Toggler (Sidebar) -->
    <div class="text-center d-none d-md-inline">
    <button class="rounded-circle border-0" id="sidebarToggle" title="Toggle sidebar"></button>
    </div>

</ul>
<!-- End of Sidebar -->