<?php
// Centralized brand helper
// Exposes:
// - $shopDetails: active shop row or null
// - $brandName: preferred display name (ShopName > ShopNameTamil > fallback)
// - page_title($suffix): helper to compose page titles

if (!isset($brandName)) {
    // Ensure DB config is loaded
    include_once(__DIR__ . '/config.php');

    $shopDetails = null;
    if (isset($con) && $con) {
        $shopQuery = @mysqli_query($con, "SELECT * FROM tblshopdetails WHERE IsActive = 1 LIMIT 1");
        if ($shopQuery) {
            $shopDetails = mysqli_fetch_assoc($shopQuery);
        }
    }

    $brandNameEn = $shopDetails['ShopName'] ?? '';
    $brandNameTa = $shopDetails['ShopNameTamil'] ?? '';
    $brandName = $brandNameEn ?: ($brandNameTa ?: 'RAJAPALAYAM MKR FINANCE');

    if (!function_exists('page_title')) {
        function page_title(string $suffix = ''): string {
            global $brandName;
            return $suffix ? ($brandName . ' | ' . $suffix) : $brandName;
        }
    }
}
?>
