<?php
require_once 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Fill;

// Create new Spreadsheet object
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set headers
$headers = [
    'Customer Name', 'Mobile Number', 'Item Type', 'Item Description', 
    'Weight (grams)', 'Purity', 'Estimated Value', 'Loan Amount', 
    'Interest Rate (%)', 'Loan Date (YYYY-MM-DD)', 'Due Date (YYYY-MM-DD)', 
    'Status', 'Notes'
];

// Add headers to first row
$column = 'A';
foreach ($headers as $header) {
    $sheet->setCellValue($column . '1', $header);
    $column++;
}

// Style the header row
$headerRange = 'A1:M1';
$sheet->getStyle($headerRange)->applyFromArray([
    'fill' => [
        'fillType' => Fill::FILL_SOLID,
        'startColor' => ['rgb' => '4CAF50']
    ],
    'font' => [
        'bold' => true,
        'color' => ['rgb' => 'FFFFFF']
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
        'vertical' => Alignment::VERTICAL_CENTER
    ]
]);

// Add sample data
$sampleData = [
    [
        'Ramesh Kumar', '9876543210', 'Gold', 'Gold Chain 22K', 
        '25.500', '22K', '75000', '60000', 
        '2.00', '2024-01-15', '2024-04-15', 
        'Active', 'Old pawn transaction'
    ],
    [
        'Meena Devi', '9123456789', 'Gold', 'Gold Bangles Set', 
        '45.250', '18K', '120000', '95000', 
        '2.50', '2024-01-20', '2024-04-20', 
        'Redeemed', 'Customer redeemed early'
    ],
    [
        'Karthik M', '9087654321', 'Silver', 'Silver Anklets Pair', 
        '180.000', '92.5%', '15000', '12000', 
        '1.50', '2024-02-01', '2024-05-01', 
        'Active', 'Regular customer'
    ]
];

$row = 2;
foreach ($sampleData as $data) {
    $column = 'A';
    foreach ($data as $value) {
        $sheet->setCellValue($column . $row, $value);
        $column++;
    }
    $row++;
}

// Auto-size columns
foreach (range('A', 'M') as $col) {
    $sheet->getColumnDimension($col)->setAutoSize(true);
}

// Add instructions sheet
$instructionSheet = $spreadsheet->createSheet();
$instructionSheet->setTitle('Instructions');

$instructions = [
    ['BULK PAWN UPLOAD - SAMPLE FORMAT'],
    [''],
    ['Instructions:'],
    ['1. Fill the data in the "Sheet1" tab following the sample format'],
    ['2. Customer Name: Full name of the customer'],
    ['3. Mobile Number: 10-digit mobile number'],
    ['4. Item Type: Gold, Silver, Diamond, Platinum, or Other'],
    ['5. Item Description: Detailed description of the item'],
    ['6. Weight: Weight in grams (decimal allowed)'],
    ['7. Purity: 22K, 18K, 92.5%, etc.'],
    ['8. Estimated Value: Market value of the item'],
    ['9. Loan Amount: Amount given as loan'],
    ['10. Interest Rate: Monthly interest rate in percentage'],
    ['11. Loan Date: Date in YYYY-MM-DD format'],
    ['12. Due Date: Due date in YYYY-MM-DD format'],
    ['13. Status: Active, Redeemed, Extended, or Auctioned'],
    ['14. Notes: Any additional notes (optional)'],
    [''],
    ['Important Notes:'],
    ['- If customer with mobile number exists, it will be linked'],
    ['- If customer doesn\'t exist, new customer will be created'],
    ['- All mandatory fields must be filled'],
    ['- Date format must be YYYY-MM-DD (e.g., 2024-01-15)'],
    ['- Save the file as .xlsx or .xls format before uploading']
];

$row = 1;
foreach ($instructions as $instruction) {
    $instructionSheet->setCellValue('A' . $row, $instruction[0]);
    if ($row == 1) {
        $instructionSheet->getStyle('A' . $row)->applyFromArray([
            'font' => ['bold' => true, 'size' => 14],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => '2196F3']
            ]
        ]);
    } elseif ($row == 3 || $row == 19) {
        $instructionSheet->getStyle('A' . $row)->applyFromArray([
            'font' => ['bold' => true]
        ]);
    }
    $row++;
}

$instructionSheet->getColumnDimension('A')->setWidth(60);

// Set active sheet back to first sheet
$spreadsheet->setActiveSheetIndex(0);

// Set filename
$filename = 'Pawn_Bulk_Upload_Sample_' . date('Y-m-d') . '.xlsx';

// Set headers for download
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');

// Write file to output
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
?>
