<?php
// Set headers for CSV download
$filename = 'Pawn_Bulk_Upload_Sample_' . date('Y-m-d') . '.csv';
header('Content-Type: text/csv');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');

// Create file handle
$output = fopen('php://output', 'w');

// CSV Headers
$headers = [
    'Customer Name', 
    'Mobile Number', 
    'Item Type', 
    'Item Description', 
    'Weight (grams)', 
    'Purity', 
    'Estimated Value', 
    'Loan Amount', 
    'Interest Rate (%)', 
    'Loan Date (YYYY-MM-DD)', 
    'Due Date (YYYY-MM-DD)', 
    'Status', 
    'Notes'
];

// Write headers
fputcsv($output, $headers);

// Sample data
$sampleData = [
    [
        'Ramesh Kumar', 
        '9876543210', 
        'Gold', 
        'Gold Chain 22K', 
        '25.500', 
        '22K', 
        '75000', 
        '60000', 
        '2.00', 
        '2024-01-15', 
        '2024-04-15', 
        'Active', 
        'Old pawn transaction'
    ],
    [
        'Meena Devi', 
        '9123456789', 
        'Gold', 
        'Gold Bangles Set', 
        '45.250', 
        '18K', 
        '120000', 
        '95000', 
        '2.50', 
        '2024-01-20', 
        '2024-04-20', 
        'Redeemed', 
        'Customer redeemed early'
    ],
    [
        'Karthik M', 
        '9087654321', 
        'Silver', 
        'Silver Anklets Pair', 
        '180.000', 
        '92.5%', 
        '15000', 
        '12000', 
        '1.50', 
        '2024-02-01', 
        '2024-05-01', 
        'Active', 
        'Regular customer'
    ]
];

// Write sample data
foreach ($sampleData as $row) {
    fputcsv($output, $row);
}

// Close file handle
fclose($output);
exit;
?>
