<?php
session_start();

$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found.");
}

include_once($configPath);

if (!isset($con) || !$con) {
    die("Error: Database connection failed.");
}

if (!isset($_SESSION['uid'])) {
    header('Location: logout.php');
    exit();
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['msg'] = "Invalid pawn transaction ID.";
    header('Location: customer-jewel-history-report.php');
    exit();
}

$pawnId = (int)$_GET['id'];

try {
    // Start transaction
    mysqli_autocommit($con, false);
    
    // Get pawn transaction details before deletion for file cleanup
    $pawnQuery = "SELECT PawnCode, ItemPhotoPath FROM tblpawntransactions WHERE ID = $pawnId";
    $pawnResult = mysqli_query($con, $pawnQuery);
    $pawnData = mysqli_fetch_assoc($pawnResult);
    
    if (!$pawnData) {
        throw new Exception("Pawn transaction not found.");
    }
    
    // Get item photos for cleanup
    $itemPhotosQuery = "SELECT ItemPhotoPath FROM tblpawnitems WHERE PawnTransactionID = $pawnId";
    $itemPhotosResult = mysqli_query($con, $itemPhotosQuery);
    $itemPhotos = [];
    while ($photo = mysqli_fetch_assoc($itemPhotosResult)) {
        if (!empty($photo['ItemPhotoPath'])) {
            $itemPhotos[] = $photo['ItemPhotoPath'];
        }
    }
    
    // Delete related records in order (maintaining referential integrity)
    
    // 1. Delete bank pledge redemptions
    $bankPledgeQuery = "SELECT ID FROM tblbankpledges WHERE PawnTransactionID = $pawnId";
    $bankPledgeResult = mysqli_query($con, $bankPledgeQuery);
    while ($pledge = mysqli_fetch_assoc($bankPledgeResult)) {
        mysqli_query($con, "DELETE FROM tblbankpledgeredemptions WHERE BankPledgeID = {$pledge['ID']}");
        mysqli_query($con, "DELETE FROM tblbankpledgepayments WHERE BankPledgeID = {$pledge['ID']}");
    }
    
    // 2. Delete bank pledges
    mysqli_query($con, "DELETE FROM tblbankpledges WHERE PawnTransactionID = $pawnId");
    
    // 3. Delete redemptions
    mysqli_query($con, "DELETE FROM tblredemptions WHERE PawnTransactionID = $pawnId");
    
    // 4. Delete payment collections
    mysqli_query($con, "DELETE FROM tblpaymentcollections WHERE PawnTransactionID = $pawnId");
    
    // 5. Delete loan increases
    mysqli_query($con, "DELETE FROM tblloanincreases WHERE PawnTransactionID = $pawnId");
    
    // 6. Delete pawn items
    mysqli_query($con, "DELETE FROM tblpawnitems WHERE PawnTransactionID = $pawnId");
    
    // 7. Delete main pawn transaction
    mysqli_query($con, "DELETE FROM tblpawntransactions WHERE ID = $pawnId");
    
    // Check if all deletions were successful
    if (mysqli_error($con)) {
        throw new Exception("Error deleting pawn transaction: " . mysqli_error($con));
    }
    
    // Commit transaction
    mysqli_commit($con);
    
    // Clean up photo files
    if (!empty($pawnData['ItemPhotoPath'])) {
        $mainPhotoPath = __DIR__ . '/' . ltrim($pawnData['ItemPhotoPath'], '/');
        if (file_exists($mainPhotoPath)) {
            unlink($mainPhotoPath);
        }
    }
    
    foreach ($itemPhotos as $photoPath) {
        $fullPhotoPath = __DIR__ . '/' . ltrim($photoPath, '/');
        if (file_exists($fullPhotoPath)) {
            unlink($fullPhotoPath);
        }
    }
    
    $_SESSION['msg'] = "Pawn transaction '{$pawnData['PawnCode']}' has been successfully deleted. Customer data has been preserved.";
    $_SESSION['msg_type'] = 'success';
    
} catch (Exception $e) {
    // Rollback transaction on error
    mysqli_rollback($con);
    $_SESSION['msg'] = "Error: " . $e->getMessage();
    $_SESSION['msg_type'] = 'error';
}

// Restore autocommit
mysqli_autocommit($con, true);

// Redirect back to the report page
header('Location: customer-jewel-history-report.php');
exit();
?>