<?php
session_start();
include_once('includes/config.php');
// Load branding helper
include_once(__DIR__ . '/includes/brand.php');
if(!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$customer_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$confirm = isset($_GET['confirm']) ? $_GET['confirm'] : '';

if ($customer_id <= 0) {
    $_SESSION['msg'] = "Invalid customer ID";
    header('Location: manage-customers.php');
    exit();
}

// Get customer details
$query = "SELECT * FROM tblcustomers WHERE ID = $customer_id";
$result = mysqli_query($con, $query);
$customer = mysqli_fetch_assoc($result);

if (!$customer) {
    $_SESSION['msg'] = "Customer not found";
    header('Location: manage-customers.php');
    exit();
}

// Get related records count
$related_records = [];

// Pawn transactions
$query = "SELECT COUNT(*) as count FROM tblpawntransactions WHERE CustomerID = $customer_id";
$result = mysqli_query($con, $query);
$related_records['pawn_transactions'] = mysqli_fetch_assoc($result)['count'];

// Payment collections
$query = "SELECT COUNT(*) as count FROM tblpaymentcollections WHERE CustomerID = $customer_id";
$result = mysqli_query($con, $query);
$related_records['payment_collections'] = mysqli_fetch_assoc($result)['count'];

// Redemptions
$query = "SELECT COUNT(*) as count FROM tblredemptions WHERE CustomerID = $customer_id";
$result = mysqli_query($con, $query);
$related_records['redemptions'] = mysqli_fetch_assoc($result)['count'];

// Loan increases
$query = "SELECT COUNT(*) as count FROM tblloanincreases WHERE CustomerID = $customer_id";
$result = mysqli_query($con, $query);
$related_records['loan_increases'] = mysqli_fetch_assoc($result)['count'];

// Cash flow
$query = "SELECT COUNT(*) as count FROM tblcashflow WHERE CustomerID = $customer_id";
$result = mysqli_query($con, $query);
$related_records['cashflow'] = mysqli_fetch_assoc($result)['count'];

$total_related = array_sum($related_records);

// Handle deletion
if ($confirm === 'yes' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        mysqli_begin_transaction($con);
        
        // Log the deletion
        $log_query = "INSERT INTO tblcashflow (TransactionCode, TransactionType, Category, Description, Amount, TransactionDate, PaymentMethod, Notes, CreatedBy) 
                     VALUES ('DEL" . time() . "', 'Expense', 'System Operations', 'Customer Account Deletion: {$customer['Name']} ({$customer['CustomerCode']})', 0.00, CURDATE(), 'System', 'Customer account and all related records deleted', {$_SESSION['uid']})";
        mysqli_query($con, $log_query);
        
        // Delete customer (cascade will handle related records)
        $delete_query = "DELETE FROM tblcustomers WHERE ID = $customer_id";
        $result = mysqli_query($con, $delete_query);
        
        if ($result) {
            mysqli_commit($con);
            $_SESSION['msg'] = "Customer account and all related records deleted successfully";
            header('Location: manage-customers.php');
            exit();
        } else {
            throw new Exception("Failed to delete customer");
        }
    } catch (Exception $e) {
        mysqli_rollback($con);
        $_SESSION['error'] = "Error deleting customer: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Delete Customer'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <style>
        .danger-card {
            border: 2px solid #dc3545;
            background: #f8f9fa;
        }
        .warning-list {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
        }
        .related-record {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px 0;
            border-bottom: 1px solid #dee2e6;
        }
        .related-record:last-child {
            border-bottom: none;
        }
        .count-badge {
            background: #dc3545;
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.8em;
        }
    </style>
</head>
<body id="page-top">
<div id="wrapper">
    <?php include_once('includes/sidebar.php'); ?>
    <div id="content-wrapper" class="d-flex flex-column">
        <div id="content">
            <?php include_once('includes/topbar.php'); ?>
            <div class="container-fluid">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card danger-card shadow">
                            <div class="card-header bg-danger text-white">
                                <h4 class="mb-0"><i class="fas fa-exclamation-triangle"></i> Delete Customer Account</h4>
                            </div>
                            <div class="card-body">
                                <!-- Customer Details -->
                                <div class="row mb-4">
                                    <div class="col-md-3">
                                        <?php if ($customer['PhotoPath']) { ?>
                                            <img src="<?php echo $customer['PhotoPath']; ?>" class="img-fluid rounded" alt="Customer Photo">
                                        <?php } else { ?>
                                            <div class="bg-secondary text-white d-flex align-items-center justify-content-center rounded" style="height: 150px;">
                                                <i class="fas fa-user fa-3x"></i>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="col-md-9">
                                        <h5 class="text-danger"><?php echo htmlspecialchars($customer['Name']); ?></h5>
                                        <p class="mb-1"><strong>Customer Code:</strong> <?php echo htmlspecialchars($customer['CustomerCode']); ?></p>
                                        <p class="mb-1"><strong>Mobile:</strong> <?php echo htmlspecialchars($customer['MobileNumber']); ?></p>
                                        <p class="mb-1"><strong>Father/Husband:</strong> <?php echo htmlspecialchars($customer['FatherHusbandName']); ?></p>
                                        <p class="mb-1"><strong>ID Proof:</strong> <?php echo htmlspecialchars($customer['IDProofType'] . ' - ' . $customer['IDProofNumber']); ?></p>
                                        <p class="mb-1"><strong>Address:</strong> <?php echo htmlspecialchars($customer['Address']); ?></p>
                                    </div>
                                </div>

                                <!-- Warning Message -->
                                <div class="alert alert-danger">
                                    <h5><i class="fas fa-exclamation-triangle"></i> WARNING: This action cannot be undone!</h5>
                                    <p class="mb-0">Deleting this customer will permanently remove:</p>
                                    <ul class="mt-2 mb-0">
                                        <li>Customer account and personal information</li>
                                        <li>All pawn transactions and related data</li>
                                        <li>Payment collections and receipts</li>
                                        <li>Redemption records</li>
                                        <li>Loan increase records</li>
                                        <li>Associated cash flow entries</li>
                                        <li>All uploaded documents and photos</li>
                                    </ul>
                                </div>

                                <!-- Related Records Summary -->
                                <div class="warning-list mb-4">
                                    <h6 class="text-warning mb-3"><i class="fas fa-list"></i> Related Records to be Deleted:</h6>
                                    <div class="related-record">
                                        <span><i class="fas fa-handshake"></i> Pawn Transactions</span>
                                        <span class="count-badge"><?php echo $related_records['pawn_transactions']; ?></span>
                                    </div>
                                    <div class="related-record">
                                        <span><i class="fas fa-receipt"></i> Payment Collections</span>
                                        <span class="count-badge"><?php echo $related_records['payment_collections']; ?></span>
                                    </div>
                                    <div class="related-record">
                                        <span><i class="fas fa-check-circle"></i> Redemptions</span>
                                        <span class="count-badge"><?php echo $related_records['redemptions']; ?></span>
                                    </div>
                                    <div class="related-record">
                                        <span><i class="fas fa-arrow-up"></i> Loan Increases</span>
                                        <span class="count-badge"><?php echo $related_records['loan_increases']; ?></span>
                                    </div>
                                    <div class="related-record">
                                        <span><i class="fas fa-exchange-alt"></i> Cash Flow Entries</span>
                                        <span class="count-badge"><?php echo $related_records['cashflow']; ?></span>
                                    </div>
                                    <div class="related-record border-top pt-2 mt-2">
                                        <strong><i class="fas fa-calculator"></i> Total Records to Delete</strong>
                                        <strong class="count-badge"><?php echo $total_related; ?></strong>
                                    </div>
                                </div>

                                <?php if (isset($_SESSION['error'])) { ?>
                                    <div class="alert alert-danger">
                                        <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                                    </div>
                                <?php } ?>

                                <!-- Confirmation Section -->
                                <?php if ($confirm !== 'yes') { ?>
                                    <div class="text-center">
                                        <a href="delete-customer.php?id=<?php echo $customer_id; ?>&confirm=yes" class="btn btn-outline-danger btn-lg mr-3">
                                            <i class="fas fa-trash"></i> I Understand, Proceed to Delete
                                        </a>
                                        <a href="manage-customers.php" class="btn btn-secondary btn-lg">
                                            <i class="fas fa-times"></i> Cancel
                                        </a>
                                    </div>
                                <?php } else { ?>
                                    <form method="post" class="text-center">
                                        <h5 class="text-danger mb-3">Final Confirmation Required</h5>
                                        <p>Type the customer name <strong>"<?php echo htmlspecialchars($customer['Name']); ?>"</strong> to confirm deletion:</p>
                                        <input type="text" id="confirmName" class="form-control mb-3" style="max-width: 300px; margin: 0 auto;" placeholder="Enter customer name to confirm">
                                        <div>
                                            <button type="submit" id="finalDeleteBtn" class="btn btn-danger btn-lg mr-3" disabled>
                                                <i class="fas fa-trash"></i> DELETE PERMANENTLY
                                            </button>
                                            <a href="manage-customers.php" class="btn btn-secondary btn-lg">
                                                <i class="fas fa-times"></i> Cancel
                                            </a>
                                        </div>
                                    </form>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php'); ?>
        </div>
    </div>
    <?php include_once('includes/footer2.php'); ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const confirmNameInput = document.getElementById('confirmName');
    const finalDeleteBtn = document.getElementById('finalDeleteBtn');
    const expectedName = "<?php echo addslashes($customer['Name']); ?>";
    
    if (confirmNameInput && finalDeleteBtn) {
        confirmNameInput.addEventListener('input', function() {
            if (this.value.trim() === expectedName) {
                finalDeleteBtn.disabled = false;
                finalDeleteBtn.classList.remove('btn-secondary');
                finalDeleteBtn.classList.add('btn-danger');
            } else {
                finalDeleteBtn.disabled = true;
                finalDeleteBtn.classList.remove('btn-danger');
                finalDeleteBtn.classList.add('btn-secondary');
            }
        });
    }
});
</script>
</body>
</html>
