<?php
session_start();

// Check if config file exists
$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found. Please create includes/config.php");
}

include_once($configPath);
include_once(__DIR__ . '/includes/brand.php');

if (!isset($con) || !$con) {
    die("Error: Database connection failed. Please check your database configuration.");
}

if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$pledgeId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$pledgeId) {
    header('location:bank_pledge_management.php');
    exit();
}

// Get pledge details
$pledgeQuery = "SELECT bp.*, pt.PawnCode, pt.ItemDescription, pt.ItemType, pt.ItemWeight, pt.LoanAmount,
                c.Name as CustomerName, c.MobileNumber, c.Address, c.CustomerCode,
                ba.BankName, ba.AccountNumber, ba.IFSCCode, ba.BranchName
                FROM tblbankpledges bp 
                JOIN tblpawntransactions pt ON bp.PawnTransactionID = pt.ID
                JOIN tblcustomers c ON pt.CustomerID = c.ID
                JOIN tblbankaccounts ba ON bp.BankAccountID = ba.ID 
                WHERE bp.ID = $pledgeId";
$pledgeResult = mysqli_query($con, $pledgeQuery);

if (mysqli_num_rows($pledgeResult) == 0) {
    header('location:bank_pledge_management.php');
    exit();
}

$pledge = mysqli_fetch_assoc($pledgeResult);

// Get payment history
$paymentsQuery = "SELECT bpp.*, u.FullName as CreatedByName
                  FROM tblbankpledgepayments bpp
                  LEFT JOIN tblusers u ON bpp.CreatedBy = u.ID
                  WHERE bpp.BankPledgeID = $pledgeId
                  ORDER BY bpp.PaymentDate DESC";
$paymentsResult = mysqli_query($con, $paymentsQuery);

// Get redemption history
$redemptionsQuery = "SELECT bpr.*, u.FullName as CreatedByName
                     FROM tblbankpledgeredemptions bpr
                     LEFT JOIN tblusers u ON bpr.CreatedBy = u.ID
                     WHERE bpr.BankPledgeID = $pledgeId
                     ORDER BY bpr.RedemptionDate DESC";
$redemptionsResult = mysqli_query($con, $redemptionsQuery);

// Calculate totals
$totalPayments = mysqli_query($con, "SELECT SUM(PaymentAmount) as total FROM tblbankpledgepayments WHERE BankPledgeID = $pledgeId");
$totalPaymentsAmount = mysqli_fetch_assoc($totalPayments)['total'] ?? 0;

// Calculate total principal payments
$totalPrincipalPayments = mysqli_query($con, "SELECT SUM(PaymentAmount) as total FROM tblbankpledgepayments WHERE BankPledgeID = $pledgeId AND PaymentType = 'Principal'");
$totalPrincipalPaymentsAmount = mysqli_fetch_assoc($totalPrincipalPayments)['total'] ?? 0;

$totalRedemptions = mysqli_query($con, "SELECT SUM(RedemptionAmount) as total FROM tblbankpledgeredemptions WHERE BankPledgeID = $pledgeId");
$totalRedemptionsAmount = mysqli_fetch_assoc($totalRedemptions)['total'] ?? 0;

// Balance = PledgeAmount - (Principal Payments + Redemptions)
$balanceAmount = $pledge['PledgeAmount'] - ($totalPrincipalPaymentsAmount + $totalRedemptionsAmount);

// Handle payment deletion
if (isset($_GET['delete_payment']) && is_numeric($_GET['delete_payment'])) {
    $deletePaymentId = (int)$_GET['delete_payment'];
    // Optional: Add permission check here
    mysqli_query($con, "DELETE FROM tblbankpledgepayments WHERE ID = $deletePaymentId AND BankPledgeID = $pledgeId");
    header("Location: bank_pledge_details.php?id=$pledgeId");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Bank Pledge Details - ' . htmlspecialchars($pledge['PledgeCode'])); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <style>
        .detail-card {
            border-left: 4px solid #4e73df;
            margin-bottom: 20px;
        }
        .info-row {
            border-bottom: 1px solid #eee;
            padding: 8px 0;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        @media print {
            .no-print { display: none !important; }
            .card { border: 1px solid #ddd !important; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Header -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h3 mb-0 text-gray-800">Bank Pledge Details</h1>
                        <div>
                            <a href="bank_pledge_management.php" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back to List
                            </a>
                            <button onclick="window.print()" class="btn btn-info">
                                <i class="fas fa-print"></i> Print
                            </button>
                        </div>
                    </div>
                    
                    <!-- Pledge Information -->
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card detail-card">
                                <div class="card-header">
                                    <h6 class="font-weight-bold text-primary mb-0">Pledge Information</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-row">
                                                <strong>Pledge Code:</strong> <?php echo $pledge['PledgeCode']; ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Bank:</strong> <?php echo htmlspecialchars($pledge['BankName']); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Account Number:</strong> <?php echo htmlspecialchars($pledge['AccountNumber']); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>IFSC Code:</strong> <?php echo htmlspecialchars($pledge['IFSCCode']); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Branch:</strong> <?php echo htmlspecialchars($pledge['BranchName']); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-row">
                                                <strong>Pledge Amount:</strong> ₹<?php echo number_format($pledge['PledgeAmount'], 2); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Interest Rate:</strong> <?php echo $pledge['InterestRate']; ?>%
                                            </div>
                                            <div class="info-row">
                                                <strong>Pledge Date:</strong> <?php echo date('d/m/Y', strtotime($pledge['PledgeDate'])); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Maturity Date:</strong> <?php echo date('d/m/Y', strtotime($pledge['MaturityDate'])); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Status:</strong> 
                                                <span class="badge badge-<?php echo ($pledge['Status'] == 'Active') ? 'success' : (($pledge['Status'] == 'Redeemed') ? 'info' : 'warning'); ?>">
                                                    <?php echo $pledge['Status']; ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if ($pledge['BankLoanNumber']) { ?>
                                        <div class="info-row mt-3">
                                            <strong>Bank Loan Number:</strong> <?php echo htmlspecialchars($pledge['BankLoanNumber']); ?>
                                        </div>
                                    <?php } ?>
                                    <?php if ($pledge['Notes']) { ?>
                                        <div class="info-row">
                                            <strong>Notes:</strong> <?php echo htmlspecialchars($pledge['Notes']); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <!-- Customer & Pawn Information -->
                            <div class="card detail-card">
                                <div class="card-header">
                                    <h6 class="font-weight-bold text-primary mb-0">Customer & Pawn Details</h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="info-row">
                                                <strong>Customer:</strong> <?php echo htmlspecialchars($pledge['CustomerName']); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Customer Code:</strong> <?php echo htmlspecialchars($pledge['CustomerCode']); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Mobile:</strong> <?php echo htmlspecialchars($pledge['MobileNumber']); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="info-row">
                                                <strong>Pawn Code:</strong> <?php echo $pledge['PawnCode']; ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Item Type:</strong> <?php echo htmlspecialchars($pledge['ItemType']); ?>
                                            </div>
                                            <div class="info-row">
                                                <strong>Weight:</strong> <?php echo number_format($pledge['ItemWeight'], 3); ?>g
                                            </div>
                                        </div>
                                    </div>
                                    <div class="info-row">
                                        <strong>Item Description:</strong> <?php echo htmlspecialchars($pledge['ItemDescription']); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Summary Card -->
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="font-weight-bold text-primary mb-0">Financial Summary</h6>
                                </div>
                                <div class="card-body">
                                    <div class="text-center mb-3">
                                        <h4 class="text-primary">₹<?php echo number_format($pledge['PledgeAmount'], 2); ?></h4>
                                        <small class="text-muted">Total Pledge Amount</small>
                                    </div>
                                    
                                    <div class="info-row">
                                        <strong>Total Payments:</strong> ₹<?php echo number_format($totalPaymentsAmount, 2); ?>
                                    </div>
                                    <div class="info-row">
                                        <strong>Total Principal Paid:</strong> ₹<?php echo number_format($totalPrincipalPaymentsAmount, 2); ?>
                                    </div>
                                    <div class="info-row">
                                        <strong>Total Redeemed:</strong> ₹<?php echo number_format($totalRedemptionsAmount, 2); ?>
                                    </div>
                                    <div class="info-row">
                                        <strong>Balance Amount:</strong> 
                                        <span class="text-<?php echo ($balanceAmount > 0) ? 'danger' : 'success'; ?>">
                                            ₹<?php echo number_format($balanceAmount, 2); ?>
                                        </span>
                                    </div>
                                    
                                    <?php if ($pledge['Status'] != 'Redeemed') { ?>
                                        <div class="mt-4 no-print">
                                            <button class="btn btn-success btn-sm btn-block" onclick="addPayment(<?php echo $pledgeId; ?>)">
                                                <i class="fas fa-plus"></i> Add Payment
                                            </button>
                                            <button class="btn btn-info btn-sm btn-block" onclick="redeemPledge(<?php echo $pledgeId; ?>)">
                                                <i class="fas fa-hand-holding-usd"></i> Process Redemption
                                            </button>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Payment History -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Payment History</h6>
                        </div>
                        <div class="card-body">
                            <?php if (mysqli_num_rows($paymentsResult) > 0) { ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Amount</th>
                                                <th>Type</th>
                                                <th>Method</th>
                                                <th>Reference</th>
                                                <th>Receipt #</th>
                                                <th>Created By</th>
                                                <th class="no-print">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while($payment = mysqli_fetch_assoc($paymentsResult)) { ?>
                                                <tr>
                                                    <td><?php echo date('d/m/Y', strtotime($payment['PaymentDate'])); ?></td>
                                                    <td>₹<?php echo number_format($payment['PaymentAmount'], 2); ?></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo ($payment['PaymentType'] == 'Interest') ? 'warning' : 'primary'; ?>">
                                                            <?php echo $payment['PaymentType']; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo $payment['PaymentMethod']; ?></td>
                                                    <td><?php echo htmlspecialchars($payment['TransactionReference']); ?></td>
                                                    <td><?php echo htmlspecialchars($payment['ReceiptNumber']); ?></td>
                                                    <td><?php echo htmlspecialchars($payment['CreatedByName']); ?></td>
                                                    <td class="no-print">
                                                        <a href="?id=<?php echo $pledgeId; ?>&delete_payment=<?php echo $payment['ID']; ?>" 
                                                           class="btn btn-danger btn-sm" 
                                                           onclick="return confirm('Are you sure you want to delete this payment?');">
                                                            <i class="fas fa-trash"></i> Delete
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center text-muted py-4">
                                    <i class="fas fa-money-bill fa-2x mb-2"></i>
                                    <p>No payments recorded yet.</p>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!-- Redemption History -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Redemption History</h6>
                        </div>
                        <div class="card-body">
                            <?php if (mysqli_num_rows($redemptionsResult) > 0) { ?>
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Amount</th>
                                                <th>Type</th>
                                                <th>Method</th>
                                                <th>Reference</th>
                                                <th>Created By</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php while($redemption = mysqli_fetch_assoc($redemptionsResult)) { ?>
                                                <tr>
                                                    <td><?php echo date('d/m/Y', strtotime($redemption['RedemptionDate'])); ?></td>
                                                    <td>₹<?php echo number_format($redemption['RedemptionAmount'], 2); ?></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo ($redemption['RedemptionType'] == 'Full') ? 'success' : 'info'; ?>">
                                                            <?php echo $redemption['RedemptionType']; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo $redemption['PaymentMethod']; ?></td>
                                                    <td><?php echo htmlspecialchars($redemption['TransactionReference']); ?></td>
                                                    <td><?php echo htmlspecialchars($redemption['CreatedByName']); ?></td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center text-muted py-4">
                                    <i class="fas fa-hand-holding-usd fa-2x mb-2"></i>
                                    <p>No redemptions processed yet.</p>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    
    <script>
    function addPayment(pledgeId) {
        window.location.href = 'bank_pledge_management.php#addPayment-' + pledgeId;
    }
    
    function redeemPledge(pledgeId) {
        window.location.href = 'bank_pledge_management.php#redeem-' + pledgeId;
    }
    </script>
</body>
</html>
