<?php
session_start();

// Check if config file exists
$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found. Please create includes/config.php");
}

include_once($configPath);
include_once(__DIR__ . '/includes/brand.php');

// Check if database connection exists
if (!isset($con) || !$con) {
    die("Error: Database connection failed. Please check your database configuration.");
}

if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$msg = "";
$userId = $_SESSION['uid'];

// Get pawn transaction ID if provided
$pawnTransactionId = isset($_GET['pawn_id']) ? (int)$_GET['pawn_id'] : 0;

// Handle form submissions
if ($_POST) {
    if (isset($_POST['add_pledge'])) {
        $pledgeCode = "PLEDGE" . str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
        $pawnTransactionId = (int)$_POST['pawn_transaction_id'];
        $bankAccountId = (int)$_POST['bank_account_id'];
        $pledgeAmount = (float)$_POST['pledge_amount'];
        $pledgeDate = mysqli_real_escape_string($con, $_POST['pledge_date']);
        $maturityDate = mysqli_real_escape_string($con, $_POST['maturity_date']);
        $interestRate = (float)$_POST['interest_rate'];
        $notes = mysqli_real_escape_string($con, $_POST['notes']);
        
        // Check if pawn transaction is already pledged
        $checkQuery = mysqli_query($con, "SELECT ID FROM tblbankpledges WHERE PawnTransactionID=$pawnTransactionId AND Status='Active'");
        if (mysqli_num_rows($checkQuery) > 0) {
            $msg = "Error: This pawn transaction is already pledged to a bank!";
        } else {
            $query = "INSERT INTO tblbankpledges (PledgeCode, PawnTransactionID, BankAccountID, PledgeAmount, PledgeDate, MaturityDate, InterestRate, Notes) 
                      VALUES ('$pledgeCode', $pawnTransactionId, $bankAccountId, $pledgeAmount, '$pledgeDate', '$maturityDate', $interestRate, '$notes')";
            
            if (mysqli_query($con, $query)) {
                // Update pawn transaction status to indicate it's pledged
                mysqli_query($con, "UPDATE tblpawntransactions SET Notes=CONCAT(COALESCE(Notes,''), '\nPledged to bank: $pledgeCode') WHERE ID=$pawnTransactionId");
                $msg = "Bank pledge created successfully!";
                $pawnTransactionId = 0; // Reset to show all pledges
            } else {
                $msg = "Error creating bank pledge: " . mysqli_error($con);
            }
        }
    }
    
    if (isset($_POST['update_pledge'])) {
        $id = (int)$_POST['pledge_id'];
        $pledgeAmount = (float)$_POST['pledge_amount'];
        $maturityDate = mysqli_real_escape_string($con, $_POST['maturity_date']);
        $interestRate = (float)$_POST['interest_rate'];
        $status = mysqli_real_escape_string($con, $_POST['status']);
        $notes = mysqli_real_escape_string($con, $_POST['notes']);
        
        $query = "UPDATE tblbankpledges SET PledgeAmount=$pledgeAmount, MaturityDate='$maturityDate', 
                  InterestRate=$interestRate, Status='$status', Notes='$notes' WHERE ID=$id";
        
        if (mysqli_query($con, $query)) {
            $msg = "Bank pledge updated successfully!";
        } else {
            $msg = "Error updating bank pledge: " . mysqli_error($con);
        }
    }
}

// Get pledge for editing
$editPledge = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $result = mysqli_query($con, "SELECT bp.*, pt.PawnCode, pt.ItemDescription, c.Name as CustomerName 
                                  FROM tblbankpledges bp 
                                  JOIN tblpawntransactions pt ON bp.PawnTransactionID = pt.ID 
                                  JOIN tblcustomers c ON pt.CustomerID = c.ID 
                                  WHERE bp.ID=$id");
    $editPledge = mysqli_fetch_assoc($result);
}

// Get pawn transaction details if pawn_id is provided
$pawnTransaction = null;
if ($pawnTransactionId > 0) {
    $result = mysqli_query($con, "SELECT pt.*, c.Name as CustomerName, c.CustomerCode 
                                  FROM tblpawntransactions pt 
                                  JOIN tblcustomers c ON pt.CustomerID = c.ID 
                                  WHERE pt.ID=$pawnTransactionId");
    $pawnTransaction = mysqli_fetch_assoc($result);
}

// Fetch bank accounts
$bankAccountsQuery = mysqli_query($con, "SELECT ID, CONCAT(BankName, ' - ', AccountNumber) as BankDetails FROM tblbankaccounts WHERE Status='Active' ORDER BY BankName");

// Fetch bank pledges
$pledgesQuery = "SELECT bp.*, pt.PawnCode, pt.ItemDescription, pt.LoanAmount, 
                 c.Name as CustomerName, c.CustomerCode,
                 ba.BankName, ba.AccountNumber,
                 DATEDIFF(bp.MaturityDate, CURDATE()) as DaysToMaturity
                 FROM tblbankpledges bp 
                 JOIN tblpawntransactions pt ON bp.PawnTransactionID = pt.ID 
                 JOIN tblcustomers c ON pt.CustomerID = c.ID 
                 JOIN tblbankaccounts ba ON bp.BankAccountID = ba.ID";

if ($pawnTransactionId > 0) {
    $pledgesQuery .= " WHERE bp.PawnTransactionID = $pawnTransactionId";
}

$pledgesQuery .= " ORDER BY bp.CreatedDate DESC";
$pledgesResult = mysqli_query($con, $pledgesQuery);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Bank Pledge'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <style>
        .form-section {
            background: #f8f9fc;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .overdue-pledge {
            background-color: #f8d7da !important;
        }
        .maturity-warning {
            background-color: #fff3cd !important;
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <?php if($msg) { ?>
                        <div class="alert alert-info alert-dismissible fade show">
                            <?php echo $msg; ?>
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                        </div>
                    <?php } ?>
                    
                    <?php if ($pawnTransaction) { ?>
                        <!-- Pawn Transaction Details -->
                        <div class="card shadow mb-4">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Pawn Transaction Details</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p><strong>Pawn Code:</strong> <?php echo $pawnTransaction['PawnCode']; ?></p>
                                        <p><strong>Customer:</strong> <?php echo $pawnTransaction['CustomerName']; ?> (<?php echo $pawnTransaction['CustomerCode']; ?>)</p>
                                        <p><strong>Item:</strong> <?php echo $pawnTransaction['ItemDescription']; ?></p>
                                    </div>
                                    <div class="col-md-6">
                                        <p><strong>Loan Amount:</strong> ₹<?php echo number_format($pawnTransaction['LoanAmount'], 2); ?></p>
                                        <p><strong>Loan Date:</strong> <?php echo date('d/m/Y', strtotime($pawnTransaction['LoanDate'])); ?></p>
                                        <p><strong>Status:</strong> <span class="badge badge-info"><?php echo $pawnTransaction['Status']; ?></span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    
                    <!-- Add/Edit Bank Pledge Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <?php echo $editPledge ? 'Edit Bank Pledge' : 'Create New Bank Pledge'; ?>
                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <?php if($editPledge) { ?>
                                    <input type="hidden" name="pledge_id" value="<?php echo $editPledge['ID']; ?>">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Pawn Transaction</label>
                                                <input type="text" class="form-control" readonly 
                                                       value="<?php echo $editPledge['PawnCode'] . ' - ' . $editPledge['CustomerName']; ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Pledge Code</label>
                                                <input type="text" class="form-control" readonly value="<?php echo $editPledge['PledgeCode']; ?>">
                                            </div>
                                        </div>
                                    </div>
                                <?php } else { ?>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Pawn Transaction <span class="text-danger">*</span></label>
                                                <?php if ($pawnTransaction) { ?>
                                                    <input type="hidden" name="pawn_transaction_id" value="<?php echo $pawnTransaction['ID']; ?>">
                                                    <input type="text" class="form-control" readonly 
                                                           value="<?php echo $pawnTransaction['PawnCode'] . ' - ' . $pawnTransaction['CustomerName']; ?>">
                                                <?php } else { ?>
                                                    <select name="pawn_transaction_id" class="form-control" required>
                                                        <option value="">Select Pawn Transaction</option>
                                                        <?php 
                                                        $pawnQuery = mysqli_query($con, "SELECT pt.ID, pt.PawnCode, c.Name as CustomerName 
                                                                                         FROM tblpawntransactions pt 
                                                                                         JOIN tblcustomers c ON pt.CustomerID = c.ID 
                                                                                         WHERE pt.Status = 'Active' 
                                                                                         AND pt.ID NOT IN (SELECT PawnTransactionID FROM tblbankpledges WHERE Status='Active')
                                                                                         ORDER BY pt.CreatedDate DESC");
                                                        while($pawn = mysqli_fetch_assoc($pawnQuery)) {
                                                        ?>
                                                            <option value="<?php echo $pawn['ID']; ?>">
                                                                <?php echo $pawn['PawnCode'] . ' - ' . $pawn['CustomerName']; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Bank Account <span class="text-danger">*</span></label>
                                            <select name="bank_account_id" class="form-control" required <?php echo $editPledge ? 'disabled' : ''; ?>>
                                                <option value="">Select Bank Account</option>
                                                <?php 
                                                mysqli_data_seek($bankAccountsQuery, 0);
                                                while($bank = mysqli_fetch_assoc($bankAccountsQuery)) {
                                                ?>
                                                    <option value="<?php echo $bank['ID']; ?>" 
                                                            <?php echo ($editPledge && $editPledge['BankAccountID'] == $bank['ID']) ? 'selected' : ''; ?>>
                                                        <?php echo $bank['BankDetails']; ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Pledge Amount <span class="text-danger">*</span></label>
                                            <input type="number" name="pledge_amount" class="form-control" step="0.01" required
                                                   value="<?php echo $editPledge ? $editPledge['PledgeAmount'] : ''; ?>">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Pledge Date <span class="text-danger">*</span></label>
                                            <input type="date" name="pledge_date" class="form-control" required
                                                   value="<?php echo $editPledge ? $editPledge['PledgeDate'] : date('Y-m-d'); ?>"
                                                   <?php echo $editPledge ? 'readonly' : ''; ?>>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Maturity Date <span class="text-danger">*</span></label>
                                            <input type="date" name="maturity_date" class="form-control" required
                                                   value="<?php echo $editPledge ? $editPledge['MaturityDate'] : ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Interest Rate (%) <span class="text-danger">*</span></label>
                                            <input type="number" name="interest_rate" class="form-control" step="0.01" required
                                                   value="<?php echo $editPledge ? $editPledge['InterestRate'] : '12'; ?>">
                                        </div>
                                    </div>
                                </div>
                                
                                <?php if($editPledge) { ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="Active" <?php echo ($editPledge['Status'] == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                    <option value="Matured" <?php echo ($editPledge['Status'] == 'Matured') ? 'selected' : ''; ?>>Matured</option>
                                                    <option value="Redeemed" <?php echo ($editPledge['Status'] == 'Redeemed') ? 'selected' : ''; ?>>Redeemed</option>
                                                    <option value="Extended" <?php echo ($editPledge['Status'] == 'Extended') ? 'selected' : ''; ?>>Extended</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea name="notes" class="form-control" rows="3"><?php echo $editPledge ? htmlspecialchars($editPledge['Notes']) : ''; ?></textarea>
                                </div>
                                
                                <button type="submit" name="<?php echo $editPledge ? 'update_pledge' : 'add_pledge'; ?>" 
                                        class="btn btn-primary">
                                    <i class="fas fa-save"></i> <?php echo $editPledge ? 'Update' : 'Create'; ?> Pledge
                                </button>
                                <?php if($editPledge) { ?>
                                    <a href="bank_pledge.php" class="btn btn-secondary">Cancel</a>
                                <?php } ?>
                                <a href="pawn_report_detailed.php" class="btn btn-info">
                                    <i class="fas fa-arrow-left"></i> Back to Report
                                </a>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Bank Pledges List -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Bank Pledges List</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Pledge Code</th>
                                            <th>Pawn Code</th>
                                            <th>Customer</th>
                                            <th>Bank</th>
                                            <th>Pledge Amount</th>
                                            <th>Pledge Date</th>
                                            <th>Maturity Date</th>
                                            <th>Interest Rate</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        if (mysqli_num_rows($pledgesResult) > 0) {
                                            $i = 1; 
                                            while($pledge = mysqli_fetch_assoc($pledgesResult)) { 
                                                $rowClass = '';
                                                if ($pledge['Status'] == 'Active' && $pledge['DaysToMaturity'] < 0) {
                                                    $rowClass = 'overdue-pledge';
                                                } elseif ($pledge['Status'] == 'Active' && $pledge['DaysToMaturity'] <= 7) {
                                                    $rowClass = 'maturity-warning';
                                                }
                                        ?>
                                            <tr class="<?php echo $rowClass; ?>">
                                                <td><?php echo $i++; ?></td>
                                                <td>
                                                    <strong><?php echo $pledge['PledgeCode']; ?></strong>
                                                    <?php if ($pledge['DaysToMaturity'] < 0 && $pledge['Status'] == 'Active') { ?>
                                                        <br><span class="badge badge-danger">Overdue</span>
                                                    <?php } elseif ($pledge['DaysToMaturity'] <= 7 && $pledge['Status'] == 'Active') { ?>
                                                        <br><span class="badge badge-warning"><?php echo $pledge['DaysToMaturity']; ?> days left</span>
                                                    <?php } ?>
                                                </td>
                                                <td><?php echo $pledge['PawnCode']; ?></td>
                                                <td>
                                                    <?php echo $pledge['CustomerName']; ?><br>
                                                    <small><?php echo $pledge['CustomerCode']; ?></small>
                                                </td>
                                                <td>
                                                    <?php echo $pledge['BankName']; ?><br>
                                                    <small><?php echo $pledge['AccountNumber']; ?></small>
                                                </td>
                                                <td>₹<?php echo number_format($pledge['PledgeAmount'], 2); ?></td>
                                                <td><?php echo date('d/m/Y', strtotime($pledge['PledgeDate'])); ?></td>
                                                <td><?php echo date('d/m/Y', strtotime($pledge['MaturityDate'])); ?></td>
                                                <td><?php echo $pledge['InterestRate']; ?>%</td>
                                                <td>
                                                    <span class="badge badge-<?php 
                                                        echo $pledge['Status'] == 'Active' ? 'success' : 
                                                            ($pledge['Status'] == 'Redeemed' ? 'primary' : 'secondary'); 
                                                    ?>">
                                                        <?php echo $pledge['Status']; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="?edit=<?php echo $pledge['ID']; ?>" class="btn btn-sm btn-primary" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php 
                                            }
                                        } else { 
                                        ?>
                                            <tr>
                                                <td colspan="11" class="text-center">No bank pledges found</td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
