<?php
session_start();

// Check if config file exists
$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found. Please create includes/config.php");
}

include_once($configPath);

// Check if database connection exists
if (!isset($con) || !$con) {
    die("Error: Database connection failed. Please check your database configuration.");
}
// Load branding helper
include_once(__DIR__ . '/includes/brand.php');

if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$msg = "";
$userId = $_SESSION['uid'];

// Search and pagination variables
$search = isset($_GET['search']) ? mysqli_real_escape_string($con, $_GET['search']) : '';
$limit = 10; // Records per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Handle form submissions
if ($_POST) {
    if (isset($_POST['add_account'])) {
        $accountCode = "BANK" . str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
        $bankName = mysqli_real_escape_string($con, $_POST['bank_name']);
        $accountHolderName = mysqli_real_escape_string($con, $_POST['account_holder_name']);
        $accountNumber = mysqli_real_escape_string($con, $_POST['account_number']);
        $ifscCode = mysqli_real_escape_string($con, $_POST['ifsc_code']);
        $branchName = mysqli_real_escape_string($con, $_POST['branch_name']);
        $accountType = mysqli_real_escape_string($con, $_POST['account_type']);
        $description = mysqli_real_escape_string($con, $_POST['description']);
        
        // Check if account number already exists
        $checkQuery = mysqli_query($con, "SELECT ID FROM tblbankaccounts WHERE AccountNumber='$accountNumber'");
        if (mysqli_num_rows($checkQuery) > 0) {
            $msg = "Error: Account number already exists!";
        } else {
            $query = "INSERT INTO tblbankaccounts (AccountCode, BankName, AccountHolderName, AccountNumber, IFSCCode, BranchName, AccountType, Description) 
                      VALUES ('$accountCode', '$bankName', '$accountHolderName', '$accountNumber', '$ifscCode', '$branchName', '$accountType', '$description')";
            
            if (mysqli_query($con, $query)) {
                $msg = "Bank account added successfully!";
            } else {
                $msg = "Error adding bank account: " . mysqli_error($con);
            }
        }
    }
    
    if (isset($_POST['update_account'])) {
        $id = (int)$_POST['account_id'];
        $bankName = mysqli_real_escape_string($con, $_POST['bank_name']);
        $accountHolderName = mysqli_real_escape_string($con, $_POST['account_holder_name']);
        $accountNumber = mysqli_real_escape_string($con, $_POST['account_number']);
        $ifscCode = mysqli_real_escape_string($con, $_POST['ifsc_code']);
        $branchName = mysqli_real_escape_string($con, $_POST['branch_name']);
        $accountType = mysqli_real_escape_string($con, $_POST['account_type']);
        $status = mysqli_real_escape_string($con, $_POST['status']);
        $description = mysqli_real_escape_string($con, $_POST['description']);
        
        // Check if account number already exists for other records
        $checkQuery = mysqli_query($con, "SELECT ID FROM tblbankaccounts WHERE AccountNumber='$accountNumber' AND ID != $id");
        if (mysqli_num_rows($checkQuery) > 0) {
            $msg = "Error: Account number already exists!";
        } else {
            $query = "UPDATE tblbankaccounts SET BankName='$bankName', AccountHolderName='$accountHolderName', AccountNumber='$accountNumber', 
                      IFSCCode='$ifscCode', BranchName='$branchName', AccountType='$accountType', 
                      Status='$status', Description='$description' WHERE ID=$id";
            
            if (mysqli_query($con, $query)) {
                $msg = "Bank account updated successfully!";
            } else {
                $msg = "Error updating bank account: " . mysqli_error($con);
            }
        }
    }
}

// Delete bank account
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $query = "DELETE FROM tblbankaccounts WHERE ID=$id";
    if (mysqli_query($con, $query)) {
        $msg = "Bank account deleted successfully!";
    } else {
        $msg = "Error deleting bank account: " . mysqli_error($con);
    }
}

// Get account for editing
$editAccount = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $result = mysqli_query($con, "SELECT * FROM tblbankaccounts WHERE ID=$id");
    $editAccount = mysqli_fetch_assoc($result);
}

// Build search query
$whereClause = "";
if (!empty($search)) {
    $whereClause = "WHERE (BankName LIKE '%$search%' OR AccountHolderName LIKE '%$search%' OR AccountNumber LIKE '%$search%' OR AccountCode LIKE '%$search%' OR IFSCCode LIKE '%$search%')";
}

// Get total count for pagination
$countQuery = "SELECT COUNT(*) as total FROM tblbankaccounts $whereClause";
$countResult = mysqli_query($con, $countQuery);
$totalRecords = mysqli_fetch_assoc($countResult)['total'];
$totalPages = ceil($totalRecords / $limit);

// Fetch bank accounts with search and pagination
$accountsQuery = mysqli_query($con, "SELECT * FROM tblbankaccounts $whereClause ORDER BY CreatedDate DESC LIMIT $limit OFFSET $offset");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?php echo page_title('Bank Account Management'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/compact.css" rel="stylesheet">
    <style>
        .search-container {
            background: #f8f9fc;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid">
                     
                    <?php if($msg) { ?>
                        <div class="alert alert-info"><?php echo $msg; ?></div>
                    <?php } ?>
                    
                    <!-- Add/Edit Bank Account Form -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <?php echo $editAccount ? 'Edit Bank Account' : 'Add New Bank Account'; ?>
                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <?php if($editAccount) { ?>
                                    <input type="hidden" name="account_id" value="<?php echo $editAccount['ID']; ?>">
                                <?php } ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Bank Name <span class="text-danger">*</span></label>
                                            <input type="text" name="bank_name" class="form-control" required
                                                   value="<?php echo $editAccount ? htmlspecialchars($editAccount['BankName']) : ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Holder Name <span class="text-danger">*</span></label>
                                            <input type="text" name="account_holder_name" class="form-control" required
                                                   value="<?php echo $editAccount ? htmlspecialchars($editAccount['AccountHolderName']) : ''; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Number <span class="text-danger">*</span></label>
                                            <input type="text" name="account_number" class="form-control" required
                                                   value="<?php echo $editAccount ? htmlspecialchars($editAccount['AccountNumber']) : ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>IFSC Code <span class="text-danger">*</span></label>
                                            <input type="text" name="ifsc_code" class="form-control" required
                                                   value="<?php echo $editAccount ? htmlspecialchars($editAccount['IFSCCode']) : ''; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Branch Name <span class="text-danger">*</span></label>
                                            <input type="text" name="branch_name" class="form-control" required
                                                   value="<?php echo $editAccount ? htmlspecialchars($editAccount['BranchName']) : ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Account Type <span class="text-danger">*</span></label>
                                            <select name="account_type" class="form-control" required>
                                                <option value="">Select Account Type</option>
                                                <option value="Savings" <?php echo ($editAccount && $editAccount['AccountType'] == 'Savings') ? 'selected' : ''; ?>>Savings</option>
                                                <option value="Current" <?php echo ($editAccount && $editAccount['AccountType'] == 'Current') ? 'selected' : ''; ?>>Current</option>
                                                <option value="Fixed Deposit" <?php echo ($editAccount && $editAccount['AccountType'] == 'Fixed Deposit') ? 'selected' : ''; ?>>Fixed Deposit</option>
                                                <option value="Recurring Deposit" <?php echo ($editAccount && $editAccount['AccountType'] == 'Recurring Deposit') ? 'selected' : ''; ?>>Recurring Deposit</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <?php if($editAccount) { ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Status</label>
                                                <select name="status" class="form-control">
                                                    <option value="Active" <?php echo ($editAccount['Status'] == 'Active') ? 'selected' : ''; ?>>Active</option>
                                                    <option value="Inactive" <?php echo ($editAccount['Status'] == 'Inactive') ? 'selected' : ''; ?>>Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="description" class="form-control" rows="3"><?php echo $editAccount ? htmlspecialchars($editAccount['Description']) : ''; ?></textarea>
                                </div>
                                <button type="submit" name="<?php echo $editAccount ? 'update_account' : 'add_account'; ?>" 
                                        class="btn btn-primary">
                                    <i class="fas fa-save"></i> <?php echo $editAccount ? 'Update' : 'Add'; ?> Account
                                </button>
                                <?php if($editAccount) { ?>
                                    <a href="bank_accounts.php" class="btn btn-secondary">Cancel</a>
                                <?php } ?>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Search Section -->
                    <div class="search-container">
                        <form method="GET" class="row">
                            <div class="col-md-8">
                                <input type="text" name="search" class="form-control" 
                                       placeholder="Search by bank name, account holder, account number, IFSC" 
                                       value="<?php echo htmlspecialchars($search); ?>">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary btn-block">
                                    <i class="fas fa-search"></i> Search
                                </button>
                            </div>
                            <div class="col-md-2">
                                <a href="bank_accounts.php" class="btn btn-secondary btn-block">
                                    <i class="fas fa-refresh"></i> Clear
                                </a>
                            </div>
                        </form>
                    </div>
                    
                    <!-- Bank Accounts List -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">Bank Accounts List</h6>
                            <small class="text-muted">Total: <?php echo $totalRecords; ?></small>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Code</th>
                                            <th>Bank Name</th>
                                            <th>Account Holder</th>
                                            <th>Account Number</th>
                                            <th>IFSC Code</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        if (mysqli_num_rows($accountsQuery) > 0) {
                                            $i = $offset + 1; 
                                            while($account = mysqli_fetch_assoc($accountsQuery)) { 
                                        ?>
                                            <tr>
                                                <td><?php echo $i++; ?></td>
                                                <td><?php echo htmlspecialchars($account['AccountCode']); ?></td>
                                                <td><?php echo htmlspecialchars($account['BankName']); ?></td>
                                                <td><?php echo htmlspecialchars($account['AccountHolderName']); ?></td>
                                                <td><?php echo htmlspecialchars($account['AccountNumber']); ?></td>
                                                <td><?php echo htmlspecialchars($account['IFSCCode']); ?></td>
                                                <td><?php echo htmlspecialchars($account['AccountType']); ?></td>
                                                <td>
                                                    <span class="badge badge-<?php echo $account['Status'] == 'Active' ? 'success' : 'secondary'; ?>">
                                                        <?php echo $account['Status']; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="?edit=<?php echo $account['ID']; ?>" class="btn btn-sm btn-primary" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="?delete=<?php echo $account['ID']; ?>" 
                                                       onclick="return confirm('Are you sure to delete?')" 
                                                       class="btn btn-sm btn-danger" title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php 
                                            }
                                        } else { 
                                        ?>
                                            <tr>
                                                <td colspan="9" class="text-center">No bank accounts found</td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <?php if ($totalPages > 1) { ?>
                                <nav aria-label="Page navigation">
                                    <ul class="pagination justify-content-center">
                                        <?php if ($page > 1) { ?>
                                            <li class="page-item">
                                                <a class="page-link" href="?page=<?php echo ($page-1); ?>&search=<?php echo urlencode($search); ?>">Previous</a>
                                            </li>
                                        <?php } ?>
                                        
                                        <?php for ($i = 1; $i <= $totalPages; $i++) { ?>
                                            <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                                                <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
                                            </li>
                                        <?php } ?>
                                        
                                        <?php if ($page < $totalPages) { ?>
                                            <li class="page-item">
                                                <a class="page-link" href="?page=<?php echo ($page+1); ?>&search=<?php echo urlencode($search); ?>">Next</a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </nav>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
</body>
</html>
             