<?php
session_start();

// Check if config file exists
$configPath = __DIR__ . '/includes/config.php';
if (!file_exists($configPath)) {
    die("Error: Database configuration file not found.");
}

include_once($configPath);

// Check if database connection exists
if (!isset($con) || !$con) {
    die("Error: Database connection failed.");
}

// Check if user is logged in
if (!isset($_SESSION['uid'])) {
    die("Unauthorized access");
}

// Get customer ID
$customerId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($customerId <= 0) {
    die("Invalid customer ID");
}

// Fetch customer details
$query = "SELECT * FROM tblcustomers WHERE ID = $customerId";
$result = mysqli_query($con, $query);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Customer not found");
}

$customer = mysqli_fetch_assoc($result);
?>

<div class="customer-details-view">
    <div class="row">
        <div class="col-md-4">
            <div class="photo-section">
                <?php if($customer['PhotoPath'] && file_exists($customer['PhotoPath'])) { ?>
                    <img src="<?php echo $customer['PhotoPath']; ?>" class="customer-photo" alt="Customer Photo">
                <?php } else { ?>
                    <div class="no-photo-placeholder" style="width: 120px; height: 120px; background: #f8f9fa; border: 2px dashed #ddd; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                        <span class="text-muted">No Photo</span>
                    </div>
                <?php } ?>
                <p class="mt-2"><strong>Customer Photo</strong></p>
            </div>
        </div>
        <div class="col-md-8">
            <table class="details-table table table-bordered">
                <tr>
                    <th width="30%">Customer Code</th>
                    <td><?php echo htmlspecialchars($customer['CustomerCode']); ?></td>
                </tr>
                <tr>
                    <th>Name</th>
                    <td><?php echo htmlspecialchars($customer['Name']); ?></td>
                </tr>
                <tr>
                    <th>Father/Husband Name</th>
                    <td><?php echo htmlspecialchars($customer['FatherHusbandName']); ?></td>
                </tr>
                <tr>
                    <th>Mobile Number</th>
                    <td><?php echo htmlspecialchars($customer['MobileNumber']); ?></td>
                </tr>
                <tr>
                    <th>Address</th>
                    <td><?php echo htmlspecialchars($customer['Address']); ?></td>
                </tr>
                <tr>
                    <th>ID Proof Type</th>
                    <td><?php echo htmlspecialchars($customer['IDProofType']); ?></td>
                </tr>
                <tr>
                    <th>ID Proof Number</th>
                    <td><?php echo htmlspecialchars($customer['IDProofNumber']); ?></td>
                </tr>
                <tr>
                    <th>PAN Number</th>
                    <td><?php echo htmlspecialchars($customer['PANNumber'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Aadhar Number</th>
                    <td><?php echo htmlspecialchars($customer['AadharNumber'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Nominee Name</th>
                    <td><?php echo htmlspecialchars($customer['NomineeName'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Nominee Relationship</th>
                    <td><?php echo htmlspecialchars($customer['NomineeRelationship'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Status</th>
                    <td>
                        <span class="badge badge-<?php echo $customer['Status'] == 'Active' ? 'success' : 'secondary'; ?>">
                            <?php echo $customer['Status']; ?>
                        </span>
                    </td>
                </tr>
                <tr>
                    <th>Created Date</th>
                    <td><?php echo date('d-m-Y H:i:s', strtotime($customer['CreatedDate'])); ?></td>
                </tr>
            </table>
        </div>
    </div>
    
    <?php if($customer['IDProofPath'] && file_exists($customer['IDProofPath'])) { ?>
        <div class="row mt-3">
            <div class="col-12">
                <h6><strong>ID Proof Document</strong></h6>
                <?php
                $fileExtension = strtolower(pathinfo($customer['IDProofPath'], PATHINFO_EXTENSION));
                if (in_array($fileExtension, ['jpg', 'jpeg', 'png', 'gif'])) {
                ?>
                    <img src="<?php echo $customer['IDProofPath']; ?>" style="max-width: 100%; max-height: 300px; border: 1px solid #ddd;" alt="ID Proof">
                <?php } else { ?>
                    <p><a href="<?php echo $customer['IDProofPath']; ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-file-pdf"></i> View ID Proof Document
                    </a></p>
                <?php } ?>
            </div>
        </div>
    <?php } ?>
</div>

<style>
.customer-details-view .customer-photo {
    width: 120px;
    height: 120px;
    object-fit: cover;
    border: 2px solid #ddd;
    border-radius: 5px;
}

.customer-details-view .details-table th {
    background-color: #f8f9fa;
    font-weight: 600;
}

.customer-details-view .photo-section {
    text-align: center;
}

@media print {
    .customer-details-view {
        font-size: 12px;
    }
    
    .customer-details-view .customer-photo {
        width: 100px;
        height: 100px;
    }
    
    .customer-details-view .details-table {
        font-size: 11px;
    }
    
    .customer-details-view .details-table th,
    .customer-details-view .details-table td {
        padding: 6px;
    }
}
</style>