<?php
session_start();
include_once('includes/config.php');

// Determine user type and ID
$isAdmin = isset($_SESSION['aid']);
$userId = $isAdmin ? $_SESSION['aid'] : (isset($_SESSION['uid']) ? $_SESSION['uid'] : null);
$userType = $isAdmin ? 'admin' : (isset($_SESSION['usertype']) ? $_SESSION['usertype'] : null);

if (!$userId) {
    header('location:login.php');
    exit();
}

// Handle Create, Update, Delete
if (isset($_POST['save'])) {
    $task = $_POST['task'];
    $status = $_POST['status'];
    if ($_POST['id'] == '') {
        $stmt = $con->prepare("INSERT INTO todo_list (task, status, user_id) VALUES (?, ?, ?)");
        $stmt->bind_param("ssi", $task, $status, $userId);
        $stmt->execute();
    } else {
        $id = intval($_POST['id']);
        // Only allow update if admin or owner
        if ($isAdmin) {
            $stmt = $con->prepare("UPDATE todo_list SET task=?, status=? WHERE id=?");
            $stmt->bind_param("ssi", $task, $status, $id);
        } else {
            $stmt = $con->prepare("UPDATE todo_list SET task=?, status=? WHERE id=? AND user_id=?");
            $stmt->bind_param("ssii", $task, $status, $id, $userId);
        }
        $stmt->execute();
    }
    header("Location: todo-list.php");
    exit();
}
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    // Only allow delete if admin or owner
    if ($isAdmin) {
        $con->query("DELETE FROM todo_list WHERE id=$id");
    } else {
        $stmt = $con->prepare("DELETE FROM todo_list WHERE id=? AND user_id=?");
        $stmt->bind_param("ii", $id, $userId);
        $stmt->execute();
    }
    header("Location: todo-list.php");
    exit();
}

// Handle status toggle
if (isset($_GET['toggle_status'])) {
    $id = intval($_GET['toggle_status']);
    // Only allow toggle if admin or owner
    $query = $isAdmin ? "SELECT status FROM todo_list WHERE id=$id" : "SELECT status FROM todo_list WHERE id=$id AND user_id=$userId";
    $res = $con->query($query);
    if ($row = $res->fetch_assoc()) {
        $current = $row['status'];
        // Cycle: Pending -> Follow Up -> Complete -> Pending
        if ($current == 'Pending') $next = 'Follow Up';
        else if ($current == 'Follow Up') $next = 'Complete';
        else $next = 'Pending';
        $stmt = $con->prepare("UPDATE todo_list SET status=? WHERE id=? " . ($isAdmin ? "" : "AND user_id=?"));
        if ($isAdmin) {
            $stmt->bind_param("si", $next, $id);
        } else {
            $stmt->bind_param("sii", $next, $id, $userId);
        }
        $stmt->execute();
    }
    header("Location: todo-list.php");
    exit();
}

// AJAX status toggle handler
if (isset($_POST['ajax_toggle_status'])) {
    $id = intval($_POST['ajax_toggle_status']);
    $query = $isAdmin ? "SELECT status FROM todo_list WHERE id=$id" : "SELECT status FROM todo_list WHERE id=$id AND user_id=$userId";
    $res = $con->query($query);
    $newStatus = '';
    if ($row = $res->fetch_assoc()) {
        $current = $row['status'];
        if ($current == 'Pending') $newStatus = 'Follow Up';
        else if ($current == 'Follow Up') $newStatus = 'Complete';
        else $newStatus = 'Pending';
        $stmt = $con->prepare("UPDATE todo_list SET status=? WHERE id=? " . ($isAdmin ? "" : "AND user_id=?"));
        if ($isAdmin) {
            $stmt->bind_param("si", $newStatus, $id);
        } else {
            $stmt->bind_param("sii", $newStatus, $id, $userId);
        }
        $stmt->execute();
    }
    // Return new status and badge class
    $badgeClass = 'badge-secondary';
    if ($newStatus == 'Pending') $badgeClass = 'badge-warning';
    else if ($newStatus == 'Follow Up') $badgeClass = 'badge-followup';
    else if ($newStatus == 'Complete') $badgeClass = 'badge-success';
    header('Content-Type: application/json');
    echo json_encode([
        'status' => $newStatus,
        'badgeClass' => $badgeClass
    ]);
    exit();
}

// Date and status filter logic
$from = isset($_GET['from']) ? $_GET['from'] : date('Y-m-d', strtotime('monday this week'));
$to = isset($_GET['to']) ? $_GET['to'] : date('Y-m-d', strtotime('sunday this week'));
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';

// Fetch filtered tasks
$query = "SELECT * FROM todo_list WHERE DATE(created_at) BETWEEN ? AND ?";
$params = [$from, $to];
$types = "ss";
if ($status_filter && in_array($status_filter, ['Pending','Follow Up','Complete'])) {
    $query .= " AND status=?";
    $params[] = $status_filter;
    $types .= "s";
}
// Only show own tasks for staff
if (!$isAdmin) {
    $query .= " AND user_id=?";
    $params[] = $userId;
    $types .= "i";
}
$query .= " ORDER BY id DESC";
$stmt = $con->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$todos = [];
while ($row = $result->fetch_assoc()) {
    $todos[] = $row;
}
$stmt->close();

// For edit
$edit = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $query = $isAdmin ? "SELECT * FROM todo_list WHERE id=$id" : "SELECT * FROM todo_list WHERE id=$id AND user_id=$userId";
    $res = $con->query($query);
    $edit = $res->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Jagadamba Opticals | To-Do List</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        body { background: #f8f9fc; }
        .card { border-radius: 1rem; }
        .form-control, .btn { border-radius: 0.5rem; }
        .btn-primary, .btn-info, .btn-danger, .btn-secondary { min-width: 90px; }
        .table th, .table td { vertical-align: middle !important; }
        .strikeout { text-decoration: line-through; color: #888; }
        .badge-followup { background-color: #ffc107; color: #212529; }
        @media (max-width: 991.98px) {
            .col-lg-5, .col-lg-7 { flex: 0 0 100%; max-width: 100%; }
            .card { margin-bottom: 1.5rem; }
        }
        @media (max-width: 600px) {
            .table-responsive { font-size: 13px; }
            .form-group label { font-size: 15px; }
            .card-header { font-size: 16px; }
            .btn { font-size: 14px; }
        }
    </style>
</head>
<body id="page-top">
<div id="wrapper">
<?php include_once('includes/sidebar.php');?>
<div id="content-wrapper" class="d-flex flex-column">
<div id="content">
<?php include_once('includes/topbar.php');?>
<div class="container-fluid">

    <!-- Filter Form -->
    <div class="row mb-3">
        <div class="col-lg-12">
            <form class="form-inline" method="get" action="">
                <label class="mr-2 font-weight-bold">From</label>
                <input type="date" name="from" class="form-control mr-2 mb-2" value="<?php echo htmlspecialchars($from); ?>">
                <label class="mr-2 font-weight-bold">To</label>
                <input type="date" name="to" class="form-control mr-2 mb-2" value="<?php echo htmlspecialchars($to); ?>">
                <label class="mr-2 font-weight-bold">Status</label>
                <select name="status" class="form-control mr-2 mb-2">
                    <option value="">All</option>
                    <option value="Pending" <?php if($status_filter=='Pending') echo 'selected'; ?>>Pending</option>
                    <option value="Follow Up" <?php if($status_filter=='Follow Up') echo 'selected'; ?>>Follow Up</option>
                    <option value="Complete" <?php if($status_filter=='Complete') echo 'selected'; ?>>Complete</option>
                </select>
                <button type="submit" class="btn btn-info mb-2">Filter</button>
                <a href="todo-list.php" class="btn btn-secondary mb-2 ml-2">Reset</a>
            </form>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-5 mb-4">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-primary text-white py-3">
                    <h6 class="m-0 font-weight-bold"><?php echo $edit ? 'Edit' : 'Add'; ?> Task</h6>
                </div>
                <div class="card-body">
                    <form method="post" autocomplete="off">
                        <input type="hidden" name="id" value="<?php echo $edit ? $edit['id'] : ''; ?>">
                        <div class="form-group">
                            <label><i class="fas fa-tasks"></i> Task</label>
                            <input type="text" name="task" class="form-control" required value="<?php echo $edit ? htmlspecialchars($edit['task']) : ''; ?>" placeholder="Enter task">
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-toggle-on"></i> Status</label>
                            <select name="status" class="form-control" required>
                                <option value="Pending" <?php if($edit && $edit['status']=='Pending') echo 'selected'; ?>>Pending</option>
                                <option value="Follow Up" <?php if($edit && $edit['status']=='Follow Up') echo 'selected'; ?>>Follow Up</option>
                                <option value="Complete" <?php if($edit && $edit['status']=='Complete') echo 'selected'; ?>>Complete</option>
                            </select>
                        </div>
                        <div class="form-group d-flex flex-wrap gap-2">
                            <button type="submit" name="save" class="btn btn-primary mr-2"><?php echo $edit ? 'Update' : 'Add'; ?> Task</button>
                            <?php if($edit): ?>
                                <a href="todo-list.php" class="btn btn-secondary">Cancel</a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-7 mb-4">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-info text-white py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold">To-Do List</h6>
                </div>
                <div class="card-body table-responsive p-0">
                    <table class="table table-bordered table-hover mb-0" id="todo-table">
                        <thead class="thead-light">
                            <tr>
                                <th>Task</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th style="min-width:80px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach($todos as $row): ?>
                            <tr id="row-<?php echo $row['id']; ?>">
                                <td class="<?php echo $row['status']=='Complete' ? 'strikeout' : ''; ?>" id="task-<?php echo $row['id']; ?>">
                                    <?php echo htmlspecialchars($row['task']); ?>
                                </td>
                                <td>
                                    <?php
                                        $badgeClass = 'badge-secondary';
                                        if ($row['status'] == 'Pending') $badgeClass = 'badge-warning';
                                        else if ($row['status'] == 'Follow Up') $badgeClass = 'badge-followup';
                                        else if ($row['status'] == 'Complete') $badgeClass = 'badge-success';
                                    ?>
                                    <span class="badge <?php echo $badgeClass; ?> status-toggle"
                                        data-id="<?php echo $row['id']; ?>"
                                        style="cursor:pointer;"
                                        id="status-<?php echo $row['id']; ?>"
                                        title="Change Status">
                                        <?php echo htmlspecialchars($row['status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <?php echo date('d-M-Y', strtotime($row['created_at'])); ?>
                                </td>
                                <td>
                                    <a href="?edit=<?php echo $row['id']; ?>&from=<?php echo urlencode($from); ?>&to=<?php echo urlencode($to); ?>" class="btn btn-sm btn-info mb-1" title="Edit"><i class="fas fa-edit"></i></a>
                                    <a href="?del=<?php echo $row['id']; ?>&from=<?php echo urlencode($from); ?>&to=<?php echo urlencode($to); ?>" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Delete this task?');" title="Delete"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; if(empty($todos)): ?>
                            <tr><td colspan="4" class="text-center">No tasks found.</td></tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php include_once('includes/footer.php');?>
</div>
</div>
<?php include_once('includes/footer2.php');?>
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>
<script src="js/sb-admin-2.min.js"></script>
<script>
$(document).ready(function(){
    $('.status-toggle').click(function(){
        var id = $(this).data('id');
        var $badge = $(this);
        $.ajax({
            url: '',
            type: 'POST',
            data: { ajax_toggle_status: id },
            dataType: 'json',
            success: function(resp) {
                $badge.text(resp.status);
                $badge.removeClass().addClass('badge status-toggle ' + resp.badgeClass);
                // Strikeout for Complete, remove otherwise
                var $task = $('#task-' + id);
                if(resp.status === 'Complete') {
                    $task.addClass('strikeout');
                } else {
                    $task.removeClass('strikeout');
                }
            }
        });
    });
});
</script>
</body>
</html>
