<?php
// Test SMS function
require_once 'includes/config.php';
require_once 'includes/sms-functions.php';

echo "=== SMS System Test ===\n";
echo "SMS Provider: " . (defined('SMS_PROVIDER') ? SMS_PROVIDER : 'undefined') . "\n";

// Test SMS sending
$result = sendSMS('9876543210', 'Test message from SMS system', 'Test Customer');

echo "SMS Result: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";

if ($result['success']) {
    echo "✅ SMS system is working correctly!\n";
} else {
    echo "❌ SMS system issue: " . $result['message'] . "\n";
}

echo "\n=== Testing Bulk SMS Function ===\n";

$testCustomers = [
    [
        'id' => 1,
        'customer_name' => 'Test Customer 1',
        'mobile' => '9876543210'
    ],
    [
        'id' => 2, 
        'customer_name' => 'Test Customer 2',
        'mobile' => '9876543211'
    ]
];

$bulkResults = sendBulkSMS($testCustomers, 'Hello [Customer Name], this is a test message.');

echo "Bulk SMS Results: " . json_encode($bulkResults, JSON_PRETTY_PRINT) . "\n";

$successCount = count(array_filter($bulkResults, function($r) { return $r['success']; }));
echo "Bulk SMS Success Count: $successCount / " . count($bulkResults) . "\n";

if ($successCount > 0) {
    echo "✅ Bulk SMS system is working correctly!\n";
} else {
    echo "❌ Bulk SMS system has issues\n";
}
?>