<?php
// Customer Prescriptions Dashboard Widget
// Include this in your main dashboard.php file

// Get prescription statistics
$stats_query = "SELECT 
    COUNT(*) as total_prescriptions,
    SUM(CASE WHEN order_status = 'Pending' THEN 1 ELSE 0 END) as pending_orders,
    SUM(CASE WHEN order_status = 'Ready' THEN 1 ELSE 0 END) as ready_orders,
    SUM(CASE WHEN order_status = 'Delivered' THEN 1 ELSE 0 END) as delivered_orders,
    SUM(total_amount) as total_revenue,
    SUM(balance_amount) as pending_balance
    FROM customer_prescriptions";

if (!$isAdmin) {
    $stats_query .= " WHERE user_id = $userId";
}

$stats_result = $con->query($stats_query);
$stats = $stats_result->fetch_assoc();

// Get recent prescriptions
$recent_query = "SELECT customer_name, mobile, order_status, total_amount, balance_amount, created_at 
                 FROM customer_prescriptions";

if (!$isAdmin) {
    $recent_query .= " WHERE user_id = $userId";
}

$recent_query .= " ORDER BY created_at DESC LIMIT 5";
$recent_result = $con->query($recent_query);
?>

<!-- Customer Prescriptions Dashboard Widget -->
<div class="row mb-4">
    <div class="col-xl-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-glasses mr-2"></i>Customer Prescriptions Overview
                </h6>
                <a href="customer-prescriptions.php" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> Add New Prescription
                </a>
            </div>
            <div class="card-body">
                
                <!-- Statistics Cards -->
                <div class="row">
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Prescriptions</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo number_format($stats['total_prescriptions']); ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-glasses fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Pending Orders</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?php echo number_format($stats['pending_orders']); ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-clock fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Total Revenue</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            ₹<?php echo number_format($stats['total_revenue'], 2); ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Pending Balance</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            ₹<?php echo number_format($stats['pending_balance'], 2); ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Prescriptions -->
                <div class="row">
                    <div class="col-lg-12">
                        <h6 class="font-weight-bold text-primary mb-3">Recent Prescriptions</h6>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Customer</th>
                                        <th>Mobile</th>
                                        <th>Status</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($row = $recent_result->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['mobile']); ?></td>
                                        <td>
                                            <span class="badge badge-<?php 
                                                if($row['order_status'] == 'Pending') echo 'warning';
                                                else if($row['order_status'] == 'In Progress') echo 'info';
                                                else if($row['order_status'] == 'Ready') echo 'success';
                                                else if($row['order_status'] == 'Delivered') echo 'secondary';
                                                else echo 'danger';
                                            ?>">
                                                <?php echo htmlspecialchars($row['order_status']); ?>
                                            </span>
                                        </td>
                                        <td>₹<?php echo number_format($row['total_amount'], 2); ?></td>
                                        <td class="<?php echo $row['balance_amount'] > 0 ? 'text-danger' : 'text-success'; ?>">
                                            ₹<?php echo number_format($row['balance_amount'], 2); ?>
                                        </td>
                                        <td><?php echo date('d-M-Y', strtotime($row['created_at'])); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                    <?php if($recent_result->num_rows == 0): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No prescriptions found</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-right mt-3">
                            <a href="customer-prescriptions.php" class="btn btn-primary btn-sm">
                                View All Prescriptions <i class="fas fa-arrow-right ml-1"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
