<?php
header('Content-Type: application/json');
include_once('../../includes/config.php');

// Check if user is logged in
session_start();
if (!isset($_SESSION['uid'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$query = $_GET['q'] ?? '';

if (strlen($query) < 2) {
    echo json_encode([]);
    exit();
}

$query = mysqli_real_escape_string($con, $query);

$searchQuery = "SELECT ID, CustomerCode, CustomerName, CompanyName 
                FROM tblcustomers 
                WHERE IsActive = 1 
                AND (CustomerCode LIKE '%$query%' 
                     OR CustomerName LIKE '%$query%' 
                     OR CompanyName LIKE '%$query%')
                ORDER BY CustomerName 
                LIMIT 10";

$result = mysqli_query($con, $searchQuery);
$customers = [];

while ($row = mysqli_fetch_assoc($result)) {
    $customers[] = $row;
}

echo json_encode($customers);
?>
