<?php
session_start();
include_once('../includes/config.php');

// Helper function to safely escape HTML content
function safe_htmlspecialchars($string) {
    return htmlspecialchars($string ?? '', ENT_QUOTES, 'UTF-8');
}

// Check if user is logged in
if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];
$message = '';

// Handle form submission
if ($_POST) {
    $action = $_POST['action'] ?? '';
    
    if ($action == 'add_transaction') {
        $customerId = intval($_POST['customer_id']);
        $invoiceNumber = mysqli_real_escape_string($con, $_POST['invoice_number']);
        $transactionType = mysqli_real_escape_string($con, $_POST['transaction_type']);
        $transactionDate = mysqli_real_escape_string($con, $_POST['transaction_date']);
        $dueDate = mysqli_real_escape_string($con, $_POST['due_date']);
        $amount = floatval($_POST['amount']);
        $taxAmount = floatval($_POST['tax_amount']);
        $description = mysqli_real_escape_string($con, $_POST['description']);
        $paymentMode = mysqli_real_escape_string($con, $_POST['payment_mode']);
        $referenceNumber = mysqli_real_escape_string($con, $_POST['reference_number']);
        
        // Calculate balance amount based on transaction type
        $balanceAmount = $amount;
        if ($transactionType == 'Payment' || $transactionType == 'Credit Note') {
            $balanceAmount = 0; // Payments and credit notes are fully settled
        }
        
        // Handle file upload
        $attachmentPath = null;
        if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] == 0) {
            $uploadDir = 'uploads/invoices/';
            $fileName = time() . '_' . $_FILES['attachment']['name'];
            $uploadPath = $uploadDir . $fileName;
            
            if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadPath)) {
                $attachmentPath = $uploadPath;
            }
        }
        
        $query = "INSERT INTO tblcustomer_accounts 
                  (CustomerID, InvoiceNumber, TransactionType, TransactionDate, DueDate, Amount, BalanceAmount, TaxAmount, Description, PaymentMode, ReferenceNumber, AttachmentPath, AddedBy) 
                  VALUES 
                  ('$customerId', '$invoiceNumber', '$transactionType', '$transactionDate', '$dueDate', '$amount', '$balanceAmount', '$taxAmount', '$description', '$paymentMode', '$referenceNumber', '$attachmentPath', '$userId')";
        
        if (mysqli_query($con, $query)) {
            // Update customer balance
            if ($transactionType == 'Invoice' || $transactionType == 'Debit Note') {
                $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance + $amount WHERE ID = $customerId";
            } else {
                $updateQuery = "UPDATE tblcustomers SET CurrentBalance = CurrentBalance - $amount WHERE ID = $customerId";
            }
            mysqli_query($con, $updateQuery);
            
            $message = '<div class="alert alert-success">Transaction added successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error: ' . mysqli_error($con) . '</div>';
        }
    }
}

// Get customers for dropdown
$customersQuery = "SELECT ID, CustomerCode, CustomerName FROM tblcustomers WHERE IsActive = 1 ORDER BY CustomerName";
$customersResult = mysqli_query($con, $customersQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Add Transaction - Ihita</title>
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    
    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column" style="margin-left: 0 !important;">
            <!-- Main Content -->
            <div id="content">
                <!-- Topbar -->
                <?php include_once('includes/customer-topbar.php'); ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Add Customer Transaction</h1>
                        <a href="accounts.php" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
                            <i class="fas fa-list fa-sm text-white-50"></i> View All Accounts
                        </a>
                    </div>

                    <?php echo $message; ?>

                    <!-- Transaction Form -->
                    <div class="row">
                        <div class="col-lg-8 mx-auto">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Transaction Details</h6>
                                </div>
                                <div class="card-body">
                                    <form method="POST" enctype="multipart/form-data">
                                        <input type="hidden" name="action" value="add_transaction">
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="customer_id">Customer *</label>
                                                    <select name="customer_id" id="customer_id" class="form-control" required>
                                                        <option value="">Select Customer</option>
                                                        <?php while ($customer = mysqli_fetch_assoc($customersResult)): ?>
                                                            <option value="<?php echo $customer['ID']; ?>">
                                                                <?php echo htmlspecialchars($customer['CustomerCode'] . ' - ' . $customer['CustomerName']); ?>
                                                            </option>
                                                        <?php endwhile; ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="transaction_type">Transaction Type *</label>
                                                    <select name="transaction_type" id="transaction_type" class="form-control" required>
                                                        <option value="Invoice">Invoice (Customer owes money)</option>
                                                        <option value="Payment">Payment (Customer pays money)</option>
                                                        <option value="Credit Note">Credit Note (Reduce customer debt)</option>
                                                        <option value="Debit Note">Debit Note (Increase customer debt)</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="invoice_number">Invoice/Reference Number *</label>
                                                    <input type="text" name="invoice_number" id="invoice_number" class="form-control" required 
                                                           placeholder="INV-001, PAY-001, etc.">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="transaction_date">Transaction Date *</label>
                                                    <input type="date" name="transaction_date" id="transaction_date" class="form-control" required 
                                                           value="<?php echo date('Y-m-d'); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="amount">Amount *</label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text">₹</span>
                                                        </div>
                                                        <input type="number" name="amount" id="amount" class="form-control" step="0.01" required 
                                                               placeholder="0.00">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="tax_amount">Tax Amount</label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text">₹</span>
                                                        </div>
                                                        <input type="number" name="tax_amount" id="tax_amount" class="form-control" step="0.01" 
                                                               value="0" placeholder="0.00">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="due_date">Due Date</label>
                                                    <input type="date" name="due_date" id="due_date" class="form-control">
                                                    <small class="form-text text-muted">Leave empty if not applicable</small>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="payment_mode">Payment Mode</label>
                                                    <select name="payment_mode" id="payment_mode" class="form-control">
                                                        <option value="">Select Mode</option>
                                                        <option value="Cash">Cash</option>
                                                        <option value="Bank Transfer">Bank Transfer</option>
                                                        <option value="UPI">UPI</option>
                                                        <option value="Card">Card</option>
                                                        <option value="Cheque">Cheque</option>
                                                        <option value="Online">Online</option>
                                                        <option value="NEFT">NEFT</option>
                                                        <option value="RTGS">RTGS</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="reference_number">Reference Number</label>
                                                    <input type="text" name="reference_number" id="reference_number" class="form-control" 
                                                           placeholder="Transaction/UTR/Cheque No.">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="attachment">Attachment</label>
                                                    <input type="file" name="attachment" id="attachment" class="form-control-file">
                                                    <small class="form-text text-muted">Upload invoice, receipt or related document</small>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea name="description" id="description" class="form-control" rows="3" 
                                                      placeholder="Add details about this transaction..."></textarea>
                                        </div>

                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fas fa-save"></i> Add Transaction
                                            </button>
                                            <a href="accounts.php" class="btn btn-secondary ml-2">
                                                <i class="fas fa-times"></i> Cancel
                                            </a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Help -->
                    <div class="row">
                        <div class="col-lg-8 mx-auto">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-info">
                                        <i class="fas fa-info-circle"></i> Transaction Types Guide
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <strong class="text-primary">Invoice:</strong>
                                                <p class="small mb-1">When you sell goods/services to customer</p>
                                                <p class="small text-muted">Customer owes you money (Increases their debt)</p>
                                            </div>
                                            <div class="mb-3">
                                                <strong class="text-success">Payment:</strong>
                                                <p class="small mb-1">When customer pays you money</p>
                                                <p class="small text-muted">Customer pays their debt (Reduces their debt)</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <strong class="text-info">Credit Note:</strong>
                                                <p class="small mb-1">When you give credit to customer</p>
                                                <p class="small text-muted">Returns, discounts (Reduces their debt)</p>
                                            </div>
                                            <div class="mb-3">
                                                <strong class="text-warning">Debit Note:</strong>
                                                <p class="small mb-1">When you charge additional amount</p>
                                                <p class="small text-muted">Extra charges, penalties (Increases their debt)</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <?php include_once('includes/customer-footer.php'); ?>
            <!-- End of Footer -->
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

    <script>
        $(document).ready(function() {
            // Auto-set due date for invoices (30 days from transaction date)
            $('#transaction_type, #transaction_date').change(function() {
                if ($('#transaction_type').val() === 'Invoice' && $('#transaction_date').val()) {
                    var transactionDate = new Date($('#transaction_date').val());
                    transactionDate.setDate(transactionDate.getDate() + 30);
                    $('#due_date').val(transactionDate.toISOString().split('T')[0]);
                } else if ($('#transaction_type').val() !== 'Invoice') {
                    $('#due_date').val('');
                }
            });

            // Auto-generate reference number based on type
            $('#transaction_type').change(function() {
                var type = $(this).val();
                var now = new Date();
                var timestamp = now.getTime().toString().slice(-6);
                
                var prefix = '';
                switch(type) {
                    case 'Invoice': prefix = 'INV-'; break;
                    case 'Payment': prefix = 'PAY-'; break;
                    case 'Credit Note': prefix = 'CN-'; break;
                    case 'Debit Note': prefix = 'DN-'; break;
                }
                
                if (prefix && !$('#invoice_number').val()) {
                    $('#invoice_number').val(prefix + timestamp);
                }
            });

            // Calculate tax automatically (you can modify this as needed)
            $('#amount').on('input', function() {
                var amount = parseFloat($(this).val()) || 0;
                // Auto-calculate 18% GST (modify as needed)
                // var tax = amount * 0.18;
                // $('#tax_amount').val(tax.toFixed(2));
            });
        });
    </script>
</body>
</html>
