# Customer Management Module

This module provides comprehensive customer and customer account management functionality for the Ihita application.

## Features

### Customer Management
- Add, edit, and manage customer information
- Customer details including contact information, credit limits, tax numbers
- Active/inactive status management
- Company and personal customer support

### Customer Accounts
- Invoice management with due dates
- Payment tracking and recording
- Credit notes and debit notes
- Multiple payment modes support
- Transaction status tracking (Pending, Partial, Paid, Overdue)
- File attachment support for invoices and receipts

### Reporting and Analytics
- Customer-wise transaction reports
- Outstanding balance reports
- Aging analysis of overdue payments
- Monthly trend analysis
- Export functionality (CSV, Excel, PDF)
- Print-friendly reports

### Key Components

#### Files Structure
- `index.php` - Dashboard with overview statistics
- `customers.php` - Customer management interface
- `accounts.php` - Customer account transactions
- `add-transaction.php` - Add new transactions
- `reports.php` - Comprehensive reporting module
- `css/customer.css` - Custom styling
- `js/customer.js` - JavaScript functionality
- `api/customer-search.php` - Customer search API

#### Database Tables
- `tblcustomers` - Customer master data
- `tblcustomer_accounts` - Transaction records

## Usage

### Adding a Customer
1. Navigate to Customer Management
2. Click "Add New Customer"
3. Fill in customer details including:
   - Customer code (unique identifier)
   - Contact information
   - Credit limit
   - Tax number (if applicable)

### Recording Transactions
1. Go to "Add Transaction"
2. Select customer
3. Choose transaction type:
   - **Invoice**: Customer owes money
   - **Payment**: Customer pays money
   - **Credit Note**: Reduce customer debt
   - **Debit Note**: Increase customer debt
4. Enter amount, dates, and other details
5. Attach supporting documents if needed

### Managing Payments
1. View customer accounts
2. For pending invoices, click the payment button
3. Enter payment amount (partial or full)
4. System automatically updates balances

### Generating Reports
1. Access Reports section
2. Apply filters (date range, customer, status)
3. View various reports:
   - Customer-wise summary
   - Outstanding aging
   - Monthly trends
4. Export or print as needed

## Transaction Types Explained

- **Invoice**: Records a sale or service provided to customer (increases customer debt)
- **Payment**: Records money received from customer (decreases customer debt)
- **Credit Note**: Adjustment in favor of customer - refunds, discounts (decreases customer debt)
- **Debit Note**: Additional charges to customer - penalties, extra fees (increases customer debt)

## Features

### Automatic Calculations
- Outstanding balances automatically calculated
- Payment tracking with partial payment support
- Credit limit monitoring
- Aging analysis for overdue amounts

### Status Management
- **Pending**: Unpaid invoices
- **Partial**: Partially paid invoices
- **Paid**: Fully paid invoices
- **Overdue**: Past due date invoices

### Search and Filter
- Quick customer search
- Filter by date ranges
- Filter by transaction types
- Filter by payment status

## Installation Notes

The module automatically creates required database tables on first access. Ensure proper database permissions are set.

## Security

- Session-based authentication required
- Input validation and sanitization
- File upload restrictions
- SQL injection protection

## Customization

The module uses Bootstrap 4 styling and can be customized through:
- `css/customer.css` for styling
- `js/customer.js` for functionality
- Database schema modifications as needed
