<?php
session_start();
include_once('includes/config.php');

// Determine user type and ID
$isAdmin = isset($_SESSION['aid']);
$userId = $isAdmin ? $_SESSION['aid'] : (isset($_SESSION['uid']) ? $_SESSION['uid'] : null);
$userType = $isAdmin ? 'admin' : (isset($_SESSION['usertype']) ? $_SESSION['usertype'] : null);

if (!$userId) {
    header('location:login.php');
    exit();
}

// AJAX endpoint for mobile number suggestions
if (isset($_POST['ajax_search_mobile'])) {
    $search = $_POST['ajax_search_mobile'];
        $query = "SELECT DISTINCT 
                                customer_name, 
                                mobile, 
                                address,
                                (SELECT customer_age FROM customer_prescriptions cp_age WHERE cp_age.mobile = cp1.mobile AND cp_age.customer_age IS NOT NULL ORDER BY cp_age.created_at DESC LIMIT 1) as customer_age,
                                (SELECT customer_sex FROM customer_prescriptions cp_sex WHERE cp_sex.mobile = cp1.mobile AND cp_sex.customer_sex IS NOT NULL ORDER BY cp_sex.created_at DESC LIMIT 1) as customer_sex,
                                (SELECT SUM(balance_amount) FROM customer_prescriptions cp2 WHERE cp2.mobile = cp1.mobile AND cp2.order_status != 'Cancelled') as outstanding_balance,
                                (SELECT COUNT(*) FROM customer_prescriptions cp3 WHERE cp3.mobile = cp1.mobile) as total_orders,
                                (SELECT right_eye_sph FROM customer_prescriptions cp4 WHERE cp4.mobile = cp1.mobile AND cp4.order_status != 'Cancelled' ORDER BY cp4.created_at DESC LIMIT 1) AS last_right_eye_sph,
                                (SELECT right_eye_cyl FROM customer_prescriptions cp5 WHERE cp5.mobile = cp1.mobile AND cp5.order_status != 'Cancelled' ORDER BY cp5.created_at DESC LIMIT 1) AS last_right_eye_cyl,
                                (SELECT right_eye_axis FROM customer_prescriptions cp6 WHERE cp6.mobile = cp1.mobile AND cp6.order_status != 'Cancelled' ORDER BY cp6.created_at DESC LIMIT 1) AS last_right_eye_axis,
                                (SELECT right_eye_addition FROM customer_prescriptions cp7 WHERE cp7.mobile = cp1.mobile AND cp7.order_status != 'Cancelled' ORDER BY cp7.created_at DESC LIMIT 1) AS last_right_eye_addition,
                                (SELECT left_eye_sph FROM customer_prescriptions cp8 WHERE cp8.mobile = cp1.mobile AND cp8.order_status != 'Cancelled' ORDER BY cp8.created_at DESC LIMIT 1) AS last_left_eye_sph,
                                (SELECT left_eye_cyl FROM customer_prescriptions cp9 WHERE cp9.mobile = cp1.mobile AND cp9.order_status != 'Cancelled' ORDER BY cp9.created_at DESC LIMIT 1) AS last_left_eye_cyl,
                                (SELECT left_eye_axis FROM customer_prescriptions cp10 WHERE cp10.mobile = cp1.mobile AND cp10.order_status != 'Cancelled' ORDER BY cp10.created_at DESC LIMIT 1) AS last_left_eye_axis,
                                (SELECT left_eye_addition FROM customer_prescriptions cp11 WHERE cp11.mobile = cp1.mobile AND cp11.order_status != 'Cancelled' ORDER BY cp11.created_at DESC LIMIT 1) AS last_left_eye_addition
                            FROM customer_prescriptions cp1 
                            WHERE (mobile LIKE ? OR customer_name LIKE ?)
                            GROUP BY mobile, customer_name, address
                            ORDER BY MAX(created_at) DESC
                            LIMIT 5";
    
    if (!$isAdmin) {
                $query = "SELECT DISTINCT 
                                        customer_name, 
                                        mobile, 
                                        address,
                                        (SELECT customer_age FROM customer_prescriptions cp_age WHERE cp_age.mobile = cp1.mobile AND cp_age.customer_age IS NOT NULL AND cp_age.user_id = ? ORDER BY cp_age.created_at DESC LIMIT 1) as customer_age,
                                        (SELECT customer_sex FROM customer_prescriptions cp_sex WHERE cp_sex.mobile = cp1.mobile AND cp_sex.customer_sex IS NOT NULL AND cp_sex.user_id = ? ORDER BY cp_sex.created_at DESC LIMIT 1) as customer_sex,
                                        (SELECT SUM(balance_amount) FROM customer_prescriptions cp2 WHERE cp2.mobile = cp1.mobile AND cp2.order_status != 'Cancelled' AND cp2.user_id = ?) as outstanding_balance,
                                        (SELECT COUNT(*) FROM customer_prescriptions cp3 WHERE cp3.mobile = cp1.mobile AND cp3.user_id = ?) as total_orders,
                                        (SELECT right_eye_sph FROM customer_prescriptions cp4 WHERE cp4.mobile = cp1.mobile AND cp4.user_id = cp1.user_id AND cp4.order_status != 'Cancelled' ORDER BY cp4.created_at DESC LIMIT 1) AS last_right_eye_sph,
                                        (SELECT right_eye_cyl FROM customer_prescriptions cp5 WHERE cp5.mobile = cp1.mobile AND cp5.user_id = cp1.user_id AND cp5.order_status != 'Cancelled' ORDER BY cp5.created_at DESC LIMIT 1) AS last_right_eye_cyl,
                                        (SELECT right_eye_axis FROM customer_prescriptions cp6 WHERE cp6.mobile = cp1.mobile AND cp6.user_id = cp1.user_id AND cp6.order_status != 'Cancelled' ORDER BY cp6.created_at DESC LIMIT 1) AS last_right_eye_axis,
                                        (SELECT right_eye_addition FROM customer_prescriptions cp7 WHERE cp7.mobile = cp1.mobile AND cp7.user_id = cp1.user_id AND cp7.order_status != 'Cancelled' ORDER BY cp7.created_at DESC LIMIT 1) AS last_right_eye_addition,
                                        (SELECT left_eye_sph FROM customer_prescriptions cp8 WHERE cp8.mobile = cp1.mobile AND cp8.user_id = cp1.user_id AND cp8.order_status != 'Cancelled' ORDER BY cp8.created_at DESC LIMIT 1) AS last_left_eye_sph,
                                        (SELECT left_eye_cyl FROM customer_prescriptions cp9 WHERE cp9.mobile = cp1.mobile AND cp9.user_id = cp1.user_id AND cp9.order_status != 'Cancelled' ORDER BY cp9.created_at DESC LIMIT 1) AS last_left_eye_cyl,
                                        (SELECT left_eye_axis FROM customer_prescriptions cp10 WHERE cp10.mobile = cp1.mobile AND cp10.user_id = cp1.user_id AND cp10.order_status != 'Cancelled' ORDER BY cp10.created_at DESC LIMIT 1) AS last_left_eye_axis,
                                        (SELECT left_eye_addition FROM customer_prescriptions cp11 WHERE cp11.mobile = cp1.mobile AND cp11.user_id = cp1.user_id AND cp11.order_status != 'Cancelled' ORDER BY cp11.created_at DESC LIMIT 1) AS last_left_eye_addition
                                    FROM customer_prescriptions cp1 
                                    WHERE (mobile LIKE ? OR customer_name LIKE ?) AND user_id = ?
                                    GROUP BY mobile, customer_name, address
                                    ORDER BY MAX(created_at) DESC
                                    LIMIT 5";
    }
    
    $stmt = $con->prepare($query);
    if ($isAdmin) {
        $search_param = "%$search%";
        $stmt->bind_param("ss", $search_param, $search_param);
    } else {
        $search_param = "%$search%";
        // Params order: userId (age subquery), userId (sex subquery), userId (sum outstanding), userId (count orders), search, search, userId (WHERE)
        $stmt->bind_param("iiiissi", $userId, $userId, $userId, $userId, $search_param, $search_param, $userId);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $suggestions = [];
    while ($row = $result->fetch_assoc()) {
        $suggestions[] = $row;
    }
    header('Content-Type: application/json');
    echo json_encode($suggestions);
    exit();
}

// Handle Create, Update, Delete
if (isset($_POST['save'])) {
    $customer_name = $_POST['customer_name'];
    $mobile = $_POST['mobile'];
    $address = $_POST['address'];
    $customer_age = !empty($_POST['customer_age']) ? intval($_POST['customer_age']) : null;
    $customer_sex = $_POST['customer_sex'];
    $right_eye_sph = $_POST['right_eye_sph'];
    $right_eye_cyl = $_POST['right_eye_cyl'];
    $right_eye_axis = $_POST['right_eye_axis'];
    $right_eye_addition = $_POST['right_eye_addition'];
    $left_eye_sph = $_POST['left_eye_sph'];
    $left_eye_cyl = $_POST['left_eye_cyl'];
    $left_eye_axis = $_POST['left_eye_axis'];
    $left_eye_addition = $_POST['left_eye_addition'];
    
    // Contact lens power values
    $right_contact_sph = $_POST['right_contact_sph'] ?? '';
    $right_contact_cyl = $_POST['right_contact_cyl'] ?? '';
    $right_contact_axis = $_POST['right_contact_axis'] ?? '';
    $left_contact_sph = $_POST['left_contact_sph'] ?? '';
    $left_contact_cyl = $_POST['left_contact_cyl'] ?? '';
    $left_contact_axis = $_POST['left_contact_axis'] ?? '';
    
    $frame_name = $_POST['frame_name'];
    $lens_name = $_POST['lens_name'];
    $frame_type = $_POST['frame_type'];
    $lens_type = $_POST['lens_type'];
    $frame_amount = floatval($_POST['frame_amount']);
    $lens_amount = floatval($_POST['lens_amount']);
    $total_amount = $frame_amount + $lens_amount; // Auto-calculate total
    $advance_amount = floatval($_POST['advance_amount']);
    $discount_type = $_POST['discount_type'];
    $discount_value = floatval($_POST['discount_value']);
    $employee_id = !empty($_POST['employee_id']) ? intval($_POST['employee_id']) : null;
    $order_status = $_POST['order_status'];
    $delivery_date = $_POST['delivery_date'] ? $_POST['delivery_date'] : NULL;
    $notes = $_POST['notes'];
    
    // Calculate discount amount
    $discount_amount = 0;
    if ($discount_value > 0) {
        if ($discount_type == 'percentage') {
            $discount_amount = ($total_amount * $discount_value) / 100;
        } else {
            $discount_amount = $discount_value;
        }
    }
    
    // Calculate final amount after discount
    $final_amount = $total_amount - $discount_amount;
    
    if ($_POST['id'] == '') {
        // Generate order number for new prescriptions
        $year_month = date('Ym');
        $order_query = "SELECT COUNT(*) as count FROM customer_prescriptions WHERE order_number LIKE 'ORD-$year_month-%'";
        $order_result = $con->query($order_query);
        $order_count = $order_result->fetch_assoc()['count'] + 1;
        $order_number = 'ORD-' . $year_month . '-' . str_pad($order_count, 4, '0', STR_PAD_LEFT);
        
        // Create new prescription
    $stmt = $con->prepare("INSERT INTO customer_prescriptions (order_number, customer_name, customer_age, customer_sex, mobile, address, right_eye_sph, right_eye_cyl, right_eye_axis, right_eye_addition, left_eye_sph, left_eye_cyl, left_eye_axis, left_eye_addition, right_contact_sph, right_contact_cyl, right_contact_axis, left_contact_sph, left_contact_cyl, left_contact_axis, frame_name, lens_name, frame_type, lens_type, frame_amount, lens_amount, advance_amount, discount_type, discount_value, discount_amount, order_status, delivery_date, notes, employee_id, user_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    // Types: ss i s s s s... (strings), ddd (amounts), s d d, s s s, i i
    $stmt->bind_param("ssisssssssssssssssssssssdddsddsssii", $order_number, $customer_name, $customer_age, $customer_sex, $mobile, $address, $right_eye_sph, $right_eye_cyl, $right_eye_axis, $right_eye_addition, $left_eye_sph, $left_eye_cyl, $left_eye_axis, $left_eye_addition, $right_contact_sph, $right_contact_cyl, $right_contact_axis, $left_contact_sph, $left_contact_cyl, $left_contact_axis, $frame_name, $lens_name, $frame_type, $lens_type, $frame_amount, $lens_amount, $advance_amount, $discount_type, $discount_value, $discount_amount, $order_status, $delivery_date, $notes, $employee_id, $userId);
        $stmt->execute();
        $success_msg = "Customer prescription added successfully!";
    } else {
        // Update existing prescription
        $id = intval($_POST['id']);
        if ($isAdmin) {
            $stmt = $con->prepare("UPDATE customer_prescriptions SET customer_name=?, customer_age=?, customer_sex=?, mobile=?, address=?, right_eye_sph=?, right_eye_cyl=?, right_eye_axis=?, right_eye_addition=?, left_eye_sph=?, left_eye_cyl=?, left_eye_axis=?, left_eye_addition=?, right_contact_sph=?, right_contact_cyl=?, right_contact_axis=?, left_contact_sph=?, left_contact_cyl=?, left_contact_axis=?, frame_name=?, lens_name=?, frame_type=?, lens_type=?, frame_amount=?, lens_amount=?, advance_amount=?, discount_type=?, discount_value=?, discount_amount=?, order_status=?, delivery_date=?, notes=?, employee_id=? WHERE id=?");
            // Types aligned with params; note trailing ii for employee_id and id
            $stmt->bind_param("sisssssssssssssssssssssdddsddsssii", $customer_name, $customer_age, $customer_sex, $mobile, $address, $right_eye_sph, $right_eye_cyl, $right_eye_axis, $right_eye_addition, $left_eye_sph, $left_eye_cyl, $left_eye_axis, $left_eye_addition, $right_contact_sph, $right_contact_cyl, $right_contact_axis, $left_contact_sph, $left_contact_cyl, $left_contact_axis, $frame_name, $lens_name, $frame_type, $lens_type, $frame_amount, $lens_amount, $advance_amount, $discount_type, $discount_value, $discount_amount, $order_status, $delivery_date, $notes, $employee_id, $id);
        } else {
            $stmt = $con->prepare("UPDATE customer_prescriptions SET customer_name=?, customer_age=?, customer_sex=?, mobile=?, address=?, right_eye_sph=?, right_eye_cyl=?, right_eye_axis=?, right_eye_addition=?, left_eye_sph=?, left_eye_cyl=?, left_eye_axis=?, left_eye_addition=?, right_contact_sph=?, right_contact_cyl=?, right_contact_axis=?, left_contact_sph=?, left_contact_cyl=?, left_contact_axis=?, frame_name=?, lens_name=?, frame_type=?, lens_type=?, frame_amount=?, lens_amount=?, advance_amount=?, discount_type=?, discount_value=?, discount_amount=?, order_status=?, delivery_date=?, notes=?, employee_id=? WHERE id=? AND user_id=?");
            // One extra trailing i for userId
            $stmt->bind_param("sisssssssssssssssssssssdddsddsssiii", $customer_name, $customer_age, $customer_sex, $mobile, $address, $right_eye_sph, $right_eye_cyl, $right_eye_axis, $right_eye_addition, $left_eye_sph, $left_eye_cyl, $left_eye_axis, $left_eye_addition, $right_contact_sph, $right_contact_cyl, $right_contact_axis, $left_contact_sph, $left_contact_cyl, $left_contact_axis, $frame_name, $lens_name, $frame_type, $lens_type, $frame_amount, $lens_amount, $advance_amount, $discount_type, $discount_value, $discount_amount, $order_status, $delivery_date, $notes, $employee_id, $id, $userId);
        }
        $stmt->execute();
        $success_msg = "Customer prescription updated successfully!";
    }
    header("Location: customer-prescriptions.php");
    exit();
}

if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    if ($isAdmin) {
        $con->query("DELETE FROM customer_prescriptions WHERE id=$id");
    } else {
        $stmt = $con->prepare("DELETE FROM customer_prescriptions WHERE id=? AND user_id=?");
        $stmt->bind_param("ii", $id, $userId);
        $stmt->execute();
    }
    header("Location: customer-prescriptions.php");
    exit();
}

// Date and status filter logic - simplified for today's data only
$from = date('Y-m-d');
$to = date('Y-m-d');
$customer_mobile = isset($_GET['customer_mobile']) ? $_GET['customer_mobile'] : '';

// Fetch prescriptions
$query = "SELECT * FROM customer_prescriptions WHERE DATE(created_at) BETWEEN ? AND ?";
$params = [$from, $to];
$types = "ss";

// Filter by specific customer mobile if selected
if ($customer_mobile) {
    $query .= " AND mobile = ?";
    $params[] = $customer_mobile;
    $types .= "s";
}

if (!$isAdmin) {
    $query .= " AND user_id=?";
    $params[] = $userId;
    $types .= "i";
}

$query .= " ORDER BY id DESC";
$stmt = $con->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$prescriptions = [];
while ($row = $result->fetch_assoc()) {
    $prescriptions[] = $row;
}
$stmt->close();

// For edit
$edit = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $query = $isAdmin ? "SELECT * FROM customer_prescriptions WHERE id=$id" : "SELECT * FROM customer_prescriptions WHERE id=$id AND user_id=$userId";
    $res = $con->query($query);
    $edit = $res->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Jagadamba Opticals | Customer Prescriptions</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        body { background: #f8f9fc; }
        .card { border-radius: 1rem; }
        .form-control, .btn { border-radius: 0.5rem; }
        .btn-primary, .btn-info, .btn-danger, .btn-secondary { min-width: 90px; }
        .table th, .table td { vertical-align: middle !important; font-size: 14px; }
        .badge-pending { background-color: #ffc107; color: #212529; }
        .badge-progress { background-color: #17a2b8; }
        .badge-ready { background-color: #28a745; }
        .badge-delivered { background-color: #6c757d; }
        .badge-cancelled { background-color: #dc3545; }
        .prescription-form { background: #fff; }
        .power-section { background: #f8f9fa; border-radius: 0.5rem; padding: 15px; margin: 10px 0; }
        
        /* E-commerce style prescription cards */
        .prescription-card {
            transition: all 0.3s ease;
            border: 1px solid #e3e6f0;
            border-radius: 0.75rem;
            overflow: hidden;
        }
        .prescription-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            border-color: #4e73df;
        }
        .prescription-card .card-body {
            position: relative;
        }
        .prescription-card .border-left-primary {
            border-left: 4px solid #4e73df !important;
        }
        .prescription-card h6 {
            font-size: 1rem;
            margin-bottom: 0.25rem;
        }
        .prescription-card .btn {
            padding: 0.25rem 0.5rem;
            margin-right: 0.25rem;
        }
        .prescription-card .badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        
        /* Mobile suggestions dropdown */
        #mobile_suggestions {
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        #mobile_suggestions .list-group-item {
            border: none;
            padding: 10px 15px;
            cursor: pointer;
            border-bottom: 1px solid #f8f9fa;
        }
        #mobile_suggestions .list-group-item:hover {
            background-color: #f8f9fa;
        }
        #mobile_suggestions .list-group-item.active {
            background-color: #4e73df;
            color: white;
        }
        #mobile_suggestions .customer-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        #mobile_suggestions .outstanding-info {
            text-align: right;
            min-width: 100px;
        }
        #mobile_suggestions .outstanding-amount {
            font-weight: bold;
            font-size: 0.9rem;
        }
        #mobile_suggestions .outstanding-positive {
            color: #dc3545;
        }
        #mobile_suggestions .outstanding-zero {
            color: #28a745;
        }
        
        /* Power dropdown styles */
        .power-dropdown {
            position: relative;
        }
        
        .power-table {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            overflow: hidden;
        }
        
        .power-table-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
            padding: 8px;
            text-align: center;
            font-weight: bold;
            font-size: 14px;
        }
        
        .power-table-cell {
            border-right: 1px solid #dee2e6;
            padding: 5px;
            text-align: center;
        }
        
        .power-table-cell:last-child {
            border-right: none;
        }
        
        .power-input {
            border: none;
            text-align: center;
            background: transparent;
            cursor: pointer;
            font-size: 14px;
            padding: 8px 4px;
            width: 100%;
        }
        
        .power-input:focus {
            outline: none;
            background-color: #e3f2fd;
        }
        
        /* Mobile-friendly focus styles */
        .form-control:focus {
            background-color: #f0f8ff !important;
            border-color: #4e73df !important;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25) !important;
        }
        
        input:focus, 
        select:focus, 
        textarea:focus {
            background-color: #f0f8ff !important;
            border-color: #4e73df !important;
            outline: none !important;
        }
        
        /* Fix combobox/select dropdown text visibility */
        select.form-control {
            padding-right: 30px !important;
            text-overflow: ellipsis;
            white-space: nowrap;
            overflow: hidden;
        }
        
        select.form-control option {
            padding: 8px 12px;
            background-color: white;
            color: #333;
            border: none;
        }
        
        /* Ensure proper text display in selects */
        .form-control {
            padding: 8px 12px;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }
        
        /* Mobile responsive improvements */
        @media (max-width: 768px) {
            .form-group {
                margin-bottom: 0.75rem; /* Reduced from 1rem */
            }
            
            .form-control {
                font-size: 16px; /* Prevents zoom on iOS */
                padding: 10px; /* Reduced padding */
                min-height: 44px; /* Reduced from 48px */
                line-height: 1.3; /* Reduced line height */
            }
            
            select.form-control {
                padding-right: 35px !important;
            }
            
            .btn {
                padding: 10px 16px; /* Reduced padding */
                font-size: 15px; /* Slightly smaller font */
                min-height: 44px; /* Reduced from 48px */
                margin-bottom: 0.5rem; /* Reduced margin */
            }
            
            .power-table-header,
            .power-input {
                font-size: 14px;
                padding: 8px 4px; /* Reduced padding */
            }
            
            .power-section {
                margin: 8px 0; /* Reduced margin */
                padding: 12px; /* Reduced padding */
            }
            
            .card-body {
                padding: 1rem; /* Reduced from default */
            }
            
            h6 {
                margin-bottom: 0.5rem; /* Reduced heading margins */
            }
            
            label {
                margin-bottom: 0.25rem; /* Reduced label margins */
            }
        }
        
        /* General line spacing improvements */
        .form-group {
            margin-bottom: 0.875rem; /* Slightly reduced */
        }
        
        .power-section {
            padding: 12px; /* Reduced padding */
            margin: 8px 0; /* Reduced margin */
        }
        
        .row {
            margin-left: -10px;
            margin-right: -10px;
        }
        
        .row > [class*="col-"] {
            padding-left: 10px;
            padding-right: 10px;
        }
        
        /* WhatsApp Button Styling */
        .btn-whatsapp {
            background-color: #25D366;
            border-color: #25D366;
            color: white;
        }
        
        .btn-whatsapp:hover {
            background-color: #128C7E;
            border-color: #128C7E;
            color: white;
        }
        
        .btn-whatsapp:focus {
            box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.5);
        }
        
        /* Additional fixes for select dropdown visibility */
        select {
            -webkit-appearance: menulist !important;
            -moz-appearance: menulist !important;
            appearance: menulist !important;
        }
        
        /* Ensure text is visible in all browsers */
        option {
            color: #212529 !important;
            background-color: #fff !important;
        }
        
        .power-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 9999;
            display: none;
            align-items: center;
            justify-content: center;
        }
        
        .power-modal-content {
            background: white;
            border-radius: 0.5rem;
            max-width: 90%;
            max-height: 80%;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        
        .power-modal-header {
            background: #4e73df;
            color: white;
            padding: 15px 20px;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .power-modal-close {
            background: none;
            border: none;
            color: white;
            font-size: 24px;
            cursor: pointer;
            padding: 0;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .power-modal-body {
            padding: 20px;
            max-height: 400px;
            overflow-y: auto;
        }
        
        .power-values-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .power-values-section {
            border: 1px solid #e3e6f0;
            border-radius: 0.375rem;
            overflow: hidden;
        }
        
        .power-values-header {
            background: #f8f9fa;
            padding: 10px;
            text-align: center;
            font-weight: bold;
            border-bottom: 1px solid #e3e6f0;
        }
        
        .power-values-list {
            max-height: 200px;
            overflow-y: auto;
        }
        
        .power-value-item {
            padding: 8px 15px;
            cursor: pointer;
            border-bottom: 1px solid #f8f9fa;
            text-align: center;
            transition: background-color 0.2s;
        }
        
        .power-value-item:hover {
            background-color: #e3f2fd;
        }
        
        .power-value-item:last-child {
            border-bottom: none;
        }
        
        .power-value-item.selected {
            background-color: #4e73df;
            color: white;
        }
        
        @media (max-width: 768px) {
            .power-modal-content {
                max-width: 95%;
                margin: 10px;
            }
            
            .power-values-grid {
                grid-template-columns: 1fr;
            }
            
            .power-table-header,
            .power-input {
                font-size: 12px;
            }
            
            .power-table-cell {
                padding: 3px;
            }
        }
        
        @media (max-width: 991.98px) {
            .table-responsive { font-size: 12px; }
            .form-group label { font-size: 14px; }
            .prescription-card h6 { font-size: 0.9rem; }
            .prescription-card small { font-size: 0.75rem; }
        }
    </style>
</head>
<body id="page-top">
<div class="container-fluid mt-4">

    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <div>
           
            <?php if($customer_mobile): ?>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb bg-transparent p-0 mb-0">
                    <li class="breadcrumb-item"><a href="customer-prescriptions.php">All Customers</a></li>
                    <li class="breadcrumb-item active" aria-current="page">
                        <?php echo htmlspecialchars($customer_info['customer_name'] ?? 'Selected Customer'); ?> 
                        (<?php echo htmlspecialchars($customer_mobile); ?>)
                    </li>
                </ol>
            </nav>
            <?php endif; ?>
        </div>
       
    </div>

    <div class="row">
        <div class="col-lg-12 mb-4">
            <div class="card shadow prescription-form">
                <div class="card-header bg-primary text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="m-0 font-weight-bold">
                            <i class="fas fa-glasses mr-2"></i><?php echo $edit ? 'Edit' : 'Add New'; ?> Prescription
                        </h6>
                        <div>
                            <a href="prescription-reports.php" class="btn btn-sm btn-info mr-2" title="View Reports">
                                <i class="fas fa-chart-bar"></i> Reports
                            </a>
                            <?php if($userType == 'admin' || $userType == 'staff'): ?>
                            <a href="create-user.php" class="btn btn-sm btn-warning" title="User Management">
                                <i class="fas fa-users"></i> Users
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form method="post" autocomplete="off">
                        <input type="hidden" name="id" value="<?php echo $edit ? $edit['id'] : ''; ?>">
                        
                        <!-- Customer Information -->
                        <div class="form-group">
                            <label><i class="fas fa-search"></i> Search Customer (Mobile/Name) *</label>
                            <input type="text" name="mobile" id="mobile_input" class="form-control" required value="<?php echo $edit ? htmlspecialchars($edit['mobile']) : ''; ?>" placeholder="Enter mobile number or customer name" autocomplete="off">
                            <div id="mobile_suggestions" class="list-group position-absolute" style="z-index: 1000; width: calc(100% - 30px); display: none;"></div>
                        </div>
                        
                        <div class="form-group">
                            <label><i class="fas fa-user"></i> Customer Name</label>
                            <input type="text" name="customer_name" id="customer_name" class="form-control" value="<?php echo $edit ? htmlspecialchars($edit['customer_name']) : ''; ?>" placeholder="Enter customer name">
                        </div>
                        
                        <div class="form-group">
                            <label><i class="fas fa-map-marker-alt"></i> Address</label>
                            <textarea name="address" class="form-control" rows="2" placeholder="Enter customer address"><?php echo $edit ? htmlspecialchars($edit['address']) : ''; ?></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-birthday-cake"></i> Age</label>
                                    <input type="number" name="customer_age" class="form-control" 
                                           value="<?php echo $edit ? htmlspecialchars($edit['customer_age']) : ''; ?>" 
                                           min="1" max="120" placeholder="Enter customer age">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-venus-mars"></i> Gender</label>
                                    <select name="customer_sex" class="form-control">
                                        <option value="Male" <?php echo ($edit && $edit['customer_sex'] == 'Male') ? 'selected' : ''; ?>>Male</option>
                                        <option value="Female" <?php echo ($edit && $edit['customer_sex'] == 'Female') ? 'selected' : ''; ?>>Female</option>
                                        <option value="Other" <?php echo ($edit && $edit['customer_sex'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Right Eye Power -->
                        <div class="power-section">
                            <h6 class="text-primary"><i class="fas fa-eye"></i> Right Eye Power</h6>
                            <div class="power-table">
                                <div class="row no-gutters">
                                    <div class="col-3 power-table-header">SPH</div>
                                    <div class="col-3 power-table-header">CYL</div>
                                    <div class="col-3 power-table-header">AXIS</div>
                                    <div class="col-3 power-table-header">ADD</div>
                                </div>
                                <div class="row no-gutters">
                                    <div class="col-3 power-table-cell">
                                        <input type="text" name="right_eye_sph" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['right_eye_sph']) : ''; ?>" 
                                               placeholder="0.00" readonly data-power-type="sph">
                                    </div>
                                    <div class="col-3 power-table-cell">
                                        <input type="text" name="right_eye_cyl" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['right_eye_cyl']) : ''; ?>" 
                                               placeholder="0.00" readonly data-power-type="cyl">
                                    </div>
                                    <div class="col-3 power-table-cell">
                                        <input type="number" name="right_eye_axis" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['right_eye_axis']) : ''; ?>" 
                                               min="1" max="180" style="text-align: center;">
                                    </div>
                                    <div class="col-3 power-table-cell">
                                        <input type="text" name="right_eye_addition" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['right_eye_addition']) : ''; ?>" 
                                               placeholder="0.00" readonly data-power-type="add">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Left Eye Power -->
                        <div class="power-section">
                            <h6 class="text-primary"><i class="fas fa-eye"></i> Left Eye Power</h6>
                            <div class="power-table">
                                <div class="row no-gutters">
                                    <div class="col-3 power-table-header">SPH</div>
                                    <div class="col-3 power-table-header">CYL</div>
                                    <div class="col-3 power-table-header">AXIS</div>
                                    <div class="col-3 power-table-header">ADD</div>
                                </div>
                                <div class="row no-gutters">
                                    <div class="col-3 power-table-cell">
                                        <input type="text" name="left_eye_sph" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['left_eye_sph']) : ''; ?>" 
                                               placeholder="0.00" readonly data-power-type="sph">
                                    </div>
                                    <div class="col-3 power-table-cell">
                                        <input type="text" name="left_eye_cyl" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['left_eye_cyl']) : ''; ?>" 
                                               placeholder="0.00" readonly data-power-type="cyl">
                                    </div>
                                    <div class="col-3 power-table-cell">
                                        <input type="number" name="left_eye_axis" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['left_eye_axis']) : ''; ?>" 
                                               min="1" max="180" style="text-align: center;">
                                    </div>
                                    <div class="col-3 power-table-cell">
                                        <input type="text" name="left_eye_addition" class="form-control power-input" 
                                               value="<?php echo $edit ? htmlspecialchars($edit['left_eye_addition']) : ''; ?>" 
                                               placeholder="0.00" readonly data-power-type="add">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Contact Lens Power Section (Hidden by default) -->
                        <div class="power-section contact-lens-section" style="display: none;">
                            <h6 class="text-success"><i class="fas fa-circle"></i> Contact Lens Power</h6>
                            
                            <!-- Right Eye Contact Power -->
                            <div class="mb-3">
                                <label class="font-weight-bold text-info">Right Eye Contact Power</label>
                                <div class="power-table">
                                    <div class="row no-gutters">
                                        <div class="col-4 power-table-header">SPH</div>
                                        <div class="col-4 power-table-header">CYL</div>
                                        <div class="col-4 power-table-header">AXIS</div>
                                    </div>
                                    <div class="row no-gutters">
                                        <div class="col-4 power-table-cell">
                                            <input type="text" name="right_contact_sph" class="form-control power-input" 
                                                   value="<?php echo $edit ? htmlspecialchars($edit['right_contact_sph'] ?? '') : ''; ?>" 
                                                   placeholder="0.00" readonly data-power-type="sph">
                                        </div>
                                        <div class="col-4 power-table-cell">
                                            <input type="text" name="right_contact_cyl" class="form-control power-input" 
                                                   value="<?php echo $edit ? htmlspecialchars($edit['right_contact_cyl'] ?? '') : ''; ?>" 
                                                   placeholder="0.00" readonly data-power-type="cyl">
                                        </div>
                                        <div class="col-4 power-table-cell">
                                            <input type="number" name="right_contact_axis" class="form-control power-input" 
                                                   value="<?php echo $edit ? htmlspecialchars($edit['right_contact_axis'] ?? '') : ''; ?>" 
                                                   min="1" max="180" style="text-align: center;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Left Eye Contact Power -->
                            <div class="mb-3">
                                <label class="font-weight-bold text-info">Left Eye Contact Power</label>
                                <div class="power-table">
                                    <div class="row no-gutters">
                                        <div class="col-4 power-table-header">SPH</div>
                                        <div class="col-4 power-table-header">CYL</div>
                                        <div class="col-4 power-table-header">AXIS</div>
                                    </div>
                                    <div class="row no-gutters">
                                        <div class="col-4 power-table-cell">
                                            <input type="text" name="left_contact_sph" class="form-control power-input" 
                                                   value="<?php echo $edit ? htmlspecialchars($edit['left_contact_sph'] ?? '') : ''; ?>" 
                                                   placeholder="0.00" readonly data-power-type="sph">
                                        </div>
                                        <div class="col-4 power-table-cell">
                                            <input type="text" name="left_contact_cyl" class="form-control power-input" 
                                                   value="<?php echo $edit ? htmlspecialchars($edit['left_contact_cyl'] ?? '') : ''; ?>" 
                                                   placeholder="0.00" readonly data-power-type="cyl">
                                        </div>
                                        <div class="col-4 power-table-cell">
                                            <input type="number" name="left_contact_axis" class="form-control power-input" 
                                                   value="<?php echo $edit ? htmlspecialchars($edit['left_contact_axis'] ?? '') : ''; ?>" 
                                                   min="1" max="180" style="text-align: center;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Frame Details -->
                        <div class="form-group">
                            <label><i class="fas fa-glasses"></i> Frame Name</label>
                            <input type="text" name="frame_name" class="form-control" value="<?php echo $edit ? htmlspecialchars($edit['frame_name']) : ''; ?>" placeholder="Enter frame name">
                        </div>

                        <div class="form-group">
                            <label><i class="fas fa-eye"></i> Lens Name</label>
                            <input type="text" name="lens_name" class="form-control" value="<?php echo $edit ? htmlspecialchars($edit['lens_name']) : ''; ?>" placeholder="Enter lens name">
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label>Frame Type</label>
                                    <select name="frame_type" class="form-control">
                                        <option value="">Select Frame Type</option>
                                        <option value="Metal Frame" <?php if($edit && $edit['frame_type']=='Metal Frame') echo 'selected'; ?>>Metal Frame</option>
                                        <option value="Cell Frame" <?php if($edit && $edit['frame_type']=='Cell Frame') echo 'selected'; ?>>Cell Frame</option>
                                        <option value="Supra Frame" <?php if($edit && $edit['frame_type']=='Supra Frame') echo 'selected'; ?>>Supra Frame</option>
                                        <option value="Sunglass" <?php if($edit && $edit['frame_type']=='Sunglass') echo 'selected'; ?>>Sunglass</option>
                                        <option value="Rimless" <?php if($edit && $edit['frame_type']=='Rimless') echo 'selected'; ?>>Rimless</option>
                                        <option value="Semi-Rimless" <?php if($edit && $edit['frame_type']=='Semi-Rimless') echo 'selected'; ?>>Semi-Rimless</option>
                                        <option value="Others" <?php if($edit && $edit['frame_type']=='Others') echo 'selected'; ?>>Others</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label>Lens Type</label>
                                    <select name="lens_type" id="lens_type" class="form-control">
                                        <option value="">Select Lens Type</option>
                                        <option value="Single Vision" <?php if($edit && $edit['lens_type']=='Single Vision') echo 'selected'; ?>>Single Vision</option>
                                        <option value="Bifocal" <?php if($edit && $edit['lens_type']=='Bifocal') echo 'selected'; ?>>Bifocal</option>
                                        <option value="Progressive" <?php if($edit && $edit['lens_type']=='Progressive') echo 'selected'; ?>>Progressive</option>
                                        <option value="Anti-Reflective" <?php if($edit && $edit['lens_type']=='Anti-Reflective') echo 'selected'; ?>>Anti-Reflective</option>
                                        <option value="Blue Light Filter" <?php if($edit && $edit['lens_type']=='Blue Light Filter') echo 'selected'; ?>>Blue Light Filter</option>
                                        <option value="Contact Lens" <?php if($edit && $edit['lens_type']=='Contact Lens') echo 'selected'; ?>>Contact Lens</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Amount Details -->
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><i class="fas fa-glasses"></i> Frame Amount (₹)</label>
                                    <input type="number" name="frame_amount" class="form-control" step="0.01" 
                                           value="<?php echo $edit ? $edit['frame_amount'] : '0'; ?>" 
                                           placeholder="0.00" min="0">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><i class="fas fa-eye"></i> Lens Amount (₹)</label>
                                    <input type="number" name="lens_amount" class="form-control" step="0.01" 
                                           value="<?php echo $edit ? $edit['lens_amount'] : '0'; ?>" 
                                           placeholder="0.00" min="0">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><i class="fas fa-user-tie"></i> Assigned Employee</label>
                                    <select name="employee_id" class="form-control">
                                        <option value="">Select Employee</option>
                                        <?php
                                        $emp_query = "SELECT id, employee_name FROM employees WHERE status = 'Active' ORDER BY employee_name";
                                        $emp_result = $con->query($emp_query);
                                        while($emp = $emp_result->fetch_assoc()) {
                                            $selected = ($edit && $edit['employee_id'] == $emp['id']) ? 'selected' : '';
                                            echo "<option value='{$emp['id']}' {$selected}>{$emp['employee_name']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Discount Section -->
                        <div class="form-group">
                            <label><i class="fas fa-percentage"></i> Discount</label>
                            <div class="row">
                                <div class="col-6">
                                    <select name="discount_type" class="form-control">
                                        <option value="percentage" <?php if($edit && $edit['discount_type']=='percentage') echo 'selected'; ?>>Percentage (%)</option>
                                        <option value="fixed" <?php if($edit && $edit['discount_type']=='fixed') echo 'selected'; ?>>Fixed Amount (₹)</option>
                                    </select>
                                </div>
                                <div class="col-6">
                                    <input type="number" name="discount_value" class="form-control" step="0.01" value="<?php echo $edit ? $edit['discount_value'] : '0'; ?>" placeholder="Enter discount value">
                                </div>
                            </div>
                        </div>

                        <!-- Payment Details -->
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label><i class="fas fa-rupee-sign"></i> Total Amount (Auto-calculated)</label>
                                    <input type="number" name="total_amount" id="total_amount_display" class="form-control" readonly step="0.01" value="<?php echo $edit ? $edit['total_amount'] : ''; ?>" placeholder="0.00" style="background-color: #f8f9fa;">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label><i class="fas fa-money-bill"></i> Advance</label>
                                    <input type="number" name="advance_amount" class="form-control" step="0.01" value="<?php echo $edit ? $edit['advance_amount'] : '0'; ?>" placeholder="0.00">
                                </div>
                            </div>
                        </div>

                        <!-- Order Details -->
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label><i class="fas fa-toggle-on"></i> Order Status</label>
                                    <select name="order_status" class="form-control" required>
                                        <option value="Pending" <?php if($edit && $edit['order_status']=='Pending') echo 'selected'; ?>>Pending</option>
                                        <option value="In Progress" <?php if($edit && $edit['order_status']=='In Progress') echo 'selected'; ?>>In Progress</option>
                                        <option value="Ready" <?php if($edit && $edit['order_status']=='Ready') echo 'selected'; ?>>Ready</option>
                                        <option value="Delivered" <?php if($edit && $edit['order_status']=='Delivered') echo 'selected'; ?>>Delivered</option>
                                        <option value="Cancelled" <?php if($edit && $edit['order_status']=='Cancelled') echo 'selected'; ?>>Cancelled</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label><i class="fas fa-calendar"></i> Delivery Date</label>
                                    <input type="date" name="delivery_date" class="form-control" value="<?php echo $edit ? $edit['delivery_date'] : ''; ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label><i class="fas fa-sticky-note"></i> Notes</label>
                            <textarea name="notes" class="form-control" rows="2" placeholder="Enter any special notes"><?php echo $edit ? htmlspecialchars($edit['notes']) : ''; ?></textarea>
                        </div>

                        <div class="form-group d-flex flex-wrap gap-2">
                            <button type="submit" name="save" class="btn btn-primary mr-2">
                                <i class="fas fa-save"></i> <?php echo $edit ? 'Update' : 'Save'; ?> Prescription
                            </button>
                            <?php if($edit): ?>
                                <a href="customer-prescriptions.php" class="btn btn-secondary mr-2">
                                    <i class="fas fa-times"></i> Cancel
                                </a>
                                <button type="button" class="btn btn-whatsapp mr-2" onclick="sendPrescriptionWhatsApp('<?php echo $edit['mobile']; ?>', '<?php echo htmlspecialchars($edit['customer_name']); ?>', '<?php echo $edit['order_number']; ?>')">
                                    <i class="fab fa-whatsapp"></i> Send WhatsApp
                                </button>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Power Selection Modal -->
<div id="powerModal" class="power-modal">
    <div class="power-modal-content">
        <div class="power-modal-header">
            <span id="powerModalTitle">Select Power Value</span>
            <button type="button" class="power-modal-close" onclick="closePowerModal()">&times;</button>
        </div>
        <div class="power-modal-body">
            <div class="power-values-grid">
                <div class="power-values-section">
                    <div class="power-values-header">Positive Values</div>
                    <div class="power-values-list" id="positiveValues"></div>
                </div>
                <div class="power-values-section">
                    <div class="power-values-header">Negative Values</div>
                    <div class="power-values-list" id="negativeValues"></div>
                </div>
            </div>
            <div class="text-center">
                <button type="button" class="btn btn-secondary mr-2" onclick="closePowerModal()">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="clearPowerValue()">Clear</button>
            </div>
        </div>
    </div>
</div>

<?php include_once('includes/footer.php');?>
<?php include_once('includes/footer2.php');?>
<script src="vendor/jquery/jquery.min.js"></script>
<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="vendor/jquery-easing/jquery.easing.min.js"></script>
<script src="js/sb-admin-2.min.js"></script>
<script>
$(document).ready(function(){
    let currentPowerInput = null;
    
    // Generate power options for SPH and CYL (-10.00 to +10.00 in 0.25 increments)
    function generatePowerOptions() {
        const options = ['0.00'];
        for (let i = 0.25; i <= 10.00; i += 0.25) {
            options.push(i.toFixed(2));
        }
        return options;
    }

    // Generate addition options (0.75 to 3.00 in 0.25 increments)
    function generateAdditionOptions() {
        const options = ['0.00'];
        for (let i = 0.75; i <= 3.00; i += 0.25) {
            options.push(i.toFixed(2));
        }
        return options;
    }

    // Open power selection modal
    function openPowerModal(input, powerType) {
        currentPowerInput = input;
        const modal = document.getElementById('powerModal');
        const title = document.getElementById('powerModalTitle');
        const positiveContainer = document.getElementById('positiveValues');
        const negativeContainer = document.getElementById('negativeValues');
        
        // Clear previous values
        positiveContainer.innerHTML = '';
        negativeContainer.innerHTML = '';
        
        let options;
        if (powerType === 'add') {
            options = generateAdditionOptions();
            title.textContent = 'Select Addition Value';
            
            // For addition, only positive values
            options.forEach(option => {
                if (option === '0.00') {
                    const item = document.createElement('div');
                    item.className = 'power-value-item';
                    item.textContent = option;
                    item.onclick = () => selectPowerValue(option);
                    positiveContainer.appendChild(item);
                } else {
                    const item = document.createElement('div');
                    item.className = 'power-value-item';
                    item.textContent = '+' + option;
                    item.onclick = () => selectPowerValue('+' + option);
                    positiveContainer.appendChild(item);
                }
            });
            
            // Hide negative section for addition
            negativeContainer.parentElement.style.display = 'none';
            document.querySelector('.power-values-grid').style.gridTemplateColumns = '1fr';
        } else {
            options = generatePowerOptions();
            title.textContent = powerType === 'sph' ? 'Select SPH Value' : 'Select CYL Value';
            
            // Show both sections
            negativeContainer.parentElement.style.display = 'block';
            document.querySelector('.power-values-grid').style.gridTemplateColumns = '1fr 1fr';
            
            // Add zero value to positive section
            const zeroItem = document.createElement('div');
            zeroItem.className = 'power-value-item';
            zeroItem.textContent = '0.00';
            zeroItem.onclick = () => selectPowerValue('0.00');
            positiveContainer.appendChild(zeroItem);
            
            // Add positive values
            options.slice(1).forEach(option => {
                const item = document.createElement('div');
                item.className = 'power-value-item';
                item.textContent = '+' + option;
                item.onclick = () => selectPowerValue('+' + option);
                positiveContainer.appendChild(item);
            });
            
            // Add negative values
            options.slice(1).forEach(option => {
                const item = document.createElement('div');
                item.className = 'power-value-item';
                item.textContent = '-' + option;
                item.onclick = () => selectPowerValue('-' + option);
                negativeContainer.appendChild(item);
            });
        }
        
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
    }

    // Select power value
    window.selectPowerValue = function(value) {
        if (currentPowerInput) {
            currentPowerInput.value = value;
        }
        closePowerModal();
    }

    // Clear power value
    window.clearPowerValue = function() {
        if (currentPowerInput) {
            currentPowerInput.value = '';
        }
        closePowerModal();
    }

    // Close power modal
    window.closePowerModal = function() {
        const modal = document.getElementById('powerModal');
        modal.style.display = 'none';
        document.body.style.overflow = 'auto';
        currentPowerInput = null;
    }

    // Handle power input clicks (only for SPH, CYL, ADD - not AXIS)
    $(document).on('click', '.power-input[data-power-type]', function() {
        const powerType = $(this).data('power-type');
        if (powerType && powerType !== 'axis') {
            openPowerModal(this, powerType);
        }
    });

    // Close modal when clicking outside
    $(document).on('click', '#powerModal', function(e) {
        if (e.target === this) {
            closePowerModal();
        }
    });

    // Auto-calculate total amount from frame and lens amounts
    function calculateTotalAmount() {
        const frameAmount = parseFloat($('input[name="frame_amount"]').val()) || 0;
        const lensAmount = parseFloat($('input[name="lens_amount"]').val()) || 0;
        const totalAmount = frameAmount + lensAmount;
        
        // Update the total amount field
        $('input[name="total_amount"]').val(totalAmount.toFixed(2));
        
        // Show breakdown if both amounts exist
        $('.amount-breakdown').remove();
        if (frameAmount > 0 || lensAmount > 0) {
            $('input[name="total_amount"]').closest('.form-group').append(
                `<small class="text-info amount-breakdown">Frame: ₹${frameAmount.toFixed(2)} + Lens: ₹${lensAmount.toFixed(2)} = ₹${totalAmount.toFixed(2)}</small>`
            );
        }
        
        // Trigger the discount calculation
        calculateFinalAmount();
    }

    // Auto-calculate final amount with discount
    function calculateFinalAmount() {
        const total = parseFloat($('input[name="total_amount"]').val()) || 0;
        const advance = parseFloat($('input[name="advance_amount"]').val()) || 0;
        const discountType = $('select[name="discount_type"]').val();
        const discountValue = parseFloat($('input[name="discount_value"]').val()) || 0;
        
        let discountAmount = 0;
        if (discountValue > 0) {
            if (discountType === 'percentage') {
                discountAmount = (total * discountValue) / 100;
            } else {
                discountAmount = discountValue;
            }
        }
        
        const finalAmount = total - discountAmount;
        const balance = finalAmount - advance;
        
        // Update UI to show calculated values
        $('.discount-display').remove(); // Remove previous display
        if (discountAmount > 0) {
            $('input[name="total_amount"]').closest('.form-group').append(
                `<small class="text-success discount-display">Discount: -₹${discountAmount.toFixed(2)} | Final: ₹${finalAmount.toFixed(2)}</small>`
            );
        }
        
        // Show balance calculation
        $('.balance-display').remove();
        $('input[name="advance_amount"]').closest('.form-group').append(
            `<small class="text-${balance > 0 ? 'danger' : 'success'} balance-display">Balance: ₹${balance.toFixed(2)}</small>`
        );
    }

    // Auto-calculate total when frame or lens amounts change
    $('input[name="frame_amount"], input[name="lens_amount"]').on('input change', calculateTotalAmount);
    
    // Auto-calculate when amounts or discount change
    $('input[name="total_amount"], input[name="advance_amount"], input[name="discount_value"], select[name="discount_type"]').on('input change', calculateFinalAmount);
    
    // Initial calculation if editing
    calculateTotalAmount(); // This will also trigger calculateFinalAmount
    calculateFinalAmount();
    
    // Mobile number auto-suggestion
    let debounceTimer;
    $('#mobile_input').on('input', function(){
        const mobile = $(this).val();
        const $suggestions = $('#mobile_suggestions');
        
        // Clear previous timer
        clearTimeout(debounceTimer);
        
        if(mobile.length >= 3) {
            // Debounce API calls
            debounceTimer = setTimeout(function() {
                $.ajax({
                    url: '',
                    type: 'POST',
                    data: { ajax_search_mobile: mobile },
                    dataType: 'json',
                    success: function(data) {
                        $suggestions.empty();
                        if(data.length > 0) {
                            data.forEach(function(customer) {
                                const outstanding = parseFloat(customer.outstanding_balance) || 0;
                                const outstandingClass = outstanding > 0 ? 'outstanding-positive' : 'outstanding-zero';
                                const outstandingText = outstanding > 0 ? `₹${outstanding.toFixed(2)} Due` : 'No Due';
                                
                                const item = $(`
                                    <div class="list-group-item customer-suggestion" 
                                         data-mobile="${customer.mobile}" 
                                         data-name="${customer.customer_name}" 
                                         data-address="${customer.address || ''}" 
                                         data-age="${customer.customer_age || ''}"
                                         data-gender="${customer.customer_sex || ''}"
                                         data-outstanding="${outstanding}"
                                         data-last_right_eye_sph="${customer.last_right_eye_sph || ''}"
                                         data-last_right_eye_cyl="${customer.last_right_eye_cyl || ''}"
                                         data-last_right_eye_axis="${customer.last_right_eye_axis || ''}"
                                         data-last_right_eye_addition="${customer.last_right_eye_addition || ''}"
                                         data-last_left_eye_sph="${customer.last_left_eye_sph || ''}"
                                         data-last_left_eye_cyl="${customer.last_left_eye_cyl || ''}"
                                         data-last_left_eye_axis="${customer.last_left_eye_axis || ''}"
                                         data-last_left_eye_addition="${customer.last_left_eye_addition || ''}">
                                        <div class="customer-info">
                                            <div class="customer-details">
                                                <strong>${customer.customer_name || ''}</strong><br>
                                                <small class="text-muted">${customer.mobile}</small>
                                                ${customer.address ? '<br><small class="text-muted">' + customer.address.substring(0, 40) + (customer.address.length > 40 ? '...' : '') + '</small>' : ''}
                                                <br><small class="text-info">${customer.total_orders} order(s)</small>
                                            </div>
                                            <div class="outstanding-info">
                                                <div class="outstanding-amount ${outstandingClass}">${outstandingText}</div>
                                                <small class="text-muted">Outstanding</small>
                                            </div>
                                        </div>
                                        <div class="mt-1 small text-muted">
                                            <em>Last Power:</em> R(SPH ${customer.last_right_eye_sph || '-'}, CYL ${customer.last_right_eye_cyl || '-'}, AXIS ${customer.last_right_eye_axis || '-'}, ADD ${customer.last_right_eye_addition || '-'}) | L(SPH ${customer.last_left_eye_sph || '-'}, CYL ${customer.last_left_eye_cyl || '-'}, AXIS ${customer.last_left_eye_axis || '-'}, ADD ${customer.last_left_eye_addition || '-'})
                                        </div>
                                    </div>
                                `);
                                $suggestions.append(item);
                            });
                            $suggestions.show();
                        } else {
                            $suggestions.hide();
                        }
                    },
                    error: function() {
                        console.log('Error fetching customer suggestions');
                        $suggestions.hide();
                    }
                });
            }, 300);
        } else {
            $suggestions.hide();
        }
    });

    // Handle suggestion selection - Fixed
    $(document).on('click', '.customer-suggestion', function(e){
        e.preventDefault();
        e.stopPropagation();
        
        const mobile = $(this).data('mobile');
        const name = $(this).data('name');
        const address = $(this).data('address');
        const age = $(this).data('age');
        const gender = $(this).data('gender');
        const outstanding = $(this).data('outstanding');
    const lastRightSph = $(this).data('last_right_eye_sph');
    const lastRightCyl = $(this).data('last_right_eye_cyl');
    const lastRightAxis = $(this).data('last_right_eye_axis');
    const lastRightAdd = $(this).data('last_right_eye_addition');
    const lastLeftSph = $(this).data('last_left_eye_sph');
    const lastLeftCyl = $(this).data('last_left_eye_cyl');
    const lastLeftAxis = $(this).data('last_left_eye_axis');
    const lastLeftAdd = $(this).data('last_left_eye_addition');
        
        console.log('Selected customer:', { mobile, name, address, outstanding });
        
        // Set the values
        $('#mobile_input').val(mobile);
        $('#customer_name').val(name);
        $('textarea[name="address"]').val(address);
        if(age) $('input[name="customer_age"]').val(age);
        if(gender) $('select[name="customer_sex"]').val(gender);
    // Autofill last power values
    $('input[name="right_eye_sph"]').val(lastRightSph || '');
    $('input[name="right_eye_cyl"]').val(lastRightCyl || '');
    $('input[name="right_eye_axis"]').val(lastRightAxis || '');
    $('input[name="right_eye_addition"]').val(lastRightAdd || '');
    $('input[name="left_eye_sph"]').val(lastLeftSph || '');
    $('input[name="left_eye_cyl"]').val(lastLeftCyl || '');
    $('input[name="left_eye_axis"]').val(lastLeftAxis || '');
    $('input[name="left_eye_addition"]').val(lastLeftAdd || '');
        
        // Show outstanding balance info if exists
        if(outstanding > 0) {
            $('.alert-warning').remove(); // Remove any existing alerts
            const alertHtml = `
                <div class="alert alert-warning alert-dismissible fade show mt-2" role="alert">
                    <i class="fas fa-exclamation-triangle"></i> 
                    <strong>Outstanding Balance:</strong> ₹${parseFloat(outstanding).toFixed(2)} pending for this customer.
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            `;
            $('#mobile_input').closest('.form-group').after(alertHtml);
            
            // Auto-remove alert after 5 seconds
            setTimeout(function() {
                $('.alert-warning').fadeOut();
            }, 5000);
        }
        
    // Hide suggestions
    $('#mobile_suggestions').hide();

    // Add / update a quick history link (without reloading immediately)
    const historyLinkId = 'customerHistoryLink';
    $('#' + historyLinkId).remove();
    const historyLink = `<small id="${historyLinkId}" class="d-block mt-1">\n            <a href="?customer_mobile=${mobile}" class="text-primary">View past prescriptions & history for this customer</a>\n        </small>`;
    $('#mobile_input').closest('.form-group').append(historyLink);

    // NOTE: Previously the page was reloading here which cleared the auto-filled power values.
    // If you still want automatic filtering, uncomment the next line.
    // filterByCustomer(mobile);
    });

    // Function to filter prescriptions by customer
    function filterByCustomer(mobile) {
        // Reload page with customer filter
        const currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('customer_mobile', mobile);
        window.location.href = currentUrl.toString();
    }

    // Function to clear customer filter
    window.clearCustomerFilter = function() {
        window.location.href = 'customer-prescriptions.php';
    }

    // Hide suggestions when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#mobile_input, #mobile_suggestions').length) {
            $('#mobile_suggestions').hide();
        }
    });

    // Keyboard navigation for suggestions
    let selectedIndex = -1;
    $('#mobile_input').on('keydown', function(e) {
        const $suggestions = $('#mobile_suggestions .customer-suggestion');
        
        if (e.which === 40) { // Down arrow
            e.preventDefault();
            selectedIndex = Math.min(selectedIndex + 1, $suggestions.length - 1);
            updateSelection($suggestions);
        } else if (e.which === 38) { // Up arrow
            e.preventDefault();
            selectedIndex = Math.max(selectedIndex - 1, -1);
            updateSelection($suggestions);
        } else if (e.which === 13 && selectedIndex >= 0) { // Enter
            e.preventDefault();
            $suggestions.eq(selectedIndex).click();
        } else if (e.which === 27) { // Escape
            $('#mobile_suggestions').hide();
            selectedIndex = -1;
        }
    });

    function updateSelection($suggestions) {
        $suggestions.removeClass('active');
        if (selectedIndex >= 0) {
            $suggestions.eq(selectedIndex).addClass('active');
        }
    }

    // Handle lens type change to show/hide contact lens section
    $('#lens_type').on('change', function() {
        const lensType = $(this).val();
        const contactSection = $('.contact-lens-section');
        
        if (lensType === 'Contact Lens') {
            contactSection.show();
        } else {
            contactSection.hide();
            // Clear contact lens values when hidden
            contactSection.find('input').val('');
        }
    });

    // Initialize contact lens section visibility on page load
    if ($('#lens_type').val() === 'Contact Lens') {
        $('.contact-lens-section').show();
    }

    // Update power modal title based on the input field
    function updatePowerModalTitle(input, powerType) {
        const fieldName = $(input).attr('name');
        let title = 'Select Power Value';
        
        if (fieldName.includes('right_eye_')) {
            title = 'Select Right Eye ' + powerType.toUpperCase() + ' Value';
        } else if (fieldName.includes('left_eye_')) {
            title = 'Select Left Eye ' + powerType.toUpperCase() + ' Value';
        } else if (fieldName.includes('right_contact_')) {
            title = 'Select Right Contact ' + powerType.toUpperCase() + ' Value';
        } else if (fieldName.includes('left_contact_')) {
            title = 'Select Left Contact ' + powerType.toUpperCase() + ' Value';
        }
        
        return title;
    }

    // Override the openPowerModal function to use updated titles
    const originalOpenPowerModal = window.openPowerModal || function(){};
    
    // Update the power input click handler to use proper titles
    $(document).off('click', '.power-input[data-power-type]').on('click', '.power-input[data-power-type]', function() {
        const powerType = $(this).data('power-type');
        if (powerType && powerType !== 'axis') {
            const modal = document.getElementById('powerModal');
            const title = document.getElementById('powerModalTitle');
            const positiveContainer = document.getElementById('positiveValues');
            const negativeContainer = document.getElementById('negativeValues');
            
            currentPowerInput = this;
            
            // Set proper title
            title.textContent = updatePowerModalTitle(this, powerType);
            
            // Clear previous values
            positiveContainer.innerHTML = '';
            negativeContainer.innerHTML = '';
            
            let options;
            if (powerType === 'add') {
                options = generateAdditionOptions();
                
                // For addition, only positive values
                options.forEach(option => {
                    if (option === '0.00') {
                        const item = document.createElement('div');
                        item.className = 'power-value-item';
                        item.textContent = option;
                        item.onclick = () => selectPowerValue(option);
                        positiveContainer.appendChild(item);
                    } else {
                        const item = document.createElement('div');
                        item.className = 'power-value-item';
                        item.textContent = '+' + option;
                        item.onclick = () => selectPowerValue('+' + option);
                        positiveContainer.appendChild(item);
                    }
                });
                
                // Hide negative section for addition
                negativeContainer.parentElement.style.display = 'none';
                document.querySelector('.power-values-grid').style.gridTemplateColumns = '1fr';
            } else {
                options = generatePowerOptions();
                
                // Show both sections
                negativeContainer.parentElement.style.display = 'block';
                document.querySelector('.power-values-grid').style.gridTemplateColumns = '1fr 1fr';
                
                // Add zero value to positive section
                const zeroItem = document.createElement('div');
                zeroItem.className = 'power-value-item';
                zeroItem.textContent = '0.00';
                zeroItem.onclick = () => selectPowerValue('0.00');
                positiveContainer.appendChild(zeroItem);
                
                // Add positive values
                options.slice(1).forEach(option => {
                    const item = document.createElement('div');
                    item.className = 'power-value-item';
                    item.textContent = '+' + option;
                    item.onclick = () => selectPowerValue('+' + option);
                    positiveContainer.appendChild(item);
                });
                
                // Add negative values
                options.slice(1).forEach(option => {
                    const item = document.createElement('div');
                    item.className = 'power-value-item';
                    item.textContent = '-' + option;
                    item.onclick = () => selectPowerValue('-' + option);
                    negativeContainer.appendChild(item);
                });
            }
            
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }
    });

    // WhatsApp functionality
    window.sendPrescriptionWhatsApp = function(mobile, customerName, orderNumber) {
        // Create prescription WhatsApp message
        const message = createPrescriptionWhatsAppMessage(customerName, orderNumber);
        
        // Clean mobile number (remove any non-digits)
        const cleanMobile = mobile.replace(/\D/g, '');
        
        // Ensure mobile number has country code (assuming India +91)
        let whatsappNumber = cleanMobile;
        if (cleanMobile.length === 10) {
            whatsappNumber = '91' + cleanMobile;
        }
        
        // Create WhatsApp URL
        const whatsappUrl = `https://wa.me/${whatsappNumber}?text=${encodeURIComponent(message)}`;
        
        // Open WhatsApp
        window.open(whatsappUrl, '_blank');
    };

    function createPrescriptionWhatsAppMessage(customerName, orderNumber) {
        const shopName = "Jagadamba Opticals";
        const today = new Date().toLocaleDateString('en-GB');
        
        const message = `*${shopName}*\n\n` +
                       `Hello ${customerName}!\n\n` +
                       `Thank you for choosing ${shopName}.\n\n` +
                       `📋 *Order Details:*\n` +
                       `Order Number: ${orderNumber}\n` +
                       `Date: ${today}\n\n` +
                       `Your prescription has been processed successfully.\n\n` +
                       `👁️ We will notify you once your glasses are ready for delivery.\n\n` +
                       `For any queries, please contact us.\n\n` +
                       `Thank you for your business! 🙏\n\n` +
                       `*${shopName}*\n` +
                       `Your Vision, Our Mission! 👓`;
        
        return message;
    }
});
</script>
</body>
</html>
