# PowerShell script to change admin password in opticals database
# Usage: Run this script and follow the prompts

Write-Host "=== Opticals Database Admin Password Changer ===" -ForegroundColor Green
Write-Host ""

# Get new password
$newPassword = Read-Host "Enter new admin password" -AsSecureString
$plainPassword = [Runtime.InteropServices.Marshal]::PtrToStringAuto([Runtime.InteropServices.Marshal]::SecureStringToBSTR($newPassword))

# Create SQL command
$sqlCommand = @"
USE opticals;
UPDATE tblusers SET Password = MD5('$plainPassword') WHERE UserType = 'admin';
SELECT CONCAT('Updated ', ROW_COUNT(), ' admin user(s)') as Result;
SELECT UserName, FullName, UserType, 'Password Updated' as Status FROM tblusers WHERE UserType = 'admin';
"@

# Save to temporary file
$tempFile = "$env:TEMP\update_admin_pass.sql"
$sqlCommand | Out-File -FilePath $tempFile -Encoding UTF8

Write-Host "Connecting to MySQL..." -ForegroundColor Yellow
Write-Host "Please enter your MySQL root password when prompted." -ForegroundColor Yellow
Write-Host ""

try {
    # Execute the SQL
    Get-Content $tempFile | & "c:\wamp64\bin\mysql\mysql9.1.0\bin\mysql.exe" -u root -p
    
    Write-Host ""
    Write-Host "Admin password updated successfully!" -ForegroundColor Green
    Write-Host "New password: $plainPassword" -ForegroundColor Cyan
    
} catch {
    Write-Host "Error updating password: $($_.Exception.Message)" -ForegroundColor Red
} finally {
    # Clean up temp file
    if (Test-Path $tempFile) {
        Remove-Item $tempFile -Force
    }
}

Write-Host ""
Write-Host "You can now login with the new admin password." -ForegroundColor Green
