<?php
// WhatsApp Test API Endpoint
// This file can be called via AJAX to test WhatsApp functionality

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

include_once('../includes/whatsapp-functions.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        $input = $_POST;
    }
    
    $mobile = $input['mobile'] ?? '';
    $customerName = $input['customer_name'] ?? 'Test Customer';
    $orderNumber = $input['order_number'] ?? 'TEST-' . date('Ymd-His');
    $message = $input['message'] ?? '';
    
    if (empty($mobile)) {
        echo json_encode([
            'success' => false,
            'message' => 'Mobile number is required'
        ]);
        exit();
    }
    
    // If custom message is provided, use it; otherwise create prescription message
    if (empty($message)) {
        $message = createPrescriptionWhatsAppMessage($customerName, $orderNumber);
    }
    
    $result = sendWhatsAppMessage($mobile, $message);
    
    // Log the test activity
    logWhatsAppActivity($mobile, $customerName, $orderNumber, $result['success'], $result);
    
    echo json_encode($result);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Only POST method is allowed'
    ]);
}
?>