# SMS Configuration Guide

## Current Status
🔴 **SMS is currently in Demo mode** - No real SMS messages are being sent.

## How to Enable Real SMS Sending

Your WhatsApp integration works perfectly! SMS can work the same way. Here are your options:

### Option 1: Use Generic HTTP SMS Provider (Recommended)

1. **Get SMS Provider Account**
   - Sign up with any SMS provider (like TextLocal, MSG91, Fast2SMS, etc.)
   - Get your API URL, API key, and sender ID

2. **Configure in `includes/config.php`**
   ```php
   // Change from demo to http
   define('SMS_PROVIDER', 'http');
   define('SMS_API_URL', 'https://your-provider.com/api/send');
   define('SMS_HTTP_METHOD', 'GET'); // or 'POST' based on provider
   define('SMS_API_KEY', 'your-api-key-here');
   define('SMS_SENDER_ID', 'OPTICALS');
   ```

3. **Example for TextLocal:**
   ```php
   define('SMS_PROVIDER', 'http');
   define('SMS_API_URL', 'https://api.textlocal.in/send/');
   define('SMS_HTTP_METHOD', 'POST');
   define('SMS_API_KEY', 'your-textlocal-api-key');
   define('SMS_SENDER_ID', 'TXTLCL');
   ```

4. **Example for Fast2SMS:**
   ```php
   define('SMS_PROVIDER', 'http');
   define('SMS_API_URL', 'https://www.fast2sms.com/dev/bulkV2');
   define('SMS_HTTP_METHOD', 'POST');
   define('SMS_API_KEY', 'your-fast2sms-api-key');
   define('SMS_SENDER_ID', 'FSTSMS');
   ```

### Option 2: Use Twilio (International)

1. **Get Twilio Account**
   - Sign up at https://www.twilio.com/
   - Get Account SID, Auth Token, and phone number

2. **Configure in `includes/config.php`**
   ```php
   define('SMS_PROVIDER', 'twilio');
   define('TWILIO_ACCOUNT_SID', 'your-account-sid');
   define('TWILIO_AUTH_TOKEN', 'your-auth-token');
   define('TWILIO_FROM_NUMBER', '+1234567890');
   ```

### Option 3: WhatsApp-Style Direct SMS (Custom Provider)

If you have a custom SMS provider, use the new `sendDirectSMS()` function:

```php
// Example usage
$result = sendDirectSMS(
    '9876543210',                           // mobile number
    'Your message here',                    // message
    'https://your-provider.com/api/send',   // API URL
    'your-api-key',                         // API key
    'OPTICALS'                              // sender ID
);

if ($result['success']) {
    echo "SMS sent successfully!";
} else {
    echo "SMS failed: " . $result['message'];
}
```

## Testing SMS Configuration

1. **Enable Test Mode** (to verify UI without spending SMS credits):
   In `sendSMS()` function, uncomment this line:
   ```php
   // return ['success' => true, 'message' => 'SMS sent (demo mode)'];
   ```

2. **Test with Real Provider**:
   - Configure your chosen provider above
   - Send a test SMS to your own number
   - Check SMS logs in database (`sms_logs` table)

## Comparing with Working WhatsApp

Your WhatsApp works because it has:
- ✅ Real API URL: `https://wav5.algotechnosoft.com/api/send`
- ✅ Valid credentials: `instanceId` and `accessToken`
- ✅ Direct HTTP call using cURL

SMS needs the same setup:
- ❌ Currently: Demo mode (no real API)
- ✅ Need: Real SMS provider API URL and credentials

## Quick Fix for Testing

To immediately see "SMS sent successfully" in the UI (for testing only):

1. Open `includes/sms-functions.php`
2. Find the demo mode section
3. Uncomment this line:
   ```php
   // return ['success' => true, 'message' => 'SMS sent (demo mode)'];
   ```

This will simulate successful SMS sending without actually sending messages.

## Popular Indian SMS Providers

1. **TextLocal** - https://www.textlocal.in/
2. **MSG91** - https://msg91.com/
3. **Fast2SMS** - https://www.fast2sms.com/
4. **ValueFirst** - https://www.vfirst.com/
5. **Route Mobile** - https://www.route-mobile.com/

## Need Help?

The SMS system is built exactly like your working WhatsApp system. Once you configure a real SMS provider (just like you have real WhatsApp credentials), SMS will work perfectly!