<?php
session_start();
include_once('includes/config.php');
if(!isset($_SESSION['uid'])) { header('location:logout.php'); exit; }
?>
<!DOCTYPE html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>POS Quick Reports</title>
<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
<style>
body{margin:0;font-family:Arial,Helvetica,sans-serif;background:#101418;color:#f2f2f2}
.header{display:flex;align-items:center;justify-content:space-between;padding:10px 14px;background:#18212b}
.header h1{font-size:16px;margin:0;font-weight:500;display:flex;align-items:center;gap:6px}
.back-btn{color:#ff9900;text-decoration:none;font-size:14px}
.quick-filters{display:flex;gap:6px;padding:10px 10px 4px;overflow-x:auto}
.quick-filters button{background:#22303d;border:1px solid #2f4354;color:#d6d9dc;padding:6px 10px;font-size:12px;border-radius:20px;flex:0 0 auto;cursor:pointer}
.quick-filters button.active,.quick-filters button:hover{background:#ff9900;color:#111}
.section{padding:8px 12px}
.cards{display:grid;grid-template-columns:repeat(2,1fr);gap:8px}
.card{background:#18212b;border:1px solid #24313d;border-radius:10px;padding:10px;position:relative;overflow:hidden}
.card h3{margin:0 0 4px;font-size:11px;font-weight:600;color:#8fa3b4;text-transform:uppercase;letter-spacing:.5px}
.value{font-size:18px;font-weight:600;color:#ffcf66}
.sub{font-size:11px;color:#8fa3b4;margin-top:2px}
.list{list-style:none;margin:6px 0 0;padding:0;max-height:150px;overflow:auto}
.list li{display:flex;justify-content:space-between;font-size:12px;padding:4px 0;border-bottom:1px solid #202d39}
.list li:last-child{border-bottom:none}
.badge{background:#22303d;padding:2px 6px;border-radius:12px;font-size:11px;color:#ff9900}
.table{width:100%;border-collapse:collapse;margin-top:8px}
.table th,.table td{padding:6px 4px;font-size:11px;border-bottom:1px solid #202d39;text-align:left}
.table th{color:#8fa3b4;font-weight:600}
.row-actions button{background:#22303d;border:0;color:#ff9900;padding:4px 6px;border-radius:6px;font-size:11px;cursor:pointer}
footer{padding:10px 0 16px;text-align:center;font-size:11px;color:#556575}
.filter-bar{display:flex;gap:6px;margin-top:6px}
.date-input{background:#18212b;border:1px solid #24313d;color:#eee;padding:6px 8px;font-size:12px;border-radius:6px;width:100%}
.refresh-btn{background:#ff9900;border:none;color:#111;padding:6px 10px;font-size:12px;font-weight:600;border-radius:6px;cursor:pointer}
.empty{padding:20px 0;text-align:center;font-size:12px;color:#6d7e8d}
</style></head>
<body>
<div class="header"><h1><i class="fas fa-receipt"></i>POS Quick Reports</h1><a class="back-btn" href="pos.php"><i class="fas fa-arrow-left"></i> POS</a></div>
<div class="quick-filters" id="rangeBar">
<button data-range="today" class="active">Today</button>
<button data-range="7d">7 Days</button>
<button data-range="30d">30 Days</button>
<button data-range="custom">Custom</button>
</div>
<div class="section" id="customRange" style="display:none">
<div class="filter-bar">
<input type="date" id="fromDate" class="date-input">
<input type="date" id="toDate" class="date-input">
<button class="refresh-btn" onclick="loadData()">Go</button>
</div>
</div>
<div class="section">
<div class="cards">
<div class="card"><h3>Total Sales</h3><div class="value" id="vTotal">₹0</div><div class="sub" id="vOrders">0 orders</div></div>
<div class="card"><h3>Paid</h3><div class="value" id="vPaid">₹0</div><div class="sub" id="vBalance">Bal ₹0</div></div>
<div class="card"><h3>Avg Order</h3><div class="value" id="vAvg">₹0</div><div class="sub" id="vCustomers">0 customers</div></div>
<div class="card"><h3>Top Products</h3><ul class="list" id="topProducts"><li class="empty">No data</li></ul></div>
</div>
</div>
<div class="section">
<table class="table" id="salesTable">
<thead><tr><th>#</th><th>Date</th><th>Amt</th><th>Paid</th><th>St</th><th></th></tr></thead>
<tbody id="salesBody"><tr><td colspan="6" class="empty">Loading…</td></tr></tbody>
</table>
</div>
<footer>Compact POS Report</footer>
<script src="vendor/jquery/jquery.min.js"></script>
<script>
let currentRange = 'today';
let fullData = [];
$(function(){
    $('#fromDate').val(new Date().toISOString().slice(0,10));
    $('#toDate').val(new Date().toISOString().slice(0,10));
    $('.quick-filters button').on('click',function(){
        $('.quick-filters button').removeClass('active');
        $(this).addClass('active');
        currentRange = $(this).data('range');
        if(currentRange==='custom'){ $('#customRange').show(); } else { $('#customRange').hide(); loadData(); }
    });
    loadData();
});
function loadData(){
    let from = $('#fromDate').val();
    let to = $('#toDate').val();
    if(currentRange!=='custom'){ from=''; to=''; }
    $.getJSON('api/get-pos-reports.php',{from_date:from,to_date:to},function(r){
        if(!r.success){ $('#salesBody').html('<tr><td colspan="6" class="empty">Error</td></tr>'); return; }
        fullData = r.transactions;
        updateStats(r.statistics); renderRows(fullData);
        loadQuick();
    });
}
function loadQuick(){
    let rng = 'today';
    if(currentRange==='7d') rng='7d'; else if(currentRange==='30d') rng='30d';
    $.getJSON('api/get-pos-quick-filters.php',{range:rng},function(r){
        if(!r.success) return;
        $('#vTotal').text('₹'+Number(r.stats.total).toFixed(0));
        $('#vPaid').text('₹'+Number(r.stats.paid).toFixed(0));
        $('#vBalance').text('Bal ₹'+Number(r.stats.balance).toFixed(0));
        let tp='';
        if(r.top_products.length===0) tp='<li class="empty">No data</li>';
        else r.top_products.forEach(p=> tp+=`<li><span>${p.ProductName}</span><span class="badge">${Number(p.qty).toFixed(0)}</span></li>`);
        $('#topProducts').html(tp);
    });
}
function updateStats(s){
    $('#vTotal').text('₹'+parseFloat(s.total_sales||0).toFixed(0));
    $('#vOrders').text((s.total_orders||0)+' orders');
    $('#vCustomers').text((s.unique_customers||0)+' customers');
    $('#vAvg').text('₹'+parseFloat(s.avg_order_value||0).toFixed(0));
}
function renderRows(data){
    if(!data.length){ $('#salesBody').html('<tr><td colspan="6" class="empty">No sales</td></tr>'); return; }
    let html='';
    data.slice(0,100).forEach((t,i)=>{ html+=`<tr><td>${i+1}</td><td>${t.TransactionDate}</td><td>₹${Number(t.Amount).toFixed(0)}</td><td>₹${Number(t.PaidAmount||0).toFixed(0)}</td><td>${statusBadge(t.Status)}</td><td><button onclick="view(${t.ID})"><i class='fas fa-eye'></i></button></td></tr>`; });
    $('#salesBody').html(html);
}
function statusBadge(st){
    const c = st==='Paid'||st==='Completed'?'#1cc88a':(st==='Partial'?'#f6c23e':(st==='Pending'?'#e74a3b':'#858796'));
    return `<span style="background:${c}22;color:${c};padding:2px 6px;border-radius:6px;font-size:10px">${st}</span>`;
}
function view(id){
    alert('Open full detail view (implement modal if needed). ID '+id);
}
</script>
</body></html>
