<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$userId = $_SESSION['uid'];
$userType = $_SESSION['usertype'];

// Get customer statistics
$totalCustomersQuery = "SELECT COUNT(*) as TotalCustomers FROM tblcustomers WHERE IsActive = 1";
$totalCustomersResult = mysqli_query($con, $totalCustomersQuery);
$totalCustomers = mysqli_fetch_assoc($totalCustomersResult)['TotalCustomers'];

$retailCustomersQuery = "SELECT COUNT(*) as RetailCustomers FROM tblcustomers WHERE CustomerType = 'Retail' AND IsActive = 1";
$retailCustomersResult = mysqli_query($con, $retailCustomersQuery);
$retailCustomers = mysqli_fetch_assoc($retailCustomersResult)['RetailCustomers'];

$shopCustomersQuery = "SELECT COUNT(*) as ShopCustomers FROM tblcustomers WHERE CustomerType = 'Shop' AND IsActive = 1";
$shopCustomersResult = mysqli_query($con, $shopCustomersQuery);
$shopCustomers = mysqli_fetch_assoc($shopCustomersResult)['ShopCustomers'];

// Calculate total outstanding
$totalOutstandingQuery = "
    SELECT 
        COALESCE(SUM(CASE WHEN TransactionType = 'Debit' THEN Amount ELSE -Amount END), 0) as TotalOutstanding
    FROM tblcustomerpayments cp 
    INNER JOIN tblcustomers c ON cp.CustomerID = c.ID
    WHERE cp.Status = 'Completed' AND cp.IsActive = 1 AND c.IsActive = 1
";
$totalOutstandingResult = mysqli_query($con, $totalOutstandingQuery);
$totalOutstanding = mysqli_fetch_assoc($totalOutstandingResult)['TotalOutstanding'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Mariyappa Nadar Ricemill | Main Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        /* Full-height layout and compact spacing */
        html, body, #wrapper, #content-wrapper, #content { height: 100%; }
        .container-fluid { padding: 8px 10px; }
        .nav-card {
            transition: transform 0.2s, box-shadow 0.2s;
            border: none;
            border-radius: 8px;
            margin-bottom: 12px;
        }
        
        .nav-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
        }
        
        .nav-btn {
            border: none;
            border-radius: 8px;
            padding: 12px 10px;
            transition: all 0.2s ease;
            text-decoration: none;
            color: white;
            display: block;
            text-align: center;
            min-height: 84px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }
        
        .nav-btn:hover {
            color: white;
            text-decoration: none;
            transform: scale(1.02);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }
        
        .nav-btn i {
            margin-bottom: 6px;
        }
        
        .nav-btn .btn-title {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 2px;
            line-height: 1.2;
        }
        
        .nav-btn .btn-subtitle {
            font-size: 0.7rem;
            opacity: 0.9;
            line-height: 1.1;
        }
        
        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 8px;
            color: white;
            padding: 14px;
            margin-bottom: 14px;
        }
        
        .stat-item {
            text-align: center;
            padding: 10px;
            background: rgba(255,255,255,0.1);
            border-radius: 8px;
            margin-bottom: 6px;
            transition: all 0.2s ease;
        }
        
        .stat-clickable:hover {
            background: rgba(255,255,255,0.2);
            transform: scale(1.02);
            cursor: pointer;
        }
        
        .stat-number {
            font-size: 1.4rem;
            font-weight: bold;
            margin-bottom: 4px;
        }
        
        .stat-label {
            font-size: 0.75rem;
            opacity: 0.9;
        }
        
        .section-header {
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            color: white;
            border-radius: 8px 8px 0 0;
            padding: 10px 12px;
            margin-bottom: 0;
        }
        
        .section-body {
            background: white;
            border-radius: 0 0 8px 8px;
            padding: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        @media (max-width: 768px) {
            .nav-btn {
                min-height: 76px;
                padding: 10px 8px;
            }
            
            .nav-btn .btn-title {
                font-size: 0.8rem;
            }
            
            .nav-btn .btn-subtitle {
                font-size: 0.65rem;
            }
            
            .nav-btn i {
                font-size: 1.5rem !important;
                margin-bottom: 6px;
            }
            
            .stats-card {
                padding: 12px;
                margin-bottom: 12px;
            }
            
            .stat-item {
                padding: 8px;
                margin-bottom: 6px;
            }
            
            .stat-number {
                font-size: 1.2rem;
            }
            
            .stat-label {
                font-size: 0.7rem;
            }
            
            .section-header {
                padding: 8px 10px;
            }
            
            .section-body {
                padding: 10px;
            }
            
            .nav-card {
                margin-bottom: 10px;
            }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-3">
                        <h1 class="h4 mb-0 text-gray-800">
                            <i class="fas fa-tachometer-alt text-primary mr-2"></i>
                            Main Dashboard
                        </h1>
                        <div class="d-none d-lg-inline-block">
                            <span class="text-gray-600" style="font-size: 0.85rem;">
                                <i class="fas fa-calendar-alt mr-1"></i>
                                <?php echo date('M j, Y'); ?>
                            </span>
                        </div>
                    </div>

                    <!-- Quick Statistics -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="stats-card">
                                <h6 class="mb-3">
                                    <i class="fas fa-chart-pie mr-2"></i>
                                    Business Overview
                                </h6>
                                <div class="row">
                                    <div class="col-6 col-md-3">
                                        <div class="stat-item">
                                            <div class="stat-number"><?php echo number_format($totalCustomers); ?></div>
                                            <div class="stat-label">Total Customers</div>
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <a href="customer-areas.php?type=Retail" class="text-decoration-none text-white">
                                            <div class="stat-item stat-clickable">
                                                <div class="stat-number"><?php echo number_format($retailCustomers); ?></div>
                                                <div class="stat-label">Retail Customers</div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <a href="customer-areas.php?type=Shop" class="text-decoration-none text-white">
                                            <div class="stat-item stat-clickable">
                                                <div class="stat-number"><?php echo number_format($shopCustomers); ?></div>
                                                <div class="stat-label">Shop Customers</div>
                                            </div>
                                        </a>
                                    </div>
                                    <div class="col-6 col-md-3">
                                        <a href="customer-outstanding.php?outstanding_only=1" class="text-decoration-none text-white">
                                            <div class="stat-item stat-clickable">
                                                <div class="stat-number">₹<?php echo number_format($totalOutstanding, 0); ?></div>
                                                <div class="stat-label">Total Outstanding</div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Customer Management Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="nav-card">
                                <div class="section-header">
                                    <h6 class="m-0">
                                        <i class="fas fa-users mr-2"></i>
                                        Customer Management
                                    </h6>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="customer-management.php" class="nav-btn bg-primary">
                                                <i class="fas fa-users fa-2x"></i>
                                                <div class="btn-title">Customer Management</div>
                                                <div class="btn-subtitle">Manage customers</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="area-management.php" class="nav-btn bg-success">
                                                <i class="fas fa-map-marker-alt fa-2x"></i>
                                                <div class="btn-title">Area Management</div>
                                                <div class="btn-subtitle">Manage customer areas</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="customer-outstanding.php?outstanding_only=1" class="nav-btn bg-danger">
                                                <i class="fas fa-exclamation-triangle fa-2x"></i>
                                                <div class="btn-title">Overdue Customers</div>
                                                <div class="btn-subtitle">Pending payments</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="customer-inactive-report.php" class="nav-btn bg-info">
                                                <i class="fas fa-user-clock fa-2x"></i>
                                                <div class="btn-title">Inactive Customers</div>
                                                <div class="btn-subtitle">Follow-up needed</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="complaints-management-modern.php" class="nav-btn bg-warning">
                                                <i class="fas fa-comment-dots fa-2x"></i>
                                                <div class="btn-title">Complaints</div>
                                                <div class="btn-subtitle">Customer issues</div>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="pending-orders-management.php" class="nav-btn bg-info">
                                                <i class="fas fa-shopping-cart fa-2x"></i>
                                                <div class="btn-title">Today Orders</div>
                                                <div class="btn-subtitle">Pending orders</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="customer-areas.php" class="nav-btn" style="background: linear-gradient(135deg, #36b9cc 0%, #258391 100%);">
                                                <i class="fas fa-map-marked-alt fa-2x"></i>
                                                <div class="btn-title">Customer Areas</div>
                                                <div class="btn-subtitle">View by areas</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="customer-payments.php" class="nav-btn" style="background: linear-gradient(135deg, #1cc88a 0%, #17a673 100%);">
                                                <i class="fas fa-money-bill-wave fa-2x"></i>
                                                <div class="btn-title">Payment Records</div>
                                                <div class="btn-subtitle">Customer payments</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="import-customers.php" class="nav-btn" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                                                <i class="fas fa-file-import fa-2x"></i>
                                                <div class="btn-title">Import Customers</div>
                                                <div class="btn-subtitle">Bulk import</div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Products & Inventory Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="nav-card">
                                <div class="section-header" style="background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);">
                                    <h6 class="m-0">
                                        <i class="fas fa-seedling mr-2"></i>
                                        Products & Inventory
                                    </h6>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="rice-bag-management.php" class="nav-btn bg-success">
                                                <i class="fas fa-seedling fa-2x"></i>
                                                <div class="btn-title">Rice Products</div>
                                                <div class="btn-subtitle">Rice bag management</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="stock-report.php" class="nav-btn bg-info">
                                                <i class="fas fa-boxes fa-2x"></i>
                                                <div class="btn-title">Stocks</div>
                                                <div class="btn-subtitle">Current inventory</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="stock-adjustment.php" class="nav-btn bg-warning">
                                                <i class="fas fa-exchange-alt fa-2x"></i>
                                                <div class="btn-title">Stock Adjustments</div>
                                                <div class="btn-subtitle">Adjust stock levels</div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Sales & Reports Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="nav-card">
                                <div class="section-header" style="background: linear-gradient(135deg, #f6c23e 0%, #dda20a 100%);">
                                    <h6 class="m-0">
                                        <i class="fas fa-chart-line mr-2"></i>
                                        Sales & Reports
                                    </h6>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="customer-reports.php" class="nav-btn bg-primary">
                                                <i class="fas fa-chart-pie fa-2x"></i>
                                                <div class="btn-title">Profit & Loss</div>
                                                <div class="btn-subtitle">Customer reports</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="pos-reports.php?filter=today" class="nav-btn bg-success">
                                                <i class="fas fa-calendar-day fa-2x"></i>
                                                <div class="btn-title">Today Sales</div>
                                                <div class="btn-subtitle">Current day sales</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="pos-reports.php?filter=yesterday" class="nav-btn bg-info">
                                                <i class="fas fa-history fa-2x"></i>
                                                <div class="btn-title">Yesterday Sales</div>
                                                <div class="btn-subtitle">Previous day sales</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="pos-reports.php?filter=monthly" class="nav-btn bg-secondary">
                                                <i class="fas fa-calendar-alt fa-2x"></i>
                                                <div class="btn-title">Monthly Sales</div>
                                                <div class="btn-subtitle">Month-wise reports</div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- POS System Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="nav-card">
                                <div class="section-header" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
                                    <h6 class="m-0">
                                        <i class="fas fa-cash-register mr-2"></i>
                                        Point of Sale System
                                    </h6>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="pos.php" class="nav-btn bg-primary">
                                                <i class="fas fa-cash-register fa-2x"></i>
                                                <div class="btn-title">POS System</div>
                                                <div class="btn-subtitle">Main point of sale</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="pos-reports.php" class="nav-btn bg-info">
                                                <i class="fas fa-chart-line fa-2x"></i>
                                                <div class="btn-title">POS Reports</div>
                                                <div class="btn-subtitle">Sales analytics</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="pos-reports-mobile.php" class="nav-btn bg-secondary">
                                                <i class="fas fa-mobile-alt fa-2x"></i>
                                                <div class="btn-title">Mobile POS</div>
                                                <div class="btn-subtitle">Mobile interface</div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- System Management Section -->
                    <?php if($_SESSION['usertype'] == 'admin'): ?>
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="nav-card">
                                <div class="section-header" style="background: linear-gradient(135deg, #e74a3b 0%, #c0392b 100%);">
                                    <h6 class="m-0">
                                        <i class="fas fa-cogs mr-2"></i>
                                        System Administration
                                    </h6>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="create-user.php" class="nav-btn bg-danger">
                                                <i class="fas fa-user-plus fa-2x"></i>
                                                <div class="btn-title">Users</div>
                                                <div class="btn-subtitle">Manage users</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="profile.php" class="nav-btn bg-secondary">
                                                <i class="fas fa-user-cog fa-2x"></i>
                                                <div class="btn-title">Profile</div>
                                                <div class="btn-subtitle">Update profile</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="change-password.php" class="nav-btn bg-dark">
                                                <i class="fas fa-key fa-2x"></i>
                                                <div class="btn-title">Password</div>
                                                <div class="btn-subtitle">Change password</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-3 mb-2">
                                            <a href="logout.php" class="nav-btn" style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); border: 2px solid #dc3545;">
                                                <i class="fas fa-sign-out-alt fa-2x"></i>
                                                <div class="btn-title">Logout</div>
                                                <div class="btn-subtitle">Sign out</div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <!-- Regular User Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="nav-card">
                                <div class="section-header" style="background: linear-gradient(135deg, #6c757d 0%, #545b62 100%);">
                                    <h6 class="m-0">
                                        <i class="fas fa-user mr-2"></i>
                                        User Settings
                                    </h6>
                                </div>
                                <div class="section-body">
                                    <div class="row">
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="profile.php" class="nav-btn bg-secondary">
                                                <i class="fas fa-user-cog fa-2x"></i>
                                                <div class="btn-title">Profile</div>
                                                <div class="btn-subtitle">Update profile</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="change-password.php" class="nav-btn bg-dark">
                                                <i class="fas fa-key fa-2x"></i>
                                                <div class="btn-title">Password</div>
                                                <div class="btn-subtitle">Change password</div>
                                            </a>
                                        </div>
                                        <div class="col-6 col-lg-4 mb-2">
                                            <a href="logout.php" class="nav-btn" style="background: linear-gradient(135deg, #dc3545 0%, #c82333 100%); border: 2px solid #dc3545;">
                                                <i class="fas fa-sign-out-alt fa-2x"></i>
                                                <div class="btn-title">Logout</div>
                                                <div class="btn-subtitle">Sign out</div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                </div>
                <!-- /.container-fluid -->
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>

    <script>
        $(document).ready(function() {
            // Hide sidebar on load for a focused, full-width view
            $('body').addClass('sidebar-toggled');
            $('.sidebar').addClass('toggled');
            if ($('.sidebar').hasClass('toggled')) {
                $('.sidebar .collapse').collapse('hide');
            }

            // Add click animation to navigation buttons
            $('.nav-btn').on('click', function() {
                $(this).css('transform', 'scale(0.95)');
                setTimeout(() => {
                    $(this).css('transform', '');
                }, 150);
            });
            
            // Add subtle animation on page load
            $('.nav-card').each(function(index) {
                $(this).css('opacity', '0').css('transform', 'translateY(20px)');
                $(this).delay(index * 100).animate({
                    opacity: 1
                }, 500, function() {
                    $(this).css('transform', 'translateY(0)');
                });
            });
        });
    </script>
</body>
</html>
