<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:logout.php');
    exit();
}

$customerType = isset($_GET['type']) ? $_GET['type'] : 'Retail';
if (!in_array($customerType, ['Retail', 'Shop'])) {
    $customerType = 'Retail';
}

// Get areas with customer count
$areasQuery = "
    SELECT 
        Area,
        COUNT(*) as CustomerCount
    FROM tblcustomers 
    WHERE CustomerType = ? AND IsActive = 1 
    GROUP BY Area 
    ORDER BY Area
";
$stmt = mysqli_prepare($con, $areasQuery);
mysqli_stmt_bind_param($stmt, "s", $customerType);
mysqli_stmt_execute($stmt);
$areasResult = mysqli_stmt_get_result($stmt);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Mariyappa Nadar Ricemill | <?php echo $customerType; ?> Customer Areas</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <style>
        /* Full-height layout and compact paddings */
        html, body, #wrapper, #content-wrapper, #content { height: 100%; }
        .container-fluid { padding: 8px 10px; }
        .area-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 4px rgba(0,0,0,0.1);
            transition: all 0.2s ease;
            border: 1px solid #e8e8e8;
            cursor: pointer;
            text-decoration: none;
            color: inherit;
            display: block;
            margin-bottom: 12px;
        }
        
        .area-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            text-decoration: none;
            color: inherit;
        }
        
        .area-card-body {
            padding: 14px 12px;
            text-align: center;
        }
        
        .area-icon {
            width: 44px;
            height: 44px;
            background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 12px;
            color: white;
            font-size: 1.1rem;
        }
        
        .area-name {
            font-size: 1rem;
            font-weight: 600;
            color: #2e59d9;
            margin-bottom: 6px;
        }
        
        .area-count {
            font-size: 0.85rem;
            color: #6c757d;
            margin-bottom: 8px;
        }
        
        .area-badge {
            background: linear-gradient(135deg, #1cc88a 0%, #13855c 100%);
            color: white;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 0.78rem;
            font-weight: 500;
            display: inline-block;
        }
        
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 8px;
            padding: 12px 14px;
            margin-bottom: 12px;
        }
        
        .back-btn {
            background: #6c757d;
            color: white;
            border: none;
            border-radius: 8px;
            padding: 6px 10px;
            font-weight: 500;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.2s ease;
            margin-bottom: 12px;
            font-size: 0.85rem;
        }
        
        .back-btn:hover {
            background: #545b62;
            color: white;
            text-decoration: none;
            transform: translateY(-1px);
        }
        
        /* Tighter grid gutters */
        .row > [class^="col-"] { padding-left: 8px; padding-right: 8px; }

        @media (max-width: 768px) {
            .area-card-body {
                padding: 12px 10px;
            }
            
            .area-icon {
                width: 38px;
                height: 38px;
                font-size: 1rem;
                margin-bottom: 10px;
            }
            
            .area-name {
                font-size: 1rem;
            }
            
            .area-count {
                font-size: 0.78rem;
            }
            
            .page-header {
                padding: 10px 12px;
            }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    
                    <!-- Back Button -->
                    <a href="dashboard.php" class="back-btn">
                        <i class="fas fa-arrow-left"></i>
                        Back to Dashboard
                    </a>
                    
                    <!-- Page Header -->
                    <div class="page-header">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h1 class="h5 mb-1">
                                    <i class="fas fa-map-marker-alt mr-2"></i>
                                    <?php echo $customerType; ?> Customer Areas
                                </h1>
                                <p class="mb-0" style="font-size: 0.85rem; opacity: 0.9;">Select an area to view customers</p>
                            </div>
                            <span class="badge badge-light" style="font-size: 0.8rem; padding: 6px 10px;">
                                <i class="fas fa-users mr-1"></i>
                                <?php echo $customerType; ?>
                            </span>
                        </div>
                    </div>

                    <!-- Areas Grid -->
                    <div class="row">
                        <?php if (mysqli_num_rows($areasResult) > 0): ?>
                            <?php while ($area = mysqli_fetch_assoc($areasResult)): ?>
                                <div class="col-6">
                                    <a href="area-customers.php?area=<?php echo urlencode($area['Area']); ?>&type=<?php echo $customerType; ?>" class="area-card">
                                        <div class="area-card-body">
                                            <div class="area-icon">
                                                <i class="fas fa-map-marker-alt"></i>
                                            </div>
                                            <div class="area-name"><?php echo htmlspecialchars($area['Area']); ?></div>
                                            <div class="area-count">
                                                <?php echo number_format($area['CustomerCount']); ?> 
                                                <?php echo $area['CustomerCount'] == 1 ? 'Customer' : 'Customers'; ?>
                                            </div>
                                            <div class="area-badge">
                                                View Customers
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="text-center py-4">
                                    <i class="fas fa-map-marker-alt fa-2x text-muted mb-2"></i>
                                    <h5 class="text-muted">No Areas Found</h5>
                                    <p class="text-muted mb-3">No <?php echo strtolower($customerType); ?> customers found in any area.</p>
                                    <a href="customer-management.php" class="btn btn-primary btn-sm">
                                        <i class="fas fa-plus mr-1"></i>Add Customers
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <?php include_once('includes/footer.php');?>
        </div>
    </div>
    <?php include_once('includes/footer2.php');?>

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>

    <script>
        $(document).ready(function() {
            // Hide sidebar on load for compact, content-focused layout
            $('body').addClass('sidebar-toggled');
            $('.sidebar').addClass('toggled');
            if ($('.sidebar').hasClass('toggled')) {
                $('.sidebar .collapse').collapse('hide');
            }
            // Add animation on page load
            $('.area-card').each(function(index) {
                $(this).css('opacity', '0').css('transform', 'translateY(30px)');
                $(this).delay(index * 100).animate({
                    opacity: 1
                }, 500, function() {
                    $(this).css('transform', 'translateY(0)');
                });
            });
            
            // Add click effect
            $('.area-card').on('click', function() {
                $(this).css('transform', 'scale(0.95)');
                setTimeout(() => {
                    // Let the normal navigation happen
                }, 150);
            });
        });
    </script>
</body>
</html>
