SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: ac_accounts
#

DROP TABLE IF EXISTS `ac_accounts`;

CREATE TABLE `ac_accounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `sort_code` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `balance` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `delete_bit` int DEFAULT '0',
  `account_selection_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `paymenttypes_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `expense_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `paymenttypes_id` (`paymenttypes_id`),
  KEY `customer_id` (`customer_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_id` (`expense_id`),
  CONSTRAINT `ac_accounts_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_2` FOREIGN KEY (`paymenttypes_id`) REFERENCES `db_paymenttypes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_4` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_5` FOREIGN KEY (`expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_moneydeposits
#

DROP TABLE IF EXISTS `ac_moneydeposits`;

CREATE TABLE `ac_moneydeposits` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneydeposits_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneydeposits_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_moneytransfer
#

DROP TABLE IF EXISTS `ac_moneytransfer`;

CREATE TABLE `ac_moneytransfer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL,
  `transfer_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneytransfer_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneytransfer_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_transactions
#

DROP TABLE IF EXISTS `ac_transactions`;

CREATE TABLE `ac_transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `transaction_type` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `debit_account_id` int DEFAULT NULL,
  `credit_account_id` int DEFAULT NULL,
  `debit_amt` double(20,4) DEFAULT NULL,
  `credit_amt` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `ref_accounts_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_moneytransfer_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_moneydeposits_id` int DEFAULT NULL COMMENT 'reference table',
  `ref_salespayments_id` int DEFAULT NULL,
  `ref_salespaymentsreturn_id` int DEFAULT NULL,
  `ref_purchasepayments_id` int DEFAULT NULL,
  `ref_purchasepaymentsreturn_id` int DEFAULT NULL,
  `ref_expense_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_id` (`transaction_type`),
  KEY `account_id` (`debit_account_id`),
  KEY `store_id` (`store_id`),
  KEY `ac_accounts_id` (`ref_accounts_id`),
  KEY `ac_moneytransfer_id` (`ref_moneytransfer_id`),
  KEY `ac_moneydeposits_id` (`ref_moneydeposits_id`),
  KEY `customer_id` (`customer_id`),
  KEY `ref_salespayments_id` (`ref_salespayments_id`),
  KEY `ref_purchasepayments_id` (`ref_purchasepayments_id`),
  KEY `ref_purchasepaymentsreturn_id` (`ref_purchasepaymentsreturn_id`),
  KEY `ac_transactions_ibfk_9` (`ref_salespaymentsreturn_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `ref_expense_id` (`ref_expense_id`),
  CONSTRAINT `ac_transactions_ibfk_10` FOREIGN KEY (`ref_purchasepayments_id`) REFERENCES `db_purchasepayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_11` FOREIGN KEY (`ref_purchasepaymentsreturn_id`) REFERENCES `db_purchasepaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_12` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_13` FOREIGN KEY (`ref_expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_4` FOREIGN KEY (`ref_accounts_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_5` FOREIGN KEY (`ref_moneytransfer_id`) REFERENCES `ac_moneytransfer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_6` FOREIGN KEY (`ref_moneydeposits_id`) REFERENCES `ac_moneydeposits` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_7` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_8` FOREIGN KEY (`ref_salespayments_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_9` FOREIGN KEY (`ref_salespaymentsreturn_id`) REFERENCES `db_salespaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=830 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `timestamp` int unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('btbt3g8mk1hbj3qij70l14rvrmjg2iak', '::1', 1756187150, '__ci_last_regenerate|i:1756187150;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1njv0v3tghjqp47rojlnhktnd6eh9eo9', '::1', 1756186847, '__ci_last_regenerate|i:1756186847;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lt2o9pkoev4dc2mj94j0rni4o8unu139', '::1', 1756186847, '__ci_last_regenerate|i:1756186847;currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hs7hd4icmetqb4hfo4tj72efrol0bacs', '::1', 1756188068, '__ci_last_regenerate|i:1756188068;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qt3no2g9gdfjq8qu10t3h62u3f68ua5j', '::1', 1756188418, '__ci_last_regenerate|i:1756188418;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eok3ffldbmujc1qccfb2ohibq39klc4f', '::1', 1756188812, '__ci_last_regenerate|i:1756188812;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h926bcqe8hadpl3qaolcti8bot2udilj', '::1', 1756189158, '__ci_last_regenerate|i:1756189158;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i1gp7cmacusg04av8phe55f54u4rnv2m', '::1', 1756189618, '__ci_last_regenerate|i:1756189618;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fbfmuq5rukv2u7p57m2ljnd378ggtti7', '::1', 1756189973, '__ci_last_regenerate|i:1756189973;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h3tgolrjun0ebku117kvhqscrgfl0i42', '::1', 1756190439, '__ci_last_regenerate|i:1756190439;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fdo6rfsbmdapfl1gbmek37bi44maonr5', '::1', 1756190849, '__ci_last_regenerate|i:1756190849;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p6gbkoigsupdle0pirp4rk6n2h1cghng', '::1', 1756191446, '__ci_last_regenerate|i:1756191446;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5691v9ljh1qsksqlhrn6ivgootpii8h0', '::1', 1756191862, '__ci_last_regenerate|i:1756191862;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6j751s74kk0c1nhffcsdhous0qj15ult', '::1', 1756192325, '__ci_last_regenerate|i:1756192325;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('khu13j2i0tqrgap7uujeoco4b70oid4q', '::1', 1756192964, '__ci_last_regenerate|i:1756192964;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u3rrbu26p2ebksjn4qtj7v8g8j4a63gd', '::1', 1756193762, '__ci_last_regenerate|i:1756193762;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('815jgssa4kirnri3cp2iv2n0o2hqf5f2', '::1', 1756194068, '__ci_last_regenerate|i:1756194068;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uivs9s9vu62jlhb4ph7kgd20fb4d8vvn', '::1', 1756194173, '__ci_last_regenerate|i:1756194068;currency|s:3:\"₹\";currency_placement|s:4:\"Left\";currency_code|s:3:\"INR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";inv_username|s:11:\"user_599174\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";email|s:17:\"admin@example.com\";language|s:7:\"English\";language_id|s:1:\"1\";');


#
# TABLE STRUCTURE FOR: db_bankdetails
#

DROP TABLE IF EXISTS `db_bankdetails`;

CREATE TABLE `db_bankdetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `holder_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `branch_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'IFSC or Bank Code',
  `account_type` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `other_details` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_bankdetails_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_bankdetails` (`id`, `store_id`, `country_id`, `holder_name`, `bank_name`, `branch_name`, `code`, `account_type`, `account_number`, `other_details`, `description`, `status`) VALUES (1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_brands
#

DROP TABLE IF EXISTS `db_brands`;

CREATE TABLE `db_brands` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `brand_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `brand_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_brands_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_brands_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=334 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (327, 2, NULL, 'AACHI', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (328, 2, NULL, 'SMA CAMEL', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (329, 2, NULL, 'ANCHOR', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (330, 2, NULL, 'FINOLEX', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (331, 2, NULL, 'WATER TEC', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (332, 2, NULL, 'MAXFLO', '', 1);
INSERT INTO `db_brands` (`id`, `store_id`, `brand_code`, `brand_name`, `description`, `status`) VALUES (333, 2, NULL, 'AVONPLAST', '', 1);


#
# TABLE STRUCTURE FOR: db_category
#

DROP TABLE IF EXISTS `db_category`;

CREATE TABLE `db_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create category Code',
  `category_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (82, 2, 1, 'CT/02/0001', 'Electronics', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (86, 2, 5, 'CT0005', 'ELECTRICALS', '', NULL, 1);
INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (87, 2, 6, 'CT0006', 'PLUMBING', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_cobpayments
#

DROP TABLE IF EXISTS `db_cobpayments`;

CREATE TABLE `db_cobpayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_company
#

DROP TABLE IF EXISTS `db_company`;

CREATE TABLE `db_company` (
  `id` double DEFAULT NULL,
  `company_code` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_website` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `logo` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `upi_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upi_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `country` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cid` int DEFAULT NULL,
  `category_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_init` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_view` int DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `status` int DEFAULT NULL,
  `sms_status` int DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `sales_terms_and_conditions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_company` (`id`, `company_code`, `company_name`, `company_website`, `mobile`, `phone`, `email`, `website`, `company_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `invoice_view`, `status`, `sms_status`, `sales_terms_and_conditions`) VALUES ('1', '', 'Company Name', NULL, '9999999999', '', 'admin@example.com', '', 'company_logo.png', 'logo-0.png', NULL, NULL, 'India', 'Karnataka', 'Belgaum', 'Address Details', '', '', '', '', '', 1, 'CT', 'IT', 'SP', 'PU', 'PR', 'CU', 'SL', 'PR', 'EX', 1, 1, 0, NULL);


#
# TABLE STRUCTURE FOR: db_country
#

DROP TABLE IF EXISTS `db_country`;

CREATE TABLE `db_country` (
  `id` int NOT NULL AUTO_INCREMENT,
  `country` varchar(4050) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=210 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (1, 'Abkhazia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (2, 'Afghanistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (3, 'Albania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (4, 'Algeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (5, 'Andorra', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (6, 'Angola', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (7, 'Antigua and Barbuda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (8, 'Argentina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (9, 'Armenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (10, 'Australia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (11, 'Austria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (12, 'Azerbaijan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (13, 'Bahamas', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (14, 'Bahrain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (15, 'Bangladesh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (16, 'Barbados', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (17, 'Belarus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (18, 'Belgium', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (19, 'Belize', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (20, 'Benin', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (21, 'Bhutan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (22, 'Bolivia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (23, 'Bosnia and Herzegovina', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (24, 'Botswana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (25, 'Brazil', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (26, 'Brunei', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (27, 'Bulgaria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (28, 'Burkina Faso', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (29, 'Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (30, 'Burundi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (31, 'Cambodia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (32, 'Cameroon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (33, 'Canada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (34, 'Cape Verde', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (35, 'Central African Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (36, 'Chad', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (37, 'Chile', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (38, 'China', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (39, 'Colombia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (40, 'Comoros', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (41, 'Congo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (42, 'Cook Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (43, 'Costa Rica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (44, 'Croatia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (45, 'Cuba', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (46, 'Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (47, 'Czech Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (48, 'C?te d\'Ivoire', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (49, 'Denmark', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (50, 'Djibouti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (51, 'Dominica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (52, 'Dominican Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (53, 'East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (54, 'Ecuador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (55, 'Egypt', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (56, 'El Salvador', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (57, 'Equatorial Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (58, 'Eritrea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (59, 'Estonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (60, 'Ethiopia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (61, 'Fiji', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (62, 'Finland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (63, 'France', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (64, 'Gabon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (65, 'Gambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (66, 'Georgia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (67, 'Germany', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (68, 'Ghana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (69, 'Greece', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (70, 'Grenada', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (71, 'Guatemala', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (72, 'Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (73, 'Guinea-Bissau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (74, 'Guyana', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (75, 'Haiti', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (76, 'Honduras', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (77, 'Hungary', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (78, 'Iceland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (79, 'India', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (80, 'Indonesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (81, 'Iran', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (82, 'Iraq', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (83, 'Ireland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (84, 'Israel', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (85, 'Italy', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (86, 'Ivory Coast', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (87, 'Jamaica', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (88, 'Japan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (89, 'Jordan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (90, 'Kazakhstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (91, 'Kenya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (92, 'Kiribati', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (93, 'Korea, North', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (94, 'Korea, South', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (95, 'Kosovo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (96, 'Kuwait', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (97, 'Kyrgyzstan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (98, 'Laos', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (99, 'Latvia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (100, 'Lebanon', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (101, 'Lesotho', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (102, 'Liberia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (103, 'Libya', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (104, 'Liechtenstein', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (105, 'Lithuania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (106, 'Luxembourg', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (107, 'Macedonia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (108, 'Madagascar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (109, 'Malawi', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (110, 'Malaysia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (111, 'Maldives', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (112, 'Mali', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (113, 'Malta', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (114, 'Marshall Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (115, 'Mauritania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (116, 'Mauritius', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (117, 'Mexico', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (118, 'Micronesia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (119, 'Moldova', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (120, 'Monaco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (121, 'Mongolia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (122, 'Montenegro', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (123, 'Morocco', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (124, 'Mozambique', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (125, 'Myanmar / Burma', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (126, 'Nagorno-Karabakh', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (127, 'Namibia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (128, 'Nauru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (129, 'Nepal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (130, 'Netherlands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (131, 'New Zealand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (132, 'Nicaragua', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (133, 'Niger', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (134, 'Nigeria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (135, 'Niue', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (136, 'Northern Cyprus', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (137, 'Norway', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (138, 'Oman', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (139, 'Pakistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (140, 'Palau', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (141, 'Palestine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (142, 'Panama', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (143, 'Papua New Guinea', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (144, 'Paraguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (145, 'Peru', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (146, 'Philippines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (147, 'Poland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (148, 'Portugal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (149, 'Qatar', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (150, 'Romania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (151, 'Russia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (152, 'Rwanda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (153, 'Sahrawi Arab Democratic Republic', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (154, 'Saint Kitts and Nevis', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (155, 'Saint Lucia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (156, 'Saint Vincent and the Grenadines', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (157, 'Samoa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (158, 'San Marino', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (159, 'Saudi Arabia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (160, 'Senegal', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (161, 'Serbia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (162, 'Seychelles', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (163, 'Sierra Leone', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (164, 'Singapore', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (165, 'Slovakia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (166, 'Slovenia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (167, 'Solomon Islands', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (168, 'Somalia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (169, 'Somaliland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (170, 'South Africa', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (171, 'South Ossetia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (172, 'Spain', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (173, 'Sri Lanka', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (174, 'Sudan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (175, 'Suriname', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (176, 'Swaziland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (177, 'Sweden', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (178, 'Switzerland', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (179, 'Syria', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (180, 'S?o Tom? and Pr?ncipe', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (181, 'Taiwan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (182, 'Tajikistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (183, 'Tanzania', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (184, 'Thailand', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (185, 'Timor-Leste / East Timor', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (186, 'Togo', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (187, 'Tonga', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (188, 'Trinidad and Tobago', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (189, 'Tunisia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (190, 'Turkey', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (191, 'Turkmenistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (192, 'Tuvalu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (193, 'Uganda', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (194, 'Ukraine', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (195, 'United Arab Emirates', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (196, 'United Kingdom', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (197, 'United States', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (198, 'Uruguay', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (199, 'Uzbekistan', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (200, 'Vanuatu', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (201, 'Vatican City', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (202, 'Venezuela', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (203, 'Vietnam', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (204, 'Yemen', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (205, 'Zambia', '2020-11-03', 1);
INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (206, 'Zimbabwe', '2020-11-03', 1);


#
# TABLE STRUCTURE FOR: db_coupons
#

DROP TABLE IF EXISTS `db_coupons`;

CREATE TABLE `db_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `value` double(20,2) DEFAULT NULL,
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `status` int DEFAULT NULL,
  `created_by` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_coupons_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_coupons_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_currency
#

DROP TABLE IF EXISTS `db_currency`;

CREATE TABLE `db_currency` (
  `id` int NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` blob,
  `symbol` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (1, 'Bulgaria-Bulgarian lev(BGN)', NULL, 'лв', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (2, 'Switzerland \r-Swiss franc (CHF)', NULL, 'CHF', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (3, 'Czechia-Czech koruna(CZK))', NULL, 'Kč ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (4, 'Denmark-Danish krone(DKK)', NULL, 'kr ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (5, 'Euro area countries -Euro(EUR)', NULL, '€ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (6, 'United Kingdom-Pounds sterling (GBP)', NULL, '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (7, 'Croatia -Croatian Kuna (HRK)', NULL, 'kn', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (8, 'Georgia -Georgian lari (GEL)', NULL, '&#8382;', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (9, 'Hungary -Hungarian forint (HUF)', NULL, 'ft', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (10, 'Norway -Norwegian krone (NOK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (11, 'Poland -Polish zloty (PLN)', NULL, 'zł ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (12, 'Russia -Russian ruble (RUB)', NULL, '&#8381; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (13, 'Romania -Romanian leu (RON)', NULL, 'lei', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (14, 'Sweden - Swedish krona (SEK)', NULL, 'kr', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (15, 'Turkey -Turkish lira (TRY)', NULL, '&#8378; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (16, 'Ukraine - Ukrainian hryvna  (UAH)', NULL, '₴ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (17, 'UAE -Emirati dirham (AED)', NULL, 'د.إ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (18, 'Israel - Israeli shekel (ILS)', NULL, '&#8362; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (19, 'Kenya - Kenyan shilling(KES)', NULL, 'Ksh', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (20, 'Morocco - Moroccan dirham (MAD)', NULL, '.د.م ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (21, 'Nigeria - Nigerian naira (NGN)', NULL, '₦ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (22, 'South Africa -South african rand** (ZAR)', NULL, 'R', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (23, 'Brazil- Brazilian real(BRL)', NULL, 'R$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (24, 'Canada-Canadian dollars (CAD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (25, 'Chile -Chilean peso (CLP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (26, 'Colombia -Colombian peso (COP)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (27, 'Mexico - Mexican peso (MXN)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (28, 'Peru -Peruvian sol(PEN)', NULL, 'S/. ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (29, 'USA -US dollar (USD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (30, 'Australia -Australian dollars (AUD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (31, 'Bangladesh -Bangladeshi taka (BDT) ', NULL, '&#2547; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (32, 'China - Chinese yuan (CNY)', NULL, '&#20803; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (33, 'Hong Kong - Hong Kong dollar(HKD)', NULL, '&#36; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (34, 'Indonesia - Indonesian rupiah (IDR)', NULL, 'Rp', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (35, 'India - Indian rupee', 'INR', '₹', '?', 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (36, 'Japan - Japanese yen (JPY)', NULL, '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (37, 'Malaysia - Malaysian ringgit (MYR)', NULL, 'RM', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (38, 'New Zealand - New Zealand dollar (NZD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (39, 'Philippines- Philippine peso (PHP)', NULL, '₱ ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (40, 'Pakistan- Pakistani rupee (PKR)', NULL, 'Rs ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (41, 'Singapore - Singapore dollar (SGD)', NULL, '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (42, 'South Korea - South Korean won (KRW)', NULL, '&#8361; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (43, 'Sri Lanka - Sri Lankan rupee (LKR)', NULL, 'Rs', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (44, 'Thailand- Thai baht (THB)', NULL, '&#3647; ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (45, 'Vietnam - Vietnamese dong', 'VND', '₫', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (46, 'Bitcoin - BTC or XBT', 'BTC ', '₿', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (47, 'Ripples', 'XRP', 'XRP', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (48, 'Monero', 'XMR', 'ɱ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (49, 'Litecoin', 'LTC', 'Ł', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (50, 'Ethereum', 'ETH', 'Ξ', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (51, 'Euro', 'EUR', '€', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (52, 'Pounds sterling', 'GBP', '£', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (53, 'US dollar', 'USD', '$', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (54, 'Japanese yen', 'JPY', '¥', NULL, 1);
INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (55, 'Omani rial', 'OMR', 'ر.ع.', NULL, 1);


#
# TABLE STRUCTURE FOR: db_custadvance
#

DROP TABLE IF EXISTS `db_custadvance`;

CREATE TABLE `db_custadvance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_custadvance_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_custadvance_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_coupons
#

DROP TABLE IF EXISTS `db_customer_coupons`;

CREATE TABLE `db_customer_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `value` double(20,2) DEFAULT NULL,
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `status` int DEFAULT NULL,
  `created_by` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `coupon_id` (`coupon_id`),
  CONSTRAINT `db_customer_coupons_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_coupons_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_coupons_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_coupons_ibfk_4` FOREIGN KEY (`coupon_id`) REFERENCES `db_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_payments
#

DROP TABLE IF EXISTS `db_customer_payments`;

CREATE TABLE `db_customer_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `salespayment_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `salespayment_id` (`salespayment_id`),
  CONSTRAINT `db_customer_payments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_payments_ibfk_2` FOREIGN KEY (`salespayment_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customers
#

DROP TABLE IF EXISTS `db_customers`;

CREATE TABLE `db_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Customer Code',
  `customer_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `sales_due` double(20,4) DEFAULT NULL,
  `sales_return_due` double(20,4) DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `state_id` int DEFAULT NULL,
  `city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ship_country_id` int DEFAULT NULL,
  `ship_state_id` int DEFAULT NULL,
  `ship_city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ship_postcode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ship_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `location_link` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `attachment_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `price_level_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Increase',
  `price_level` double(20,4) DEFAULT '0.0000',
  `delete_bit` int DEFAULT '0',
  `tot_advance` double(20,4) DEFAULT NULL,
  `credit_limit` double(20,4) DEFAULT '-1.0000',
  `shippingaddress_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_customers_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (1, 1, NULL, 'CU0001', 'Walk-in customer', NULL, '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 1, NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2019-01-01', '10:55:54 pm', 'admin', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, NULL, '-1.0000', 1);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (2, 2, 1, 'CU/02/0001', 'Walk-in customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0.6000', '0.0000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-02-12', '05:53:37 pm', '', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, '0.0000', '-1.0000', 2);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (3, 2, 2, 'CU0002', 'Jegan Sekar', '8883888012', '', 'uzrssoft2016@gmail.com', '', '', NULL, '0.0000', '19.0000', NULL, 79, 46, 'Madurai', '625532', 'Ramuni Nagar\r\nV.Karisalkulam', NULL, NULL, NULL, NULL, NULL, '::1', 'UZRS', '2025-08-24', '07:29:28 pm', 'user_599174', NULL, 1, '', NULL, 'Increase', '0.0000', 0, '0.0000', '-1.0000', 3);


#
# TABLE STRUCTURE FOR: db_emailtemplates
#

DROP TABLE IF EXISTS `db_emailtemplates`;

CREATE TABLE `db_emailtemplates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `key` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `variables` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  `undelete_bit` int DEFAULT NULL,
  `admin_only` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_emailtemplates_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (1, 1, 'SAAS_FORGOT_PASSWORD_EMAIL', 'Site forgot password email template', 'Hi {{user_name}},\r\n\r\nyour OTP is {{email_otp}}\r\n\r\nThank you\r\n{{saas_name}}', '{{user_name}}<br>\r\n{{saas_name}}<br>\r\n{{email_otp}}<br>', 1, 1, 1);
INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (2, 1, 'SAAS_WELCOME_EMAIL', 'Site welcome email', 'Hi {{user_name}},\r\nYour email id {{email_id}},\r\nwelcome to our {{saas_name}},\r\n\r\nThank you', '{{user_name}}<br>\r\n{{email_id}}<br>\r\n{{saas_name}}<br>', 1, 1, 1);


#
# TABLE STRUCTURE FOR: db_expense
#

DROP TABLE IF EXISTS `db_expense`;

CREATE TABLE `db_expense` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Expense Code',
  `expense_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_for` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_amt` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `db_expense_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_expense_ibfk_2` FOREIGN KEY (`account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_expense` (`id`, `store_id`, `count_id`, `expense_code`, `category_id`, `expense_date`, `reference_no`, `expense_for`, `expense_amt`, `payment_type`, `account_id`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`) VALUES (34, 2, 1, 'EX0001', 58, '2025-08-25', '', 'test', '100.0000', 'CASH', NULL, '', 'user_599174', '2025-08-25', '11:02:46 pm', '::1', 'UZRS', 1);


#
# TABLE STRUCTURE FOR: db_expense_category
#

DROP TABLE IF EXISTS `db_expense_category`;

CREATE TABLE `db_expense_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `category_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_expense_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_expense_category` (`id`, `store_id`, `category_code`, `category_name`, `description`, `created_by`, `status`) VALUES (58, 2, 'EC0001', 'Office Maintanance', '', 'user_599174', 1);


#
# TABLE STRUCTURE FOR: db_fivemojo
#

DROP TABLE IF EXISTS `db_fivemojo`;

CREATE TABLE `db_fivemojo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `instance_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `status` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_fivemojo_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_hold
#

DROP TABLE IF EXISTS `db_hold`;

CREATE TABLE `db_hold` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `reference_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Temprary',
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_hold_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_holditems
#

DROP TABLE IF EXISTS `db_holditems`;

CREATE TABLE `db_holditems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `hold_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`hold_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `db_holditems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_2` FOREIGN KEY (`hold_id`) REFERENCES `db_hold` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=394 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_instamojo
#

DROP TABLE IF EXISTS `db_instamojo`;

CREATE TABLE `db_instamojo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `api_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `api_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_instamojo_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_instamojo` (`id`, `store_id`, `sandbox`, `api_key`, `api_token`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_instamojopayments
#

DROP TABLE IF EXISTS `db_instamojopayments`;

CREATE TABLE `db_instamojopayments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `buyer_name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `amount` decimal(16,2) NOT NULL,
  `purpose` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `expires_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `send_sms` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `send_email` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `sms_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `shorturl` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `longurl` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `redirect_url` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `webhook` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `allow_repeated_payments` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL DEFAULT 'false',
  `customer_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `modified_at` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_items
#

DROP TABLE IF EXISTS `db_items`;

CREATE TABLE `db_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create ITEM Code',
  `item_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `sku` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hsn` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sac` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int DEFAULT NULL,
  `alert_qty` int DEFAULT NULL,
  `brand_id` int DEFAULT NULL,
  `lot_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `price` double(20,4) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `purchase_price` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profit_margin` double(20,2) DEFAULT NULL,
  `sales_price` double(20,4) DEFAULT NULL,
  `stock` double(20,2) DEFAULT NULL,
  `item_image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `discount_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Percentage',
  `discount` double(20,2) DEFAULT '0.00',
  `service_bit` int DEFAULT '0',
  `seller_points` double(20,2) DEFAULT '0.00',
  `custom_barcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `item_group` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `variant_id` int DEFAULT NULL,
  `child_bit` int DEFAULT '0',
  `mrp` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_items_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=514 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (1, 2, 1, 'IT020001', 'Sandisk 32GB USB 2.0 Flash Drive', 82, '', '', NULL, 61, 0, 0, NULL, NULL, '1.5000', 149, '1.5000', 'Inclusive', '86.67', '2.8000', '215.00', NULL, '37.28.46.147', 'dynamic.isp.ooredoo.om', '2022-08-09', '12:00:19 pm', 'Chris', NULL, 1, 'Percentage', '0.00', 0, '0.00', '619659069193', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (2, 2, 2, 'IT020002', 'Imation 64GB Flash Drive', 82, '', '', NULL, 61, 0, 0, NULL, NULL, '2.0000', 149, '2.0000', 'Inclusive', '95.00', '3.9000', '96.00', NULL, '37.28.46.147', 'dynamic.isp.ooredoo.om', '2022-08-09', '01:38:51 pm', 'Chris', NULL, 1, 'Percentage', '0.00', 0, '0.00', '3536403352219', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (3, 2, 3, 'IT020003', 'Sandisk Flash Drive USB C', 82, '', '', NULL, 61, 0, 0, NULL, NULL, '2.5000', 149, '2.5000', 'Inclusive', '100.00', '5.0000', '48.00', NULL, '5.21.237.233', '5.21.237.233', '2022-08-10', '09:23:28 am', 'Chris', NULL, 1, 'Percentage', '0.00', 0, '0.00', '619659142049', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (4, 2, 4, 'IT020004', '68001-1way switch,1m,6A', 86, '', '68001', NULL, 61, 100, 329, NULL, NULL, '12.9500', 153, '15.2800', 'Exclusive', '31.27', '17.0000', '196.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:42:41 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '33.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (5, 2, 5, 'IT020005', '68208-6A,  3Pin Round Socket,', 86, '', '68208', NULL, 61, 25, 329, NULL, NULL, '26.9500', 153, '31.8000', 'Exclusive', '35.00', '36.3800', '47.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:47:55 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '64.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (6, 2, 6, 'IT020006', '16A, 1Way switch with indicator-68077', 86, '', '85361020', NULL, 61, 15, 329, NULL, NULL, '36.5100', 153, '43.0800', 'Exclusive', '40.00', '51.1100', '26.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:53:51 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '89.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (7, 2, 7, 'IT020007', '6A/16A 3PIN SOCKET -68205', 86, '', '85361020', NULL, 61, 15, 329, NULL, NULL, '58.6700', 153, '69.2300', 'Exclusive', '40.00', '82.1400', '56.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:56:55 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '140.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (8, 2, 8, 'IT020008', '6A 2WAY SWITCH-68002', 86, '', '85361010', NULL, 61, 25, 329, NULL, NULL, '26.5100', 153, '31.2800', 'Exclusive', '40.00', '37.1100', '22.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:00:44 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '65.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (9, 2, 9, 'IT020009', '6A BELL PUSH-68003', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '27.8100', 153, '32.8200', 'Exclusive', '50.00', '41.7100', '17.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:03:40 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '68.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (10, 2, 10, 'IT020010', 'INDICATOR LED RED-68504', 86, '', '85318000', NULL, 61, 5, 329, NULL, NULL, '30.4200', 153, '35.9000', 'Exclusive', '50.00', '45.6300', '7.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:05:29 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '75.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (11, 2, 11, 'IT020011', 'FAN REGULATOR 4STEP-68301', 86, '', '84149030', NULL, 61, 20, 329, NULL, NULL, '122.1200', 153, '144.1000', 'Exclusive', '50.00', '183.1800', '37.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:08:56 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (12, 2, 12, 'IT020012', 'FAN REGULATOR 5STEP-68302', 86, '', '84149030', NULL, 61, 10, 329, NULL, NULL, '140.8100', 153, '166.1600', 'Exclusive', '50.00', '211.2200', '18.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:10:11 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (13, 2, 13, 'IT020013', '32A DP SWITCH WITH INDICATOR-68032', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '79.9700', 153, '94.3600', 'Exclusive', '50.00', '119.9500', '7.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:12:17 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (14, 2, 14, 'IT020014', 'SWITCH DUMMY-68503', 86, '', '85389000', NULL, 61, 50, 329, NULL, NULL, '7.8200', 153, '9.2300', 'Exclusive', '50.00', '11.7300', '96.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:13:49 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (15, 2, 15, 'IT02001', 'USB CHARGER(2.1A,5VDC)-68505', 86, '', '85044090', NULL, 61, 5, 329, NULL, NULL, '406.7900', 153, '480.0100', 'Exclusive', '50.00', '610.1900', '8.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:16:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '993.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (16, 2, 16, 'IT020016', 'TELEPHONE SOCKET RJ11-68610', 86, '', '85366910', NULL, 61, 5, 329, NULL, NULL, '43.9000', 153, '51.8000', 'Exclusive', '50.00', '65.8500', '9.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:19:08 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (17, 2, 17, 'IT020017', 'COMPUTER JACK RJ45-68622', 86, '', '85444299', NULL, 61, 5, 329, NULL, NULL, '231.2100', 153, '272.8300', 'Exclusive', '50.00', '346.8100', '8.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:22:24 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (18, 2, 18, 'IT020018', 'FOOT LIGHT LED 240V-68705', 86, '', '94054090', NULL, 61, 5, 329, NULL, NULL, '178.6200', 153, '210.7700', 'Exclusive', '50.00', '267.9300', '8.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:23:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (19, 2, 19, 'IT020019', '1 MODULE PLATE WOODEN BOX CHROME COLLAR-68551', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '35.2000', 153, '41.5400', 'Exclusive', '50.00', '52.8000', '18.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:26:33 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (20, 2, 20, 'IT020020', '2 MODULE PLATE WOODEN BOX CHROME COLLAR-68552', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '35.2000', 153, '41.5400', 'Exclusive', '50.00', '52.8000', '18.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:27:54 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (21, 2, 21, 'IT020021', '3 MODULE PLATE WOODEN BOX CHROME COLLAR-68553', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '41.2900', 153, '48.7200', 'Exclusive', '50.00', '61.9400', '19.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:30:03 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (22, 2, 22, 'IT020022', '4 MODULE PLATE WOODEN BOX CHROME COLLAR-68554', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '50.4100', 153, '59.4800', 'Exclusive', '50.00', '75.6100', '17.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:31:01 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (23, 2, 23, 'IT020023', '6 MODULE PLATE WOODEN BOX CHROME COLLAR-68556', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '68.6700', 153, '81.0300', 'Exclusive', '50.00', '103.0000', '8.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:32:48 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (24, 2, 24, 'IT020024', '8 MODULE PLATE WOODEN BOX CHROME COLLAR-68558', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '91.7000', 153, '108.2100', 'Exclusive', '50.00', '137.5500', '17.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:33:47 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (25, 2, 25, 'IT020025', '12 MODULE PLATE WOODEN BOX CHROME COLLAR-68512', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '113.0000', 153, '133.3400', 'Exclusive', '50.00', '169.5000', '9.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:34:50 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (26, 2, 26, 'IT020026', '10 MODULE H PLATE WOODEN BOX CHROME COLLAR-68560', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '102.5700', 153, '121.0300', 'Exclusive', '50.00', '153.8500', '9.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:36:40 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (27, 2, 27, 'IT020027', '12 MODULE H PLATE WOODEN BOX CHROME COLLAR-68562', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '113.0000', 153, '133.3400', 'Exclusive', '50.00', '169.5000', '9.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:37:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (28, 2, 28, 'IT020028', '16 MODULE PLATE WOODEN BOX CHROME COLLAR-68516', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '126.0400', 153, '148.7300', 'Exclusive', '50.00', '189.0600', '9.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:38:58 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (29, 2, 29, 'IT020029', '18 MODULE PLATE WOODEN BOX CHROME COLLAR-68518', 86, '', '85381090', NULL, 61, 3, 329, NULL, NULL, '136.4700', 153, '161.0300', 'Exclusive', '50.00', '204.7000', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:40:02 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (30, 2, 30, 'IT020030', '20 MODULE PLATE WOODEN BOX CHROME COLLAR-68520', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '146.9400', 153, '173.3900', 'Exclusive', '50.00', '220.4100', '9.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:41:12 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (31, 2, 31, 'IT020031', '24M PLATE WITH INNER FRAME WOODEN BOX-68524', 86, '', '85381090', NULL, 61, 3, 329, NULL, NULL, '207.3100', 153, '244.6300', 'Exclusive', '50.00', '310.9700', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:42:41 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (32, 2, 32, 'IT020032', '1M,SURFACE BOX WITH PLATE-68451', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '49.5500', 153, '58.4700', 'Exclusive', '50.00', '74.3200', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:44:18 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (33, 2, 33, 'IT020033', '12M,SURFACE BOX WITH PLATE-68452', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '49.5500', 153, '58.4700', 'Exclusive', '50.00', '74.3200', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:45:32 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (34, 2, 34, 'IT020034', '2M,SURFACE BOX WITH PLATE-68452', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '49.5500', 153, '58.4700', 'Exclusive', '50.00', '74.3200', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:46:53 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (35, 2, 35, 'IT020035', '3M,SURFACE BOX WITH PLATE-68453', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '60.4100', 153, '71.2800', 'Exclusive', '50.00', '90.6100', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:48:04 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (36, 2, 36, 'IT020036', '4M,SURFACE BOX WITH PLATE-68454', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '74.7500', 153, '88.2000', 'Exclusive', '50.00', '112.1300', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:49:02 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (37, 2, 37, 'IT020037', '6M,SURFACE BOX WITH PLATE-68456', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '99.5300', 153, '117.4500', 'Exclusive', '50.00', '149.3000', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:50:17 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (38, 2, 38, 'IT020038', '8M,SURFACE BOX WITH PLATE-68458', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '130.3800', 153, '153.8500', 'Exclusive', '50.00', '195.5700', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:52:28 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (39, 2, 39, 'IT020039', '12M,SURFACE BOX WITH PLATE-68412', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '159.0700', 153, '187.7000', 'Exclusive', '50.00', '238.6000', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:02:37 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (40, 2, 40, 'IT020040', '16M,SURFACE BOX WITH PLATE-68416', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '183.8400', 153, '216.9300', 'Exclusive', '50.00', '275.7600', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:04:54 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (41, 2, 41, 'IT020041', '18M,SURFACE BOX WITH PLATE-68418', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '201.2200', 153, '237.4400', 'Exclusive', '50.00', '301.8300', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:06:00 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (42, 2, 42, 'IT020042', '6A 1WAY CHERRY SWITCH WHITE-38194', 86, '', '85361010', NULL, 61, 30, 329, NULL, NULL, '11.9500', 153, '14.1000', 'Exclusive', '50.00', '17.9200', '60.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:08:03 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (43, 2, 43, 'IT020043', '6A, 3PIN SOCKET WHITE-38342', 86, '', '85366910', NULL, 61, 20, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '40.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:09:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (44, 2, 44, 'IT020044', '6A 2WAY  SWITCH PENTA CHERRYWHITE-38207', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:11:22 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (45, 2, 45, 'IT020045', '6A BELL PUSH CHERRY WHITE-38218', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:47:08 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (46, 2, 46, 'IT020046', 'NEON LIGHT LAMP WHITE-38273', 86, '', '85311090', NULL, 61, 10, 329, NULL, NULL, '26.5000', 153, '31.2700', 'Exclusive', '50.00', '39.7500', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:48:29 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (47, 2, 47, 'IT020047', 'FAN REGULATOR EME MINI WHITE-38284', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '141.8300', 153, '167.3600', 'Exclusive', '50.00', '212.7500', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:49:58 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (48, 2, 48, 'IT020048', 'FAN REGULATOR EME DELUXE WHITE-38660', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '159.5000', 153, '188.2100', 'Exclusive', '50.00', '239.2500', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:51:12 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (49, 2, 49, 'IT020049', '6A 1WAY SWITCH DELUXE IVORY-51373', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '11.4300', 153, '13.4900', 'Exclusive', '50.00', '17.1400', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:53:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (50, 2, 50, 'IT020050', '6A 3PIN SOCKET IVORY-50246', 86, '', '85446090', NULL, 61, 10, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:54:51 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (51, 2, 51, 'IT020051', '20A &amp; 10A 5IN1 WITH BOX UREA BACK PIECE WHITE', 86, '', '85361020', NULL, 61, 3, 329, NULL, NULL, '142.3500', 153, '167.9700', 'Exclusive', '50.00', '213.5200', '6.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:57:17 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (52, 2, 52, 'IT020052', '20A &amp; 10A 5IN1 EURO CAPTON UREA BACK PIECE WHITE -39986', 86, '', '85361020', NULL, 61, 3, 329, NULL, NULL, '136.1200', 153, '160.6200', 'Exclusive', '50.00', '204.1800', '6.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:59:13 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (53, 2, 53, 'IT020053', '20A &amp; 10A SS COMBINED UREA BACK PIECE  -39998', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '93.5200', 153, '110.3500', 'Exclusive', '50.00', '140.2800', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:01:00 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (54, 2, 54, 'IT020054', '20A &amp; 10A SS COMBINED WITH BOX UREA WHITE PIECE -39593', 86, '', '85361020', NULL, 61, 3, 329, NULL, NULL, '111.1800', 153, '131.1900', 'Exclusive', '50.00', '166.7700', '6.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:02:54 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (55, 2, 55, 'IT020055', '6A 3 PIN SUPERPLUG TOP WHITE', 86, '', '85365090', NULL, 61, 10, 329, NULL, NULL, '41.0800', 153, '48.4700', 'Exclusive', '50.00', '61.6200', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:04:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (56, 2, 56, 'IT020056', '16 A 3PIN SUPER PLUG TOP WHITE', 86, '', '85365090', NULL, 61, 10, 329, NULL, NULL, '54.0400', 153, '63.7700', 'Exclusive', '50.00', '81.0600', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:06:13 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (57, 2, 57, 'IT020057', 'DOOR BELL ROSE MERRY DING DONG-8294', 86, '', '85318000', NULL, 61, 5, 329, NULL, NULL, '107.0200', 153, '126.2800', 'Exclusive', '50.00', '160.5300', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:07:24 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (58, 2, 58, 'IT020058', '2PIN FLEXICORD 4M BLUE CHERRY-5208B', 86, '', '85366910', NULL, 61, 1, 329, NULL, NULL, '183.3900', 153, '216.4000', 'Exclusive', '50.00', '275.0800', '2.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:08:59 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (59, 2, 59, 'IT020059', '2PIN FLEXICORD 8M BLUE CHERRY-5219B', 86, '', '85366910', NULL, 61, 1, 329, NULL, NULL, '233.2700', 153, '275.2600', 'Exclusive', '50.00', '349.9100', '2.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:10:22 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (60, 2, 60, 'IT020060', 'SPIKE GUARD-4 UNIVERSAL SOCKET SHUTTER WITH IN SWITCH 4M-22568', 86, '', '85369090', NULL, 61, 1, 329, NULL, NULL, '378.7400', 153, '446.9100', 'Exclusive', '50.00', '568.1100', '2.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:12:00 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (61, 2, 61, 'IT020061', 'SPIKE GUARD-4 UNIVERSAL SOCKET SHUTTER WITH IN SWITCH 4M-22569', 86, '', '85369090', NULL, 61, 2, 329, NULL, NULL, '439.0000', 153, '518.0200', 'Exclusive', '50.00', '658.5000', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:17:45 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (62, 2, 62, 'IT020062', '6A 1WAY BED SWITCH WHITE-2527', 86, '', '85365020', NULL, 61, 10, 329, NULL, NULL, '29.0900', 153, '34.3300', 'Exclusive', '50.00', '43.6300', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:19:15 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (63, 2, 63, 'IT020063', '32A FUSE PORCELIAN UNIT PILOT-9322', 86, '', '85361060', NULL, 61, 3, 329, NULL, NULL, '120.5300', 153, '142.2300', 'Exclusive', '50.00', '180.8000', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:20:30 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (64, 2, 64, 'IT020064', '63A-FUSE UNIT PILOT-9322', 86, '', '85361060', NULL, 61, 2, 329, NULL, NULL, '299.7700', 153, '353.7300', 'Exclusive', '50.00', '449.6500', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:21:43 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (65, 2, 65, 'IT020065', '100A-FUSE UNIT PILOT-9333', 86, '', '85361060', NULL, 61, 2, 329, NULL, NULL, '529.4000', 153, '624.6900', 'Exclusive', '50.00', '794.1000', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:22:50 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (66, 2, 66, 'IT020066', 'INSULATION TAPE PVC 1.8CMX6M -1529', 86, '', '85469090', NULL, 61, 200, 329, NULL, NULL, '7.7400', 153, '9.1300', 'Exclusive', '35.00', '10.4500', '300.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:24:41 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (67, 2, 67, 'IT020067', '1.00SQMM PENTA WIRE -96333BK', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '29.75', '1386.1100', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:29:23 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (68, 2, 68, 'IT020068', '1.00SQMM RED PENTA WIRE -96333RD', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:31:07 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (69, 2, 69, 'IT020069', '1.00SQMMBLUE PENTA WIRE -96333BU', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:32:25 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (70, 2, 70, 'IT020070', '1.00SQMMGREEN PENTA WIRE -96333GN', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:33:42 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (71, 2, 71, 'IT020071', '1.00SQMMYELLOWPENTA WIRE -96333YL', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:35:03 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (72, 2, 72, 'IT020072', '1.5SQMM GREY PENTA WIRE -96333GY', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '1565.1900', 153, '1846.9200', 'Exclusive', '30.00', '2034.7500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:36:55 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (73, 2, 73, 'IT020073', '1.5SQMM BLACK PENTA WIRE -96333BK', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '1565.1900', 153, '1846.9200', 'Exclusive', '30.00', '2034.7500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:37:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (74, 2, 74, 'IT020074', '1.5SQMM RED PENTA WIRE -96333RD', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1565.1900', 153, '1846.9200', 'Exclusive', '30.00', '2034.7500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:39:48 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (75, 2, 75, 'IT020075', '2.5SQMM RED PENTA WIRE -96335RD', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:41:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (76, 2, 76, 'IT020076', '2.5SQMM BLACKPENTA WIRE -96335BK', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:41:58 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (77, 2, 77, 'IT020077', '2.5SQMM YELLOW PENTA WIRE -96335YL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:43:15 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (78, 2, 78, 'IT020078', '2.5SQMM BLUE PENTA WIRE -96335BL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:44:10 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (79, 2, 79, 'IT020079', '4.00SQMM BLUE PENTA WIRE -96336BL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '3760.9600', 153, '4437.9300', 'Exclusive', '30.00', '4889.2500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:45:12 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (80, 2, 80, 'IT020080', '4.00SQMM YELLOW PENTA WIRE -96336YL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '3760.9600', 153, '4437.9300', 'Exclusive', '30.00', '4889.2500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:46:21 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (81, 2, 81, 'IT020081', 'MCB 6A UNO SERIES-98001', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:47:56 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (82, 2, 82, 'IT020082', 'MCB 10A UNO SERIES-98002', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:48:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (83, 2, 83, 'IT020083', 'MCB 16A UNO SERIES-98003', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:49:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (84, 2, 84, 'IT020084', 'MCB 20A UNO SERIES-98004', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:50:49 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (85, 2, 85, 'IT020085', 'MCB 25A UNO SERIES-98005', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:51:47 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (86, 2, 86, 'IT020086', 'ISOLATOR 40A UNOSERIES-98055', 86, '', '85353090', NULL, 61, 6, 329, NULL, NULL, '254.9800', 153, '300.8800', 'Exclusive', '50.00', '382.4700', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:54:35 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (87, 2, 87, 'IT020087', 'RCCB 40A 30mA-98207', 86, '', '85362040', NULL, 61, 3, 329, NULL, NULL, '1522.3700', 153, '1796.4000', 'Exclusive', '30.00', '1979.0800', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:56:37 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (88, 2, 88, 'IT020088', 'MCB MINI 4M 25A METAL TOP-98498', 86, '', '85371000', NULL, 61, 3, 329, NULL, NULL, '477.0900', 153, '562.9700', 'Exclusive', '50.00', '715.6300', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:58:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (89, 2, 89, 'IT020089', 'MCB 40A -98023', 86, '', '85362030', NULL, 61, 3, 329, NULL, NULL, '591.6700', 153, '698.1700', 'Exclusive', '50.00', '887.5000', '6.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:00:15 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (90, 2, 90, 'IT020090', 'MCB 32A -98022', 86, '', '85362030', NULL, 61, 3, 329, NULL, NULL, '393.5100', 153, '464.3400', 'Exclusive', '50.00', '590.2600', '6.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:01:27 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (91, 2, 91, 'IT020091', 'MCB 63A UNO SERIES-98024', 86, '', '85362030', NULL, 61, 1, 329, NULL, NULL, '684.1700', 153, '807.3200', 'Exclusive', '50.00', '1026.2500', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:02:32 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (92, 2, 92, 'IT020092', 'RCCB 40A 30mA-98219', 86, '', '85362040', NULL, 61, 1, 329, NULL, NULL, '2011.6700', 153, '2373.7700', 'Exclusive', '50.00', '3017.5100', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:03:53 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (93, 2, 93, 'IT020093', 'RCCB 63A 30mA-98024', 86, '', '85362040', NULL, 61, 1, 329, NULL, NULL, '2210.7700', 153, '2608.7100', 'Exclusive', '50.00', '3316.1500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:05:34 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (94, 2, 94, 'IT020094', '1/2  MODULE METAL BOX -21780', 86, '', '85389000', NULL, 61, 10, 329, NULL, NULL, '30.6900', 153, '36.2100', 'Exclusive', '50.00', '46.0400', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:11:28 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (95, 2, 95, 'IT020095', '3  MODULE METAL BOX -21452', 86, '', '85389000', NULL, 61, 10, 329, NULL, NULL, '52.5100', 153, '61.9600', 'Exclusive', '50.00', '78.7700', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:14:02 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (96, 2, 96, 'IT020096', '4  MODULE METAL BOX -21791', 86, '', '85389000', NULL, 61, 10, 329, NULL, NULL, '52.5100', 153, '61.9600', 'Exclusive', '50.00', '78.7700', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:16:11 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (97, 2, 97, 'IT020097', '6  MODULE METAL BOX -21463', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '70.0200', 153, '82.6200', 'Exclusive', '50.00', '105.0300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:17:09 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (98, 2, 98, 'IT020098', '8/9  MODULE METAL BOX -30453', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '90.1600', 153, '106.3900', 'Exclusive', '50.00', '135.2400', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:18:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (99, 2, 99, 'IT020099', '12MODULE METAL BOX -21485', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '111.2600', 153, '131.2900', 'Exclusive', '50.00', '166.8900', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:19:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (100, 2, 100, 'IT020100', '16MODULE METAL BOX -21736', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '127.0900', 153, '149.9700', 'Exclusive', '50.00', '190.6300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:20:10 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (101, 2, 101, 'IT020101', '18MODULE METAL BOX -21758', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '141.4700', 153, '166.9300', 'Exclusive', '50.00', '212.2000', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:22:32 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (102, 2, 102, 'IT020102', 'ANGLE HOLDER WHITE-39673', 86, '', '85366110', NULL, 61, 30, 329, NULL, NULL, '27.5400', 153, '32.5000', 'Exclusive', '50.00', '41.3100', '60.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:23:38 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (103, 2, 103, 'IT020103', 'BATTEN HOLDER WHITE-39684', 86, '', '39684', NULL, 61, 10, 329, NULL, NULL, '27.5400', 153, '32.5000', 'Exclusive', '50.00', '41.3100', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:24:28 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (104, 2, 104, 'IT020104', 'LAMP HOLDER ANGLE WITH METAL RING-39797', 86, '', '85366110', NULL, 61, 60, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '90.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:06:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (105, 2, 105, 'IT020105', 'LAMP HOLDER BATTEN  WITH METAL RING-39800', 86, '', '85366110', NULL, 61, 60, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '90.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:07:46 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (106, 2, 106, 'IT020106', '6A CEILING ROSE JUMBO 2PLATE WHITE-39028', 86, '', '94054090', NULL, 61, 20, 329, NULL, NULL, '24.9400', 153, '29.4300', 'Exclusive', '50.00', '37.4100', '40.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:21:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (107, 2, 107, 'IT020107', '6A CEILING ROSE  2PLATE WHITE-39017', 86, '', '94054090', NULL, 61, 20, 329, NULL, NULL, '16.1100', 153, '19.0100', 'Exclusive', '50.00', '24.1600', '40.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:23:04 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (108, 2, 108, 'IT020108', '6AMULTI PLUG ADAPTOR-22841', 86, '', '85365090', NULL, 61, 10, 329, NULL, NULL, '85.2000', 153, '100.5400', 'Exclusive', '50.00', '127.8000', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:24:36 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (109, 2, 109, 'IT020109', '16A DYNA FLEXICRD SOCKET 4M-3381', 86, '', '85366910', NULL, 61, 1, 329, NULL, NULL, '431.2100', 153, '508.8300', 'Exclusive', '50.00', '646.8100', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:26:29 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (110, 2, 110, 'IT020110', 'MCB 16A MINI &quot;C&quot;ZIVA SERIES-68982', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '32.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:28:28 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (111, 2, 111, 'IT020111', 'MCB 20A MINI &quot;C&quot;ZIVA SERIES-68983', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '16.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:30:44 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (112, 2, 112, 'IT020112', 'MCB 25A MINI &quot;C&quot;ZIVA SERIES-68984', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '16.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:32:31 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (113, 2, 113, 'IT020113', 'MCB 32A MINI &quot;C&quot;ZIVA SERIES-68985', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '16.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:33:48 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (114, 2, 114, 'IT020114', 'WATER HEATER ANCHOR VENICE 3L-', 86, '', '85161000', NULL, 61, 3, 329, NULL, NULL, '2418.0000', 153, '2853.2400', 'Exclusive', '50.00', '3627.0000', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:36:00 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (115, 2, 115, 'IT020115', '9W LED BULB PANSONIC', 86, '', '85395200', NULL, 61, 500, 329, NULL, NULL, '35.0000', 153, '41.3000', 'Exclusive', '50.00', '52.5000', '600.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:38:40 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (116, 2, 116, 'IT020116', '12W LED BULB PANSONIC', 86, '', '85395200', NULL, 61, 90, 329, NULL, NULL, '72.0000', 153, '84.9600', 'Exclusive', '50.00', '108.0000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:41:19 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (117, 2, 117, 'IT020117', '20W LED PATTEN PANASONIC', 86, '', '94051100', NULL, 61, 30, 329, NULL, NULL, '83.0000', 153, '97.9400', 'Exclusive', '50.00', '124.5000', '50.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:43:12 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (118, 2, 118, 'IT020118', '3W LED JUNCTION PANASONIC', 86, '', '94051010', NULL, 61, 50, 329, NULL, NULL, '65.0000', 153, '76.7000', 'Exclusive', '50.00', '97.5000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:44:39 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (119, 2, 119, 'IT020119', '5W LED DOWN LIGHT PANASONIC', 86, '', '94054900', NULL, 61, 50, 329, NULL, NULL, '72.0000', 153, '84.9600', 'Exclusive', '50.00', '108.0000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:46:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (120, 2, 120, 'IT020120', '9W LED EMERGENCY PANSONIC', 86, '', '85395200', NULL, 61, 3, 329, NULL, NULL, '270.0000', 153, '318.6000', 'Exclusive', '50.00', '405.0000', '8.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:47:41 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (121, 2, 121, 'IT020121', '15W LED PC PANEL ROUND PANASONIC', 86, '', '94051100', NULL, 61, 3, 329, NULL, NULL, '380.0000', 153, '448.4000', 'Exclusive', '50.00', '570.0000', '8.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:49:23 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (122, 2, 122, 'IT020122', 'DOOR BELL PARROT-22666', 86, '', '85318000', NULL, 61, 3, 329, NULL, NULL, '167.8100', 153, '198.0200', 'Exclusive', '50.00', '251.7200', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:53:40 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (123, 2, 123, 'IT020123', 'DOOR BELL WIRELESS-22740', 86, '', '85318000', NULL, 61, 1, 329, NULL, NULL, '452.5100', 153, '533.9600', 'Exclusive', '50.00', '678.7600', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:54:52 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (124, 2, 124, 'IT020124', 'DOOR BELL WIRELESS PLUG-22720', 86, '', '85318000', NULL, 61, 1, 329, NULL, NULL, '456.6700', 153, '538.8700', 'Exclusive', '50.00', '685.0000', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:55:59 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (125, 2, 125, 'IT020125', 'PENDENT HOLDER WHITE-6506', 86, '', '85366110', NULL, 61, 50, 329, NULL, NULL, '18.1800', 153, '21.4500', 'Exclusive', '50.00', '27.2700', '60.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:57:10 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (126, 2, 126, 'IT020126', 'ADAPTOR WHITE-6506', 86, '', '85369090', NULL, 61, 10, 329, NULL, NULL, '16.1100', 153, '19.0100', 'Exclusive', '50.00', '24.1600', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:58:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (127, 2, 127, 'IT020127', '0.5W LED NIGHT LAMP', 86, '', '85395200', NULL, 61, 30, 329, NULL, NULL, '30.5000', 153, '35.9900', 'Exclusive', '50.00', '45.7500', '50.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:59:50 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (128, 2, 128, 'IT020128', '6A 3 PIN PLUG DELUXEMULTIPLUG WHITE-3155', 86, '', '85365090', NULL, 61, 5, 329, NULL, NULL, '48.3200', 153, '57.0200', 'Exclusive', '50.00', '72.4800', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:01:45 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (129, 2, 129, 'IT020129', '6A CEILING ROSE  39676', 86, '', '85446090', NULL, 61, 5, 329, NULL, NULL, '31.6900', 153, '37.3900', 'Exclusive', '50.00', '47.5400', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:03:12 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (130, 2, 130, 'IT020130', 'LAMP HOLDER ANGLE 39675', 86, '', '85366110', NULL, 61, 5, 329, NULL, NULL, '32.2100', 153, '38.0100', 'Exclusive', '50.00', '48.3100', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:05:02 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (131, 2, 131, 'IT020131', 'LAMP HOLDER BATTEN 39686', 86, '', '85366110', NULL, 61, 5, 329, NULL, NULL, '32.2100', 153, '38.0100', 'Exclusive', '50.00', '48.3100', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:06:28 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (132, 2, 132, 'IT020132', '6A 1WAY SLIM SWITCH', 86, '', '85361010', NULL, 61, 50, 329, NULL, NULL, '13.2000', 153, '15.5800', 'Exclusive', '50.00', '19.8000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:07:43 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (133, 2, 133, 'IT020133', '6A 3PIN ROUND SOCKET', 86, '', '85366910', NULL, 61, 25, 329, NULL, NULL, '29.5300', 153, '34.8500', 'Exclusive', '50.00', '44.3000', '50.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:09:16 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (134, 2, 134, 'IT020134', '16A, 1Way switch SLIM with indicator-47163', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '47.5400', 153, '56.1000', 'Exclusive', '50.00', '71.3100', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:10:32 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (135, 2, 135, 'IT020135', '6A/16A TWIN SOCKET -47366', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '76.7600', 153, '90.5800', 'Exclusive', '50.00', '115.1400', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:11:39 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (136, 2, 136, 'IT020136', 'FAN REGULATOR TINY-47513', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '141.8300', 153, '167.3600', 'Exclusive', '50.00', '212.7500', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:12:39 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (137, 2, 137, 'IT020137', 'FAN REGULATOR MEGA-47500', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '163.2600', 153, '192.6500', 'Exclusive', '50.00', '244.8900', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:13:42 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (138, 2, 138, 'IT020138', 'INDICATOR GREEN/ RED-47682', 86, '', '85318000', NULL, 61, 5, 329, NULL, NULL, '37.0200', 153, '43.6800', 'Exclusive', '50.00', '55.5300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:15:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (139, 2, 139, 'IT020139', 'BLANK PLATE SINGLE-47684', 86, '', '85389000', NULL, 61, 40, 329, NULL, NULL, '10.9100', 153, '12.8700', 'Exclusive', '50.00', '16.3700', '52.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:16:11 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (140, 2, 140, 'IT020140', '6A 2WAY SLIM SWITCH-47102', 86, '', '85361010', NULL, 61, 4, 329, NULL, NULL, '34.2900', 153, '40.4600', 'Exclusive', '50.00', '51.4400', '8.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:17:17 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (141, 2, 141, 'IT020141', '6A BELL PUSH SLIM-47104', 86, '', '85361010', NULL, 61, 5, 329, NULL, NULL, '36.2400', 153, '42.7600', 'Exclusive', '50.00', '54.3600', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:18:38 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (142, 2, 142, 'IT020142', '32A 1WAY MEGADP SWITCH WITH INDICATOR-47132', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '83.0000', 153, '97.9400', 'Exclusive', '50.00', '124.5000', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:20:20 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (143, 2, 143, 'IT020143', '2 MODULE PLATE INNER FRAME WOODEN BOX-48302', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '38.6100', 153, '45.5600', 'Exclusive', '50.00', '57.9100', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:21:57 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (144, 2, 144, 'IT020144', '3 MODULE PLATE INNER FRAME WOODEN BOX-48303', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '46.8000', 153, '55.2200', 'Exclusive', '50.00', '70.2000', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:22:56 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (145, 2, 145, 'IT020145', '4 MODULE PLATE INNER FRAME WOODEN BOX-48304', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '55.3800', 153, '65.3500', 'Exclusive', '50.00', '83.0700', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:23:47 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (146, 2, 146, 'IT020146', '6 MODULE PLATE INNER FRAME WOODEN BOX-48306', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '74.1000', 153, '87.4400', 'Exclusive', '50.00', '111.1500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:24:38 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (147, 2, 147, 'IT020147', '8 MODULE PLATE HORIZONTAL INNER FRAME WOODEN BOX-48308', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '98.6800', 153, '116.4400', 'Exclusive', '50.00', '148.0200', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:25:46 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (148, 2, 148, 'IT020148', '10 MODULE PLATE HORIZONTAL INNER FRAME WOODEN BOX-48310', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '105.3000', 153, '124.2500', 'Exclusive', '50.00', '157.9500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:26:54 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (149, 2, 149, 'IT020149', '12 MODULE PLATE  INNER FRAME WOODEN BOX-48313', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '120.9000', 153, '142.6600', 'Exclusive', '50.00', '181.3500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:28:02 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (150, 2, 150, 'IT020150', '16 MODULE PLATE  INNER FRAME WOODEN BOX-48316', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '136.5000', 153, '161.0700', 'Exclusive', '50.00', '204.7500', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:29:20 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (151, 2, 151, 'IT020151', '20 MODULE PLATE  INNER FRAME WOODEN BOX-48316', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '165.7500', 153, '195.5900', 'Exclusive', '50.00', '248.6300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:30:15 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (152, 2, 152, 'IT020152', '12 MODULE PLATE HORIZONTAL INNER FRAME WOODEN BOX-48312', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '116.5000', 153, '137.4700', 'Exclusive', '50.00', '174.7500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:31:19 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (153, 2, 153, 'IT020153', '4&quot; PIPE 15KG (RED)32MM', 87, '', '39174000', NULL, 61, 4, 332, NULL, NULL, '715.0000', 153, '715.0000', 'Inclusive', '30.00', '929.5000', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '04:04:15 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (154, 2, 154, 'IT020154', '2 1/2&quot; MAXFLO PIPE4KGBLUE 75mm', 87, '', '39174000', NULL, 61, 5, 332, NULL, NULL, '420.0000', 153, '420.0000', 'Inclusive', '25.00', '525.0000', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '04:20:29 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (155, 2, 155, 'IT020155', '1&quot; PVC PIPE MAXFLO 15KG -32MM', 87, '', '39174000', NULL, 61, 15, 332, NULL, NULL, '265.0000', 153, '265.0000', 'Inclusive', '30.00', '344.5000', '30.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '04:23:34 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (156, 2, 156, 'IT020156', '1&quot; PVC ELBOW- 32MM AVON PLAST 10KG', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '8.4200', 153, '8.4200', 'Inclusive', '50.00', '12.6300', '122.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:39:04 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (157, 2, 157, 'IT020157', '1&quot; TEE 32MM PVC-AVON 10KG', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '11.2800', 153, '11.2800', 'Inclusive', '50.00', '16.9200', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:40:37 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (158, 2, 158, 'IT020158', '1&quot; SWR 45DEG BEND 32MM PVC-AVON 10KG', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '11.1300', 153, '11.1300', 'Inclusive', '50.00', '16.7000', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:42:02 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (159, 2, 159, 'IT020159', '1&quot;COUPLER 32MM PVC-AVON 10KG', 86, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '4.9200', 153, '4.9200', 'Inclusive', '50.00', '7.3800', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:43:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (160, 2, 160, 'IT020160', '1&quot; MTA 32MM PVC-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '5.0300', 153, '5.0300', 'Inclusive', '50.00', '7.5400', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:44:19 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (161, 2, 161, 'IT020161', '1&quot; FTA 32MM PVC-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '5.1500', 153, '5.1500', 'Inclusive', '50.00', '7.7300', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:45:16 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (162, 2, 162, 'IT020162', '1&quot; UNION32MM PVC-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '34.1500', 153, '34.1500', 'Inclusive', '30.00', '44.3900', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:46:15 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (163, 2, 163, 'IT020163', '1&quot; PVC BALL VALVE  32MM LONG HANDLE-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '76.2300', 153, '76.2300', 'Inclusive', '25.00', '95.2900', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:48:03 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (164, 2, 164, 'IT020164', '1&quot;X1/2&quot;PVC BRASS ELBOW', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '61.6300', 153, '61.6300', 'Inclusive', '30.00', '80.1200', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:49:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (165, 2, 165, 'IT020165', '1&quot;X1/2&quot;PVC BRASS FTA', 87, '', '39172390', NULL, 61, 5, 333, NULL, NULL, '64.4900', 153, '64.4900', 'Inclusive', '30.00', '83.8400', '10.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:50:53 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (166, 2, 166, 'IT020166', '1&quot; CPVC 90DEG ELBOW', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '20.7300', 153, '20.7300', 'Inclusive', '30.00', '26.9500', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:53:14 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (167, 2, 167, 'IT020167', '1&quot; CPVC 90DEG TEE AVON', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '26.5600', 153, '26.5600', 'Inclusive', '30.00', '34.5300', '30.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:54:13 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (168, 2, 168, 'IT020168', '1&quot;X1/2&quot;CPVC BRASS ELBOW  AVON', 87, '', '39172390', NULL, 61, 50, 333, NULL, NULL, '63.2100', 153, '63.2100', 'Inclusive', '30.00', '82.1700', '75.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:55:24 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (169, 2, 169, 'IT020169', '1&quot;X1/2&quot;CPVC BRASS TEE  AVON', 87, '', '39172390', NULL, 61, 50, 333, NULL, NULL, '71.5900', 153, '71.5900', 'Inclusive', '30.00', '93.0700', '70.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:56:38 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (170, 2, 170, 'IT020170', '1&quot; MTA  CPVC (PLASTIC)-AVON 32MM', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '16.8000', 153, '16.8000', 'Inclusive', '30.00', '21.8400', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:58:32 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (171, 2, 171, 'IT020171', '1&quot; FTA  CPVC (PLASTIC)-AVON 32MM', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '23.1300', 153, '23.1300', 'Inclusive', '30.00', '30.0700', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:59:36 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (172, 2, 172, 'IT020172', '1&quot;CPVC TANK NIPPLE', 87, '', '39172390', NULL, 61, 40, 333, NULL, NULL, '50.2800', 153, '50.2800', 'Inclusive', '30.00', '65.3600', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:01:14 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (173, 2, 173, 'IT020173', '1&quot; CPVC UNION', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '61.8300', 153, '61.8300', 'Inclusive', '30.00', '80.3800', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:02:40 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (174, 2, 174, 'IT020174', '1&quot; CPVC CONCEALED VALVE SHORT', 87, '', '39172390', NULL, 61, 10, 333, NULL, NULL, '854.9600', 153, '854.9600', 'Inclusive', '30.00', '1111.4500', '18.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:04:53 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (175, 2, 175, 'IT020175', '1&quot;X1/2&quot;CPVC BRASS FTA', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '59.1700', 153, '59.1700', 'Inclusive', '30.00', '76.9200', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:06:33 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (176, 2, 176, 'IT020176', '4&quot;PVC ELBOW 110MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '68.0000', 153, '68.0000', 'Inclusive', '30.00', '88.4000', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:09:48 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (177, 2, 177, 'IT020177', '4&quot;PVC TEE 110MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '79.5800', 153, '79.5800', 'Inclusive', '30.00', '103.4500', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:11:05 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (178, 2, 178, 'IT020178', '4&quot;PVC 45DEG BEND 110MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '56.0500', 153, '56.0500', 'Inclusive', '30.00', '72.8600', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:12:49 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (179, 2, 179, 'IT020179', '4&quot;AIR VENT COWL', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '14.2200', 153, '14.2200', 'Inclusive', '30.00', '18.4900', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:13:56 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (180, 2, 180, 'IT020180', '2 1/2&quot; PVC DOOR BEND', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '52.7100', 153, '52.7100', 'Inclusive', '30.00', '68.5200', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:15:04 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (181, 2, 181, 'IT020181', '2 1/2&quot; PVC SINGLE  PLAIN TEE', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '48.2100', 153, '48.2100', 'Inclusive', '30.00', '62.6700', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:16:22 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (182, 2, 182, 'IT020182', '2 1/2&quot; PVC SINGLE  DOOR TEE', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '57.6700', 153, '57.6700', 'Inclusive', '30.00', '74.9700', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:17:13 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (183, 2, 183, 'IT020183', '2 1/2&quot;PVC 45DEG BEND 75MM', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '29.6100', 153, '29.6100', 'Inclusive', '30.00', '38.4900', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:19:00 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (184, 2, 184, 'IT020184', '2 1/2&quot;PVC ELBOW 75MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '30.8700', 153, '30.8700', 'Inclusive', '30.00', '40.1300', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:20:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (185, 2, 185, 'IT020185', '2 1/2&quot;AIR VENT COWL', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '8.7700', 153, '8.7700', 'Inclusive', '30.00', '11.4000', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:21:21 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (186, 2, 186, 'IT020186', '1&quot;X1/2&quot; PVC BRASS FTA', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '64.5000', 153, '64.5000', 'Inclusive', '30.00', '83.8500', '40.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:23:34 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (187, 2, 187, 'IT020187', '750 LTR WATER TANK 3LAYER 10YR GURANTED', 87, '', '84807900', NULL, 61, 1, 333, NULL, NULL, '3216.0000', 153, '3216.0000', 'Inclusive', '28.00', '4116.4800', '1.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:36:14 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (188, 2, 188, 'IT020188', '1.25&quot; COLUMN PIPES', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '235.0000', 153, '235.0000', 'Inclusive', '40.00', '329.0000', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:38:08 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (189, 2, 189, 'IT020189', '1&quot; CPVC PIPE AVON SDR 13.5', 87, '', '39172390', NULL, 61, 100, 333, NULL, NULL, '356.0000', 153, '356.0000', 'Inclusive', '30.00', '462.8000', '30.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:41:33 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (259, 2, 1, 'IT020001', 'Anchor', 86, '', '68001', NULL, 61, 100, 329, NULL, NULL, '12.9500', 153, '15.2800', 'Exclusive', '0.00', '12.9500', '201.00', NULL, '120.56.75.25', '120.56.75.25', '2025-08-24', '09:01:33 pm', 'user_450343', NULL, 1, 'Fixed', '0.00', 0, '0.00', '', '1 WAY SWITCH,1,6A,240V', 'Single', NULL, NULL, 0, '33.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (260, 2, 4, 'IT020004', '68001-1way switch,1m,6A', 86, '', '68001', NULL, 61, 100, 329, NULL, NULL, '12.9500', 153, '15.2800', 'Exclusive', '31.27', '17.0000', '200.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:42:41 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '33.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (261, 2, 5, 'IT020005', '68208-6A,  3Pin Round Socket,', 86, '', '68208', NULL, 61, 25, 329, NULL, NULL, '26.9500', 153, '31.8000', 'Exclusive', '35.00', '36.3800', '50.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:47:55 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '64.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (262, 2, 6, 'IT020006', '16A, 1Way switch with indicator-68077', 86, '', '85361020', NULL, 61, 15, 329, NULL, NULL, '36.5100', 153, '43.0800', 'Exclusive', '40.00', '51.1100', '30.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:53:51 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '89.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (263, 2, 7, 'IT020007', '6A/16A 3PIN SOCKET -68205', 86, '', '85361020', NULL, 61, 15, 329, NULL, NULL, '58.6700', 153, '69.2300', 'Exclusive', '40.00', '82.1400', '60.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-24', '11:56:55 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '140.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (264, 2, 8, 'IT020008', '6A 2WAY SWITCH-68002', 86, '', '85361010', NULL, 61, 25, 329, NULL, NULL, '26.5100', 153, '31.2800', 'Exclusive', '40.00', '37.1100', '25.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:00:44 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '65.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (265, 2, 9, 'IT020009', '6A BELL PUSH-68003', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '27.8100', 153, '32.8200', 'Exclusive', '50.00', '41.7100', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:03:40 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '68.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (266, 2, 10, 'IT020010', 'INDICATOR LED RED-68504', 86, '', '85318000', NULL, 61, 5, 329, NULL, NULL, '30.4200', 153, '35.9000', 'Exclusive', '50.00', '45.6300', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:05:29 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '75.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (267, 2, 11, 'IT020011', 'FAN REGULATOR 4STEP-68301', 86, '', '84149030', NULL, 61, 20, 329, NULL, NULL, '122.1200', 153, '144.1000', 'Exclusive', '50.00', '183.1800', '37.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:08:56 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (268, 2, 12, 'IT020012', 'FAN REGULATOR 5STEP-68302', 86, '', '84149030', NULL, 61, 10, 329, NULL, NULL, '140.8100', 153, '166.1600', 'Exclusive', '50.00', '211.2200', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:10:11 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (269, 2, 13, 'IT020013', '32A DP SWITCH WITH INDICATOR-68032', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '79.9700', 153, '94.3600', 'Exclusive', '50.00', '119.9500', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:12:17 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (270, 2, 14, 'IT020014', 'SWITCH DUMMY-68503', 86, '', '85389000', NULL, 61, 50, 329, NULL, NULL, '7.8200', 153, '9.2300', 'Exclusive', '50.00', '11.7300', '90.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:13:49 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (271, 2, 15, 'IT02001', 'USB CHARGER(2.1A,5VDC)-68505', 86, '', '85044090', NULL, 61, 5, 329, NULL, NULL, '406.7900', 153, '480.0100', 'Exclusive', '50.00', '610.1900', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:16:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '993.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (272, 2, 16, 'IT020016', 'TELEPHONE SOCKET RJ11-68610', 86, '', '85366910', NULL, 61, 5, 329, NULL, NULL, '43.9000', 153, '51.8000', 'Exclusive', '50.00', '65.8500', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:19:08 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (273, 2, 17, 'IT020017', 'COMPUTER JACK RJ45-68622', 86, '', '85444299', NULL, 61, 5, 329, NULL, NULL, '231.2100', 153, '272.8300', 'Exclusive', '50.00', '346.8100', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:22:24 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (274, 2, 18, 'IT020018', 'FOOT LIGHT LED 240V-68705', 86, '', '94054090', NULL, 61, 5, 329, NULL, NULL, '178.6200', 153, '210.7700', 'Exclusive', '50.00', '267.9300', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:23:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (275, 2, 19, 'IT020019', '1 MODULE PLATE WOODEN BOX CHROME COLLAR-68551', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '35.2000', 153, '41.5400', 'Exclusive', '50.00', '52.8000', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:26:33 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (276, 2, 20, 'IT020020', '2 MODULE PLATE WOODEN BOX CHROME COLLAR-68552', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '35.2000', 153, '41.5400', 'Exclusive', '50.00', '52.8000', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:27:54 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (277, 2, 21, 'IT020021', '3 MODULE PLATE WOODEN BOX CHROME COLLAR-68553', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '41.2900', 153, '48.7200', 'Exclusive', '50.00', '61.9400', '16.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:30:03 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (278, 2, 22, 'IT020022', '4 MODULE PLATE WOODEN BOX CHROME COLLAR-68554', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '50.4100', 153, '59.4800', 'Exclusive', '50.00', '75.6100', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:31:01 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (279, 2, 23, 'IT020023', '6 MODULE PLATE WOODEN BOX CHROME COLLAR-68556', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '68.6700', 153, '81.0300', 'Exclusive', '50.00', '103.0000', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:32:48 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (280, 2, 24, 'IT020024', '8 MODULE PLATE WOODEN BOX CHROME COLLAR-68558', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '91.7000', 153, '108.2100', 'Exclusive', '50.00', '137.5500', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:33:47 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (281, 2, 25, 'IT020025', '12 MODULE PLATE WOODEN BOX CHROME COLLAR-68512', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '113.0000', 153, '133.3400', 'Exclusive', '50.00', '169.5000', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:34:50 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (282, 2, 26, 'IT020026', '10 MODULE H PLATE WOODEN BOX CHROME COLLAR-68560', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '102.5700', 153, '121.0300', 'Exclusive', '50.00', '153.8500', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:36:40 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (283, 2, 27, 'IT020027', '12 MODULE H PLATE WOODEN BOX CHROME COLLAR-68562', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '113.0000', 153, '133.3400', 'Exclusive', '50.00', '169.5000', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:37:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (284, 2, 28, 'IT020028', '16 MODULE PLATE WOODEN BOX CHROME COLLAR-68516', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '126.0400', 153, '148.7300', 'Exclusive', '50.00', '189.0600', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:38:58 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (285, 2, 29, 'IT020029', '18 MODULE PLATE WOODEN BOX CHROME COLLAR-68518', 86, '', '85381090', NULL, 61, 3, 329, NULL, NULL, '136.4700', 153, '161.0300', 'Exclusive', '50.00', '204.7000', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:40:02 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (286, 2, 30, 'IT020030', '20 MODULE PLATE WOODEN BOX CHROME COLLAR-68520', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '146.9400', 153, '173.3900', 'Exclusive', '50.00', '220.4100', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:41:12 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (287, 2, 31, 'IT020031', '24M PLATE WITH INNER FRAME WOODEN BOX-68524', 86, '', '85381090', NULL, 61, 3, 329, NULL, NULL, '207.3100', 153, '244.6300', 'Exclusive', '50.00', '310.9700', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:42:41 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (288, 2, 32, 'IT020032', '1M,SURFACE BOX WITH PLATE-68451', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '49.5500', 153, '58.4700', 'Exclusive', '50.00', '74.3200', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:44:18 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (289, 2, 33, 'IT020033', '12M,SURFACE BOX WITH PLATE-68452', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '49.5500', 153, '58.4700', 'Exclusive', '50.00', '74.3200', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:45:32 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (290, 2, 34, 'IT020034', '2M,SURFACE BOX WITH PLATE-68452', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '49.5500', 153, '58.4700', 'Exclusive', '50.00', '74.3200', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:46:53 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (291, 2, 35, 'IT020035', '3M,SURFACE BOX WITH PLATE-68453', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '60.4100', 153, '71.2800', 'Exclusive', '50.00', '90.6100', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:48:04 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (292, 2, 36, 'IT020036', '4M,SURFACE BOX WITH PLATE-68454', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '74.7500', 153, '88.2000', 'Exclusive', '50.00', '112.1300', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:49:02 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (293, 2, 37, 'IT020037', '6M,SURFACE BOX WITH PLATE-68456', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '99.5300', 153, '117.4500', 'Exclusive', '50.00', '149.3000', '10.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:50:17 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (294, 2, 38, 'IT020038', '8M,SURFACE BOX WITH PLATE-68458', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '130.3800', 153, '153.8500', 'Exclusive', '50.00', '195.5700', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '12:52:28 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (295, 2, 39, 'IT020039', '12M,SURFACE BOX WITH PLATE-68412', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '159.0700', 153, '187.7000', 'Exclusive', '50.00', '238.6000', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:02:37 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (296, 2, 40, 'IT020040', '16M,SURFACE BOX WITH PLATE-68416', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '183.8400', 153, '216.9300', 'Exclusive', '50.00', '275.7600', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:04:54 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (297, 2, 41, 'IT020041', '18M,SURFACE BOX WITH PLATE-68418', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '201.2200', 153, '237.4400', 'Exclusive', '50.00', '301.8300', '5.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:06:00 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (298, 2, 42, 'IT020042', '6A 1WAY CHERRY SWITCH WHITE-38194', 86, '', '85361010', NULL, 61, 30, 329, NULL, NULL, '11.9500', 153, '14.1000', 'Exclusive', '50.00', '17.9200', '60.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:08:03 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (299, 2, 43, 'IT020043', '6A, 3PIN SOCKET WHITE-38342', 86, '', '85366910', NULL, 61, 20, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '40.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:09:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (300, 2, 44, 'IT020044', '6A 2WAY  SWITCH PENTA CHERRYWHITE-38207', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '20.00', NULL, '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', '2025-08-25', '01:11:22 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (301, 2, 45, 'IT020045', '6A BELL PUSH CHERRY WHITE-38218', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:47:08 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (302, 2, 46, 'IT020046', 'NEON LIGHT LAMP WHITE-38273', 86, '', '85311090', NULL, 61, 10, 329, NULL, NULL, '26.5000', 153, '31.2700', 'Exclusive', '50.00', '39.7500', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:48:29 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (303, 2, 47, 'IT020047', 'FAN REGULATOR EME MINI WHITE-38284', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '141.8300', 153, '167.3600', 'Exclusive', '50.00', '212.7500', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:49:58 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (304, 2, 48, 'IT020048', 'FAN REGULATOR EME DELUXE WHITE-38660', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '159.5000', 153, '188.2100', 'Exclusive', '50.00', '239.2500', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:51:12 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (305, 2, 49, 'IT020049', '6A 1WAY SWITCH DELUXE IVORY-51373', 86, '', '85361010', NULL, 61, 10, 329, NULL, NULL, '11.4300', 153, '13.4900', 'Exclusive', '50.00', '17.1400', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:53:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (306, 2, 50, 'IT020050', '6A 3PIN SOCKET IVORY-50246', 86, '', '85446090', NULL, 61, 10, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:54:51 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (307, 2, 51, 'IT020051', '20A &amp; 10A 5IN1 WITH BOX UREA BACK PIECE WHITE', 86, '', '85361020', NULL, 61, 3, 329, NULL, NULL, '142.3500', 153, '167.9700', 'Exclusive', '50.00', '213.5200', '6.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:57:17 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (308, 2, 52, 'IT020052', '20A &amp; 10A 5IN1 EURO CAPTON UREA BACK PIECE WHITE -39986', 86, '', '85361020', NULL, 61, 3, 329, NULL, NULL, '136.1200', 153, '160.6200', 'Exclusive', '50.00', '204.1800', '6.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '07:59:13 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (309, 2, 53, 'IT020053', '20A &amp; 10A SS COMBINED UREA BACK PIECE  -39998', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '93.5200', 153, '110.3500', 'Exclusive', '50.00', '140.2800', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:01:00 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (310, 2, 54, 'IT020054', '20A &amp; 10A SS COMBINED WITH BOX UREA WHITE PIECE -39593', 86, '', '85361020', NULL, 61, 3, 329, NULL, NULL, '111.1800', 153, '131.1900', 'Exclusive', '50.00', '166.7700', '6.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:02:54 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (311, 2, 55, 'IT020055', '6A 3 PIN SUPERPLUG TOP WHITE', 86, '', '85365090', NULL, 61, 10, 329, NULL, NULL, '41.0800', 153, '48.4700', 'Exclusive', '50.00', '61.6200', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:04:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (312, 2, 56, 'IT020056', '16 A 3PIN SUPER PLUG TOP WHITE', 86, '', '85365090', NULL, 61, 10, 329, NULL, NULL, '54.0400', 153, '63.7700', 'Exclusive', '50.00', '81.0600', '20.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:06:13 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (313, 2, 57, 'IT020057', 'DOOR BELL ROSE MERRY DING DONG-8294', 86, '', '85318000', NULL, 61, 5, 329, NULL, NULL, '107.0200', 153, '126.2800', 'Exclusive', '50.00', '160.5300', '10.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:07:24 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (314, 2, 58, 'IT020058', '2PIN FLEXICORD 4M BLUE CHERRY-5208B', 86, '', '85366910', NULL, 61, 1, 329, NULL, NULL, '183.3900', 153, '216.4000', 'Exclusive', '50.00', '275.0800', '2.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:08:59 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (315, 2, 59, 'IT020059', '2PIN FLEXICORD 8M BLUE CHERRY-5219B', 86, '', '85366910', NULL, 61, 1, 329, NULL, NULL, '233.2700', 153, '275.2600', 'Exclusive', '50.00', '349.9100', '2.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:10:22 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (316, 2, 60, 'IT020060', 'SPIKE GUARD-4 UNIVERSAL SOCKET SHUTTER WITH IN SWITCH 4M-22568', 86, '', '85369090', NULL, 61, 1, 329, NULL, NULL, '378.7400', 153, '446.9100', 'Exclusive', '50.00', '568.1100', '2.00', NULL, '120.56.64.43', '120.56.64.43', '2025-08-25', '08:12:00 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (317, 2, 61, 'IT020061', 'SPIKE GUARD-4 UNIVERSAL SOCKET SHUTTER WITH IN SWITCH 4M-22569', 86, '', '85369090', NULL, 61, 2, 329, NULL, NULL, '439.0000', 153, '518.0200', 'Exclusive', '50.00', '658.5000', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:17:45 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (318, 2, 62, 'IT020062', '6A 1WAY BED SWITCH WHITE-2527', 86, '', '85365020', NULL, 61, 10, 329, NULL, NULL, '29.0900', 153, '34.3300', 'Exclusive', '50.00', '43.6300', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:19:15 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (319, 2, 63, 'IT020063', '32A FUSE PORCELIAN UNIT PILOT-9322', 86, '', '85361060', NULL, 61, 3, 329, NULL, NULL, '120.5300', 153, '142.2300', 'Exclusive', '50.00', '180.8000', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:20:30 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (320, 2, 64, 'IT020064', '63A-FUSE UNIT PILOT-9322', 86, '', '85361060', NULL, 61, 2, 329, NULL, NULL, '299.7700', 153, '353.7300', 'Exclusive', '50.00', '449.6500', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:21:43 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (321, 2, 65, 'IT020065', '100A-FUSE UNIT PILOT-9333', 86, '', '85361060', NULL, 61, 2, 329, NULL, NULL, '529.4000', 153, '624.6900', 'Exclusive', '50.00', '794.1000', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:22:50 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (322, 2, 66, 'IT020066', 'INSULATION TAPE PVC 1.8CMX6M -1529', 86, '', '85469090', NULL, 61, 200, 329, NULL, NULL, '7.7400', 153, '9.1300', 'Exclusive', '35.00', '10.4500', '300.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:24:41 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (323, 2, 67, 'IT020067', '1.00SQMM PENTA WIRE -96333BK', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '29.75', '1386.1100', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:29:23 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (324, 2, 68, 'IT020068', '1.00SQMM RED PENTA WIRE -96333RD', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:31:07 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (325, 2, 69, 'IT020069', '1.00SQMMBLUE PENTA WIRE -96333BU', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:32:25 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (326, 2, 70, 'IT020070', '1.00SQMMGREEN PENTA WIRE -96333GN', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:33:42 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (327, 2, 71, 'IT020071', '1.00SQMMYELLOWPENTA WIRE -96333YL', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1068.2800', 153, '1260.5700', 'Exclusive', '30.00', '1388.7600', '3.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:35:03 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (328, 2, 72, 'IT020072', '1.5SQMM GREY PENTA WIRE -96333GY', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '1565.1900', 153, '1846.9200', 'Exclusive', '30.00', '2034.7500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:36:55 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (329, 2, 73, 'IT020073', '1.5SQMM BLACK PENTA WIRE -96333BK', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '1565.1900', 153, '1846.9200', 'Exclusive', '30.00', '2034.7500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:37:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (330, 2, 74, 'IT020074', '1.5SQMM RED PENTA WIRE -96333RD', 86, '', '85446090', NULL, 61, 2, 329, NULL, NULL, '1565.1900', 153, '1846.9200', 'Exclusive', '30.00', '2034.7500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:39:48 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (331, 2, 75, 'IT020075', '2.5SQMM RED PENTA WIRE -96335RD', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:41:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (332, 2, 76, 'IT020076', '2.5SQMM BLACKPENTA WIRE -96335BK', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:41:58 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (333, 2, 77, 'IT020077', '2.5SQMM YELLOW PENTA WIRE -96335YL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:43:15 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (334, 2, 78, 'IT020078', '2.5SQMM BLUE PENTA WIRE -96335BL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '2490.2000', 153, '2938.4400', 'Exclusive', '30.00', '3237.2600', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:44:10 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (335, 2, 79, 'IT020079', '4.00SQMM BLUE PENTA WIRE -96336BL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '3760.9600', 153, '4437.9300', 'Exclusive', '30.00', '4889.2500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:45:12 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (336, 2, 80, 'IT020080', '4.00SQMM YELLOW PENTA WIRE -96336YL', 86, '', '85446090', NULL, 61, 1, 329, NULL, NULL, '3760.9600', 153, '4437.9300', 'Exclusive', '30.00', '4889.2500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:46:21 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (337, 2, 81, 'IT020081', 'MCB 6A UNO SERIES-98001', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:47:56 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (338, 2, 82, 'IT020082', 'MCB 10A UNO SERIES-98002', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:48:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (339, 2, 83, 'IT020083', 'MCB 16A UNO SERIES-98003', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:49:57 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (340, 2, 84, 'IT020084', 'MCB 20A UNO SERIES-98004', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:50:49 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (341, 2, 85, 'IT020085', 'MCB 25A UNO SERIES-98005', 86, '', '85362030', NULL, 61, 6, 329, NULL, NULL, '111.7600', 153, '131.8800', 'Exclusive', '50.00', '167.6400', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:51:47 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (342, 2, 86, 'IT020086', 'ISOLATOR 40A UNOSERIES-98055', 86, '', '85353090', NULL, 61, 6, 329, NULL, NULL, '254.9800', 153, '300.8800', 'Exclusive', '50.00', '382.4700', '12.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:54:35 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (343, 2, 87, 'IT020087', 'RCCB 40A 30mA-98207', 86, '', '85362040', NULL, 61, 3, 329, NULL, NULL, '1522.3700', 153, '1796.4000', 'Exclusive', '30.00', '1979.0800', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:56:37 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (344, 2, 88, 'IT020088', 'MCB MINI 4M 25A METAL TOP-98498', 86, '', '85371000', NULL, 61, 3, 329, NULL, NULL, '477.0900', 153, '562.9700', 'Exclusive', '50.00', '715.6300', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '08:58:52 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (345, 2, 89, 'IT020089', 'MCB 40A -98023', 86, '', '85362030', NULL, 61, 3, 329, NULL, NULL, '591.6700', 153, '698.1700', 'Exclusive', '50.00', '887.5000', '6.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:00:15 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (346, 2, 90, 'IT020090', 'MCB 32A -98022', 86, '', '85362030', NULL, 61, 3, 329, NULL, NULL, '393.5100', 153, '464.3400', 'Exclusive', '50.00', '590.2600', '6.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:01:27 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (347, 2, 91, 'IT020091', 'MCB 63A UNO SERIES-98024', 86, '', '85362030', NULL, 61, 1, 329, NULL, NULL, '684.1700', 153, '807.3200', 'Exclusive', '50.00', '1026.2500', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:02:32 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (348, 2, 92, 'IT020092', 'RCCB 40A 30mA-98219', 86, '', '85362040', NULL, 61, 1, 329, NULL, NULL, '2011.6700', 153, '2373.7700', 'Exclusive', '50.00', '3017.5100', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:03:53 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (349, 2, 93, 'IT020093', 'RCCB 63A 30mA-98024', 86, '', '85362040', NULL, 61, 1, 329, NULL, NULL, '2210.7700', 153, '2608.7100', 'Exclusive', '50.00', '3316.1500', '2.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:05:34 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (350, 2, 94, 'IT020094', '1/2  MODULE METAL BOX -21780', 86, '', '85389000', NULL, 61, 10, 329, NULL, NULL, '30.6900', 153, '36.2100', 'Exclusive', '50.00', '46.0400', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:11:28 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (351, 2, 95, 'IT020095', '3  MODULE METAL BOX -21452', 86, '', '85389000', NULL, 61, 10, 329, NULL, NULL, '52.5100', 153, '61.9600', 'Exclusive', '50.00', '78.7700', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:14:02 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (352, 2, 96, 'IT020096', '4  MODULE METAL BOX -21791', 86, '', '85389000', NULL, 61, 10, 329, NULL, NULL, '52.5100', 153, '61.9600', 'Exclusive', '50.00', '78.7700', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:16:11 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (353, 2, 97, 'IT020097', '6  MODULE METAL BOX -21463', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '70.0200', 153, '82.6200', 'Exclusive', '50.00', '105.0300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:17:09 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (354, 2, 98, 'IT020098', '8/9  MODULE METAL BOX -30453', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '90.1600', 153, '106.3900', 'Exclusive', '50.00', '135.2400', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:18:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (355, 2, 99, 'IT020099', '12MODULE METAL BOX -21485', 86, '', '85389000', NULL, 61, 5, 329, NULL, NULL, '111.2600', 153, '131.2900', 'Exclusive', '50.00', '166.8900', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:19:05 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (356, 2, 100, 'IT020100', '16MODULE METAL BOX -21736', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '127.0900', 153, '149.9700', 'Exclusive', '50.00', '190.6300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:20:10 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (357, 2, 101, 'IT020101', '18MODULE METAL BOX -21758', 86, '', '85389000', NULL, 61, 3, 329, NULL, NULL, '141.4700', 153, '166.9300', 'Exclusive', '50.00', '212.2000', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:22:32 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (358, 2, 102, 'IT020102', 'ANGLE HOLDER WHITE-39673', 86, '', '85366110', NULL, 61, 30, 329, NULL, NULL, '27.5400', 153, '32.5000', 'Exclusive', '50.00', '41.3100', '60.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:23:38 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (359, 2, 103, 'IT020103', 'BATTEN HOLDER WHITE-39684', 86, '', '39684', NULL, 61, 10, 329, NULL, NULL, '27.5400', 153, '32.5000', 'Exclusive', '50.00', '41.3100', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '09:24:28 am', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (360, 2, 104, 'IT020104', 'LAMP HOLDER ANGLE WITH METAL RING-39797', 86, '', '85366110', NULL, 61, 60, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '90.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:06:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (361, 2, 105, 'IT020105', 'LAMP HOLDER BATTEN  WITH METAL RING-39800', 86, '', '85366110', NULL, 61, 60, 329, NULL, NULL, '22.3400', 153, '26.3600', 'Exclusive', '50.00', '33.5100', '90.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:07:46 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (362, 2, 106, 'IT020106', '6A CEILING ROSE JUMBO 2PLATE WHITE-39028', 86, '', '94054090', NULL, 61, 20, 329, NULL, NULL, '24.9400', 153, '29.4300', 'Exclusive', '50.00', '37.4100', '40.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:21:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (363, 2, 107, 'IT020107', '6A CEILING ROSE  2PLATE WHITE-39017', 86, '', '94054090', NULL, 61, 20, 329, NULL, NULL, '16.1100', 153, '19.0100', 'Exclusive', '50.00', '24.1600', '40.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:23:04 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (364, 2, 108, 'IT020108', '6AMULTI PLUG ADAPTOR-22841', 86, '', '85365090', NULL, 61, 10, 329, NULL, NULL, '85.2000', 153, '100.5400', 'Exclusive', '50.00', '127.8000', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:24:36 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (365, 2, 109, 'IT020109', '16A DYNA FLEXICRD SOCKET 4M-3381', 86, '', '85366910', NULL, 61, 1, 329, NULL, NULL, '431.2100', 153, '508.8300', 'Exclusive', '50.00', '646.8100', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:26:29 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (366, 2, 110, 'IT020110', 'MCB 16A MINI &quot;C&quot;ZIVA SERIES-68982', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '32.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:28:28 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (367, 2, 111, 'IT020111', 'MCB 20A MINI &quot;C&quot;ZIVA SERIES-68983', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '16.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:30:44 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (368, 2, 112, 'IT020112', 'MCB 25A MINI &quot;C&quot;ZIVA SERIES-68984', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '16.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:32:31 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (369, 2, 113, 'IT020113', 'MCB 32A MINI &quot;C&quot;ZIVA SERIES-68985', 86, '', '85362030', NULL, 61, 10, 329, NULL, NULL, '138.9900', 153, '164.0100', 'Exclusive', '50.00', '208.4900', '16.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:33:48 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (370, 2, 114, 'IT020114', 'WATER HEATER ANCHOR VENICE 3L-', 86, '', '85161000', NULL, 61, 3, 329, NULL, NULL, '2418.0000', 153, '2853.2400', 'Exclusive', '50.00', '3627.0000', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:36:00 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (371, 2, 115, 'IT020115', '9W LED BULB PANSONIC', 86, '', '85395200', NULL, 61, 500, 329, NULL, NULL, '35.0000', 153, '41.3000', 'Exclusive', '50.00', '52.5000', '600.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:38:40 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (372, 2, 116, 'IT020116', '12W LED BULB PANSONIC', 86, '', '85395200', NULL, 61, 90, 329, NULL, NULL, '72.0000', 153, '84.9600', 'Exclusive', '50.00', '108.0000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:41:19 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (373, 2, 117, 'IT020117', '20W LED PATTEN PANASONIC', 86, '', '94051100', NULL, 61, 30, 329, NULL, NULL, '83.0000', 153, '97.9400', 'Exclusive', '50.00', '124.5000', '50.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:43:12 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (374, 2, 118, 'IT020118', '3W LED JUNCTION PANASONIC', 86, '', '94051010', NULL, 61, 50, 329, NULL, NULL, '65.0000', 153, '76.7000', 'Exclusive', '50.00', '97.5000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:44:39 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (375, 2, 119, 'IT020119', '5W LED DOWN LIGHT PANASONIC', 86, '', '94054900', NULL, 61, 50, 329, NULL, NULL, '72.0000', 153, '84.9600', 'Exclusive', '50.00', '108.0000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:46:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (376, 2, 120, 'IT020120', '9W LED EMERGENCY PANSONIC', 86, '', '85395200', NULL, 61, 3, 329, NULL, NULL, '270.0000', 153, '318.6000', 'Exclusive', '50.00', '405.0000', '8.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:47:41 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (377, 2, 121, 'IT020121', '15W LED PC PANEL ROUND PANASONIC', 86, '', '94051100', NULL, 61, 3, 329, NULL, NULL, '380.0000', 153, '448.4000', 'Exclusive', '50.00', '570.0000', '8.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:49:23 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (378, 2, 122, 'IT020122', 'DOOR BELL PARROT-22666', 86, '', '85318000', NULL, 61, 3, 329, NULL, NULL, '167.8100', 153, '198.0200', 'Exclusive', '50.00', '251.7200', '5.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:53:40 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (379, 2, 123, 'IT020123', 'DOOR BELL WIRELESS-22740', 86, '', '85318000', NULL, 61, 1, 329, NULL, NULL, '452.5100', 153, '533.9600', 'Exclusive', '50.00', '678.7600', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:54:52 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (380, 2, 124, 'IT020124', 'DOOR BELL WIRELESS PLUG-22720', 86, '', '85318000', NULL, 61, 1, 329, NULL, NULL, '456.6700', 153, '538.8700', 'Exclusive', '50.00', '685.0000', '1.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:55:59 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (381, 2, 125, 'IT020125', 'PENDENT HOLDER WHITE-6506', 86, '', '85366110', NULL, 61, 50, 329, NULL, NULL, '18.1800', 153, '21.4500', 'Exclusive', '50.00', '27.2700', '60.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:57:10 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (382, 2, 126, 'IT020126', 'ADAPTOR WHITE-6506', 86, '', '85369090', NULL, 61, 10, 329, NULL, NULL, '16.1100', 153, '19.0100', 'Exclusive', '50.00', '24.1600', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:58:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (383, 2, 127, 'IT020127', '0.5W LED NIGHT LAMP', 86, '', '85395200', NULL, 61, 30, 329, NULL, NULL, '30.5000', 153, '35.9900', 'Exclusive', '50.00', '45.7500', '50.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '02:59:50 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (384, 2, 128, 'IT020128', '6A 3 PIN PLUG DELUXEMULTIPLUG WHITE-3155', 86, '', '85365090', NULL, 61, 5, 329, NULL, NULL, '48.3200', 153, '57.0200', 'Exclusive', '50.00', '72.4800', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:01:45 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (385, 2, 129, 'IT020129', '6A CEILING ROSE  39676', 86, '', '85446090', NULL, 61, 5, 329, NULL, NULL, '31.6900', 153, '37.3900', 'Exclusive', '50.00', '47.5400', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:03:12 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (386, 2, 130, 'IT020130', 'LAMP HOLDER ANGLE 39675', 86, '', '85366110', NULL, 61, 5, 329, NULL, NULL, '32.2100', 153, '38.0100', 'Exclusive', '50.00', '48.3100', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:05:02 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (387, 2, 131, 'IT020131', 'LAMP HOLDER BATTEN 39686', 86, '', '85366110', NULL, 61, 5, 329, NULL, NULL, '32.2100', 153, '38.0100', 'Exclusive', '50.00', '48.3100', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:06:28 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (388, 2, 132, 'IT020132', '6A 1WAY SLIM SWITCH', 86, '', '85361010', NULL, 61, 50, 329, NULL, NULL, '13.2000', 153, '15.5800', 'Exclusive', '50.00', '19.8000', '100.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:07:43 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (389, 2, 133, 'IT020133', '6A 3PIN ROUND SOCKET', 86, '', '85366910', NULL, 61, 25, 329, NULL, NULL, '29.5300', 153, '34.8500', 'Exclusive', '50.00', '44.3000', '50.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:09:16 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (390, 2, 134, 'IT020134', '16A, 1Way switch SLIM with indicator-47163', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '47.5400', 153, '56.1000', 'Exclusive', '50.00', '71.3100', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:10:32 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (391, 2, 135, 'IT020135', '6A/16A TWIN SOCKET -47366', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '76.7600', 153, '90.5800', 'Exclusive', '50.00', '115.1400', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:11:39 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (392, 2, 136, 'IT020136', 'FAN REGULATOR TINY-47513', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '141.8300', 153, '167.3600', 'Exclusive', '50.00', '212.7500', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:12:39 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (393, 2, 137, 'IT020137', 'FAN REGULATOR MEGA-47500', 86, '', '84149030', NULL, 61, 5, 329, NULL, NULL, '163.2600', 153, '192.6500', 'Exclusive', '50.00', '244.8900', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:13:42 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (394, 2, 138, 'IT020138', 'INDICATOR GREEN/ RED-47682', 86, '', '85318000', NULL, 61, 5, 329, NULL, NULL, '37.0200', 153, '43.6800', 'Exclusive', '50.00', '55.5300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:15:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (395, 2, 139, 'IT020139', 'BLANK PLATE SINGLE-47684', 86, '', '85389000', NULL, 61, 40, 329, NULL, NULL, '10.9100', 153, '12.8700', 'Exclusive', '50.00', '16.3700', '52.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:16:11 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (396, 2, 140, 'IT020140', '6A 2WAY SLIM SWITCH-47102', 86, '', '85361010', NULL, 61, 4, 329, NULL, NULL, '34.2900', 153, '40.4600', 'Exclusive', '50.00', '51.4400', '8.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:17:17 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (397, 2, 141, 'IT020141', '6A BELL PUSH SLIM-47104', 86, '', '85361010', NULL, 61, 5, 329, NULL, NULL, '36.2400', 153, '42.7600', 'Exclusive', '50.00', '54.3600', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:18:38 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (398, 2, 142, 'IT020142', '32A 1WAY MEGADP SWITCH WITH INDICATOR-47132', 86, '', '85361020', NULL, 61, 5, 329, NULL, NULL, '83.0000', 153, '97.9400', 'Exclusive', '50.00', '124.5000', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:20:20 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (399, 2, 143, 'IT020143', '2 MODULE PLATE INNER FRAME WOODEN BOX-48302', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '38.6100', 153, '45.5600', 'Exclusive', '50.00', '57.9100', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:21:57 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (400, 2, 144, 'IT020144', '3 MODULE PLATE INNER FRAME WOODEN BOX-48303', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '46.8000', 153, '55.2200', 'Exclusive', '50.00', '70.2000', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:22:56 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (401, 2, 145, 'IT020145', '4 MODULE PLATE INNER FRAME WOODEN BOX-48304', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '55.3800', 153, '65.3500', 'Exclusive', '50.00', '83.0700', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:23:47 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (402, 2, 146, 'IT020146', '6 MODULE PLATE INNER FRAME WOODEN BOX-48306', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '74.1000', 153, '87.4400', 'Exclusive', '50.00', '111.1500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:24:38 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (403, 2, 147, 'IT020147', '8 MODULE PLATE HORIZONTAL INNER FRAME WOODEN BOX-48308', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '98.6800', 153, '116.4400', 'Exclusive', '50.00', '148.0200', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:25:46 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (404, 2, 148, 'IT020148', '10 MODULE PLATE HORIZONTAL INNER FRAME WOODEN BOX-48310', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '105.3000', 153, '124.2500', 'Exclusive', '50.00', '157.9500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:26:54 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (405, 2, 149, 'IT020149', '12 MODULE PLATE  INNER FRAME WOODEN BOX-48313', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '120.9000', 153, '142.6600', 'Exclusive', '50.00', '181.3500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:28:02 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (406, 2, 150, 'IT020150', '16 MODULE PLATE  INNER FRAME WOODEN BOX-48316', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '136.5000', 153, '161.0700', 'Exclusive', '50.00', '204.7500', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:29:20 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (407, 2, 151, 'IT020151', '20 MODULE PLATE  INNER FRAME WOODEN BOX-48316', 86, '', '85381090', NULL, 61, 5, 329, NULL, NULL, '165.7500', 153, '195.5900', 'Exclusive', '50.00', '248.6300', '10.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:30:15 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (408, 2, 152, 'IT020152', '12 MODULE PLATE HORIZONTAL INNER FRAME WOODEN BOX-48312', 86, '', '85381090', NULL, 61, 10, 329, NULL, NULL, '116.5000', 153, '137.4700', 'Exclusive', '50.00', '174.7500', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '03:31:19 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (409, 2, 153, 'IT020153', '4&quot; PIPE 15KG (RED)32MM', 87, '', '39174000', NULL, 61, 4, 332, NULL, NULL, '715.0000', 153, '715.0000', 'Inclusive', '30.00', '929.5000', '4.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '04:04:15 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (410, 2, 154, 'IT020154', '2 1/2&quot; MAXFLO PIPE4KGBLUE 75mm', 87, '', '39174000', NULL, 61, 5, 332, NULL, NULL, '420.0000', 153, '420.0000', 'Inclusive', '25.00', '525.0000', '20.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '04:20:29 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (411, 2, 155, 'IT020155', '1&quot; PVC PIPE MAXFLO 15KG -32MM', 87, '', '39174000', NULL, 61, 15, 332, NULL, NULL, '265.0000', 153, '265.0000', 'Inclusive', '30.00', '344.5000', '30.00', NULL, '117.196.32.8', '117.196.32.8', '2025-08-25', '04:23:34 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (412, 2, 156, 'IT020156', '1&quot; PVC ELBOW- 32MM AVON PLAST 10KG', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '8.4200', 153, '8.4200', 'Inclusive', '50.00', '12.6300', '122.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:39:04 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (413, 2, 157, 'IT020157', '1&quot; TEE 32MM PVC-AVON 10KG', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '11.2800', 153, '11.2800', 'Inclusive', '50.00', '16.9200', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:40:37 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (414, 2, 158, 'IT020158', '1&quot; SWR 45DEG BEND 32MM PVC-AVON 10KG', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '11.1300', 153, '11.1300', 'Inclusive', '50.00', '16.7000', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:42:02 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (415, 2, 159, 'IT020159', '1&quot;COUPLER 32MM PVC-AVON 10KG', 86, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '4.9200', 153, '4.9200', 'Inclusive', '50.00', '7.3800', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:43:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (416, 2, 160, 'IT020160', '1&quot; MTA 32MM PVC-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '5.0300', 153, '5.0300', 'Inclusive', '50.00', '7.5400', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:44:19 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (417, 2, 161, 'IT020161', '1&quot; FTA 32MM PVC-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '5.1500', 153, '5.1500', 'Inclusive', '50.00', '7.7300', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:45:16 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (418, 2, 162, 'IT020162', '1&quot; UNION32MM PVC-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '34.1500', 153, '34.1500', 'Inclusive', '30.00', '44.3900', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:46:15 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (419, 2, 163, 'IT020163', '1&quot; PVC BALL VALVE  32MM LONG HANDLE-AVON', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '76.2300', 153, '76.2300', 'Inclusive', '25.00', '95.2900', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:48:03 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (420, 2, 164, 'IT020164', '1&quot;X1/2&quot;PVC BRASS ELBOW', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '61.6300', 153, '61.6300', 'Inclusive', '30.00', '80.1200', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:49:25 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (421, 2, 165, 'IT020165', '1&quot;X1/2&quot;PVC BRASS FTA', 87, '', '39172390', NULL, 61, 5, 333, NULL, NULL, '64.4900', 153, '64.4900', 'Inclusive', '30.00', '83.8400', '10.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:50:53 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (422, 2, 166, 'IT020166', '1&quot; CPVC 90DEG ELBOW', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '20.7300', 153, '20.7300', 'Inclusive', '30.00', '26.9500', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:53:14 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (423, 2, 167, 'IT020167', '1&quot; CPVC 90DEG TEE AVON', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '26.5600', 153, '26.5600', 'Inclusive', '30.00', '34.5300', '30.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:54:13 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (424, 2, 168, 'IT020168', '1&quot;X1/2&quot;CPVC BRASS ELBOW  AVON', 87, '', '39172390', NULL, 61, 50, 333, NULL, NULL, '63.2100', 153, '63.2100', 'Inclusive', '30.00', '82.1700', '75.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:55:24 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (425, 2, 169, 'IT020169', '1&quot;X1/2&quot;CPVC BRASS TEE  AVON', 87, '', '39172390', NULL, 61, 50, 333, NULL, NULL, '71.5900', 153, '71.5900', 'Inclusive', '30.00', '93.0700', '70.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:56:38 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (426, 2, 170, 'IT020170', '1&quot; MTA  CPVC (PLASTIC)-AVON 32MM', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '16.8000', 153, '16.8000', 'Inclusive', '30.00', '21.8400', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:58:32 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (427, 2, 171, 'IT020171', '1&quot; FTA  CPVC (PLASTIC)-AVON 32MM', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '23.1300', 153, '23.1300', 'Inclusive', '30.00', '30.0700', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '04:59:36 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (428, 2, 172, 'IT020172', '1&quot;CPVC TANK NIPPLE', 87, '', '39172390', NULL, 61, 40, 333, NULL, NULL, '50.2800', 153, '50.2800', 'Inclusive', '30.00', '65.3600', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:01:14 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (429, 2, 173, 'IT020173', '1&quot; CPVC UNION', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '61.8300', 153, '61.8300', 'Inclusive', '30.00', '80.3800', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:02:40 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (430, 2, 174, 'IT020174', '1&quot; CPVC CONCEALED VALVE SHORT', 87, '', '39172390', NULL, 61, 10, 333, NULL, NULL, '854.9600', 153, '854.9600', 'Inclusive', '30.00', '1111.4500', '18.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:04:53 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (431, 2, 175, 'IT020175', '1&quot;X1/2&quot;CPVC BRASS FTA', 87, '', '39172390', NULL, 61, 25, 333, NULL, NULL, '59.1700', 153, '59.1700', 'Inclusive', '30.00', '76.9200', '50.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:06:33 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (432, 2, 176, 'IT020176', '4&quot;PVC ELBOW 110MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '68.0000', 153, '68.0000', 'Inclusive', '30.00', '88.4000', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:09:48 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (433, 2, 177, 'IT020177', '4&quot;PVC TEE 110MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '79.5800', 153, '79.5800', 'Inclusive', '30.00', '103.4500', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:11:05 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (434, 2, 178, 'IT020178', '4&quot;PVC 45DEG BEND 110MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '56.0500', 153, '56.0500', 'Inclusive', '30.00', '72.8600', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:12:49 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (435, 2, 179, 'IT020179', '4&quot;AIR VENT COWL', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '14.2200', 153, '14.2200', 'Inclusive', '30.00', '18.4900', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:13:56 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (436, 2, 180, 'IT020180', '2 1/2&quot; PVC DOOR BEND', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '52.7100', 153, '52.7100', 'Inclusive', '30.00', '68.5200', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:15:04 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (437, 2, 181, 'IT020181', '2 1/2&quot; PVC SINGLE  PLAIN TEE', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '48.2100', 153, '48.2100', 'Inclusive', '30.00', '62.6700', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:16:22 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (438, 2, 182, 'IT020182', '2 1/2&quot; PVC SINGLE  DOOR TEE', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '57.6700', 153, '57.6700', 'Inclusive', '30.00', '74.9700', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:17:13 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (439, 2, 183, 'IT020183', '2 1/2&quot;PVC 45DEG BEND 75MM', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '29.6100', 153, '29.6100', 'Inclusive', '30.00', '38.4900', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:19:00 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (440, 2, 184, 'IT020184', '2 1/2&quot;PVC ELBOW 75MM 4KG', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '30.8700', 153, '30.8700', 'Inclusive', '30.00', '40.1300', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:20:06 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (441, 2, 185, 'IT020185', '2 1/2&quot;AIR VENT COWL', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '8.7700', 153, '8.7700', 'Inclusive', '30.00', '11.4000', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:21:21 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (442, 2, 186, 'IT020186', '1&quot;X1/2&quot; PVC BRASS FTA', 87, '', '39172390', NULL, 61, 30, 333, NULL, NULL, '64.5000', 153, '64.5000', 'Inclusive', '30.00', '83.8500', '40.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:23:34 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (443, 2, 187, 'IT020187', '750 LTR WATER TANK 3LAYER 10YR GURANTED', 87, '', '84807900', NULL, 61, 1, 333, NULL, NULL, '3216.0000', 153, '3216.0000', 'Inclusive', '28.00', '4116.4800', '1.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:36:14 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (444, 2, 188, 'IT020188', '1.25&quot; COLUMN PIPES', 87, '', '39172390', NULL, 61, 20, 333, NULL, NULL, '235.0000', 153, '235.0000', 'Inclusive', '40.00', '329.0000', '25.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:38:08 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');
INSERT INTO `db_items` (`id`, `store_id`, `count_id`, `item_code`, `item_name`, `category_id`, `sku`, `hsn`, `sac`, `unit_id`, `alert_qty`, `brand_id`, `lot_number`, `expire_date`, `price`, `tax_id`, `purchase_price`, `tax_type`, `profit_margin`, `sales_price`, `stock`, `item_image`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `discount_type`, `discount`, `service_bit`, `seller_points`, `custom_barcode`, `description`, `item_group`, `parent_id`, `variant_id`, `child_bit`, `mrp`) VALUES (445, 2, 189, 'IT020189', '1&quot; CPVC PIPE AVON SDR 13.5', 87, '', '39172390', NULL, 61, 100, 333, NULL, NULL, '356.0000', 153, '356.0000', 'Inclusive', '30.00', '462.8000', '30.00', NULL, '120.56.128.82', '120.56.128.82', '2025-08-25', '05:41:33 pm', 'user_450343', NULL, 1, 'Percentage', '0.00', 0, '0.00', '', '', 'Single', NULL, NULL, 0, '0.0000');


#
# TABLE STRUCTURE FOR: db_languages
#

DROP TABLE IF EXISTS `db_languages`;

CREATE TABLE `db_languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (1, 'English', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (2, 'Russian', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (3, 'Spanish', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (4, 'Arabic', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (5, 'Bangla', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (6, 'French', 1);


#
# TABLE STRUCTURE FOR: db_package
#

DROP TABLE IF EXISTS `db_package`;

CREATE TABLE `db_package` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `package_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `monthly_price` double(20,2) DEFAULT NULL,
  `annual_price` double(20,2) DEFAULT NULL,
  `trial_days` int DEFAULT NULL,
  `max_users` int DEFAULT NULL,
  `max_items` int DEFAULT NULL,
  `max_invoices` int DEFAULT NULL,
  `max_warehouses` int DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `plan_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_package_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_package` (`id`, `store_id`, `package_type`, `package_code`, `package_name`, `description`, `monthly_price`, `annual_price`, `trial_days`, `max_users`, `max_items`, `max_invoices`, `max_warehouses`, `expire_date`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `status`, `plan_type`) VALUES (1, 1, 'Free', NULL, 'Free', 'Test description', '0.00', '0.00', 10, 2, 20, 20, 2, '2021-01-14', '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-01-13', '06:37:21 pm', 'admin', 1, NULL);
INSERT INTO `db_package` (`id`, `store_id`, `package_type`, `package_code`, `package_name`, `description`, `monthly_price`, `annual_price`, `trial_days`, `max_users`, `max_items`, `max_invoices`, `max_warehouses`, `expire_date`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `status`, `plan_type`) VALUES (2, 1, 'Paid', NULL, 'Regular', 'Test description', '250.00', '2000.00', 15, 20, 200, 200, 20, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-01-13', '06:39:23 pm', 'admin', 1, NULL);
INSERT INTO `db_package` (`id`, `store_id`, `package_type`, `package_code`, `package_name`, `description`, `monthly_price`, `annual_price`, `trial_days`, `max_users`, `max_items`, `max_invoices`, `max_warehouses`, `expire_date`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `status`, `plan_type`) VALUES (3, 1, 'Paid', NULL, 'Ultimate', 'Description', '500.00', '5000.00', 15, -1, -1, -1, -1, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-01-24', '12:35:30 pm', 'admin', 1, NULL);


#
# TABLE STRUCTURE FOR: db_paymenttypes
#

DROP TABLE IF EXISTS `db_paymenttypes`;

CREATE TABLE `db_paymenttypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paymenttypes_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (36, 2, 'CASH', 1);


#
# TABLE STRUCTURE FOR: db_paypal
#

DROP TABLE IF EXISTS `db_paypal`;

CREATE TABLE `db_paypal` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paypal_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_paypal` (`id`, `store_id`, `sandbox`, `email`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_paypalpaylog
#

DROP TABLE IF EXISTS `db_paypalpaylog`;

CREATE TABLE `db_paypalpaylog` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` int NOT NULL,
  `txn_id` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_gross` float(10,2) NOT NULL,
  `currency_code` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payer_email` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_permissions
#

DROP TABLE IF EXISTS `db_permissions`;

CREATE TABLE `db_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `permissions` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_permissions_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4414, 1, 17, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4415, 1, 17, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4416, 1, 17, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4417, 1, 17, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4418, 1, 17, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4419, 1, 17, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4420, 1, 17, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4421, 1, 17, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4422, 1, 17, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4423, 1, 17, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4424, 1, 17, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4425, 1, 17, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4426, 1, 17, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4427, 1, 17, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4428, 1, 17, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4429, 1, 17, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4430, 1, 17, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4431, 1, 17, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4432, 1, 17, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4433, 1, 17, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4434, 1, 17, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4435, 1, 17, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4436, 1, 17, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4437, 1, 17, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4438, 1, 17, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4439, 1, 17, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4440, 1, 17, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4441, 1, 17, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4442, 1, 17, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4443, 1, 17, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4444, 1, 17, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4445, 1, 17, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4446, 1, 17, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4447, 1, 17, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4448, 1, 17, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4449, 1, 17, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4450, 1, 17, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4451, 1, 17, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4452, 1, 17, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4453, 1, 17, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4454, 1, 17, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4455, 1, 17, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4456, 1, 17, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4457, 1, 17, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4458, 1, 17, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4459, 1, 17, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4460, 1, 17, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4461, 1, 17, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4462, 1, 17, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4463, 1, 17, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4464, 1, 17, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4465, 1, 17, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4466, 1, 17, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4467, 1, 17, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4468, 1, 17, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4469, 1, 17, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4470, 1, 17, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4471, 1, 17, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4472, 1, 17, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4473, 1, 17, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4474, 1, 17, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4475, 1, 17, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4476, 1, 17, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4477, 1, 17, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4478, 1, 17, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4479, 1, 17, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4480, 1, 17, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4481, 1, 17, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4482, 1, 17, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4483, 1, 17, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4484, 1, 17, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4485, 1, 17, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4486, 1, 17, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4487, 1, 17, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4488, 1, 17, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4489, 1, 17, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4490, 1, 17, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4491, 1, 17, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4492, 1, 18, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4493, 1, 18, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4494, 1, 18, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4495, 1, 18, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4496, 1, 18, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4497, 1, 18, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4498, 1, 18, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4499, 1, 18, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4500, 1, 18, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4501, 1, 18, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4502, 1, 18, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4503, 1, 18, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4504, 1, 18, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4505, 1, 18, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4506, 1, 18, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4507, 1, 18, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4508, 1, 18, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4509, 1, 18, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4510, 1, 18, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4511, 1, 18, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4512, 1, 18, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4513, 1, 18, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4514, 1, 18, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4515, 1, 18, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4516, 1, 18, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4517, 1, 18, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4518, 1, 18, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4519, 1, 18, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4520, 1, 18, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4521, 1, 18, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4522, 1, 18, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4523, 1, 18, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4524, 1, 18, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4525, 1, 18, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4526, 1, 18, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4527, 1, 18, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4528, 1, 18, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4529, 1, 18, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4530, 1, 18, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4531, 1, 18, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4532, 1, 18, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4533, 1, 18, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4534, 1, 18, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4535, 1, 18, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4536, 1, 18, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4537, 1, 18, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4538, 1, 18, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4539, 1, 18, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4540, 1, 18, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4541, 1, 18, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4542, 1, 18, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4543, 1, 18, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4544, 1, 18, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4545, 1, 18, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4546, 1, 18, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4547, 1, 18, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4548, 1, 18, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4549, 1, 18, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4550, 1, 18, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4551, 1, 18, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4552, 1, 18, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4553, 1, 18, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4554, 1, 18, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4555, 1, 18, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4556, 1, 18, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4557, 1, 18, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4558, 1, 18, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4559, 1, 18, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4560, 1, 18, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4561, 1, 18, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4562, 1, 18, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4563, 1, 18, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4564, 1, 18, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4565, 1, 18, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4566, 1, 18, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4567, 1, 18, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4568, 1, 18, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4569, 1, 18, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4570, 1, 18, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4571, 1, 18, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4572, 1, 18, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4573, 1, 18, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4574, 1, 18, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4575, 1, 18, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4576, 1, 18, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4577, 1, 18, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4578, 1, 18, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4579, 1, 18, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4580, 1, 18, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5818, 1, 2, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5819, 1, 2, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5820, 1, 2, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5821, 1, 2, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5822, 1, 2, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5823, 1, 2, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5824, 1, 2, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5825, 1, 2, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5826, 1, 2, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5827, 1, 2, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5828, 1, 2, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5829, 1, 2, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5830, 1, 2, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5831, 1, 2, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5832, 1, 2, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5833, 1, 2, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5834, 1, 2, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5835, 1, 2, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5836, 1, 2, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5837, 1, 2, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5838, 1, 2, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5839, 1, 2, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5840, 1, 2, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5841, 1, 2, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5842, 1, 2, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5843, 1, 2, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5844, 1, 2, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5845, 1, 2, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5846, 1, 2, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5847, 1, 2, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5848, 1, 2, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5849, 1, 2, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5850, 1, 2, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5851, 1, 2, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5852, 1, 2, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5853, 1, 2, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5854, 1, 2, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5855, 1, 2, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5856, 1, 2, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5857, 1, 2, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5858, 1, 2, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5859, 1, 2, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5860, 1, 2, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5861, 1, 2, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5862, 1, 2, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5863, 1, 2, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5864, 1, 2, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5865, 1, 2, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5866, 1, 2, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5867, 1, 2, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5868, 1, 2, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5869, 1, 2, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5870, 1, 2, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5871, 1, 2, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5872, 1, 2, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5873, 1, 2, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5874, 1, 2, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5875, 1, 2, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5876, 1, 2, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5877, 1, 2, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5878, 1, 2, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5879, 1, 2, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5880, 1, 2, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5881, 1, 2, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5882, 1, 2, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5883, 1, 2, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5884, 1, 2, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5885, 1, 2, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5886, 1, 2, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5887, 1, 2, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5888, 1, 2, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5889, 1, 2, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5890, 1, 2, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5891, 1, 2, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5892, 1, 2, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5893, 1, 2, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5894, 1, 2, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5895, 1, 2, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5896, 1, 2, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5897, 1, 2, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5898, 1, 2, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5899, 1, 2, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5900, 1, 2, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5901, 1, 2, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5902, 1, 2, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5903, 1, 2, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5904, 1, 2, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5905, 1, 2, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5906, 1, 2, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5907, 1, 2, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5908, 1, 2, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5909, 1, 2, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5910, 1, 2, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5911, 1, 2, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5912, 1, 2, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5913, 1, 2, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5914, 1, 2, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5915, 1, 2, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5916, 1, 2, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5917, 1, 2, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5918, 1, 2, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5919, 1, 2, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5920, 1, 2, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5921, 1, 2, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5922, 1, 2, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5923, 1, 2, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5924, 1, 2, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5925, 1, 2, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5926, 1, 2, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5927, 1, 2, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5928, 1, 2, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5929, 1, 2, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5930, 1, 2, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5931, 1, 2, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5932, 1, 2, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5933, 1, 2, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5934, 1, 2, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5935, 1, 2, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5936, 1, 2, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5937, 1, 2, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5938, 1, 2, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5939, 1, 2, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5940, 1, 2, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5941, 1, 2, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5942, 1, 2, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5943, 1, 2, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5944, 1, 2, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5945, 1, 2, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5946, 1, 2, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5947, 1, 2, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5948, 1, 2, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5949, 1, 2, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5950, 1, 2, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5951, 1, 2, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5952, 1, 2, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5953, 1, 2, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5954, 1, 2, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5955, 1, 2, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5956, 1, 2, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5957, 1, 2, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5958, 1, 2, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5959, 1, 2, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5960, 1, 2, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5961, 1, 2, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5962, 1, 2, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5963, 1, 2, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5964, 1, 2, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5965, 1, 2, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5966, 1, 2, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5967, 1, 2, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5968, 1, 2, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5969, 1, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5970, 1, 2, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5971, 1, 2, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5972, 1, 2, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5973, 1, 2, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5974, 1, 2, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5975, 1, 2, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5976, 1, 2, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5977, 1, 2, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5978, 1, 2, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5999, 2, 28, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6000, 2, 28, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6001, 2, 28, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6002, 2, 28, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6011, 2, 29, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6012, 2, 29, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6013, 2, 29, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6014, 2, 29, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6015, 2, 29, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6016, 2, 29, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6017, 2, 29, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6018, 2, 29, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6019, 2, 29, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6020, 2, 29, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6021, 2, 29, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6022, 2, 29, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6023, 2, 29, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6024, 2, 29, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6025, 2, 29, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6026, 2, 29, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6027, 2, 29, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6028, 2, 29, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6029, 2, 29, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6030, 2, 29, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6031, 2, 29, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6032, 2, 29, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6033, 2, 29, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6034, 2, 29, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6035, 2, 29, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6036, 2, 29, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6037, 2, 29, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6038, 2, 29, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6039, 2, 29, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6040, 2, 29, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6041, 2, 29, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6042, 2, 29, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6043, 2, 29, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6044, 2, 29, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6045, 2, 29, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6046, 2, 29, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6047, 2, 29, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6048, 2, 29, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6049, 2, 29, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6050, 2, 29, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6051, 2, 29, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6052, 2, 29, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6053, 2, 29, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6054, 2, 29, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6055, 2, 29, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6056, 2, 29, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6057, 2, 29, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6058, 2, 29, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6059, 2, 29, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6060, 2, 29, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6061, 2, 29, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6062, 2, 29, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6063, 2, 29, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6064, 2, 29, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6065, 2, 29, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6066, 2, 29, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6067, 2, 29, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6068, 2, 29, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6069, 2, 29, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6070, 2, 29, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6071, 2, 29, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6072, 2, 29, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6073, 2, 29, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6074, 2, 29, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6075, 2, 29, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6076, 2, 29, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6077, 2, 29, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6078, 2, 29, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6079, 2, 29, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6080, 2, 29, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6081, 2, 29, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6082, 2, 29, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6083, 2, 29, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6084, 2, 29, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6085, 2, 29, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6086, 2, 29, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6087, 2, 29, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6088, 2, 29, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6089, 2, 29, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6090, 2, 29, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6091, 2, 29, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6092, 2, 29, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6093, 2, 29, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6094, 2, 29, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6095, 2, 29, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6096, 2, 29, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6097, 2, 29, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6098, 2, 29, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6099, 2, 29, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6100, 2, 29, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6101, 2, 29, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6102, 2, 29, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6103, 2, 29, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6104, 2, 29, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6105, 2, 29, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6106, 2, 29, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6107, 2, 29, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6108, 2, 29, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6109, 2, 29, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6110, 2, 29, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6111, 2, 29, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6112, 2, 29, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6113, 2, 29, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6114, 2, 29, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6115, 2, 29, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6116, 2, 29, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6117, 2, 29, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6118, 2, 29, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6119, 2, 29, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6120, 2, 29, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6121, 2, 29, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6122, 2, 29, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6123, 2, 29, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6124, 2, 29, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6125, 2, 29, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6126, 2, 29, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6127, 2, 29, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6128, 2, 29, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6129, 2, 29, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6130, 2, 29, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6131, 2, 29, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6132, 2, 29, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6133, 2, 29, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6134, 2, 29, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6135, 2, 29, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6136, 2, 29, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6137, 2, 29, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6138, 2, 29, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6139, 2, 29, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6140, 2, 29, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6141, 2, 29, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6142, 2, 29, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6143, 2, 29, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6144, 2, 29, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6145, 2, 29, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6146, 2, 29, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6147, 2, 29, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6148, 2, 29, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6149, 2, 29, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6150, 2, 29, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6151, 2, 29, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6152, 2, 29, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6153, 2, 29, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6154, 2, 29, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6155, 2, 29, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6156, 2, 29, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6157, 2, 29, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6158, 2, 29, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6159, 2, 29, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6160, 2, 29, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6161, 2, 29, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6162, 2, 29, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6163, 2, 29, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6164, 2, 29, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6165, 2, 29, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6166, 2, 29, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6167, 2, 29, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6168, 2, 29, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6169, 2, 29, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6170, 2, 29, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6179, 1, 2, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6180, 1, 2, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6181, 1, 2, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6182, 1, 2, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6183, 1, 2, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6184, 1, 2, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6185, 1, 2, 'discountCouponAdd');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6186, 1, 2, 'discountCouponEdit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6187, 1, 2, 'discountCouponDelete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6188, 1, 2, 'discountCouponView');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6189, 2, 2, 'sales_gst_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6190, 2, 2, 'purchase_gst_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6191, 2, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6192, 1, 2, 'customerCouponAdd');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6193, 1, 2, 'customerCouponEdit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6194, 1, 2, 'customerCouponDelete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6195, 1, 2, 'customerCouponView');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6196, 1, 2, 'return_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6197, 1, 2, 'help_link');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6198, 2, 31, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6199, 2, 31, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6200, 2, 31, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6201, 2, 31, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6202, 2, 31, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6203, 2, 31, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6204, 2, 31, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6205, 2, 31, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6206, 2, 31, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6207, 2, 31, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6208, 2, 31, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6209, 2, 31, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6210, 2, 31, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6211, 2, 31, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6212, 2, 31, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6213, 2, 31, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6214, 2, 31, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6215, 2, 2, 'recent_sales_invoice_list');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6216, 1, 2, 'stock_transfer_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6217, 1, 2, 'pos');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6218, 1, 2, 'sales_summary_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6219, 1, 2, 'sales_return_payments');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6228, 1, 2, 'sales_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6229, 1, 2, 'sales_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6230, 1, 2, 'sales_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6231, 1, 2, 'sales_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6248, 1, 1, 'customer_credit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6249, 1, 1, 'customer_debit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6250, 1, 1, 'customer_accounts_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6251, 1, 2, 'customer_credit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6252, 1, 2, 'customer_debit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6253, 1, 2, 'customer_accounts_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6254, 1, 1, 'customer_financial_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6255, 1, 2, 'customer_financial_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6256, 2, 1, 'customer_financial_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6257, 2, 2, 'customer_financial_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6258, 2, 31, 'customer_financial_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6260, 1, 31, 'customer_financial_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6261, 1, 1, 'customer_accounts_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6262, 1, 2, 'customer_accounts_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6263, 2, 1, 'customer_accounts_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6264, 2, 2, 'customer_accounts_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6286, 1, 1, 'whatsapp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6287, 1, 1, 'whatsapp_send');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6288, 1, 1, 'whatsapp_templates_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6289, 1, 1, 'whatsapp_templates_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6290, 1, 1, 'whatsapp_logs_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6291, 2, 1, 'whatsapp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6292, 2, 1, 'whatsapp_send');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6293, 2, 1, 'whatsapp_templates_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6294, 2, 1, 'whatsapp_templates_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6295, 2, 1, 'whatsapp_logs_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6296, 2, 1, 'whatsapp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6297, 2, 1, 'whatsapp_send');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6298, 2, 1, 'whatsapp_templates_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6299, 2, 1, 'whatsapp_templates_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6300, 2, 1, 'whatsapp_logs_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6301, 2, 1, 'whatsapp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6302, 2, 1, 'whatsapp_send');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6303, 2, 1, 'whatsapp_templates_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6304, 2, 1, 'whatsapp_templates_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6305, 2, 1, 'whatsapp_logs_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6306, 2, 2, 'whatsapp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6307, 2, 2, 'whatsapp_send');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6308, 2, 2, 'whatsapp_templates_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6309, 2, 2, 'whatsapp_templates_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6310, 2, 2, 'whatsapp_logs_view');


#
# TABLE STRUCTURE FOR: db_purchase
#

DROP TABLE IF EXISTS `db_purchase`;

CREATE TABLE `db_purchase` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Purchase Code',
  `purchase_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `purchase_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'Purchase return raised',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchase_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchase_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (1, 2, 2, 1, 'PU0001', '', '2022-08-09', 'Received', 1, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2022-08-09', '01:59:42 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (2, 2, 2, 2, 'PU0002', '', '2022-08-10', 'Received', 1, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '50.0000', NULL, '50.0000', '', 'Paid', '50.0000', '2022-08-10', '09:25:01 am', 'Chris', '5.21.237.233', '5.21.237.233', NULL, 1, NULL);
INSERT INTO `db_purchase` (`id`, `store_id`, `warehouse_id`, `count_id`, `purchase_code`, `reference_no`, `purchase_date`, `purchase_status`, `supplier_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `purchase_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `status`, `return_bit`) VALUES (3, 2, 2, 3, 'PU0003', 'a', '2025-08-24', 'Received', 1, NULL, NULL, NULL, NULL, 'in_percentage', NULL, '1.5000', '0.5000', '2.0000', '', 'Unpaid', '0.0000', '2025-08-24', '06:16:51 pm', 'user_599174', '::1', 'UZRS', NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_purchaseitems
#

DROP TABLE IF EXISTS `db_purchaseitems`;

CREATE TABLE `db_purchaseitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `purchase_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `purchase_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitems_ibfk_1` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (201, 2, 1, 'Received', 2, '25.00', '2.0000', 'Inclusive', 149, '2.3800', 'Percentage', '0.0000', '0.0000', '2.0000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (202, 2, 2, 'Received', 3, '20.00', '2.5000', 'Inclusive', 149, '2.3800', 'Percentage', '0.0000', '0.0000', '2.5000', '50.0000', NULL, NULL, 1, '');
INSERT INTO `db_purchaseitems` (`id`, `store_id`, `purchase_id`, `purchase_status`, `item_id`, `purchase_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `profit_margin_per`, `unit_sales_price`, `status`, `description`) VALUES (203, 2, 3, 'Received', 1, '1.00', '1.5000', 'Inclusive', 149, '0.0700', 'Percentage', '0.0000', '0.0000', '1.5000', '1.5000', NULL, NULL, 1, '');


#
# TABLE STRUCTURE FOR: db_purchaseitemsreturn
#

DROP TABLE IF EXISTS `db_purchaseitemsreturn`;

CREATE TABLE `db_purchaseitemsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchaseitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepayments
#

DROP TABLE IF EXISTS `db_purchasepayments`;

CREATE TABLE `db_purchasepayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (108, 1, 'PP0001', 2, 1, '2022-08-09', 'CASH', '50.0000', '', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:59:42', '2022-08-09', 'Chris', 1, NULL, 1, NULL);
INSERT INTO `db_purchasepayments` (`id`, `count_id`, `payment_code`, `store_id`, `purchase_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `supplier_id`, `short_code`) VALUES (109, 2, 'PP0002', 2, 2, '2022-08-10', 'CASH', '50.0000', '', '5.21.237.233', '5.21.237.233', '09:25:01', '2022-08-10', 'Chris', 1, NULL, 1, NULL);


#
# TABLE STRUCTURE FOR: db_purchasepaymentsreturn
#

DROP TABLE IF EXISTS `db_purchasepaymentsreturn`;

CREATE TABLE `db_purchasepaymentsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasereturn
#

DROP TABLE IF EXISTS `db_purchasereturn`;

CREATE TABLE `db_purchasereturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Purchase Return Code',
  `warehouse_id` int DEFAULT NULL,
  `purchase_id` int DEFAULT NULL,
  `return_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchasereturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasereturn_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotation
#

DROP TABLE IF EXISTS `db_quotation`;

CREATE TABLE `db_quotation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create quotation Code',
  `quotation_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `quotation_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `quotation_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'quotation return raised',
  `customer_previous_due` double(20,4) DEFAULT NULL,
  `customer_total_due` double(20,4) DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_quotation_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotationitems
#

DROP TABLE IF EXISTS `db_quotationitems`;

CREATE TABLE `db_quotationitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `quotation_id` int DEFAULT NULL,
  `quotation_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quotation_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `seller_points` double(20,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `quotation_id` (`quotation_id`),
  CONSTRAINT `db_quotationitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotationitems_ibfk_2` FOREIGN KEY (`quotation_id`) REFERENCES `db_quotation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=288 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_roles
#

DROP TABLE IF EXISTS `db_roles`;

CREATE TABLE `db_roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `role_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_roles_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (1, 1, 'Admin', 'All Rights Permitted.', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (2, 1, 'Store Admin', 'Note: Apply this role for New Store Admin. ', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (31, 2, 'Cashier', '', 1);


#
# TABLE STRUCTURE FOR: db_sales
#

DROP TABLE IF EXISTS `db_sales`;

CREATE TABLE `db_sales` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `sales_type_id` int DEFAULT '1',
  `init_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count_id` decimal(20,0) DEFAULT NULL COMMENT 'Use to create Sales Code',
  `sales_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'sales return raised',
  `customer_previous_due` double(20,2) DEFAULT NULL,
  `customer_total_due` double(20,2) DEFAULT NULL,
  `quotation_id` int DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `coupon_amt` double(20,2) DEFAULT '0.00',
  `invoice_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `idx_sales_type_id` (`sales_type_id`),
  CONSTRAINT `db_sales_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_4` FOREIGN KEY (`coupon_id`) REFERENCES `db_customer_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (1, 2, 2, 1, 'SL/2021/02/', '1', 'SL/2021/02/1', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.60', '0.40', '6.0000', '', 'Paid', '6.0000', '2022-08-09', '12:04:50 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (2, 2, 2, 1, 'SL/2021/02/', '2', 'SL/2021/02/2', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.60', '0.40', '6.0000', '', 'Partial', '5.4000', '2022-08-09', '12:05:49 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (3, 2, 2, 1, 'SL/2021/02/', '3', 'SL/2021/02/3', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:06:55 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (4, 2, 2, 1, 'SL/2021/02/', '4', 'SL/2021/02/4', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:07:13 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (5, 2, 2, 1, 'SL/2021/02/', '5', 'SL/2021/02/5', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:10:57 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (6, 2, 2, 1, 'SL/2021/02/', '6', 'SL/2021/02/6', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:12:02 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (7, 2, 2, 1, 'SL/2021/02/', '7', 'SL/2021/02/7', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:14:12 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (8, 2, 2, 1, 'SL/2021/02/', '8', 'SL/2021/02/8', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:16:01 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (9, 2, 2, 1, 'SL/2021/02/', '9', 'SL/2021/02/9', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:16:41 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (10, 2, 2, 1, 'SL/2021/02/', '10', 'SL/2021/02/10', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:17:33 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (11, 2, 2, 1, 'SL/2021/02/', '11', 'SL/2021/02/11', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:18:50 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (12, 2, 2, 1, 'SL/2021/02/', '12', 'SL/2021/02/12', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:23:57 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (13, 2, 2, 1, 'SL/2021/02/', '13', 'SL/2021/02/13', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:34:13 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (14, 2, 2, 1, 'SL/2021/02/', '14', 'SL/2021/02/14', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:37:35 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (15, 2, 2, 1, 'SL/2021/02/', '15', 'SL/2021/02/15', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:38:50 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (16, 2, 2, 1, 'SL/2021/02/', '16', 'SL/2021/02/16', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:49:10 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (17, 2, 2, 1, 'SL/2021/02/', '17', 'SL/2021/02/17', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:51:00 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (18, 2, 2, 1, 'SL/2021/02/', '18', 'SL/2021/02/18', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:51:40 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (19, 2, 2, 1, 'SL/2021/02/', '19', 'SL/2021/02/19', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:56:20 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (20, 2, 2, 1, 'SL/2021/02/', '20', 'SL/2021/02/20', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:56:37 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (21, 2, 2, 1, 'SL/2021/02/', '21', 'SL/2021/02/21', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:57:46 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (22, 2, 2, 1, 'SL/2021/02/', '22', 'SL/2021/02/22', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:58:07 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (23, 2, 2, 1, 'SL/2021/02/', '23', 'SL/2021/02/23', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '12:59:18 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (24, 2, 2, 1, 'SL/2021/02/', '24', 'SL/2021/02/24', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:06:31 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (25, 2, 2, 1, 'SL/2021/02/', '25', 'SL/2021/02/25', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:10:17 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (26, 2, 2, 1, 'SL/2021/02/', '26', 'SL/2021/02/26', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:16:45 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (27, 2, 2, 1, 'SL/2021/02/', '27', 'SL/2021/02/27', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:18:51 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (28, 2, 2, 1, 'SL/2021/02/', '28', 'SL/2021/02/28', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:24:13 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (29, 2, 2, 1, 'SL/2021/02/', '29', 'SL/2021/02/29', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:24:37 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (30, 2, 2, 1, 'SL/2021/02/', '30', 'SL/2021/02/30', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:25:33 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (31, 2, 2, 1, 'SL/2021/02/', '31', 'SL/2021/02/31', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:27:11 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (32, 2, 2, 1, 'SL22', '32', 'SL2232', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:29:55 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (33, 2, 2, 1, 'SL22222', '33', 'SL2222233', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:32:12 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (34, 2, 2, 1, 'SL22222', '34', 'SL2222234', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:37:06 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (35, 2, 2, 1, 'SL', '35', 'SL35', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:37:32 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (36, 2, 2, 1, 'SL', '36', 'SL36', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.70', '0.30', '7.0000', '', 'Paid', '7.0000', '2022-08-09', '01:39:26 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (37, 2, 2, 1, 'SL', '37', 'SL37', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:41:51 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (38, 2, 2, 1, 'SL', '38', 'SL38', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:42:13 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (39, 2, 2, 1, 'SL', '39', 'SL39', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:44:36 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (40, 2, 2, 1, 'SL', '40', 'SL40', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:46:04 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (41, 2, 2, 1, 'SL', '41', 'SL41', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:46:45 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (42, 2, 2, 1, 'SL', '42', 'SL42', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:49:14 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (43, 2, 2, 1, 'SL', '43', 'SL43', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:49:54 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (44, 2, 2, 1, 'SL', '44', 'SL44', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.70', '0.30', '7.0000', '', 'Paid', '7.0000', '2022-08-09', '01:51:01 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (45, 2, 2, 1, 'SL', '45', 'SL45', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:52:46 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (46, 2, 2, 1, 'SL', '46', 'SL46', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:53:20 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (47, 2, 2, 1, 'SL', '47', 'SL47', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '01:53:41 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (48, 2, 2, 1, 'SL', '48', 'SL48', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.70', '0.30', '7.0000', '', 'Paid', '7.0000', '2022-08-09', '01:54:18 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (49, 2, 2, 1, 'SL', '49', 'SL49', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '02:26:10 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (50, 2, 2, 1, 'SL', '50', 'SL50', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.70', '0.30', '7.0000', '', 'Paid', '7.0000', '2022-08-09', '02:26:25 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (51, 2, 2, 1, 'SL', '51', 'SL51', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '02:30:27 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (52, 2, 2, 1, 'SL', '52', 'SL52', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '02:32:04 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (53, 2, 2, 1, 'SL', '53', 'SL53', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '02:32:25 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (54, 2, 2, 1, 'SL', '54', 'SL54', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '02:32:48 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (55, 2, 2, 1, 'SL', '55', 'SL55', NULL, '2022-08-09', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-09', '02:33:35 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (56, 2, 2, 1, 'SL', '56', 'SL56', NULL, '2022-08-10', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.00', '0.00', '5.0000', '', 'Paid', '5.0000', '2022-08-10', '09:23:50 am', 'Chris', '5.21.237.233', '5.21.237.233', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (57, 2, 2, 1, 'SL', '57', 'SL57', NULL, '2022-08-10', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '16.70', '0.30', '17.0000', '', 'Paid', '17.0000', '2022-08-10', '09:55:42 am', 'Chris', '5.21.237.233', '5.21.237.233', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (58, 2, 2, 1, 'SL', '58', 'SL58', NULL, '2022-08-10', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '2.80', '0.20', '3.0000', '', 'Paid', '3.0000', '2022-08-10', '09:55:59 am', 'Chris', '5.21.237.233', '5.21.237.233', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', NULL);
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (59, 2, 2, 6, 'SL', '1', 'SL1', NULL, '2025-08-24', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '5.60', '0.40', '6.0000', '', 'Paid', '6.0000', '2025-08-24', '01:10:03 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (60, 2, 2, 11, 'TS', '1', 'TS1', NULL, '2025-08-25', NULL, 'Final', 3, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '29.10', '-0.10', '29.0000', '', 'Partial', '10.0000', '2025-08-25', '02:22:12 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (61, 2, 2, 11, 'TS', '2', 'TS2', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '6.70', '0.30', '7.0000', '', 'Paid', '7.0000', '2025-08-25', '08:02:28 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (62, 2, 2, 11, 'TS', '3', 'TS3', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '17.80', '0.20', '18.0000', '', 'Paid', '18.0000', '2025-08-25', '08:20:37 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (63, 2, 2, 11, 'TS', '4', 'TS4', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '17.80', '0.20', '18.0000', '', 'Paid', '18.0000', '2025-08-25', '08:29:05 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (64, 2, 2, 11, 'TS', '5', 'TS5', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '13.40', '-0.40', '13.0000', '', 'Paid', '13.0000', '2025-08-25', '08:31:53 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (65, 2, 2, 11, 'TS', '6', 'TS6', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.70', '0.30', '12.0000', '', 'Paid', '12.0000', '2025-08-25', '08:41:13 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (66, 2, 2, 11, 'TS', '7', 'TS7', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.70', '0.30', '12.0000', '', 'Paid', '12.0000', '2025-08-25', '08:55:27 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (67, 2, 2, 11, 'TS', '8', 'TS8', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '15.60', '0.40', '16.0000', '', 'Paid', '16.0000', '2025-08-25', '09:15:08 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (68, 2, 2, 11, 'TS', '9', 'TS9', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.70', '0.30', '12.0000', '', 'Paid', '12.0000', '2025-08-25', '10:21:15 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (69, 2, 2, 11, 'TS', '10', 'TS10', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.70', '0.30', '12.0000', '', 'Paid', '12.0000', '2025-08-25', '10:42:29 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (70, 2, 2, 11, 'TS', '11', 'TS11', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '19.50', '0.50', '20.0000', '', 'Paid', '20.0000', '2025-08-25', '10:47:01 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (71, 2, 2, 11, 'TS', '12', 'TS12', NULL, '2025-08-25', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '11.70', '0.30', '12.0000', '', 'Paid', '12.0000', '2025-08-25', '10:51:54 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (72, 2, 2, 11, 'TS', '13', 'TS13', NULL, '2025-08-26', NULL, 'Final', 3, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '24.50', '0.50', '25.0000', '', 'Paid', '25.0000', '2025-08-26', '11:31:23 am', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (73, 2, 2, 11, 'TS', '14', 'TS14', NULL, '2025-08-26', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '1984.93', '0.07', '1985.0000', '', 'Paid', '1985.0000', '2025-08-26', '12:35:09 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (74, 2, 2, 11, 'TS', '15', 'TS15', NULL, '2025-08-26', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '3305.25', '-0.25', '3305.0000', '', 'Paid', '3305.0000', '2025-08-26', '12:35:55 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (75, 2, 2, 11, 'TS', '16', 'TS16', NULL, '2025-08-26', NULL, 'Final', 3, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '1602.46', '-0.46', '1602.0000', '', 'Paid', '1602.0000', '2025-08-26', '12:38:01 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');
INSERT INTO `db_sales` (`id`, `store_id`, `warehouse_id`, `sales_type_id`, `init_code`, `count_id`, `sales_code`, `reference_no`, `sales_date`, `due_date`, `sales_status`, `customer_id`, `other_charges_input`, `other_charges_tax_id`, `other_charges_amt`, `discount_to_all_input`, `discount_to_all_type`, `tot_discount_to_all_amt`, `subtotal`, `round_off`, `grand_total`, `sales_note`, `payment_status`, `paid_amount`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `company_id`, `pos`, `status`, `return_bit`, `customer_previous_due`, `customer_total_due`, `quotation_id`, `coupon_id`, `coupon_amt`, `invoice_terms`) VALUES (76, 2, 2, 11, 'TS', '17', 'TS17', NULL, '2025-08-26', NULL, 'Final', 2, NULL, NULL, NULL, '0.00', 'in_percentage', '0.00', '161.95', '0.05', '162.0000', '', 'Paid', '162.0000', '2025-08-26', '12:42:17 pm', 'user_599174', '::1', 'UZRS', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, '0.00', '');


#
# TABLE STRUCTURE FOR: db_sales_credit_note_items
#

DROP TABLE IF EXISTS `db_sales_credit_note_items`;

CREATE TABLE `db_sales_credit_note_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `credit_note_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quantity_before` double(20,2) DEFAULT NULL,
  `quantity_now` double(20,2) DEFAULT NULL,
  `unit_cost_price` double(20,2) DEFAULT NULL,
  `unit_sales_price` double(20,2) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,2) DEFAULT NULL,
  `discount_amt` double(20,2) DEFAULT NULL,
  `unit_total_cost` double(20,2) DEFAULT NULL,
  `total_cost` double(20,2) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,2) DEFAULT NULL,
  `unit_price_with_tax` double(20,2) DEFAULT NULL,
  `total_price_with_tax` double(20,2) DEFAULT NULL,
  `show_part` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sales_credit_note_items_store_id` (`store_id`),
  KEY `fk_sales_credit_note_items_credit_note_id` (`credit_note_id`),
  KEY `fk_sales_credit_note_items_item_id` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_sales_debit_note_items
#

DROP TABLE IF EXISTS `db_sales_debit_note_items`;

CREATE TABLE `db_sales_debit_note_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `debit_note_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quantity_before` double(20,2) DEFAULT NULL,
  `quantity_now` double(20,2) DEFAULT NULL,
  `unit_cost_price` double(20,2) DEFAULT NULL,
  `unit_sales_price` double(20,2) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,2) DEFAULT NULL,
  `discount_amt` double(20,2) DEFAULT NULL,
  `unit_total_cost` double(20,2) DEFAULT NULL,
  `total_cost` double(20,2) DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,2) DEFAULT NULL,
  `unit_price_with_tax` double(20,2) DEFAULT NULL,
  `total_price_with_tax` double(20,2) DEFAULT NULL,
  `show_part` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_sales_types
#

DROP TABLE IF EXISTS `db_sales_types`;

CREATE TABLE `db_sales_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `type_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT '1' COMMENT '1=Active, 0=Inactive',
  `sort_order` int DEFAULT '0',
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_date` date DEFAULT NULL,
  `updated_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `sales_type_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_type_store` (`type_name`,`store_id`),
  UNIQUE KEY `unique_code_store` (`short_code`,`store_id`),
  KEY `store_id` (`store_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`),
  CONSTRAINT `db_sales_types_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_sales_types` (`id`, `store_id`, `type_name`, `short_code`, `description`, `status`, `sort_order`, `created_date`, `created_time`, `created_by`, `updated_date`, `updated_time`, `updated_by`, `company_id`, `sales_type_name`) VALUES (6, 2, 'Shop', 'SL', 'Direct shop sales', 1, 1, '2025-08-24', '13:03:02', 'System', NULL, NULL, NULL, NULL, 'Shop');
INSERT INTO `db_sales_types` (`id`, `store_id`, `type_name`, `short_code`, `description`, `status`, `sort_order`, `created_date`, `created_time`, `created_by`, `updated_date`, `updated_time`, `updated_by`, `company_id`, `sales_type_name`) VALUES (7, 2, 'Flipkart', 'FK', 'Flipkart marketplace sales', 1, 2, '2025-08-24', '13:03:02', 'System', NULL, NULL, NULL, NULL, 'Flipkart');
INSERT INTO `db_sales_types` (`id`, `store_id`, `type_name`, `short_code`, `description`, `status`, `sort_order`, `created_date`, `created_time`, `created_by`, `updated_date`, `updated_time`, `updated_by`, `company_id`, `sales_type_name`) VALUES (8, 2, 'Amazon', 'AM', 'Amazon marketplace sales', 1, 3, '2025-08-24', '13:03:02', 'System', NULL, NULL, NULL, NULL, 'Amazon');
INSERT INTO `db_sales_types` (`id`, `store_id`, `type_name`, `short_code`, `description`, `status`, `sort_order`, `created_date`, `created_time`, `created_by`, `updated_date`, `updated_time`, `updated_by`, `company_id`, `sales_type_name`) VALUES (9, 2, 'Meesho', 'MO', 'Meesho marketplace sales', 1, 4, '2025-08-24', '13:03:02', 'System', NULL, NULL, NULL, NULL, 'Meesho');
INSERT INTO `db_sales_types` (`id`, `store_id`, `type_name`, `short_code`, `description`, `status`, `sort_order`, `created_date`, `created_time`, `created_by`, `updated_date`, `updated_time`, `updated_by`, `company_id`, `sales_type_name`) VALUES (11, 2, 'Test Shop', 'TS', 'Test entry', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Test Shop');


#
# TABLE STRUCTURE FOR: db_salesitems
#

DROP TABLE IF EXISTS `db_salesitems`;

CREATE TABLE `db_salesitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sales_id` int DEFAULT NULL,
  `sales_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `seller_points` double(20,2) DEFAULT '0.00',
  `purchase_price` double(20,3) DEFAULT '0.000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  CONSTRAINT `db_salesitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesitems_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=735 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (556, 2, 1, 'Final', 1, '', '2.00', '2.8000', 'Inclusive', 149, '0.2700', 'Percentage', '0.0000', '0.0000', '2.8000', '5.6000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (557, 2, 2, 'Final', 1, '', '2.00', '2.8000', 'Inclusive', 149, '0.2700', 'Percentage', '0.0000', '0.0000', '2.8000', '5.6000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (558, 2, 3, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (559, 2, 4, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (560, 2, 5, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (561, 2, 6, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (562, 2, 7, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (563, 2, 8, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (564, 2, 9, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (565, 2, 10, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (566, 2, 11, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (567, 2, 12, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (568, 2, 13, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (569, 2, 14, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (570, 2, 15, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (571, 2, 16, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (572, 2, 17, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (573, 2, 18, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (574, 2, 19, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (575, 2, 20, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (576, 2, 21, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (577, 2, 22, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (578, 2, 23, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (579, 2, 24, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (580, 2, 25, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (581, 2, 26, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (582, 2, 27, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (583, 2, 28, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (584, 2, 29, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (585, 2, 30, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (586, 2, 31, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (587, 2, 32, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (588, 2, 33, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (589, 2, 34, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (590, 2, 35, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (591, 2, 36, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (592, 2, 36, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (593, 2, 37, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (594, 2, 38, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (595, 2, 39, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (596, 2, 40, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (597, 2, 41, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (598, 2, 42, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (599, 2, 43, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (600, 2, 44, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (601, 2, 44, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (602, 2, 45, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (603, 2, 46, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (604, 2, 47, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (605, 2, 48, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (606, 2, 48, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (607, 2, 49, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (608, 2, 50, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (609, 2, 50, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (610, 2, 51, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (611, 2, 52, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (612, 2, 53, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (613, 2, 54, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (614, 2, 55, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (615, 2, 56, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (616, 2, 57, 'Final', 3, '', '2.00', '5.0000', 'Inclusive', 149, '0.4800', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (617, 2, 57, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (618, 2, 57, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (619, 2, 58, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (620, 2, 59, 'Final', 1, '', '2.00', '2.8000', 'Inclusive', 149, '0.2700', 'Percentage', '0.0000', '0.0000', '2.8000', '5.6000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (621, 2, 60, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (622, 2, 60, 'Final', 1, '', '9.00', '2.8000', 'Inclusive', 149, '1.2000', 'Percentage', '0.0000', '0.0000', '2.8000', '25.2000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (623, 2, 61, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (624, 2, 61, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (625, 2, 62, 'Final', 3, '', '2.00', '5.0000', 'Inclusive', 149, '0.4800', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (626, 2, 62, 'Final', 2, '', '2.00', '3.9000', 'Inclusive', 149, '0.3700', 'Percentage', '0.0000', '0.0000', '3.9000', '7.8000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (627, 2, 63, 'Final', 3, '', '2.00', '5.0000', 'Inclusive', 149, '0.4800', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (628, 2, 63, 'Final', 2, '', '2.00', '3.9000', 'Inclusive', 149, '0.3700', 'Percentage', '0.0000', '0.0000', '3.9000', '7.8000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (629, 2, 64, 'Final', 1, '', '2.00', '2.8000', 'Inclusive', 149, '0.2700', 'Percentage', '0.0000', '0.0000', '2.8000', '5.6000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (630, 2, 64, 'Final', 2, '', '2.00', '3.9000', 'Inclusive', 149, '0.3700', 'Percentage', '0.0000', '0.0000', '3.9000', '7.8000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (631, 2, 65, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (632, 2, 65, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (633, 2, 65, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (634, 2, 66, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (635, 2, 66, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (636, 2, 66, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (637, 2, 67, 'Final', 2, '', '2.00', '3.9000', 'Inclusive', 149, '0.3700', 'Percentage', '0.0000', '0.0000', '3.9000', '7.8000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (638, 2, 67, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (639, 2, 67, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (652, 2, 68, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (653, 2, 68, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (654, 2, 68, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (655, 2, 69, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (656, 2, 69, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (657, 2, 69, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (658, 2, 70, 'Final', 2, '', '3.00', '3.9000', 'Inclusive', 149, '0.5600', 'Percentage', '0.0000', '0.0000', '3.9000', '11.7000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (659, 2, 70, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (660, 2, 70, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (661, 2, 71, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (662, 2, 71, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (663, 2, 71, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (664, 2, 72, 'Final', 1, '', '2.00', '2.8000', 'Inclusive', 149, '0.2700', 'Percentage', '0.0000', '0.0000', '2.8000', '5.6000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (665, 2, 72, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (666, 2, 72, 'Final', 3, '', '3.00', '5.0000', 'Inclusive', 149, '0.7100', 'Percentage', '0.0000', '0.0000', '5.0000', '15.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (667, 2, 73, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (668, 2, 73, 'Final', 2, '', '2.00', '3.9000', 'Inclusive', 149, '0.3700', 'Percentage', '0.0000', '0.0000', '3.9000', '7.8000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (669, 2, 73, 'Final', 3, '', '2.00', '5.0000', 'Inclusive', 149, '0.4800', 'Percentage', '0.0000', '0.0000', '5.0000', '10.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (670, 2, 73, 'Final', 6, '', '1.00', '51.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '51.1100', '51.1100', 1, '0.00', '36.510');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (671, 2, 73, 'Final', 5, '', '1.00', '36.3800', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '36.3800', '36.3800', 1, '0.00', '26.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (672, 2, 73, 'Final', 9, '', '1.00', '41.7100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '41.7100', '41.7100', 1, '0.00', '27.810');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (673, 2, 73, 'Final', 10, '', '1.00', '45.6300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '45.6300', '45.6300', 1, '0.00', '30.420');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (674, 2, 73, 'Final', 11, '', '1.00', '183.1800', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '183.1800', '183.1800', 1, '0.00', '122.120');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (675, 2, 73, 'Final', 7, '', '1.00', '82.1400', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '82.1400', '82.1400', 1, '0.00', '58.670');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (676, 2, 73, 'Final', 8, '', '1.00', '37.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '37.1100', '37.1100', 1, '0.00', '26.510');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (677, 2, 73, 'Final', 4, '', '1.00', '17.0000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '17.0000', '17.0000', 1, '0.00', '12.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (678, 2, 73, 'Final', 17, '', '1.00', '346.8100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '346.8100', '346.8100', 1, '0.00', '231.210');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (679, 2, 73, 'Final', 18, '', '1.00', '267.9300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '267.9300', '267.9300', 1, '0.00', '178.620');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (680, 2, 73, 'Final', 19, '', '1.00', '52.8000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '52.8000', '52.8000', 1, '0.00', '35.200');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (681, 2, 73, 'Final', 20, '', '1.00', '52.8000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '52.8000', '52.8000', 1, '0.00', '35.200');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (682, 2, 73, 'Final', 24, '', '2.00', '137.5500', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '137.5500', '275.1000', 1, '0.00', '91.700');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (683, 2, 73, 'Final', 22, '', '2.00', '75.6100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '75.6100', '151.2200', 1, '0.00', '50.410');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (684, 2, 73, 'Final', 23, '', '1.00', '103.0000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '103.0000', '103.0000', 1, '0.00', '68.670');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (685, 2, 73, 'Final', 30, '', '1.00', '220.4100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '220.4100', '220.4100', 1, '0.00', '146.940');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (686, 2, 74, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (687, 2, 74, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (688, 2, 74, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (689, 2, 74, 'Final', 4, '', '1.00', '17.0000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '17.0000', '17.0000', 1, '0.00', '12.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (690, 2, 74, 'Final', 8, '', '1.00', '37.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '37.1100', '37.1100', 1, '0.00', '26.510');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (691, 2, 74, 'Final', 7, '', '1.00', '82.1400', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '82.1400', '82.1400', 1, '0.00', '58.670');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (692, 2, 74, 'Final', 6, '', '1.00', '51.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '51.1100', '51.1100', 1, '0.00', '36.510');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (693, 2, 74, 'Final', 5, '', '1.00', '36.3800', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '36.3800', '36.3800', 1, '0.00', '26.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (694, 2, 74, 'Final', 9, '', '1.00', '41.7100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '41.7100', '41.7100', 1, '0.00', '27.810');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (695, 2, 74, 'Final', 10, '', '1.00', '45.6300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '45.6300', '45.6300', 1, '0.00', '30.420');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (696, 2, 74, 'Final', 11, '', '1.00', '183.1800', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '183.1800', '183.1800', 1, '0.00', '122.120');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (697, 2, 74, 'Final', 12, '', '1.00', '211.2200', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '211.2200', '211.2200', 1, '0.00', '140.810');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (698, 2, 74, 'Final', 16, '', '1.00', '65.8500', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '65.8500', '65.8500', 1, '0.00', '43.900');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (699, 2, 74, 'Final', 15, '', '1.00', '610.1900', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '610.1900', '610.1900', 1, '0.00', '406.790');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (700, 2, 74, 'Final', 14, '', '1.00', '11.7300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '11.7300', '11.7300', 1, '0.00', '7.820');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (701, 2, 74, 'Final', 13, '', '1.00', '119.9500', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '119.9500', '119.9500', 1, '0.00', '79.970');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (702, 2, 74, 'Final', 17, '', '1.00', '346.8100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '346.8100', '346.8100', 1, '0.00', '231.210');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (703, 2, 74, 'Final', 18, '', '1.00', '267.9300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '267.9300', '267.9300', 1, '0.00', '178.620');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (704, 2, 74, 'Final', 19, '', '1.00', '52.8000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '52.8000', '52.8000', 1, '0.00', '35.200');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (705, 2, 74, 'Final', 20, '', '1.00', '52.8000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '52.8000', '52.8000', 1, '0.00', '35.200');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (706, 2, 74, 'Final', 24, '', '1.00', '137.5500', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '137.5500', '137.5500', 1, '0.00', '91.700');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (707, 2, 74, 'Final', 23, '', '1.00', '103.0000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '103.0000', '103.0000', 1, '0.00', '68.670');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (708, 2, 74, 'Final', 22, '', '1.00', '75.6100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '75.6100', '75.6100', 1, '0.00', '50.410');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (709, 2, 74, 'Final', 21, '', '1.00', '61.9400', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '61.9400', '61.9400', 1, '0.00', '41.290');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (710, 2, 74, 'Final', 25, '', '1.00', '169.5000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '169.5000', '169.5000', 1, '0.00', '113.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (711, 2, 74, 'Final', 26, '', '1.00', '153.8500', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '153.8500', '153.8500', 1, '0.00', '102.570');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (712, 2, 74, 'Final', 27, '', '1.00', '169.5000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '169.5000', '169.5000', 1, '0.00', '113.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (713, 2, 74, 'Final', 28, '', '1.00', '189.0600', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '189.0600', '189.0600', 1, '0.00', '126.040');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (714, 2, 75, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (715, 2, 75, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (716, 2, 75, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (717, 2, 75, 'Final', 4, '', '1.00', '17.0000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '17.0000', '17.0000', 1, '0.00', '12.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (718, 2, 75, 'Final', 8, '', '1.00', '37.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '37.1100', '37.1100', 1, '0.00', '26.510');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (719, 2, 75, 'Final', 7, '', '1.00', '82.1400', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '82.1400', '82.1400', 1, '0.00', '58.670');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (720, 2, 75, 'Final', 6, '', '1.00', '51.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '51.1100', '51.1100', 1, '0.00', '36.510');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (721, 2, 75, 'Final', 5, '', '1.00', '36.3800', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '36.3800', '36.3800', 1, '0.00', '26.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (722, 2, 75, 'Final', 9, '', '1.00', '41.7100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '41.7100', '41.7100', 1, '0.00', '27.810');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (723, 2, 75, 'Final', 10, '', '1.00', '45.6300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '45.6300', '45.6300', 1, '0.00', '30.420');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (724, 2, 75, 'Final', 11, '', '1.00', '183.1800', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '183.1800', '183.1800', 1, '0.00', '122.120');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (725, 2, 75, 'Final', 12, '', '1.00', '211.2200', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '211.2200', '211.2200', 1, '0.00', '140.810');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (726, 2, 75, 'Final', 15, '', '1.00', '610.1900', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '610.1900', '610.1900', 1, '0.00', '406.790');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (727, 2, 75, 'Final', 14, '', '3.00', '11.7300', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '11.7300', '35.1900', 1, '0.00', '7.820');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (728, 2, 75, 'Final', 13, '', '2.00', '119.9500', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '119.9500', '239.9000', 1, '0.00', '79.970');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (729, 2, 76, 'Final', 1, '', '1.00', '2.8000', 'Inclusive', 149, '0.1300', 'Percentage', '0.0000', '0.0000', '2.8000', '2.8000', 1, '0.00', '1.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (730, 2, 76, 'Final', 2, '', '1.00', '3.9000', 'Inclusive', 149, '0.1900', 'Percentage', '0.0000', '0.0000', '3.9000', '3.9000', 1, '0.00', '2.000');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (731, 2, 76, 'Final', 3, '', '1.00', '5.0000', 'Inclusive', 149, '0.2400', 'Percentage', '0.0000', '0.0000', '5.0000', '5.0000', 1, '0.00', '2.500');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (732, 2, 76, 'Final', 4, '', '1.00', '17.0000', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '17.0000', '17.0000', 1, '0.00', '12.950');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (733, 2, 76, 'Final', 7, '', '1.00', '82.1400', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '82.1400', '82.1400', 1, '0.00', '58.670');
INSERT INTO `db_salesitems` (`id`, `store_id`, `sales_id`, `sales_status`, `item_id`, `description`, `sales_qty`, `price_per_unit`, `tax_type`, `tax_id`, `tax_amt`, `discount_type`, `discount_input`, `discount_amt`, `unit_total_cost`, `total_cost`, `status`, `seller_points`, `purchase_price`) VALUES (734, 2, 76, 'Final', 6, '', '1.00', '51.1100', 'Exclusive', 153, NULL, 'Percentage', '0.0000', '0.0000', '51.1100', '51.1100', 1, '0.00', '36.510');


#
# TABLE STRUCTURE FOR: db_salesitemsreturn
#

DROP TABLE IF EXISTS `db_salesitemsreturn`;

CREATE TABLE `db_salesitemsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sales_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_id` int DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `purchase_price` double(20,3) DEFAULT '0.000',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  CONSTRAINT `db_salesitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_salesreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salespayments
#

DROP TABLE IF EXISTS `db_salespayments`;

CREATE TABLE `db_salespayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `sales_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `change_return` double(20,4) DEFAULT NULL COMMENT 'Refunding the greater amount',
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `advance_adjusted` double(20,4) DEFAULT NULL,
  `cheque_number` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_period` int DEFAULT NULL,
  `cheque_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `db_salespayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespayments_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespayments_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=371 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (290, 1, 'SP/2021/02/0001', 2, 1, '2022-08-09', 'CASH', '6.0000', '', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:04:50 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (291, 2, 'SP/2021/02/0002', 2, 2, '2022-08-09', 'CASH', '5.4000', '', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:05:49 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (292, 3, 'SP/2021/02/0003', 2, 3, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:06:55 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (293, 4, 'SP/2021/02/0004', 2, 4, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:07:13 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (294, 5, 'SP/2021/02/0005', 2, 5, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:10:57 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (295, 6, 'SP/2021/02/0006', 2, 6, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:12:02 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (296, 7, 'SP/2021/02/0007', 2, 7, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:14:12 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (297, 8, 'SP/2021/02/0008', 2, 8, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:16:01 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (298, 9, 'SP/2021/02/0009', 2, 9, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:16:41 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (299, 10, 'SP/2021/02/0010', 2, 10, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:17:33 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (300, 11, 'SP/2021/02/0011', 2, 11, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:18:50 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (301, 12, 'SP/2021/02/0012', 2, 12, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:23:57 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (302, 13, 'SP/2021/02/0013', 2, 13, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:34:13 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (303, 14, 'SP/2021/02/0014', 2, 14, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:37:35 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (304, 15, 'SP/2021/02/0015', 2, 15, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:38:50 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (305, 16, 'SP/2021/02/0016', 2, 16, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:49:10 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (306, 17, 'SP/2021/02/0017', 2, 17, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:51:00 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (307, 18, 'SP/2021/02/0018', 2, 18, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:51:40 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (308, 19, 'SP/2021/02/0019', 2, 19, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:56:20 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (309, 20, 'SP/2021/02/0020', 2, 20, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:56:37 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (310, 21, 'SP/2021/02/0021', 2, 21, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:57:46 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (311, 22, 'SP/2021/02/0022', 2, 22, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:58:07 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (312, 23, 'SP/2021/02/0023', 2, 23, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '12:59:18 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (313, 24, 'SP/2021/02/0024', 2, 24, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:06:31 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (314, 25, 'SP/2021/02/0025', 2, 25, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:10:17 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (315, 26, 'SP/2021/02/0026', 2, 26, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:16:45 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (316, 27, 'SP/2021/02/0027', 2, 27, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:18:51 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (317, 28, 'SP/2021/02/0028', 2, 28, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:24:13 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (318, 29, 'SP/2021/02/0029', 2, 29, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:24:37 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (319, 30, 'SP/2021/02/0030', 2, 30, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:25:33 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (320, 31, 'SP/2021/02/0031', 2, 31, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:27:11 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (321, 32, 'SP22/0032', 2, 32, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:29:55 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (322, 33, 'SP22/0033', 2, 33, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:32:12 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (323, 34, 'SP0034', 2, 34, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:37:06 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (324, 35, 'SP0035', 2, 35, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:37:32 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (325, 36, 'SP0036', 2, 36, '2022-08-09', 'Cash', '7.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:39:26 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (326, 37, 'SP0037', 2, 37, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:41:51 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (327, 38, 'SP0038', 2, 38, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:42:13 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (328, 39, 'SP0039', 2, 39, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:44:36 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (329, 40, 'SP0040', 2, 40, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:46:04 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (330, 41, 'SP0041', 2, 41, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:46:45 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (331, 42, 'SP0042', 2, 42, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:49:14 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (332, 43, 'SP0043', 2, 43, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:49:54 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (333, 44, 'SP0044', 2, 44, '2022-08-09', 'Cash', '7.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:51:01 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (334, 45, 'SP0045', 2, 45, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:52:46 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (335, 46, 'SP0046', 2, 46, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:53:20 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (336, 47, 'SP0047', 2, 47, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:53:41 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (337, 48, 'SP0048', 2, 48, '2022-08-09', 'Cash', '7.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '01:54:18 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (338, 49, 'SP0049', 2, 49, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:26:10 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (339, 50, 'SP0050', 2, 50, '2022-08-09', 'Cash', '7.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:26:25 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (340, 51, 'SP0051', 2, 51, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:30:27 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (341, 52, 'SP0052', 2, 52, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:32:04 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (342, 53, 'SP0053', 2, 53, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:32:25 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (343, 54, 'SP0054', 2, 54, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:32:48 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (344, 55, 'SP0055', 2, 55, '2022-08-09', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '37.28.46.147', 'dynamic.isp.ooredoo.om', '02:33:35 pm', '2022-08-09', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (345, 56, 'SP0056', 2, 56, '2022-08-10', 'Cash', '5.0000', 'Paid By Cash', '0.0000', '5.21.237.233', '5.21.237.233', '09:23:50 am', '2022-08-10', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (346, 57, 'SP0057', 2, 57, '2022-08-10', 'CASH', '10.0000', '', '0.0000', '5.21.237.233', '5.21.237.233', '09:55:42 am', '2022-08-10', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (347, 58, 'SP0058', 2, 57, '2022-08-10', 'CASH', '7.0000', '', '0.0000', '5.21.237.233', '5.21.237.233', '09:55:42 am', '2022-08-10', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (348, 59, 'SP0059', 2, 58, '2022-08-10', 'Cash', '3.0000', 'Paid By Cash', '0.0000', '5.21.237.233', '5.21.237.233', '09:55:59 am', '2022-08-10', 'Chris', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (349, 60, 'SP0060', 2, 59, '2025-08-24', 'Cash', '6.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '01:10:03 pm', '2025-08-24', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (350, 61, 'SP0061', 2, 60, '2025-08-25', 'CASH', '10.0000', '', NULL, '::1', 'UZRS', '02:31:57 pm', '2025-08-25', 'user_599174', 1, NULL, 3, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (351, 62, 'SP0062', 2, 61, '2025-08-25', 'Cash', '7.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '08:02:28 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (352, 63, 'SP0063', 2, 62, '2025-08-25', 'Cash', '18.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '08:20:37 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (353, 64, 'SP0064', 2, 63, '2025-08-25', 'Cash', '18.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '08:29:05 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (354, 65, 'SP0065', 2, 64, '2025-08-25', 'Cash', '13.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '08:31:53 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (355, 66, 'SP0066', 2, 65, '2025-08-25', 'Cash', '12.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '08:41:13 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (356, 67, 'SP0067', 2, 66, '2025-08-25', 'Cash', '12.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '08:55:27 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (357, 68, 'SP0068', 2, 67, '2025-08-25', 'Cash', '16.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '09:15:08 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (362, 69, 'SP0069', 2, 68, '2025-08-25', 'CASH', '12.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '10:42:00 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (363, 70, 'SP0070', 2, 69, '2025-08-25', 'Cash', '12.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '10:42:29 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (364, 71, 'SP0071', 2, 70, '2025-08-25', 'Cash', '20.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '10:47:01 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (365, 72, 'SP0072', 2, 71, '2025-08-25', 'Cash', '12.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '10:51:54 pm', '2025-08-25', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (366, 73, 'SP0073', 2, 72, '2025-08-26', 'Cash', '25.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '11:31:23 am', '2025-08-26', 'user_599174', 1, NULL, 3, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (367, 74, 'SP0074', 2, 73, '2025-08-26', 'Cash', '1985.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '12:35:09 pm', '2025-08-26', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (368, 75, 'SP0075', 2, 74, '2025-08-26', 'Cash', '3305.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '12:35:55 pm', '2025-08-26', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (369, 76, 'SP0076', 2, 75, '2025-08-26', 'Cash', '1602.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '12:38:01 pm', '2025-08-26', 'user_599174', 1, NULL, 3, NULL, '0.0000', NULL, NULL, NULL);
INSERT INTO `db_salespayments` (`id`, `count_id`, `payment_code`, `store_id`, `sales_id`, `payment_date`, `payment_type`, `payment`, `payment_note`, `change_return`, `system_ip`, `system_name`, `created_time`, `created_date`, `created_by`, `status`, `account_id`, `customer_id`, `short_code`, `advance_adjusted`, `cheque_number`, `cheque_period`, `cheque_status`) VALUES (370, 77, 'SP0077', 2, 76, '2025-08-26', 'Cash', '162.0000', 'Paid By Cash', '0.0000', '::1', 'UZRS', '12:42:17 pm', '2025-08-26', 'user_599174', 1, NULL, 2, NULL, '0.0000', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_salespaymentsreturn
#

DROP TABLE IF EXISTS `db_salespaymentsreturn`;

CREATE TABLE `db_salespaymentsreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `count_id` int DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int DEFAULT NULL,
  `sales_id` int DEFAULT NULL,
  `return_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `change_return` double(20,4) DEFAULT NULL COMMENT 'Refunding the greater amount',
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `account_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `db_salespaymentsreturn_ibfk_3` (`customer_id`),
  CONSTRAINT `db_salespaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_salesreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespaymentsreturn_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salesreturn
#

DROP TABLE IF EXISTS `db_salesreturn`;

CREATE TABLE `db_salesreturn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create Sales Return Code',
  `sales_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `return_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `pos` int DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int DEFAULT NULL,
  `return_bit` int DEFAULT NULL COMMENT 'Return raised or not 1 or null',
  `coupon_id` int DEFAULT NULL,
  `coupon_amt` double(20,2) DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  KEY `coupon_id` (`coupon_id`),
  CONSTRAINT `db_salesreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesreturn_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesreturn_ibfk_3` FOREIGN KEY (`coupon_id`) REFERENCES `db_customer_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_shippingaddress
#

DROP TABLE IF EXISTS `db_shippingaddress`;

CREATE TABLE `db_shippingaddress` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `state_id` int DEFAULT NULL,
  `city` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `postcode` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `address` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `status` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `location_link` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  KEY `id` (`id`),
  CONSTRAINT `db_shippingaddress_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_shippingaddress_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (1, 1, 1, NULL, NULL, '', '', 1, 1, NULL);
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (2, 2, NULL, NULL, NULL, NULL, NULL, 1, 2, NULL);
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (3, 2, 0, 0, '', '', '', 1, 3, '');


#
# TABLE STRUCTURE FOR: db_sitesettings
#

DROP TABLE IF EXISTS `db_sitesettings`;

CREATE TABLE `db_sitesettings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `version` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `site_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'path',
  `machine_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `domain` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `unique_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_sitesettings` (`id`, `version`, `site_name`, `logo`, `machine_id`, `domain`, `unique_code`) VALUES (1, '3.0', 'Home Care Trading', '/uploads/site/logo.png', '1', 'pointofsale.ozonepos.com', '4kcd2s8v9axrpm6gy1foh7tlqij5nw');


#
# TABLE STRUCTURE FOR: db_smsapi
#

DROP TABLE IF EXISTS `db_smsapi`;

CREATE TABLE `db_smsapi` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `info` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(600) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key_value` varchar(600) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delete_bit` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_smsapi_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (26, 2, 'url', 'weblink', 'http://example.com/sendmessage', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (27, 2, 'mobile', 'mobiles', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (28, 2, 'message', 'message', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (29, 1, 'url', 'weblink', 'https://www.example.com/api/mt/SendSMS?', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (30, 1, 'mobile', 'mobiles', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (31, 1, 'message', 'message', '', NULL);


#
# TABLE STRUCTURE FOR: db_smstemplates
#

DROP TABLE IF EXISTS `db_smstemplates`;

CREATE TABLE `db_smstemplates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `template_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `variables` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  `undelete_bit` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_smstemplates_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (1, 1, 'GREETING TO CUSTOMER ON SALES', 'Hi {{customer_name}},\r\nYour sales Id is {{sales_id}},\r\nSales Date {{sales_date}},\r\nTotal amount  {{sales_amount}},\r\nYou have paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}<br>                          \r\n{{sales_id}}<br>\r\n{{sales_date}}<br>\r\n{{sales_amount}}<br>\r\n{{paid_amt}}<br>\r\n{{due_amt}}<br>\r\n{{store_name}}<br>\r\n{{store_mobile}}<br>\r\n{{store_address}}<br>\r\n{{store_website}}<br>\r\n{{store_email}}<br>\r\n', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (2, 1, 'GREETING TO CUSTOMER ON SALES RETURN', 'Hi {{customer_name}},\r\nYour sales return Id is {{return_id}},\r\nReturn Date {{return_date}},\r\nTotal amount  {{return_amount}},\r\nWe paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}<br>                          \r\n{{return_id}}<br>\r\n{{return_date}}<br>\r\n{{return_amount}}<br>\r\n{{paid_amt}}<br>\r\n{{due_amt}}<br>\r\n{{company_name}}<br>\r\n{{company_mobile}}<br>\r\n{{company_address}}<br>\r\n{{company_website}}<br>\r\n{{company_email}}<br>', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (12, 2, 'GREETING TO CUSTOMER ON SALES', 'Hi {{customer_name}},\r\nYour sales Id is {{sales_id}},\r\nSales Date {{sales_date}},\r\nTotal amount  {{sales_amount}},\r\nYou have paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}                          \r\n{{sales_id}}\r\n{{sales_date}}\r\n{{sales_amount}}\r\n{{paid_amt}}\r\n{{due_amt}}\r\n{{store_name}}\r\n{{store_mobile}}\r\n{{store_address}}\r\n{{store_website}}\r\n{{store_email}}\r\n', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (13, 2, 'GREETING TO CUSTOMER ON SALES RETURN', 'Hi {{customer_name}},\r\nYour sales return Id is {{return_id}},\r\nReturn Date {{return_date}},\r\nTotal amount  {{return_amount}},\r\nWe paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}                          \r\n{{return_id}}\r\n{{return_date}}\r\n{{return_amount}}\r\n{{paid_amt}}\r\n{{due_amt}}\r\n{{company_name}}\r\n{{company_mobile}}\r\n{{company_address}}\r\n{{company_website}}\r\n{{company_email}}\r\n', 1, 1);


#
# TABLE STRUCTURE FOR: db_sobpayments
#

DROP TABLE IF EXISTS `db_sobpayments`;

CREATE TABLE `db_sobpayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `supplier_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_states
#

DROP TABLE IF EXISTS `db_states`;

CREATE TABLE `db_states` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `state_code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(4050) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_code` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `country` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_states_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (23, 1, 'ST0001', 'Karnataka', 'CNT0001', NULL, 'India', '2017-07-10', 1, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (24, 1, 'ST0024', 'Maharashtra', 'CNT0001', NULL, 'India', '2018-04-13', 1, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (25, 2, 'ST0025', 'Andhra Pradesh', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (26, 1, 'ST0026', 'Arunachal Pradesh', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (27, 1, 'ST0027', 'Assam', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (28, 1, 'ST0028', 'Bihar', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (29, 1, 'ST0029', 'Chhattisgarh', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (30, 1, 'ST0030', 'Goa', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (31, 1, 'ST0031', 'Gujarat', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (32, 1, 'ST0032', 'Haryana', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (33, 1, 'ST0033', 'Himachal Pradesh', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (34, 1, 'ST0034', 'Jammu and Kashmir', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (35, 1, 'ST0035', 'Jharkhand', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (36, 1, 'ST0036', 'Kerala', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (37, 1, 'ST0037', 'Madhya Pradesh', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (38, 1, 'ST0038', 'Manipur', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (39, 1, 'ST0039', 'Meghalaya', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (40, 1, 'ST0040', 'Mizoram', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (41, 1, 'ST0041', 'Nagaland', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (42, 1, 'ST0042', 'Odisha', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (43, 1, 'ST0043', 'Punjab', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (44, 1, 'ST0044', 'Rajasthan', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (45, 1, 'ST0045', 'Sikkim', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (46, 1, 'ST0046', 'Tamil Nadu', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (47, 1, 'ST0047', 'Telangana', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (48, 1, 'ST0048', 'Tripura', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (49, 1, 'ST0049', 'Uttar Pradesh', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (50, 1, 'ST0050', 'Uttarakhand', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (51, 1, 'ST0051', 'West Bengal', 'CNT0001', NULL, 'India', '2018-11-02', NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (52, 1, NULL, 'New York', NULL, NULL, 'USA', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (53, 1, NULL, 'Delhi', NULL, NULL, 'India', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (63, 2, NULL, 'Karnataka', NULL, 79, 'India', NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_stockadjustment
#

DROP TABLE IF EXISTS `db_stockadjustment`;

CREATE TABLE `db_stockadjustment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_date` date DEFAULT NULL,
  `adjustment_note` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_stockadjustment_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (1, 2, 87, '000001', '2025-08-01', '', '2025-08-01', '06:30:09 pm', 'user_450343', '::1', 'UZRS', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (2, 2, 2, '', '2025-08-02', '', '2025-08-02', '11:33:32 pm', 'user_450343', '::1', 'UZRS', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (3, 2, 2, NULL, '2025-08-12', NULL, '2025-08-12', '02:52:26 pm', 'user_450343', '::1', 'UZRS', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (4, 2, 2, NULL, '2025-08-18', NULL, '2025-08-18', '08:31:36 pm', 'user_450343', '117.98.184.35', '117.98.184.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (5, 2, 2, NULL, '2025-08-18', NULL, '2025-08-18', '09:56:23 pm', 'user_450343', '117.98.184.35', '117.98.184.35', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (6, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '09:01:33 pm', 'user_450343', '120.56.75.25', '120.56.75.25', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (7, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '10:30:02 pm', 'user_450343', '120.56.75.25', '120.56.75.25', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (8, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '11:09:20 pm', 'user_450343', '120.56.75.25', '120.56.75.25', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (9, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '11:42:41 pm', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (10, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '11:47:55 pm', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (11, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '11:53:51 pm', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (12, 2, 2, NULL, '2025-08-24', NULL, '2025-08-24', '11:56:55 pm', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (13, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:00:44 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (14, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:01:38 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (15, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:03:40 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (16, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:05:29 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (17, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:08:56 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (18, 2, 2, NULL, '2022-08-09', NULL, '2022-08-09', '12:00:19 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (19, 2, 2, NULL, '2022-08-09', NULL, '2022-08-09', '01:38:51 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (20, 2, 2, NULL, '2022-08-10', NULL, '2022-08-10', '09:23:28 am', 'Chris', '5.21.237.233', '5.21.237.233', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (21, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:16:57 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (22, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:19:08 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (23, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:22:24 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (24, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:23:52 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (25, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:26:33 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (26, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:27:54 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (27, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:30:03 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (28, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:31:01 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (29, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:32:48 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (30, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:33:47 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (31, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:34:50 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (32, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:36:40 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (33, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:37:52 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (34, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:38:58 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (35, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:40:02 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (36, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:41:12 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (37, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:42:41 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (38, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:44:18 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (39, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:45:32 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (40, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:46:53 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (41, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:48:04 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (42, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:49:02 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (43, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:50:17 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (44, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:51:16 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (45, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '12:52:28 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (46, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '01:02:37 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (47, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '01:04:54 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (48, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '01:06:00 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (49, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '01:08:03 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (50, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '01:09:57 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (51, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '01:11:22 am', 'user_450343', '120.60.205.4', 'triband-mum-120.60.205.4.mtnl.net.in', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (52, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:47:08 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (53, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:48:29 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (54, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:49:58 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (55, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:51:12 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (56, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:53:05 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (57, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:54:51 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (58, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:57:17 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (59, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '07:59:13 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (60, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:01:00 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (61, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:02:54 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (62, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:04:05 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (63, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:06:13 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (64, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:07:24 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (65, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:08:59 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (66, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:10:22 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (67, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:12:00 am', 'user_450343', '120.56.64.43', '120.56.64.43', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (68, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:17:45 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (69, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:19:15 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (70, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:20:30 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (71, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:21:43 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (72, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:22:50 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (73, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:24:41 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (74, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:29:23 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (75, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:31:07 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (76, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:32:25 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (77, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:33:42 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (78, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:35:03 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (79, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:36:55 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (80, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:37:57 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (81, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:39:48 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (82, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:41:05 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (83, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:41:58 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (84, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:43:15 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (85, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:44:10 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (86, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:45:12 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (87, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:46:21 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (88, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:47:56 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (89, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:48:52 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (90, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:49:57 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (91, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:50:49 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (92, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:51:47 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (93, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:54:35 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (94, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:56:37 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (95, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '08:58:52 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (96, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:00:15 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (97, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:01:27 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (98, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:02:32 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (99, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:03:53 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (100, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:05:34 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (101, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:11:28 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (102, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:14:02 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (103, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:16:11 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (104, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:17:09 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (105, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:18:05 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (106, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:19:05 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (107, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:20:10 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (108, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:21:38 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (109, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:22:32 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (110, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:23:38 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (111, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '09:24:28 am', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (112, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:06:25 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (113, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:07:46 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (114, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:21:25 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (115, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:23:04 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (116, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:24:36 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (117, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:26:29 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (118, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:28:28 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (119, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:30:44 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (120, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:31:12 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (121, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:32:31 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (122, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:33:48 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (123, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:36:00 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (124, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:38:40 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (125, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:41:19 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (126, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:43:12 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (127, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:44:39 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (128, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:46:25 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (129, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:47:41 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (130, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:49:23 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (131, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:50:15 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (132, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:51:32 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (133, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:53:40 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (134, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:54:52 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (135, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:55:59 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (136, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:57:10 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (137, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:58:06 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (138, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '02:59:50 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (139, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:01:45 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (140, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:03:12 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (141, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:05:02 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (142, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:06:28 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (143, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:07:43 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (144, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:09:16 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (145, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:10:32 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (146, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:11:39 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (147, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:12:39 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (148, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:13:42 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (149, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:15:06 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (150, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:16:11 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (151, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:17:17 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (152, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:18:38 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (153, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:20:20 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (154, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:21:57 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (155, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:22:56 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (156, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:23:47 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (157, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:24:38 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (158, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:25:46 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (159, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:26:54 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (160, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:28:02 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (161, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:29:20 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (162, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:30:15 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (163, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '03:31:19 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (164, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:04:15 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (165, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:20:29 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (166, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:20:55 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (167, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:23:34 pm', 'user_450343', '117.196.32.8', '117.196.32.8', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (168, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:39:04 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (169, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:40:37 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (170, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:42:02 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (171, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:43:06 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (172, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:44:19 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (173, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:45:16 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (174, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:46:15 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (175, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:48:03 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (176, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:49:25 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (177, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:50:53 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (178, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:53:14 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (179, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:54:13 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (180, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:55:24 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (181, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:56:38 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (182, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:58:32 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (183, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '04:59:36 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (184, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:01:14 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (185, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:02:40 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (186, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:04:53 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (187, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:06:33 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (188, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:09:48 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (189, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:11:05 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (190, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:12:49 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (191, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:13:56 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (192, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:15:04 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (193, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:16:22 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (194, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:17:13 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (195, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:19:00 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (196, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:20:06 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (197, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:21:21 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (198, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:23:34 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (199, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:32:52 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (200, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:36:14 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (201, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:38:08 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (202, 2, 2, NULL, '2025-08-25', NULL, '2025-08-25', '05:41:33 pm', 'user_450343', '120.56.128.82', '120.56.128.82', 1);


#
# TABLE STRUCTURE FOR: db_stockadjustmentitems
#

DROP TABLE IF EXISTS `db_stockadjustmentitems`;

CREATE TABLE `db_stockadjustmentitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `adjustment_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `adjustment_qty` double(20,2) DEFAULT NULL,
  `status` int DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `purchase_id` (`adjustment_id`),
  KEY `item_id` (`item_id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_stockadjustmentitems_ibfk_1` FOREIGN KEY (`adjustment_id`) REFERENCES `db_stockadjustment` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stockadjustmentitems_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stockadjustmentitems_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stockadjustmentitems_ibfk_4` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=571 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (363, 2, 2, 18, 1, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (364, 2, 2, 19, 2, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (365, 2, 2, 20, 3, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (374, 2, 2, 6, 1, '200.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (377, 2, 2, 9, 4, '200.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (378, 2, 2, 10, 5, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (379, 2, 2, 11, 6, '30.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (380, 2, 2, 12, 7, '30.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (381, 2, 2, 13, 8, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (382, 2, 2, 14, 7, '30.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (383, 2, 2, 15, 9, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (384, 2, 2, 16, 10, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (385, 2, 2, 17, 11, '40.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (386, 2, 2, 18, 12, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (387, 2, 2, 19, 13, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (388, 2, 2, 20, 14, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (389, 2, 2, 21, 15, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (390, 2, 2, 22, 16, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (391, 2, 2, 23, 17, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (392, 2, 2, 24, 18, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (393, 2, 2, 25, 19, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (394, 2, 2, 26, 20, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (395, 2, 2, 27, 21, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (396, 2, 2, 28, 22, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (397, 2, 2, 29, 23, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (398, 2, 2, 30, 24, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (399, 2, 2, 31, 25, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (400, 2, 2, 32, 26, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (401, 2, 2, 33, 27, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (402, 2, 2, 34, 28, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (403, 2, 2, 35, 29, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (404, 2, 2, 36, 30, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (405, 2, 2, 37, 31, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (406, 2, 2, 38, 32, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (407, 2, 2, 39, 33, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (408, 2, 2, 40, 34, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (409, 2, 2, 41, 35, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (410, 2, 2, 42, 36, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (411, 2, 2, 43, 37, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (412, 2, 2, 44, 36, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (413, 2, 2, 45, 38, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (414, 2, 2, 46, 39, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (415, 2, 2, 47, 40, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (416, 2, 2, 48, 41, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (417, 2, 2, 49, 42, '60.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (418, 2, 2, 50, 43, '40.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (419, 2, 2, 51, 44, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (420, 2, 2, 52, 45, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (421, 2, 2, 53, 46, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (422, 2, 2, 54, 47, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (423, 2, 2, 55, 48, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (424, 2, 2, 56, 49, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (425, 2, 2, 57, 50, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (426, 2, 2, 58, 51, '6.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (427, 2, 2, 59, 52, '6.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (428, 2, 2, 60, 53, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (429, 2, 2, 61, 54, '6.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (430, 2, 2, 62, 55, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (431, 2, 2, 63, 56, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (432, 2, 2, 64, 57, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (433, 2, 2, 65, 58, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (434, 2, 2, 66, 59, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (435, 2, 2, 67, 60, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (436, 2, 2, 68, 61, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (437, 2, 2, 69, 62, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (438, 2, 2, 70, 63, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (439, 2, 2, 71, 64, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (440, 2, 2, 72, 65, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (441, 2, 2, 73, 66, '300.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (442, 2, 2, 74, 67, '4.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (443, 2, 2, 75, 68, '4.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (444, 2, 2, 76, 69, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (445, 2, 2, 77, 70, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (446, 2, 2, 78, 71, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (447, 2, 2, 79, 72, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (448, 2, 2, 80, 73, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (449, 2, 2, 81, 74, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (450, 2, 2, 82, 75, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (451, 2, 2, 83, 76, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (452, 2, 2, 84, 77, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (453, 2, 2, 85, 78, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (454, 2, 2, 86, 79, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (455, 2, 2, 87, 80, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (456, 2, 2, 88, 81, '12.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (457, 2, 2, 89, 82, '12.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (458, 2, 2, 90, 83, '12.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (459, 2, 2, 91, 84, '12.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (460, 2, 2, 92, 85, '12.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (461, 2, 2, 93, 86, '12.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (462, 2, 2, 94, 87, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (463, 2, 2, 95, 88, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (464, 2, 2, 96, 89, '6.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (465, 2, 2, 97, 90, '6.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (466, 2, 2, 98, 91, '1.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (467, 2, 2, 99, 92, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (468, 2, 2, 100, 93, '2.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (469, 2, 2, 101, 94, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (470, 2, 2, 102, 95, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (471, 2, 2, 103, 96, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (472, 2, 2, 104, 97, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (473, 2, 2, 105, 98, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (474, 2, 2, 106, 99, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (475, 2, 2, 107, 100, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (476, 2, 2, 108, 100, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (477, 2, 2, 109, 101, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (478, 2, 2, 110, 102, '60.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (479, 2, 2, 111, 103, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (480, 2, 2, 112, 104, '90.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (481, 2, 2, 113, 105, '90.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (482, 2, 2, 114, 106, '40.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (483, 2, 2, 115, 107, '40.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (484, 2, 2, 116, 108, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (485, 2, 2, 117, 109, '1.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (486, 2, 2, 118, 110, '16.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (487, 2, 2, 119, 111, '16.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (488, 2, 2, 120, 110, '16.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (489, 2, 2, 121, 112, '16.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (490, 2, 2, 122, 113, '16.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (491, 2, 2, 123, 114, '4.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (492, 2, 2, 124, 115, '600.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (493, 2, 2, 125, 116, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (494, 2, 2, 126, 117, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (495, 2, 2, 127, 118, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (496, 2, 2, 128, 119, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (497, 2, 2, 129, 120, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (498, 2, 2, 130, 121, '3.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (499, 2, 2, 131, 120, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (500, 2, 2, 132, 121, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (501, 2, 2, 133, 122, '5.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (502, 2, 2, 134, 123, '1.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (503, 2, 2, 135, 124, '1.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (504, 2, 2, 136, 125, '60.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (505, 2, 2, 137, 126, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (506, 2, 2, 138, 127, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (507, 2, 2, 139, 128, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (508, 2, 2, 140, 129, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (509, 2, 2, 141, 130, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (510, 2, 2, 142, 131, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (511, 2, 2, 143, 132, '100.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (512, 2, 2, 144, 133, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (513, 2, 2, 145, 134, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (514, 2, 2, 146, 135, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (515, 2, 2, 147, 136, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (516, 2, 2, 148, 137, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (517, 2, 2, 149, 138, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (518, 2, 2, 150, 139, '52.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (519, 2, 2, 151, 140, '8.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (520, 2, 2, 152, 141, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (521, 2, 2, 153, 142, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (522, 2, 2, 154, 143, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (523, 2, 2, 155, 144, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (524, 2, 2, 156, 145, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (525, 2, 2, 157, 146, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (526, 2, 2, 158, 147, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (527, 2, 2, 159, 148, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (528, 2, 2, 160, 149, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (529, 2, 2, 161, 150, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (530, 2, 2, 162, 151, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (531, 2, 2, 163, 152, '20.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (532, 2, 2, 164, 153, '7.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (533, 2, 2, 165, 154, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (534, 2, 2, 166, 154, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (535, 2, 2, 167, 155, '30.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (536, 2, 2, 168, 156, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (537, 2, 2, 169, 157, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (538, 2, 2, 170, 158, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (539, 2, 2, 171, 159, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (540, 2, 2, 172, 160, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (541, 2, 2, 173, 161, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (542, 2, 2, 174, 162, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (543, 2, 2, 175, 163, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (544, 2, 2, 176, 164, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (545, 2, 2, 177, 165, '10.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (546, 2, 2, 178, 166, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (547, 2, 2, 179, 167, '30.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (548, 2, 2, 180, 168, '75.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (549, 2, 2, 181, 169, '70.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (550, 2, 2, 182, 170, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (551, 2, 2, 183, 171, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (552, 2, 2, 184, 172, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (553, 2, 2, 185, 173, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (554, 2, 2, 186, 174, '18.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (555, 2, 2, 187, 175, '50.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (556, 2, 2, 188, 176, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (557, 2, 2, 189, 177, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (558, 2, 2, 190, 178, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (559, 2, 2, 191, 179, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (560, 2, 2, 192, 180, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (561, 2, 2, 193, 181, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (562, 2, 2, 194, 182, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (563, 2, 2, 195, 183, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (564, 2, 2, 196, 184, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (565, 2, 2, 197, 185, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (566, 2, 2, 198, 186, '40.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (567, 2, 2, 199, 156, '72.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (568, 2, 2, 200, 187, '1.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (569, 2, 2, 201, 188, '25.00', 1, NULL);
INSERT INTO `db_stockadjustmentitems` (`id`, `store_id`, `warehouse_id`, `adjustment_id`, `item_id`, `adjustment_qty`, `status`, `description`) VALUES (570, 2, 2, 202, 189, '30.00', 1, NULL);


#
# TABLE STRUCTURE FOR: db_stockentry
#

DROP TABLE IF EXISTS `db_stockentry`;

CREATE TABLE `db_stockentry` (
  `id` int NOT NULL AUTO_INCREMENT,
  `entry_date` date DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `qty` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stocktransfer
#

DROP TABLE IF EXISTS `db_stocktransfer`;

CREATE TABLE `db_stocktransfer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL COMMENT 'from store',
  `to_store_id` int DEFAULT NULL COMMENT 'to store transfer',
  `warehouse_from` int DEFAULT NULL,
  `warehouse_to` int DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_from`),
  KEY `warehouse_to` (`warehouse_to`),
  KEY `db_stocktransfer_ibfk_4` (`to_store_id`),
  CONSTRAINT `db_stocktransfer_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransfer_ibfk_2` FOREIGN KEY (`warehouse_from`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransfer_ibfk_3` FOREIGN KEY (`warehouse_to`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransfer_ibfk_4` FOREIGN KEY (`to_store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_stocktransfer` (`id`, `store_id`, `to_store_id`, `warehouse_from`, `warehouse_to`, `transfer_date`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`) VALUES (1, 2, NULL, 2, 86, '2022-08-09', '', 'Chris', '2022-08-09', '02:02:41 pm', '37.28.46.147', 'dynamic.isp.ooredoo.om', 1);


#
# TABLE STRUCTURE FOR: db_stocktransferitems
#

DROP TABLE IF EXISTS `db_stocktransferitems`;

CREATE TABLE `db_stocktransferitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `stocktransfer_id` int DEFAULT NULL,
  `store_id` int DEFAULT NULL COMMENT 'from store',
  `to_store_id` int DEFAULT NULL COMMENT 'to store',
  `warehouse_from` int DEFAULT NULL COMMENT 'warehouse ids',
  `warehouse_to` int DEFAULT NULL COMMENT 'warehouse ids',
  `item_id` int DEFAULT NULL,
  `transfer_qty` double(20,2) DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_from` (`warehouse_from`),
  KEY `warehouse_to` (`warehouse_to`),
  KEY `stocktranfer_id` (`stocktransfer_id`),
  KEY `item_id` (`item_id`),
  KEY `db_stocktransferitems_ibfk_6` (`to_store_id`),
  CONSTRAINT `db_stocktransferitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_2` FOREIGN KEY (`warehouse_from`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_3` FOREIGN KEY (`warehouse_to`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_4` FOREIGN KEY (`stocktransfer_id`) REFERENCES `db_stocktransfer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_5` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_6` FOREIGN KEY (`to_store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_stocktransferitems` (`id`, `stocktransfer_id`, `store_id`, `to_store_id`, `warehouse_from`, `warehouse_to`, `item_id`, `transfer_qty`, `status`) VALUES (89, 1, 2, NULL, 2, 86, 2, '25.00', 1);


#
# TABLE STRUCTURE FOR: db_store
#

DROP TABLE IF EXISTS `db_store`;

CREATE TABLE `db_store` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_code` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_website` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_logo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `logo` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `upi_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upi_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `country` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gst_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pan_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_details` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cid` int DEFAULT NULL,
  `category_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accounts_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `journal_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cust_advance_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_view` int DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `sms_status` int DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `status` int DEFAULT NULL,
  `language_id` int DEFAULT NULL,
  `currency_id` int DEFAULT NULL,
  `currency_placement` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_format` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_format` int DEFAULT NULL,
  `sales_discount` double(20,4) DEFAULT NULL,
  `currencysymbol_id` int DEFAULT NULL,
  `regno_key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fav_icon` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `purchase_code` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `change_return` int DEFAULT NULL,
  `sales_invoice_format_id` int DEFAULT NULL,
  `pos_invoice_format_id` int DEFAULT NULL,
  `sales_invoice_footer_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `round_off` int DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimals` int DEFAULT '2',
  `money_transfer_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sales_payment_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sales_return_payment_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_payment_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_return_payment_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expense_payment_init` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_subscriptionlist_id` int DEFAULT '0',
  `smtp_host` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_port` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_user` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_pass` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_status` int DEFAULT '0',
  `sms_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int NOT NULL,
  `mrp_column` int DEFAULT '0',
  `invoice_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `previous_balance_bit` int DEFAULT '1' COMMENT '1=Show, 0=Hide - Shows on sales invoice',
  `qty_decimals` int DEFAULT '2',
  `signature` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `show_signature` int DEFAULT '0',
  `t_and_c_status` int DEFAULT '1' COMMENT '1=Show, 0=Hide - Shows on sales invoice',
  `t_and_c_status_pos` int DEFAULT '1',
  `number_to_words` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Default',
  `default_account_id` int DEFAULT NULL,
  `whatsapp_status` int DEFAULT '0' COMMENT '1=Enable, 0=Disable',
  `whatsapp_api_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'WhatsApp API endpoint URL',
  `whatsapp_api_key` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'WhatsApp API authentication key',
  `whatsapp_api_secret` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'WhatsApp API secret',
  `whatsapp_instance_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'WhatsApp instance/phone number ID',
  `whatsapp_webhook_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Webhook URL for receiving messages',
  `whatsapp_webhook_token` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Webhook verification token',
  `whatsapp_send_invoice` int DEFAULT '1' COMMENT '1=Enable, 0=Disable sending invoices',
  `whatsapp_send_reminders` int DEFAULT '1' COMMENT '1=Enable, 0=Disable payment reminders',
  `whatsapp_send_notifications` int DEFAULT '1' COMMENT '1=Enable, 0=Disable general notifications',
  `whatsapp_business_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Business name for WhatsApp display',
  `whatsapp_default_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Default message template',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_store` (`id`, `store_code`, `store_name`, `store_website`, `mobile`, `phone`, `email`, `website`, `store_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `accounts_init`, `journal_init`, `cust_advance_init`, `invoice_view`, `sms_status`, `status`, `language_id`, `currency_id`, `currency_placement`, `timezone`, `date_format`, `time_format`, `sales_discount`, `currencysymbol_id`, `regno_key`, `fav_icon`, `purchase_code`, `change_return`, `sales_invoice_format_id`, `pos_invoice_format_id`, `sales_invoice_footer_text`, `round_off`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `quotation_init`, `decimals`, `money_transfer_init`, `sales_payment_init`, `sales_return_payment_init`, `purchase_payment_init`, `purchase_return_payment_init`, `expense_payment_init`, `current_subscriptionlist_id`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `smtp_status`, `sms_url`, `user_id`, `mrp_column`, `invoice_terms`, `previous_balance_bit`, `qty_decimals`, `signature`, `show_signature`, `t_and_c_status`, `t_and_c_status_pos`, `number_to_words`, `default_account_id`, `whatsapp_status`, `whatsapp_api_url`, `whatsapp_api_key`, `whatsapp_api_secret`, `whatsapp_instance_id`, `whatsapp_webhook_url`, `whatsapp_webhook_token`, `whatsapp_send_invoice`, `whatsapp_send_reminders`, `whatsapp_send_notifications`, `whatsapp_business_name`, `whatsapp_default_message`) VALUES (1, 'ST0001', 'SAAS ADMIN', '', '+919999999999', '', 'admin@example.com', 'www', 'uploads/store/company_logo.png', NULL, NULL, NULL, 'India', 'Karnataka', 'Bengalore', 'Gandhi Road', '', '', '', '', '', NULL, 'CT/01/', 'IT01', 'SU/01/', 'PU/2020/01', 'PR/2020/01/', 'CU/01/', 'SL/2020/01/', 'SR/2020/01/', 'EX/2020/01/', 'AC/01/', 'JE', 'ADV', 1, 0, 1, 1, 35, 'Left', 'Asia/Kolkata\r\n', 'dd-mm-yyyy', 12, '0.0000', NULL, NULL, NULL, NULL, 1, 3, 1, 'Its Footer, You can change it from Store Settings.', 0, NULL, NULL, NULL, NULL, NULL, 'QT/2020/01/', 2, 'MT/01/', 'SP/2020/01/', 'SRP/2020/01/', 'PP/2020/01/', 'PRP/2020/01/', 'XP/2020/01/', 26, 'ssl://smtp.gmail.com', '465', 'salmanpathanindia@gmail.com', '9632563672', 1, 'http://sms.proware.in/api/sendhttp.php?authkey=248050Asbku6K75bf27efc&amp;mobiles={{MOBILE}}&amp;message={{MESSAGE}}&amp;sender=WBMGIC&amp;route=4', 0, 0, NULL, 1, 2, NULL, 0, 1, 1, 'Default', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, 1, NULL, NULL);
INSERT INTO `db_store` (`id`, `store_code`, `store_name`, `store_website`, `mobile`, `phone`, `email`, `website`, `store_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `accounts_init`, `journal_init`, `cust_advance_init`, `invoice_view`, `sms_status`, `status`, `language_id`, `currency_id`, `currency_placement`, `timezone`, `date_format`, `time_format`, `sales_discount`, `currencysymbol_id`, `regno_key`, `fav_icon`, `purchase_code`, `change_return`, `sales_invoice_format_id`, `pos_invoice_format_id`, `sales_invoice_footer_text`, `round_off`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `quotation_init`, `decimals`, `money_transfer_init`, `sales_payment_init`, `sales_return_payment_init`, `purchase_payment_init`, `purchase_return_payment_init`, `expense_payment_init`, `current_subscriptionlist_id`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `smtp_status`, `sms_url`, `user_id`, `mrp_column`, `invoice_terms`, `previous_balance_bit`, `qty_decimals`, `signature`, `show_signature`, `t_and_c_status`, `t_and_c_status_pos`, `number_to_words`, `default_account_id`, `whatsapp_status`, `whatsapp_api_url`, `whatsapp_api_key`, `whatsapp_api_secret`, `whatsapp_instance_id`, `whatsapp_webhook_url`, `whatsapp_webhook_token`, `whatsapp_send_invoice`, `whatsapp_send_reminders`, `whatsapp_send_notifications`, `whatsapp_business_name`, `whatsapp_default_message`) VALUES (2, 'ST0002', 'Home Care Trading', '', '97845124', '', 'homecaretrading@gmail.com', NULL, 'uploads/store/uzrs_logo_final.jpg', NULL, NULL, NULL, 'Oman', '', 'Muscat', 'Al Amerat', '199', '', '', '', '', NULL, 'CT', 'IT02', 'SU', 'PU', 'PR', 'CU', 'SL', 'SR', 'EX', 'AC', NULL, 'ADV', 1, 2, 1, 1, 35, 'Left', 'Asia/Kolkata\r\n', 'dd-mm-yyyy', 12, '0.0000', NULL, NULL, NULL, NULL, 1, 3, 7, 'This is footer text. It is in Store Management.', 1, '2021-02-12', '05:53:37 pm', '', '127.0.0.1', 'LAPTOP-I5OUIM4R', 'QT', 2, 'MT', 'SP', 'SRP', 'PP', 'PRP', 'XP', 28, NULL, NULL, NULL, NULL, 0, NULL, 0, 0, '', 1, 2, NULL, 0, 1, 1, 'Default', NULL, 1, 'https://wav5.algotechnosoft.com/api/send', '677655e0f0f18', '', '6776571FDCA84', '', '', 1, 1, 1, 'Minerva Technologies', 'API Test Message from UZRS Softwares');


#
# TABLE STRUCTURE FOR: db_stripe
#

DROP TABLE IF EXISTS `db_stripe`;

CREATE TABLE `db_stripe` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `sandbox` int DEFAULT NULL,
  `publishable_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `api_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_stripe_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stripepayments
#

DROP TABLE IF EXISTS `db_stripepayments`;

CREATE TABLE `db_stripepayments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `buyer_name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `buyer_email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `paid_amount` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `paid_amount_currency` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `txn_id` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_subscription
#

DROP TABLE IF EXISTS `db_subscription`;

CREATE TABLE `db_subscription` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `payment_id` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `package_id` int DEFAULT NULL,
  `package_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `package_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `subscription_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `trial_days` int DEFAULT NULL,
  `max_users` int DEFAULT NULL,
  `max_warehouses` int DEFAULT NULL,
  `max_items` int DEFAULT NULL,
  `max_invoices` int DEFAULT NULL,
  `payment_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `txn_id` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payment_gross` double(10,2) DEFAULT NULL,
  `currency_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payer_email` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payment_status` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `package_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payment_type` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'manual subscription only',
  `package_count` int DEFAULT NULL COMMENT 'manual subscription only',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (13, 22, NULL, 2, NULL, 'Regular', 'Test description', '2021-01-25', NULL, 15, 20, 20, 200, 200, 'PayPal', '48R18927X78299709', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '01:30:45 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (14, 22, NULL, 2, 'Paid', 'Regular', 'Test description', '2021-01-25', NULL, 15, 20, 20, 200, 200, 'PayPal', '9M838440FH9266015', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '01:32:28 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (16, 22, NULL, 2, 'Paid', 'Regular', 'Test description', '2021-01-25', '2021-02-25', 15, 20, 20, 200, 200, 'PayPal', '2PT61144W90213341', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '02:00:38 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (26, 1, NULL, 1, 'Free', 'Free', 'Test description', '2021-01-25', '2021-02-04', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-01-25', '06:32:32 pm', 'admin', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (27, 24, NULL, 1, 'Free', 'Free', 'Test description', '2021-02-11', '2021-02-21', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-02-11', '03:09:47 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (28, 2, NULL, 1, 'Free', 'Free', 'Test description', '2021-02-12', '2021-02-22', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-02-12', '06:57:18 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_supplier_payments
#

DROP TABLE IF EXISTS `db_supplier_payments`;

CREATE TABLE `db_supplier_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `purchasepayment_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `purchasepayment_id` (`purchasepayment_id`),
  CONSTRAINT `db_supplier_payments_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_supplier_payments_ibfk_2` FOREIGN KEY (`purchasepayment_id`) REFERENCES `db_purchasepayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_suppliers
#

DROP TABLE IF EXISTS `db_suppliers`;

CREATE TABLE `db_suppliers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `count_id` int DEFAULT NULL COMMENT 'Use to create supplier Code',
  `supplier_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gstin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vatin` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `purchase_due` double(20,4) DEFAULT NULL,
  `purchase_return_due` double(20,4) DEFAULT NULL,
  `country_id` int DEFAULT NULL,
  `state_id` int DEFAULT NULL,
  `city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_suppliers_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_suppliers` (`id`, `store_id`, `count_id`, `supplier_code`, `supplier_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `purchase_due`, `purchase_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`) VALUES (1, 2, 1, 'SU0001', 'EZ tech', '', '', '', '', '', NULL, '0.0000', '2.0000', NULL, 0, 0, '', '', '', '37.28.46.147', 'dynamic.isp.ooredoo.om', '2022-08-09', '01:59:07 pm', 'Chris', NULL, 1);


#
# TABLE STRUCTURE FOR: db_tax
#

DROP TABLE IF EXISTS `db_tax`;

CREATE TABLE `db_tax` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `tax_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax` double(20,4) DEFAULT NULL,
  `group_bit` int DEFAULT NULL COMMENT '1=Yes, 0=No',
  `subtax_ids` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Tax groups IDs',
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_tax_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_tax` (`id`, `store_id`, `tax_name`, `tax`, `group_bit`, `subtax_ids`, `status`) VALUES (149, 2, 'GST 5%', '5.0000', NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_timezone
#

DROP TABLE IF EXISTS `db_timezone`;

CREATE TABLE `db_timezone` (
  `id` int NOT NULL AUTO_INCREMENT,
  `timezone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=549 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (1, 'Africa/Abidjan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (2, 'Africa/Accra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (3, 'Africa/Addis_Ababa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (4, 'Africa/Algiers\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (5, 'Africa/Asmara\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (6, 'Africa/Asmera\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (7, 'Africa/Bamako\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (8, 'Africa/Bangui\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (9, 'Africa/Banjul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (10, 'Africa/Bissau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (11, 'Africa/Blantyre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (12, 'Africa/Brazzaville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (13, 'Africa/Bujumbura\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (14, 'Africa/Cairo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (15, 'Africa/Casablanca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (16, 'Africa/Ceuta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (17, 'Africa/Conakry\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (18, 'Africa/Dakar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (19, 'Africa/Dar_es_Salaam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (20, 'Africa/Djibouti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (21, 'Africa/Douala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (22, 'Africa/El_Aaiun\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (23, 'Africa/Freetown\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (24, 'Africa/Gaborone\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (25, 'Africa/Harare\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (26, 'Africa/Johannesburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (27, 'Africa/Juba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (28, 'Africa/Kampala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (29, 'Africa/Khartoum\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (30, 'Africa/Kigali\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (31, 'Africa/Kinshasa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (32, 'Africa/Lagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (33, 'Africa/Libreville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (34, 'Africa/Lome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (35, 'Africa/Luanda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (36, 'Africa/Lubumbashi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (37, 'Africa/Lusaka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (38, 'Africa/Malabo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (39, 'Africa/Maputo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (40, 'Africa/Maseru\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (41, 'Africa/Mbabane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (42, 'Africa/Mogadishu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (43, 'Africa/Monrovia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (44, 'Africa/Nairobi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (45, 'Africa/Ndjamena\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (46, 'Africa/Niamey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (47, 'Africa/Nouakchott\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (48, 'Africa/Ouagadougou\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (49, 'Africa/Porto-Novo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (50, 'Africa/Sao_Tome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (51, 'Africa/Timbuktu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (52, 'Africa/Tripoli\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (53, 'Africa/Tunis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (54, 'Africa/Windhoek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (55, 'AKST9AKDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (56, 'America/Adak\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (57, 'America/Anchorage\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (58, 'America/Anguilla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (59, 'America/Antigua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (60, 'America/Araguaina\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (61, 'America/Argentina/Buenos_Aires\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (62, 'America/Argentina/Catamarca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (63, 'America/Argentina/ComodRivadavia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (64, 'America/Argentina/Cordoba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (65, 'America/Argentina/Jujuy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (66, 'America/Argentina/La_Rioja\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (67, 'America/Argentina/Mendoza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (68, 'America/Argentina/Rio_Gallegos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (69, 'America/Argentina/Salta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (70, 'America/Argentina/San_Juan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (71, 'America/Argentina/San_Luis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (72, 'America/Argentina/Tucuman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (73, 'America/Argentina/Ushuaia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (74, 'America/Aruba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (75, 'America/Asuncion\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (76, 'America/Atikokan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (77, 'America/Atka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (78, 'America/Bahia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (79, 'America/Bahia_Banderas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (80, 'America/Barbados\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (81, 'America/Belem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (82, 'America/Belize\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (83, 'America/Blanc-Sablon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (84, 'America/Boa_Vista\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (85, 'America/Bogota\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (86, 'America/Boise\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (87, 'America/Buenos_Aires\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (88, 'America/Cambridge_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (89, 'America/Campo_Grande\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (90, 'America/Cancun\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (91, 'America/Caracas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (92, 'America/Catamarca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (93, 'America/Cayenne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (94, 'America/Cayman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (95, 'America/Chicago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (96, 'America/Chihuahua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (97, 'America/Coral_Harbour\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (98, 'America/Cordoba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (99, 'America/Costa_Rica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (100, 'America/Creston\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (101, 'America/Cuiaba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (102, 'America/Curacao\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (103, 'America/Danmarkshavn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (104, 'America/Dawson\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (105, 'America/Dawson_Creek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (106, 'America/Denver\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (107, 'America/Detroit\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (108, 'America/Dominica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (109, 'America/Edmonton\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (110, 'America/Eirunepe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (111, 'America/El_Salvador\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (112, 'America/Ensenada\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (113, 'America/Fort_Wayne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (114, 'America/Fortaleza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (115, 'America/Glace_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (116, 'America/Godthab\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (117, 'America/Goose_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (118, 'America/Grand_Turk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (119, 'America/Grenada\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (120, 'America/Guadeloupe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (121, 'America/Guatemala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (122, 'America/Guayaquil\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (123, 'America/Guyana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (124, 'America/Halifax\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (125, 'America/Havana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (126, 'America/Hermosillo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (127, 'America/Indiana/Indianapolis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (128, 'America/Indiana/Knox\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (129, 'America/Indiana/Marengo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (130, 'America/Indiana/Petersburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (131, 'America/Indiana/Tell_City\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (132, 'America/Indiana/Vevay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (133, 'America/Indiana/Vincennes\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (134, 'America/Indiana/Winamac\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (135, 'America/Indianapolis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (136, 'America/Inuvik\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (137, 'America/Iqaluit\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (138, 'America/Jamaica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (139, 'America/Jujuy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (140, 'America/Juneau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (141, 'America/Kentucky/Louisville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (142, 'America/Kentucky/Monticello\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (143, 'America/Knox_IN\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (144, 'America/Kralendijk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (145, 'America/La_Paz\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (146, 'America/Lima\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (147, 'America/Los_Angeles\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (148, 'America/Louisville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (149, 'America/Lower_Princes\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (150, 'America/Maceio\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (151, 'America/Managua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (152, 'America/Manaus\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (153, 'America/Marigot\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (154, 'America/Martinique\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (155, 'America/Matamoros\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (156, 'America/Mazatlan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (157, 'America/Mendoza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (158, 'America/Menominee\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (159, 'America/Merida\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (160, 'America/Metlakatla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (161, 'America/Mexico_City\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (162, 'America/Miquelon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (163, 'America/Moncton\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (164, 'America/Monterrey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (165, 'America/Montevideo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (166, 'America/Montreal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (167, 'America/Montserrat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (168, 'America/Nassau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (169, 'America/New_York\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (170, 'America/Nipigon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (171, 'America/Nome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (172, 'America/Noronha\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (173, 'America/North_Dakota/Beulah\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (174, 'America/North_Dakota/Center\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (175, 'America/North_Dakota/New_Salem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (176, 'America/Ojinaga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (177, 'America/Panama\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (178, 'America/Pangnirtung\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (179, 'America/Paramaribo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (180, 'America/Phoenix\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (181, 'America/Port_of_Spain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (182, 'America/Port-au-Prince\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (183, 'America/Porto_Acre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (184, 'America/Porto_Velho\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (185, 'America/Puerto_Rico\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (186, 'America/Rainy_River\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (187, 'America/Rankin_Inlet\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (188, 'America/Recife\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (189, 'America/Regina\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (190, 'America/Resolute\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (191, 'America/Rio_Branco\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (192, 'America/Rosario\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (193, 'America/Santa_Isabel\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (194, 'America/Santarem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (195, 'America/Santiago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (196, 'America/Santo_Domingo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (197, 'America/Sao_Paulo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (198, 'America/Scoresbysund\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (199, 'America/Shiprock\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (200, 'America/Sitka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (201, 'America/St_Barthelemy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (202, 'America/St_Johns\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (203, 'America/St_Kitts\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (204, 'America/St_Lucia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (205, 'America/St_Thomas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (206, 'America/St_Vincent\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (207, 'America/Swift_Current\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (208, 'America/Tegucigalpa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (209, 'America/Thule\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (210, 'America/Thunder_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (211, 'America/Tijuana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (212, 'America/Toronto\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (213, 'America/Tortola\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (214, 'America/Vancouver\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (215, 'America/Virgin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (216, 'America/Whitehorse\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (217, 'America/Winnipeg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (218, 'America/Yakutat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (219, 'America/Yellowknife\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (220, 'Antarctica/Casey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (221, 'Antarctica/Davis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (222, 'Antarctica/DumontDUrville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (223, 'Antarctica/Macquarie\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (224, 'Antarctica/Mawson\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (225, 'Antarctica/McMurdo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (226, 'Antarctica/Palmer\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (227, 'Antarctica/Rothera\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (228, 'Antarctica/South_Pole\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (229, 'Antarctica/Syowa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (230, 'Antarctica/Vostok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (231, 'Arctic/Longyearbyen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (232, 'Asia/Aden\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (233, 'Asia/Almaty\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (234, 'Asia/Amman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (235, 'Asia/Anadyr\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (236, 'Asia/Aqtau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (237, 'Asia/Aqtobe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (238, 'Asia/Ashgabat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (239, 'Asia/Ashkhabad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (240, 'Asia/Baghdad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (241, 'Asia/Bahrain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (242, 'Asia/Baku\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (243, 'Asia/Bangkok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (244, 'Asia/Beirut\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (245, 'Asia/Bishkek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (246, 'Asia/Brunei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (247, 'Asia/Calcutta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (248, 'Asia/Choibalsan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (249, 'Asia/Chongqing\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (250, 'Asia/Chungking\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (251, 'Asia/Colombo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (252, 'Asia/Dacca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (253, 'Asia/Damascus\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (254, 'Asia/Dhaka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (255, 'Asia/Dili\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (256, 'Asia/Dubai\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (257, 'Asia/Dushanbe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (258, 'Asia/Gaza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (259, 'Asia/Harbin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (260, 'Asia/Hebron\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (261, 'Asia/Ho_Chi_Minh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (262, 'Asia/Hong_Kong\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (263, 'Asia/Hovd\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (264, 'Asia/Irkutsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (265, 'Asia/Istanbul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (266, 'Asia/Jakarta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (267, 'Asia/Jayapura\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (268, 'Asia/Jerusalem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (269, 'Asia/Kabul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (270, 'Asia/Kamchatka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (271, 'Asia/Karachi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (272, 'Asia/Kashgar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (273, 'Asia/Kathmandu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (274, 'Asia/Katmandu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (275, 'Asia/Kolkata\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (276, 'Asia/Krasnoyarsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (277, 'Asia/Kuala_Lumpur\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (278, 'Asia/Kuching\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (279, 'Asia/Kuwait\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (280, 'Asia/Macao\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (281, 'Asia/Macau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (282, 'Asia/Magadan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (283, 'Asia/Makassar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (284, 'Asia/Manila\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (285, 'Asia/Muscat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (286, 'Asia/Nicosia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (287, 'Asia/Novokuznetsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (288, 'Asia/Novosibirsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (289, 'Asia/Omsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (290, 'Asia/Oral\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (291, 'Asia/Phnom_Penh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (292, 'Asia/Pontianak\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (293, 'Asia/Pyongyang\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (294, 'Asia/Qatar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (295, 'Asia/Qyzylorda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (296, 'Asia/Rangoon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (297, 'Asia/Riyadh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (298, 'Asia/Saigon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (299, 'Asia/Sakhalin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (300, 'Asia/Samarkand\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (301, 'Asia/Seoul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (302, 'Asia/Shanghai\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (303, 'Asia/Singapore\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (304, 'Asia/Taipei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (305, 'Asia/Tashkent\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (306, 'Asia/Tbilisi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (307, 'Asia/Tehran\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (308, 'Asia/Tel_Aviv\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (309, 'Asia/Thimbu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (310, 'Asia/Thimphu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (311, 'Asia/Tokyo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (312, 'Asia/Ujung_Pandang\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (313, 'Asia/Ulaanbaatar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (314, 'Asia/Ulan_Bator\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (315, 'Asia/Urumqi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (316, 'Asia/Vientiane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (317, 'Asia/Vladivostok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (318, 'Asia/Yakutsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (319, 'Asia/Yekaterinburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (320, 'Asia/Yerevan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (321, 'Atlantic/Azores\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (322, 'Atlantic/Bermuda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (323, 'Atlantic/Canary\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (324, 'Atlantic/Cape_Verde\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (325, 'Atlantic/Faeroe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (326, 'Atlantic/Faroe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (327, 'Atlantic/Jan_Mayen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (328, 'Atlantic/Madeira\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (329, 'Atlantic/Reykjavik\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (330, 'Atlantic/South_Georgia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (331, 'Atlantic/St_Helena\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (332, 'Atlantic/Stanley\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (333, 'Australia/ACT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (334, 'Australia/Adelaide\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (335, 'Australia/Brisbane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (336, 'Australia/Broken_Hill\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (337, 'Australia/Canberra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (338, 'Australia/Currie\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (339, 'Australia/Darwin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (340, 'Australia/Eucla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (341, 'Australia/Hobart\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (342, 'Australia/LHI\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (343, 'Australia/Lindeman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (344, 'Australia/Lord_Howe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (345, 'Australia/Melbourne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (346, 'Australia/North\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (347, 'Australia/NSW\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (348, 'Australia/Perth\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (349, 'Australia/Queensland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (350, 'Australia/South\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (351, 'Australia/Sydney\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (352, 'Australia/Tasmania\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (353, 'Australia/Victoria\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (354, 'Australia/West\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (355, 'Australia/Yancowinna\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (356, 'Brazil/Acre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (357, 'Brazil/DeNoronha\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (358, 'Brazil/East\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (359, 'Brazil/West\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (360, 'Canada/Atlantic\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (361, 'Canada/Central\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (362, 'Canada/Eastern\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (363, 'Canada/East-Saskatchewan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (364, 'Canada/Mountain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (365, 'Canada/Newfoundland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (366, 'Canada/Pacific\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (367, 'Canada/Saskatchewan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (368, 'Canada/Yukon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (369, 'CET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (370, 'Chile/Continental\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (371, 'Chile/EasterIsland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (372, 'CST6CDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (373, 'Cuba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (374, 'EET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (375, 'Egypt\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (376, 'Eire\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (377, 'EST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (378, 'EST5EDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (379, 'Etc./GMT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (380, 'Etc./GMT+0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (381, 'Etc./UCT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (382, 'Etc./Universal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (383, 'Etc./UTC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (384, 'Etc./Zulu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (385, 'Europe/Amsterdam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (386, 'Europe/Andorra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (387, 'Europe/Athens\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (388, 'Europe/Belfast\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (389, 'Europe/Belgrade\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (390, 'Europe/Berlin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (391, 'Europe/Bratislava\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (392, 'Europe/Brussels\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (393, 'Europe/Bucharest\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (394, 'Europe/Budapest\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (395, 'Europe/Chisinau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (396, 'Europe/Copenhagen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (397, 'Europe/Dublin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (398, 'Europe/Gibraltar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (399, 'Europe/Guernsey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (400, 'Europe/Helsinki\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (401, 'Europe/Isle_of_Man\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (402, 'Europe/Istanbul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (403, 'Europe/Jersey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (404, 'Europe/Kaliningrad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (405, 'Europe/Kiev\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (406, 'Europe/Lisbon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (407, 'Europe/Ljubljana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (408, 'Europe/London\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (409, 'Europe/Luxembourg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (410, 'Europe/Madrid\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (411, 'Europe/Malta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (412, 'Europe/Mariehamn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (413, 'Europe/Minsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (414, 'Europe/Monaco\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (415, 'Europe/Moscow\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (416, 'Europe/Nicosia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (417, 'Europe/Oslo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (418, 'Europe/Paris\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (419, 'Europe/Podgorica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (420, 'Europe/Prague\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (421, 'Europe/Riga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (422, 'Europe/Rome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (423, 'Europe/Samara\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (424, 'Europe/San_Marino\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (425, 'Europe/Sarajevo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (426, 'Europe/Simferopol\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (427, 'Europe/Skopje\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (428, 'Europe/Sofia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (429, 'Europe/Stockholm\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (430, 'Europe/Tallinn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (431, 'Europe/Tirane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (432, 'Europe/Tiraspol\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (433, 'Europe/Uzhgorod\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (434, 'Europe/Vaduz\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (435, 'Europe/Vatican\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (436, 'Europe/Vienna\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (437, 'Europe/Vilnius\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (438, 'Europe/Volgograd\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (439, 'Europe/Warsaw\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (440, 'Europe/Zagreb\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (441, 'Europe/Zaporozhye\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (442, 'Europe/Zurich\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (443, 'GB\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (444, 'GB-Eire\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (445, 'GMT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (446, 'GMT+0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (447, 'GMT0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (448, 'GMT-0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (449, 'Greenwich\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (450, 'Hong Kong\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (451, 'HST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (452, 'Iceland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (453, 'Indian/Antananarivo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (454, 'Indian/Chagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (455, 'Indian/Christmas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (456, 'Indian/Cocos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (457, 'Indian/Comoro\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (458, 'Indian/Kerguelen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (459, 'Indian/Mahe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (460, 'Indian/Maldives\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (461, 'Indian/Mauritius\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (462, 'Indian/Mayotte\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (463, 'Indian/Reunion\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (464, 'Iran\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (465, 'Israel\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (466, 'Jamaica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (467, 'Japan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (468, 'JST-9\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (469, 'Kwajalein\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (470, 'Libya\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (471, 'MET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (472, 'Mexico/BajaNorte\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (473, 'Mexico/BajaSur\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (474, 'Mexico/General\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (475, 'MST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (476, 'MST7MDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (477, 'Navajo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (478, 'NZ\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (479, 'NZ-CHAT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (480, 'Pacific/Apia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (481, 'Pacific/Auckland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (482, 'Pacific/Chatham\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (483, 'Pacific/Chuuk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (484, 'Pacific/Easter\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (485, 'Pacific/Efate\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (486, 'Pacific/Enderbury\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (487, 'Pacific/Fakaofo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (488, 'Pacific/Fiji\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (489, 'Pacific/Funafuti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (490, 'Pacific/Galapagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (491, 'Pacific/Gambier\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (492, 'Pacific/Guadalcanal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (493, 'Pacific/Guam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (494, 'Pacific/Honolulu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (495, 'Pacific/Johnston\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (496, 'Pacific/Kiritimati\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (497, 'Pacific/Kosrae\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (498, 'Pacific/Kwajalein\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (499, 'Pacific/Majuro\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (500, 'Pacific/Marquesas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (501, 'Pacific/Midway\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (502, 'Pacific/Nauru\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (503, 'Pacific/Niue\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (504, 'Pacific/Norfolk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (505, 'Pacific/Noumea\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (506, 'Pacific/Pago_Pago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (507, 'Pacific/Palau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (508, 'Pacific/Pitcairn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (509, 'Pacific/Pohnpei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (510, 'Pacific/Ponape\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (511, 'Pacific/Port_Moresby\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (512, 'Pacific/Rarotonga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (513, 'Pacific/Saipan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (514, 'Pacific/Samoa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (515, 'Pacific/Tahiti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (516, 'Pacific/Tarawa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (517, 'Pacific/Tongatapu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (518, 'Pacific/Truk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (519, 'Pacific/Wake\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (520, 'Pacific/Wallis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (521, 'Pacific/Yap\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (522, 'Poland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (523, 'Portugal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (524, 'PRC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (525, 'PST8PDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (526, 'ROC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (527, 'ROK\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (528, 'Singapore\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (529, 'Turkey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (530, 'UCT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (531, 'Universal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (532, 'US/Alaska\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (533, 'US/Aleutian\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (534, 'US/Arizona\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (535, 'US/Central\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (536, 'US/Eastern\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (537, 'US/East-Indiana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (538, 'US/Hawaii\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (539, 'US/Indiana-Starke\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (540, 'US/Michigan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (541, 'US/Mountain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (542, 'US/Pacific\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (543, 'US/Pacific-New\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (544, 'US/Samoa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (545, 'UTC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (546, 'WET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (547, 'W-SU\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (548, 'Zulu\r', 1);


#
# TABLE STRUCTURE FOR: db_twilio
#

DROP TABLE IF EXISTS `db_twilio`;

CREATE TABLE `db_twilio` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `account_sid` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `auth_token` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `twilio_phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  `status` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_twilio_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_twilio` (`id`, `store_id`, `account_sid`, `auth_token`, `twilio_phone`, `status`) VALUES (1, 1, '', '', '', 0);
INSERT INTO `db_twilio` (`id`, `store_id`, `account_sid`, `auth_token`, `twilio_phone`, `status`) VALUES (3, 2, '', '', '', 0);


#
# TABLE STRUCTURE FOR: db_units
#

DROP TABLE IF EXISTS `db_units`;

CREATE TABLE `db_units` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `unit_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `company_id` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_units_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (61, 2, 'PCS', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (62, 2, 'KG', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (63, 2, 'test', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_users
#

DROP TABLE IF EXISTS `db_users`;

CREATE TABLE `db_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `username` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` blob,
  `member_of` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `firstname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo` blob,
  `gender` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` blob,
  `postcode` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role_id` int DEFAULT NULL,
  `profile_picture` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_ip` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` double DEFAULT NULL,
  `creater_id` int DEFAULT NULL,
  `updater_id` int DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `default_warehouse_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_users_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`, `default_warehouse_id`) VALUES (1, 1, 'user_838594', 'Admin', 'Power', 'e10adc3949ba59abbe56e057f20f883e', '', NULL, NULL, '', 'super@example.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'uploads/users/admin.png', '2018-11-27', '::1', NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`, `default_warehouse_id`) VALUES (2, 2, 'user_599174', 'Chris', 'Morris', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '9999999999', 'admin@example.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, 'uploads/users/avatar1.png', '2021-02-12', '05:53:37 pm', '', '127.0.0.1', 'LAPTOP-I5OUIM4R', '1', NULL, NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`, `default_warehouse_id`) VALUES (101, 2, 'user_480088', 'Salman', 'Khan', 'e10adc3949ba59abbe56e057f20f883e', NULL, NULL, NULL, '', 'salman@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 31, NULL, '2022-08-09', '02:05:40 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', '1', NULL, NULL, NULL, 86);


#
# TABLE STRUCTURE FOR: db_userswarehouses
#

DROP TABLE IF EXISTS `db_userswarehouses`;

CREATE TABLE `db_userswarehouses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_userswarehouses_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `db_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_userswarehouses_ibfk_2` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_userswarehouses` (`id`, `user_id`, `warehouse_id`) VALUES (76, 101, 86);


#
# TABLE STRUCTURE FOR: db_variants
#

DROP TABLE IF EXISTS `db_variants`;

CREATE TABLE `db_variants` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `variant_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `variant_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_variants_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_variants_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_warehouse
#

DROP TABLE IF EXISTS `db_warehouse`;

CREATE TABLE `db_warehouse` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `warehouse_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_warehouse_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (1, 1, 'System', 'Warehouse-A', '', 'warehouse_a@example.com', 1, NULL);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (2, 2, 'System', 'System Warehouse', '', '', 1, NULL);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (86, 2, 'Custom', 'Al Amerat Store', '', '', 1, NULL);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (87, 2, 'Custom', 'iron shop', '', '', 1, '2025-08-20');


#
# TABLE STRUCTURE FOR: db_warehouseitems
#

DROP TABLE IF EXISTS `db_warehouseitems`;

CREATE TABLE `db_warehouseitems` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `warehouse_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `available_qty` double(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `db_warehouseitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_warehouseitems_ibfk_2` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_warehouseitems_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5057 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4295, NULL, 2, 1, '201.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4296, NULL, 2, 5, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4297, NULL, 2, 6, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4298, NULL, 2, 8, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4299, NULL, 2, 7, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4300, NULL, 2, 9, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4301, NULL, 2, 10, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4302, NULL, 2, 12, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4303, NULL, 2, 13, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4304, NULL, 2, 15, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4305, NULL, 2, 16, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4306, NULL, 2, 17, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4307, NULL, 2, 18, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4308, NULL, 2, 19, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4309, NULL, 2, 20, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4310, NULL, 2, 22, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4311, NULL, 2, 23, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4312, NULL, 2, 24, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4313, NULL, 2, 25, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4314, NULL, 2, 26, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4315, NULL, 2, 27, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4316, NULL, 2, 28, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4317, NULL, 2, 29, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4318, NULL, 2, 30, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4319, NULL, 2, 31, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4320, NULL, 2, 32, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4321, NULL, 2, 33, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4322, NULL, 2, 34, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4323, NULL, 2, 35, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4324, NULL, 2, 37, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4325, NULL, 2, 36, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4326, NULL, 2, 38, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4327, NULL, 2, 39, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4328, NULL, 2, 40, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4329, NULL, 2, 41, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4330, NULL, 2, 42, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4331, NULL, 2, 43, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4332, NULL, 2, 44, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4333, NULL, 2, 4, '200.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4334, NULL, 2, 11, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4335, NULL, 2, 14, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4336, NULL, 2, 21, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4337, NULL, 2, 45, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4338, NULL, 2, 46, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4339, NULL, 2, 47, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4340, NULL, 2, 48, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4341, NULL, 2, 49, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4342, NULL, 2, 50, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4343, NULL, 2, 51, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4344, NULL, 2, 52, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4345, NULL, 2, 53, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4346, NULL, 2, 54, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4347, NULL, 2, 55, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4348, NULL, 2, 56, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4349, NULL, 2, 57, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4350, NULL, 2, 58, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4351, NULL, 2, 59, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4352, NULL, 2, 60, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4353, NULL, 2, 61, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4354, NULL, 2, 62, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4355, NULL, 2, 63, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4356, NULL, 2, 64, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4357, NULL, 2, 65, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4358, NULL, 2, 66, '300.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4359, NULL, 2, 67, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4360, NULL, 2, 68, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4361, NULL, 2, 69, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4362, NULL, 2, 70, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4363, NULL, 2, 71, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4364, NULL, 2, 72, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4365, NULL, 2, 73, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4366, NULL, 2, 74, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4367, NULL, 2, 75, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4368, NULL, 2, 76, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4369, NULL, 2, 77, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4370, NULL, 2, 78, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4371, NULL, 2, 79, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4372, NULL, 2, 80, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4373, NULL, 2, 81, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4374, NULL, 2, 82, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4375, NULL, 2, 83, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4376, NULL, 2, 84, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4377, NULL, 2, 85, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4378, NULL, 2, 86, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4379, NULL, 2, 87, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4380, NULL, 2, 88, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4381, NULL, 2, 89, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4382, NULL, 2, 90, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4383, NULL, 2, 91, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4384, NULL, 2, 92, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4385, NULL, 2, 93, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4386, NULL, 2, 94, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4387, NULL, 2, 95, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4388, NULL, 2, 96, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4389, NULL, 2, 97, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4390, NULL, 2, 98, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4391, NULL, 2, 99, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4392, NULL, 2, 100, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4393, NULL, 2, 101, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4394, NULL, 2, 102, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4395, NULL, 2, 103, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4396, NULL, 2, 104, '90.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4397, NULL, 2, 105, '90.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4398, NULL, 2, 106, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4399, NULL, 2, 107, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4400, NULL, 2, 108, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4401, NULL, 2, 109, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4402, NULL, 2, 111, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4403, NULL, 2, 110, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4404, NULL, 2, 112, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4405, NULL, 2, 113, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4406, NULL, 2, 114, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4407, NULL, 2, 115, '600.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4408, NULL, 2, 116, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4409, NULL, 2, 117, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4410, NULL, 2, 118, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4411, NULL, 2, 119, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4412, NULL, 2, 120, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4413, NULL, 2, 121, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4414, NULL, 2, 122, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4415, NULL, 2, 123, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4416, NULL, 2, 124, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4417, NULL, 2, 125, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4418, NULL, 2, 126, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4419, NULL, 2, 127, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4420, NULL, 2, 128, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4421, NULL, 2, 129, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4422, NULL, 2, 130, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4423, NULL, 2, 131, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4424, NULL, 2, 132, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4425, NULL, 2, 133, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4426, NULL, 2, 134, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4427, NULL, 2, 135, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4428, NULL, 2, 136, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4429, NULL, 2, 137, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4430, NULL, 2, 138, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4431, NULL, 2, 139, '52.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4432, NULL, 2, 140, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4433, NULL, 2, 141, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4434, NULL, 2, 142, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4435, NULL, 2, 143, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4436, NULL, 2, 144, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4437, NULL, 2, 145, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4438, NULL, 2, 146, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4439, NULL, 2, 147, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4440, NULL, 2, 148, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4441, NULL, 2, 149, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4442, NULL, 2, 150, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4443, NULL, 2, 151, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4444, NULL, 2, 152, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4445, NULL, 2, 154, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4446, NULL, 2, 155, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4447, NULL, 2, 157, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4448, NULL, 2, 158, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4449, NULL, 2, 159, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4450, NULL, 2, 160, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4451, NULL, 2, 161, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4452, NULL, 2, 162, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4453, NULL, 2, 163, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4454, NULL, 2, 164, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4455, NULL, 2, 165, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4456, NULL, 2, 166, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4457, NULL, 2, 167, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4458, NULL, 2, 168, '75.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4459, NULL, 2, 169, '70.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4460, NULL, 2, 170, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4461, NULL, 2, 171, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4462, NULL, 2, 172, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4463, NULL, 2, 173, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4464, NULL, 2, 174, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4465, NULL, 2, 175, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4466, NULL, 2, 176, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4467, NULL, 2, 177, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4468, NULL, 2, 178, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4469, NULL, 2, 179, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4470, NULL, 2, 180, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4471, NULL, 2, 181, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4472, NULL, 2, 182, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4473, NULL, 2, 183, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4474, NULL, 2, 184, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4475, NULL, 2, 185, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4476, NULL, 2, 186, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4477, NULL, 2, 187, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4478, NULL, 2, 188, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4479, NULL, 2, 189, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4480, NULL, 2, 153, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4481, NULL, 2, 156, '122.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4805, 2, 2, 29, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4807, 2, 2, 31, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4808, 2, 2, 32, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4809, 2, 2, 33, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4810, 2, 2, 34, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4811, 2, 2, 35, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4813, 2, 2, 37, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4814, 2, 2, 36, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4815, 2, 2, 38, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4816, 2, 2, 39, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4817, 2, 2, 40, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4818, 2, 2, 41, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4819, 2, 2, 42, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4820, 2, 2, 43, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4821, 2, 2, 44, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4830, 2, 2, 45, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4831, 2, 2, 46, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4832, 2, 2, 47, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4833, 2, 2, 48, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4834, 2, 2, 49, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4835, 2, 2, 50, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4836, 2, 2, 51, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4837, 2, 2, 52, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4838, 2, 2, 53, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4839, 2, 2, 54, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4840, 2, 2, 55, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4841, 2, 2, 56, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4842, 2, 2, 57, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4843, 2, 2, 58, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4844, 2, 2, 59, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4845, 2, 2, 60, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4846, 2, 2, 61, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4847, 2, 2, 62, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4848, 2, 2, 63, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4849, 2, 2, 64, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4850, 2, 2, 65, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4851, 2, 2, 66, '300.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4852, 2, 2, 67, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4853, 2, 2, 68, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4854, 2, 2, 69, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4855, 2, 2, 70, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4856, 2, 2, 71, '3.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4857, 2, 2, 72, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4858, 2, 2, 73, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4859, 2, 2, 74, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4860, 2, 2, 75, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4861, 2, 2, 76, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4862, 2, 2, 77, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4863, 2, 2, 78, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4864, 2, 2, 79, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4865, 2, 2, 80, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4866, 2, 2, 81, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4867, 2, 2, 82, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4868, 2, 2, 83, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4869, 2, 2, 84, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4870, 2, 2, 85, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4871, 2, 2, 86, '12.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4872, 2, 2, 87, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4873, 2, 2, 88, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4874, 2, 2, 89, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4875, 2, 2, 90, '6.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4876, 2, 2, 91, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4877, 2, 2, 92, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4878, 2, 2, 93, '2.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4879, 2, 2, 94, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4880, 2, 2, 95, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4881, 2, 2, 96, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4882, 2, 2, 97, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4883, 2, 2, 98, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4884, 2, 2, 99, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4886, 2, 2, 100, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4887, 2, 2, 101, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4888, 2, 2, 102, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4889, 2, 2, 103, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4890, 2, 2, 104, '90.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4891, 2, 2, 105, '90.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4892, 2, 2, 106, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4893, 2, 2, 107, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4894, 2, 2, 108, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4895, 2, 2, 109, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4897, 2, 2, 111, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4898, 2, 2, 110, '32.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4899, 2, 2, 112, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4900, 2, 2, 113, '16.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4901, 2, 2, 114, '4.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4902, 2, 2, 115, '600.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4903, 2, 2, 116, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4904, 2, 2, 117, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4905, 2, 2, 118, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4906, 2, 2, 119, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4909, 2, 2, 120, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4910, 2, 2, 121, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4911, 2, 2, 122, '5.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4912, 2, 2, 123, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4913, 2, 2, 124, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4914, 2, 2, 125, '60.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4915, 2, 2, 126, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4916, 2, 2, 127, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4917, 2, 2, 128, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4918, 2, 2, 129, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4919, 2, 2, 130, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4920, 2, 2, 131, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4921, 2, 2, 132, '100.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4922, 2, 2, 133, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4923, 2, 2, 134, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4924, 2, 2, 135, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4925, 2, 2, 136, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4926, 2, 2, 137, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4927, 2, 2, 138, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4928, 2, 2, 139, '52.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4929, 2, 2, 140, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4930, 2, 2, 141, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4931, 2, 2, 142, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4932, 2, 2, 143, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4933, 2, 2, 144, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4934, 2, 2, 145, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4935, 2, 2, 146, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4936, 2, 2, 147, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4937, 2, 2, 148, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4938, 2, 2, 149, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4939, 2, 2, 150, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4940, 2, 2, 151, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4941, 2, 2, 152, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4944, 2, 2, 154, '20.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4945, 2, 2, 155, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4947, 2, 2, 157, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4948, 2, 2, 158, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4949, 2, 2, 159, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4950, 2, 2, 160, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4951, 2, 2, 161, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4952, 2, 2, 162, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4953, 2, 2, 163, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4954, 2, 2, 164, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4955, 2, 2, 165, '10.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4956, 2, 2, 166, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4957, 2, 2, 167, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4958, 2, 2, 168, '75.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4959, 2, 2, 169, '70.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4960, 2, 2, 170, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4961, 2, 2, 171, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4962, 2, 2, 172, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4963, 2, 2, 173, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4964, 2, 2, 174, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4965, 2, 2, 175, '50.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4966, 2, 2, 176, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4967, 2, 2, 177, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4968, 2, 2, 178, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4969, 2, 2, 179, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4970, 2, 2, 180, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4971, 2, 2, 181, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4972, 2, 2, 182, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4973, 2, 2, 183, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4974, 2, 2, 184, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4975, 2, 2, 185, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4976, 2, 2, 186, '40.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4978, 2, 2, 187, '1.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4979, 2, 2, 188, '25.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4980, 2, 2, 189, '30.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4983, 2, 2, 153, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (4984, 2, 2, 156, '122.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5003, 2, 2, 30, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5020, 2, 2, 16, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5021, 2, 2, 17, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5022, 2, 2, 18, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5023, 2, 2, 19, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5024, 2, 2, 20, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5025, 2, 2, 21, '19.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5026, 2, 2, 22, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5027, 2, 2, 23, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5028, 2, 2, 24, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5029, 2, 2, 25, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5030, 2, 2, 26, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5031, 2, 2, 27, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5032, 2, 2, 28, '9.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5038, 2, 2, 5, '47.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5041, 2, 2, 8, '22.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5042, 2, 2, 9, '17.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5043, 2, 2, 10, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5044, 2, 2, 11, '37.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5045, 2, 2, 12, '18.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5046, 2, 2, 13, '7.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5047, 2, 2, 14, '96.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5048, 2, 2, 15, '8.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5050, 2, 2, 1, '215.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5051, 2, 2, 2, '71.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5052, 2, 2, 3, '48.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5053, 2, 2, 4, '196.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5054, 2, 2, 6, '26.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5055, 2, 2, 7, '56.00');
INSERT INTO `db_warehouseitems` (`id`, `store_id`, `warehouse_id`, `item_id`, `available_qty`) VALUES (5056, 2, 86, 2, '25.00');


#
# TABLE STRUCTURE FOR: db_whatsapp_logs
#

DROP TABLE IF EXISTS `db_whatsapp_logs`;

CREATE TABLE `db_whatsapp_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `store_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `phone_number` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'invoice, reminder, notification, manual',
  `message_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `reference_id` int DEFAULT NULL COMMENT 'Reference to sales_id, purchase_id 