<!DOCTYPE html>
<html>
<head>
    <?php include"comman/code_css.php"; ?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php include"sidebar.php"; ?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                WhatsApp Templates
                <small>Manage Message Templates</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="<?php echo $base_url; ?>whatsapp"><i class="fa fa-whatsapp"></i> WhatsApp</a></li>
                <li class="active">Templates</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <?php include"comman/code_flashdata.php"; ?>
                
                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">WhatsApp Message Templates</h3>
                            <div class="box-tools">
                                <button class="btn btn-info" data-toggle="modal" data-target="#add-template-modal">
                                    <i class="fa fa-plus"></i> Add Custom Template
                                </button>
                            </div>
                        </div>
                        
                        <div class="box-body">
                            <table id="templates_table" class="table table-bordered custom_hover" width="100%">
                                <thead class="bg-gray">
                                    <tr>
                                        <th>Template Name</th>
                                        <th>Type</th>
                                        <th>Subject</th>
                                        <th>Content</th>
                                        <th>Status</th>
                                        <th style="width:10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Add Template Modal -->
    <div class="modal fade" id="add-template-modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Add New Template</h4>
                </div>
                <form id="add-template-form">
                    <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                    <input type="hidden" id="base_url" value="<?php echo $base_url; ?>">
                    
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Template Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="template_name" id="new_template_name" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Template Type <span class="text-danger">*</span></label>
                            <select class="form-control" name="template_type" id="new_template_type" required>
                                <option value="">Select Type</option>
                                <option value="invoice">Invoice</option>
                                <option value="reminder">Payment Reminder</option>
                                <option value="notification">Notification</option>
                                <option value="welcome">Welcome</option>
                                <option value="custom">Custom</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label>Subject</label>
                            <input type="text" class="form-control" name="template_subject" id="new_template_subject">
                        </div>
                        
                        <div class="form-group">
                            <label>Template Content <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="template_content" id="new_template_content" rows="8" required></textarea>
                            <small class="text-muted">Use variables like {CUSTOMER_NAME}, {BUSINESS_NAME}, etc.</small>
                        </div>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Save Template</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include"footer.php"; ?>
    <div class="control-sidebar-bg"></div>
</div>

<?php include"comman/code_js_sound.php"; ?>
<?php include"comman/code_js.php"; ?>

<script type="text/javascript">
$(document).ready(function() {
    var table = $('#templates_table').DataTable({
        dom:'<"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr><"pull-right margin-left-10 "B>>>t<"row"<"col-sm-5"i><"col-sm-7"p>>',
        buttons: {
            buttons: [
                { extend: 'copy', className: 'btn' },
                { extend: 'csv', className: 'btn' },
                { extend: 'excel', className: 'btn' },
                { extend: 'print', className: 'btn' },
                { extend: 'pdf', className: 'btn' }
            ]
        },
        "processing": true,
        "serverSide": true,
        "order": [],
        "responsive": true,
        language: {
            processing: '<i class="fa fa-spinner fa-spin fa-2x fa-fw"></i><span class="sr-only">Loading...</span> '
        },
        "ajax": {
            "url": "<?php echo site_url('whatsapp/templates_ajax_list')?>",
            "type": "POST"
        },
        "columnDefs": [
            { 
                "targets": [ 5 ],
                "orderable": false,
            }
        ],
    });

    // Add template form submission
    $('#add-template-form').on('submit', function(e) {
        e.preventDefault();
        var base_url = $("#base_url").val();
        
        $.ajax({
            type: 'POST',
            url: base_url + 'whatsapp/add_template',
            data: $(this).serialize(),
            success: function(result) {
                if(result == "success") {
                    toastr["success"]("Template added successfully!");
                    $('#add-template-modal').modal('hide');
                    $('#add-template-form')[0].reset();
                    table.ajax.reload();
                } else {
                    toastr["error"](result);
                }
            },
            error: function() {
                toastr["error"]("An error occurred. Please try again!");
            }
        });
    });
});

// Update template status
function update_template_status(id, status) {
    var base_url = $("#base_url").val();
    if(confirm("Do you want to change the status?")) {
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $.post(base_url + "whatsapp/update_template_status", {id: id, status: status}, function(result) {
            if(result == "success") {
                toastr["success"]("Status updated successfully!");
                $('#templates_table').DataTable().ajax.reload();
            } else {
                toastr["error"]("Failed to update status!");
            }
            $(".overlay").remove();
        });
    }
}

// Delete template
function delete_template(id) {
    var base_url = $("#base_url").val();
    if(confirm("Do you want to delete this template?")) {
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $.post(base_url + "whatsapp/delete_template", {template_id: id}, function(result) {
            if(result == "success") {
                toastr["success"]("Template deleted successfully!");
                $('#templates_table').DataTable().ajax.reload();
            } else {
                toastr["error"](result);
            }
            $(".overlay").remove();
        });
    }
}
</script>

<script>$(".whatsapp-templates-active-li").addClass("active");</script>
</body>
</html>
