<!DOCTYPE html>
<html>
<head>
    <?php include"comman/code_css.php"; ?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php include"sidebar.php"; ?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                WhatsApp Message Logs
                <small>View sent and received messages</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="<?php echo $base_url; ?>whatsapp"><i class="fa fa-whatsapp"></i> WhatsApp</a></li>
                <li class="active">Message Logs</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <?php include"comman/code_flashdata.php"; ?>
                
                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">WhatsApp Message History</h3>
                            <div class="box-tools">
                                <div class="btn-group">
                                    <button class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                                        Filter <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu pull-right">
                                        <li><a href="#" onclick="filterLogs('all')">All Messages</a></li>
                                        <li><a href="#" onclick="filterLogs('sent')">Sent</a></li>
                                        <li><a href="#" onclick="filterLogs('failed')">Failed</a></li>
                                        <li><a href="#" onclick="filterLogs('pending')">Pending</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="box-body">
                            <table id="logs_table" class="table table-bordered custom_hover" width="100%">
                                <thead class="bg-gray">
                                    <tr>
                                        <th>Phone Number</th>
                                        <th>Message Type</th>
                                        <th>Message Content</th>
                                        <th>Status</th>
                                        <th>Sent At</th>
                                        <th style="width:10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Message Details Modal -->
    <div class="modal fade" id="message-details-modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Message Details</h4>
                </div>
                <div class="modal-body" id="message-details-content">
                    <!-- Content will be loaded here -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <?php include"footer.php"; ?>
    <div class="control-sidebar-bg"></div>
</div>

<?php include"comman/code_js_sound.php"; ?>
<?php include"comman/code_js.php"; ?>

<script type="text/javascript">
var logs_table;

$(document).ready(function() {
    logs_table = $('#logs_table').DataTable({
        dom:'<"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr><"pull-right margin-left-10 "B>>>t<"row"<"col-sm-5"i><"col-sm-7"p>>',
        buttons: {
            buttons: [
                { extend: 'copy', className: 'btn' },
                { extend: 'csv', className: 'btn' },
                { extend: 'excel', className: 'btn' },
                { extend: 'print', className: 'btn' },
                { extend: 'pdf', className: 'btn' }
            ]
        },
        "processing": true,
        "serverSide": true,
        "order": [[4, "desc"]],
        "responsive": true,
        language: {
            processing: '<i class="fa fa-spinner fa-spin fa-2x fa-fw"></i><span class="sr-only">Loading...</span> '
        },
        "ajax": {
            "url": "<?php echo site_url('whatsapp/logs_ajax_list')?>",
            "type": "POST"
        },
        "columnDefs": [
            { 
                "targets": [ 5 ],
                "orderable": false,
            }
        ],
    });
});

// View message details
function view_log_details(id) {
    var base_url = $("#base_url").val();
    
    $.ajax({
        type: 'GET',
        url: base_url + 'whatsapp/view_log/' + id,
        dataType: 'json',
        success: function(log) {
            var content = `
                <div class="row">
                    <div class="col-md-6">
                        <strong>Phone Number:</strong><br>
                        ${log.phone_number || 'N/A'}
                    </div>
                    <div class="col-md-6">
                        <strong>Message Type:</strong><br>
                        <span class="label label-info">${log.message_type || 'N/A'}</span>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-6">
                        <strong>Status:</strong><br>
                        <span class="label ${getStatusClass(log.status)}">${log.status || 'N/A'}</span>
                    </div>
                    <div class="col-md-6">
                        <strong>Sent At:</strong><br>
                        ${log.sent_at || 'N/A'}
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-12">
                        <strong>Message Content:</strong><br>
                        <div class="well well-sm">${log.message_content || 'N/A'}</div>
                    </div>
                </div>
                ${log.response_data ? `
                <div class="row">
                    <div class="col-md-12">
                        <strong>API Response:</strong><br>
                        <pre class="well well-sm" style="max-height: 200px; overflow-y: auto;">${log.response_data}</pre>
                    </div>
                </div>
                ` : ''}
                ${log.error_message ? `
                <div class="row">
                    <div class="col-md-12">
                        <strong>Error Message:</strong><br>
                        <div class="alert alert-danger">${log.error_message}</div>
                    </div>
                </div>
                ` : ''}
            `;
            
            $('#message-details-content').html(content);
            $('#message-details-modal').modal('show');
        },
        error: function() {
            toastr["error"]("Failed to load message details!");
        }
    });
}

function getStatusClass(status) {
    switch(status) {
        case 'sent': return 'label-success';
        case 'failed': return 'label-danger';
        case 'pending': return 'label-warning';
        default: return 'label-default';
    }
}

// Filter logs
function filterLogs(status) {
    // You can implement server-side filtering here
    // For now, we'll just reload the table
    logs_table.ajax.reload();
}
</script>

<script>$(".whatsapp-logs-active-li").addClass("active");</script>
</body>
</html>
