<!DOCTYPE html>
<html>

<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <!-- Left side column. contains the logo and sidebar -->
  
  <?php include"sidebar.php"; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Sales Types List
        <small>View/Search Sales Types</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Sales Types List</li>
      </ol>
    </section>

  <!-- Main content -->
  <section class="content">
    <div class="row">
      <!-- ********** ALERT MESSAGE START******* -->
      <?php include"comman/code_flashdata.php"; ?>
      <!-- ********** ALERT MESSAGE END******* -->
      <input type="hidden" id='base_url' value="<?=$base_url;?>">
      <div class="col-xs-12">
        <div class="box box-primary">
          <div class="box-header with-border">
            <h3 class="box-title">Sales Types List</h3>
            <?php if($CI->permissions('sales_types_add')) { ?>
            <div class="box-tools">
              <a class="btn btn-block btn-info" href="<?php echo $base_url; ?>sales_types/add">
              <i class="fa fa-plus"></i> New Sales Type</a>
            </div>
            <?php } ?>
          </div>
          <!-- /.box-header -->
          <div class="box-body">
            <table id="example2" class="table table-bordered custom_hover" width="100%">
              <thead class="bg-gray ">
                <tr>
                  <th>Sales Type Name</th>
                  <th>Short Code</th>
                  <th>Description</th>
                  <th>Status</th>
                  <th style="width:10%">Action</th>
                </tr>
              </thead>
              <tbody>
              
              </tbody>
            </table>
          </div><!-- /.box-body -->
        </div><!-- /.box -->
      </div><!-- /.col -->
    </div><!-- /.row -->
  </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<?php include"footer.php"; ?>
<!-- Add the sidebar's background. This div must be placed
     immediately after the control sidebar -->
<div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>

<script type="text/javascript">
$(document).ready(function() {
    //datatables
   var table = $('#example2').DataTable({ 

      /* FOR EXPORT BUTTONS START*/
  dom:'<"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr><"pull-right margin-left-10 "B>>>tip',
 /* dom:'<"row"<"col-sm-12"<"pull-left"B><"pull-right">>> <"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr>>>tip',*/
      buttons: {
        buttons: [
            {
                className: 'btn bg-red color-palette btn-flat hidden delete_btn pull-left',
                text: 'Delete',
                action: function ( e, dt, node, config ) {
                    multi_delete();
                }
            },
            { extend: 'copy', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: ':visible'} },
            { extend: 'excel', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: ':visible'} },
            { extend: 'pdf', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: ':visible'} },
            { extend: 'print', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: ':visible'} },
            { extend: 'csv', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: ':visible'} },
            { extend: 'colvis', className: 'btn bg-teal color-palette btn-flat',text:'Columns' },  

            ]
        },
        /* FOR EXPORT BUTTONS END */

        "processing": true, //Feature control the processing indicator.
        "serverSide": true, //Feature control DataTables' server-side processing mode.
        "order": [], //Initial no order.
        "responsive": true,
        language: {
            processing: '<div class="text-primary bg-primary" style="position: relative;z-index:100;overflow: visible;">Processing...</div>'
        },
        // Load data for the table's content from an Ajax source
        "ajax": {
            "url": "<?php echo site_url('sales_types/ajax_list')?>",
            "type": "POST",
            
            complete: function (data) {
             /*$('.column_checkbox').iCheck({
                checkboxClass: 'icheckbox_square-orange',
                //uncheckedClass: 'bg-white',
                radioClass: 'iradio_square-orange',
                increaseArea: '10%' // optional
              });*/
             //call_code();
              //$(".delete_btn").hide();
             },

        },

        //Set column definition initialisation properties.
        "columnDefs": [
        { 
            "targets": [ 4 ], //last column / action column
            "orderable": false, //set not orderable
        },
        {
            "targets" :[],
            "className": "text-center",
        },
        
        ],
    });
    new $.fn.dataTable.FixedHeader( table );
});

//Delete Item
function delete_sales_type(q_id){
  var base_url=$("#base_url").val();
  if(confirm("Do you Want to Delete ?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url+"sales_types/delete_sales_type",{q_id:q_id},function(result){
       if(result=="success"){
          toastr["success"]("Record Deleted Successfully!");
          $('#example2').DataTable().ajax.reload();
       }else{
          toastr["error"]("Failed to Delete Record!");
       }
       $(".overlay").remove();
    });
  }
}

//Update Status
function update_status(id,status){
  var base_url=$("#base_url").val();
  if(confirm("Do you want to change the status?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url+"sales_types/update_status",{id:id,status:status},function(result){
       if(result=="success"){
          toastr["success"]("Status Updated Successfully!");
          $('#example2').DataTable().ajax.reload();
       }else{
          toastr["error"]("Failed to Update Status!");
       }
       $(".overlay").remove();
    });
  }
}

//Multi Delete
function multi_delete(){
  var base_url=$("#base_url").val();
  var o=[];
  $('.column_checkbox:checked').each(function(){
    o.push($(this).val());
  });
  if(o.length==0){
    toastr["warning"]("Please Select atleast one Record!");
    return;
  }
  if(confirm("Do you Want to Delete these Records?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url+"sales_types/multi_delete",{checkbox:o},function(result){
       if(result=="success"){
          toastr["success"]("Records Deleted Successfully!");
          $('#example2').DataTable().ajax.reload();
       }else{
          toastr["error"]("Failed to Delete Records!");
       }
       $(".overlay").remove();
    });
  }
}

//Select all
$("#select_all").change(function(){  //"select all" change 
    $(".column_checkbox").prop('checked', $(this).prop("checked")); //change all ".checkbox" checked status
});
//".checkbox" change 
$('.column_checkbox').change(function(){
    //uncheck "select all", if one of the listed checkbox item is unchecked
    if(false == $(this).prop("checked")){ //if this item is unchecked
        $("#select_all").prop('checked', false); //change "select all" checked status to false
    }
    //check "select all" if all checkbox items are checked
    if ($('.column_checkbox:checked').length == $('.column_checkbox').length ){
        $("#select_all").prop('checked', true);
    }
});
</script>
<script src="<?php echo $theme_link; ?>js/sales_types.js"></script>
<!-- Make sidebar menu hughlighter/selector -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
</body>
</html>
