<?php include "header.php"; ?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <?=$page_title;?>
      <small>Add New Sales Type</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
      <li><a href="<?php echo $base_url; ?>sales_types">Sales Types</a></li>
      <li class="active"><?=$page_title;?></li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="row">
      <!-- ********** ALERT MESSAGE START******* -->
      <?php include "alerts.php"; ?>
      <!-- ********** ALERT MESSAGE END******* -->
      <div class="col-md-12">
        <div class="box">
          <div class="box-header with-border">
            <h3 class="box-title"><?=$page_title;?></h3>
            <div class="box-tools pull-right">
              <a class="btn btn-primary btn-sm" href="<?=base_url('sales_types')?>" ><i class="fa fa-arrow-left"></i> Back</a>
            </div>
          </div>
          <!-- /.box-header -->
          <div class="box-body">
            <form class="form-horizontal" method="post" enctype="multipart/form-data" id="sales_type_form">
              <div class="row">
                <div class="col-md-8">
                  <div class="form-group">
                    <label for="type_name" class="col-sm-3 control-label">Sales Type Name *</label>
                    <div class="col-sm-6">
                      <input type="text" class="form-control" id="type_name" name="type_name" placeholder="Enter Sales Type Name" autofocus>
                      <span id="type_name_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>

                  <div class="form-group">
                    <label for="short_code" class="col-sm-3 control-label">Short Code *</label>
                    <div class="col-sm-6">
                      <input type="text" class="form-control" id="short_code" name="short_code" placeholder="Enter Short Code" maxlength="10" style="text-transform: uppercase;">
                      <span id="short_code_msg" style="display:none" class="text-danger"></span>
                      <span class="help-block">Maximum 10 characters (e.g., FC, AM, MO)</span>
                    </div>
                  </div>

                  <div class="form-group">
                    <label for="description" class="col-sm-3 control-label">Description</label>
                    <div class="col-sm-6">
                      <textarea class="form-control" id="description" name="description" placeholder="Enter Description" rows="3"></textarea>
                    </div>
                  </div>

                  <div class="form-group">
                    <label for="sort_order" class="col-sm-3 control-label">Sort Order</label>
                    <div class="col-sm-6">
                      <input type="number" class="form-control" id="sort_order" name="sort_order" placeholder="Enter Sort Order" value="0" min="0">
                      <span class="help-block">Lower numbers appear first</span>
                    </div>
                  </div>

                  <div class="form-group">
                    <label for="status" class="col-sm-3 control-label">Status</label>
                    <div class="col-sm-6">
                      <div class="checkbox checkbox-success">
                        <input type="checkbox" id="status" name="status" value="1" checked>
                        <label for="status">Active</label>
                      </div>
                    </div>
                  </div>

                  <div class="form-group">
                    <div class="col-sm-offset-3 col-sm-6">
                      <button type="button" class="btn btn-success" id="save"><i class="fa fa-save"></i> Save</button>
                      <button type="button" class="btn btn-danger" onclick="window.location='<?=base_url('sales_types')?>'"><i class="fa fa-ban"></i> Cancel</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
          </div>
          <!-- /.box-body -->
        </div>
        <!-- /.box -->
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
  </section>
  <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php include "footer.php"; ?>

<!-- Form validation scripts -->
<script type="text/javascript">
  $(document).ready(function(){
    // Auto uppercase short code
    $('#short_code').on('input', function(){
      this.value = this.value.toUpperCase();
    });

    $('#save').click(function(){
      var type_name = $('#type_name').val();
      var short_code = $('#short_code').val();

      if(type_name.length == 0){
        toastr.error('Sales Type Name is required!');
        $('#type_name').focus();
        return false;
      }
      if(short_code.length == 0){
        toastr.error('Short Code is required!');
        $('#short_code').focus();
        return false;
      }

      $('#save').attr('disabled', true);
      $('#save').html('<i class="fa fa-refresh fa-spin"></i> Saving...');

      var formData = new FormData($('#sales_type_form')[0]);

      $.ajax({
        url: '<?=base_url()?>sales_types/add_sales_type',
        method: 'POST',
        data: formData,
        cache: false,
        contentType: false,
        processData: false,
        success: function(data) {
          if (data == "Sales type added successfully!") {
            toastr.success(data);
            setTimeout(function(){
              window.location = '<?=base_url()?>sales_types';
            }, 1000);
          } else {
            toastr.error(data);
            $('#save').attr('disabled', false);
            $('#save').html('<i class="fa fa-save"></i> Save');
          }
        },
        error: function(){
          toastr.error('Something went wrong!');
          $('#save').attr('disabled', false);
          $('#save').html('<i class="fa fa-save"></i> Save');
        }
      });
    });
  });
</script>
