<!-- Sales Type Add Modal -->
<div class="modal fade" id="sales_type_modal" tabindex="-1" role="dialog" aria-labelledby="salesTypeModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="salesTypeModalLabel">Add Sales Type</h4>
      </div>
      <form id="sales_type_modal_form">
        <div class="modal-body">
          <div class="form-group">
            <label for="modal_type_name">Sales Type Name *</label>
            <input type="text" class="form-control" id="modal_type_name" name="type_name" placeholder="Enter Sales Type Name" required>
          </div>
          
          <div class="form-group">
            <label for="modal_short_code">Short Code *</label>
            <input type="text" class="form-control" id="modal_short_code" name="short_code" placeholder="Enter Short Code" maxlength="10" style="text-transform: uppercase;" required>
            <span class="help-block">Maximum 10 characters (e.g., FC, AM, MO)</span>
          </div>
          
          <div class="form-group">
            <label for="modal_description">Description</label>
            <textarea class="form-control" id="modal_description" name="description" placeholder="Enter Description" rows="3"></textarea>
          </div>
          
          <div class="form-group">
            <label for="modal_sort_order">Sort Order</label>
            <input type="number" class="form-control" id="modal_sort_order" name="sort_order" placeholder="Enter Sort Order" value="0" min="0">
            <span class="help-block">Lower numbers appear first</span>
          </div>
          
          <div class="form-group">
            <div class="checkbox">
              <label>
                <input type="checkbox" id="modal_status" name="status" value="1" checked> Active
              </label>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" id="modal_save">Save Sales Type</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script type="text/javascript">
$(document).ready(function(){
  // Auto uppercase short code in modal
  $('#modal_short_code').on('input', function(){
    this.value = this.value.toUpperCase();
  });

  $('#modal_save').click(function(){
    var type_name = $('#modal_type_name').val();
    var short_code = $('#modal_short_code').val();

    if(type_name.length == 0){
      toastr.error('Sales Type Name is required!');
      $('#modal_type_name').focus();
      return false;
    }
    if(short_code.length == 0){
      toastr.error('Short Code is required!');
      $('#modal_short_code').focus();
      return false;
    }

    $('#modal_save').attr('disabled', true);
    $('#modal_save').html('<i class="fa fa-refresh fa-spin"></i> Saving...');

    var formData = new FormData($('#sales_type_modal_form')[0]);

    $.ajax({
      url: '<?=base_url()?>sales_types/add_sales_type',
      method: 'POST',
      data: formData,
      cache: false,
      contentType: false,
      processData: false,
      success: function(data) {
        if (data == "Sales type added successfully!") {
          toastr.success(data);
          $('#sales_type_modal').modal('hide');
          // Reset form
          $('#sales_type_modal_form')[0].reset();
          $('#modal_status').prop('checked', true);
          $('#modal_sort_order').val('0');
          
          // Refresh any select lists if needed
          if(typeof refresh_sales_types_select === 'function'){
            refresh_sales_types_select();
          }
        } else {
          toastr.error(data);
        }
        $('#modal_save').attr('disabled', false);
        $('#modal_save').html('Save Sales Type');
      },
      error: function(){
        toastr.error('Something went wrong!');
        $('#modal_save').attr('disabled', false);
        $('#modal_save').html('Save Sales Type');
      }
    });
  });

  // Reset form when modal is closed
  $('#sales_type_modal').on('hidden.bs.modal', function () {
    $('#sales_type_modal_form')[0].reset();
    $('#modal_status').prop('checked', true);
    $('#modal_sort_order').val('0');
    $('#modal_save').attr('disabled', false);
    $('#modal_save').html('Save Sales Type');
  });
});
</script>
