<!DOCTYPE html>
<html>
<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<style type="text/css">
	body{
		font-family: 'Courier New', Consolas, monospace;
		font-size: 11px;
		font-weight: bold;
		padding: 5px;
		margin: 0;
		background-color: #fafafa;
		color: #000;
		line-height: 1.2;
		width: 350px;
		max-width: 350px;
	}

	@media print {
        .no-print { display: none; }
        body { 
        	background-color: white; 
        	width: 80mm;
        	max-width: 80mm;
        	margin: 0;
        	padding: 3mm;
        }
    }
    
    .text-bold { font-weight: bold; }
    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-uppercase { text-transform: uppercase; }
    
    table {
    	font-family: 'Courier New', monospace;
    	font-size: 11px;
    }
    
    .thermal-divider {
    	border-top: 1px dashed #000;
    	margin: 5px 0;
    }
</style>
</head>
<body onload="window.print();">
	<?php
	$CI =& get_instance();
	
	$q3=$this->db->query("SELECT b.coupon_id,b.coupon_amt, b.created_by, b.customer_previous_due,b.customer_total_due,b.store_id,a.customer_name,a.mobile,a.phone,a.gstin,a.tax_number,a.email,a.delete_bit,b.invoice_terms,
                           a.opening_balance,a.country_id,a.state_id,
                           a.postcode,a.address,b.sales_date,b.created_time,b.reference_no,
                           b.sales_code,b.sales_note,a.sales_due,
                           coalesce(b.grand_total,0) as grand_total,
                           coalesce(b.subtotal,0) as subtotal,
                           coalesce(b.paid_amount,0) as paid_amount,
                           coalesce(b.other_charges_input,0) as other_charges_input,
                           other_charges_tax_id,
                           coalesce(b.other_charges_amt,0) as other_charges_amt,
                           discount_to_all_input,
                           b.discount_to_all_type,
                           coalesce(b.tot_discount_to_all_amt,0) as tot_discount_to_all_amt,
                           coalesce(b.round_off,0) as round_off,
                           b.payment_status

                           FROM db_customers a,
                           db_sales b 
                           WHERE 
                           a.`id`=b.`customer_id` AND 
                           b.`id`='$sales_id' 
                           ");
                          
    $res3=$q3->row();
    $customer_name=$res3->customer_name;
    $customer_mobile=$res3->mobile;
    $customer_phone=$res3->phone;
    $customer_email=$res3->email;
    $customer_country=$res3->country_id;
    $customer_state=$res3->state_id;
    $customer_address=$res3->address;
    $customer_postcode=$res3->postcode;
    $customer_gst_no=$res3->gstin;
    $customer_tax_number=$res3->tax_number;
    $customer_opening_balance=$res3->opening_balance;
    $sales_date=show_date($res3->sales_date);
    $reference_no=$res3->reference_no;
    $created_time=show_time($res3->created_time);
    $sales_code=$res3->sales_code;
    $sales_note=$res3->sales_note;
    $customer_delete_bit=$res3->delete_bit;
   // $invoice_terms=nl2br($res3->invoice_terms);

    $previous_due=$res3->sales_due-($res3->grand_total-$res3->paid_amount);//$res3->customer_previous_due;
    $previous_due = ($previous_due>0) ? $previous_due : 0;
    $total_due=$res3->sales_due;//$res3->customer_total_due;

    $coupon_id=$res3->coupon_id;
    $coupon_amt=$res3->coupon_amt;

    $coupon_code = '';
    $coupon_type = '';
    $coupon_value=0;
    if(!empty($coupon_id)){
    	$coupon_details =get_customer_coupon_details($coupon_id);
    	$coupon_code =$coupon_details->code;
    	$coupon_value =$coupon_details->value;
    	$coupon_type =$coupon_details->type;
    }

    $subtotal=$res3->subtotal;
    $grand_total=$res3->grand_total;
    $other_charges_input=$res3->other_charges_input;
    $other_charges_tax_id=$res3->other_charges_tax_id;
    $other_charges_amt=$res3->other_charges_amt;
    $paid_amount=$res3->paid_amount;
    $discount_to_all_input=$res3->discount_to_all_input;
    $discount_to_all_type=$res3->discount_to_all_type;
    //$discount_to_all_type = ($discount_to_all_type=='in_percentage') ? '%' : 'Fixed';
    $tot_discount_to_all_amt=$res3->tot_discount_to_all_amt;
    $round_off=$res3->round_off;
    $payment_status=$res3->payment_status;
    
    if($discount_to_all_input>0){
    	$str="($discount_to_all_input%)";
    }else{
    	$str="(Fixed)";
    }


    if(!empty($customer_state)){
      $q6 = $this->db->query("select state from db_states where id='$customer_state'");
      if($q6->num_rows()>0){
      	$customer_state = $q6->row()->state;
      }
    }

    $overall_discounted = $tot_discount_to_all_amt + $coupon_amt;

    $q1=$this->db->query("select * from db_store where id=".$res3->store_id." ");
    $res1=$q1->row();
    $store_name		=$res1->store_name;
    $company_mobile		=$res1->mobile;
    $company_phone		=$res1->phone;
    $company_email		=$res1->email;
    $company_country	=$res1->country;
    $company_state		=$res1->state;
    $company_city		=$res1->city;
    $company_address	=$res1->address;
    $company_postcode	=$res1->postcode;
    $company_gst_no		=$res1->gst_no;//Goods and Service Tax Number (issued by govt.)
    $company_vat_number		=$res1->vat_no;//Goods and Service Tax Number (issued by govt.)
    $store_logo=(!empty($res1->store_logo)) ? $res1->store_logo : store_demo_logo();
    $store_website		=$res1->store_website;
    $mrp_column		=$res1->mrp_column;
    $previous_balance_bit	=$res1->previous_balance_bit;
    $pos_invoice_format_id	=$res1->pos_invoice_format_id;
    $t_and_c_status_pos	=$res1->t_and_c_status_pos;
    
    ?>
	<table width="95%" align="center">
		<!-- Header Section (Center Aligned) -->
		<tr>
			<td align="center">
				<span>													 
                <strong style="font-size: 14px; text-transform: uppercase;"><?= $store_name; ?></strong><br>
                <?= strtoupper($company_city); ?><br>
		        <?php if(!empty(trim($company_mobile))) 
		        		{ 
		        			echo "CELL: ".$company_mobile."<br>";
		        		}
		        ?> 
		        <i style="font-style: italic;">NATURAL FOOD FOR HEALTH</i><br>
			</span>
			</td>
		</tr>
		
		<!-- Bill Info Section (Left Aligned) -->
		<tr>
			<td style="padding-top: 10px;">
				<div style="text-align: left;">
					Bill No: <?= $sales_code; ?><br>
					Date: <?= $sales_date; ?><br>
					Time: <?= $created_time; ?>
				</div>
			</td>
		</tr>
		
		<!-- Items Table Section -->
		<tr>
			<td style="padding-top: 8px;">
				<table width="100%" cellpadding="0" cellspacing="0" style="font-family: 'Courier New', monospace; font-size: 10px;">
					<thead>
					<tr style="border-top: 1px dashed #000; border-bottom: 1px dashed #000;">
						<th style="text-align: left; padding: 2px; width: 8%;">Sno</th>
						<th style="text-align: left; padding: 2px; width: 45%;">Name</th>
						<th style="text-align: right; padding: 2px; width: 15%;">Rate</th>
						<th style="text-align: right; padding: 2px; width: 12%;">Qty</th>
						<th style="text-align: right; padding: 2px; width: 20%;">Amount</th>
					</tr>
					</thead>
					<tbody>
						<?php
			              $i=0;
			              $tot_qty=0;
			              $subtotal=0;
			              $tax_amt=0;
			              $this->db->select(" a.description,c.mrp,c.item_name, a.sales_qty,a.tax_type,
                                  a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
                                  a.discount_input,a.discount_amt, a.unit_total_cost,
                                  a.total_cost , d.unit_name,c.sku,c.hsn
                              ");
			              $this->db->where("a.sales_id",$sales_id);
			              $this->db->from("db_salesitems a");
			              $this->db->join("db_tax b","b.id=a.tax_id","left");
			              $this->db->join("db_items c","c.id=a.item_id","left");
			              $this->db->join("db_units d","d.id = c.unit_id","left");
			              $q2=$this->db->get();
			              foreach ($q2->result() as $res2) {
			                  echo "<tr>";  
			                  echo "<td style='text-align: left; padding: 1px;'>".++$i."</td>";
			                  echo "<td style='text-align: left; padding: 1px;'>".$res2->item_name."</td>";
			                  echo "<td style='text-align: right; padding: 1px;'>".store_number_format($res2->unit_total_cost)."</td>";
			                  echo "<td style='text-align: right; padding: 1px;'>".format_qty($res2->sales_qty)."</td>";
			                  echo "<td style='text-align: right; padding: 1px;'>".store_number_format($res2->total_cost)."</td>";
			                  echo "</tr>";  
			                  $tot_qty+=$res2->sales_qty;
			                  $subtotal+=($res2->total_cost);
			                  $tax_amt+=$res2->tax_amt;
			              }
			              $before_tax = $subtotal-$tax_amt;
			              ?>
					</tbody>
				</table>
			</td>
		</tr>
		
		<!-- Totals Section (Right Aligned) -->
		<tr>
			<td style="padding-top: 8px; border-top: 1px dashed #000;">
				<div style="text-align: right; font-size: 11px;">
					Qty: <?= format_qty($tot_qty); ?><br>
					<?php if($round_off != 0) { ?>
					Round Off: <?= store_number_format($round_off); ?><br>
					<?php } ?>
					<strong style="font-size: 12px;">Total: <?= store_number_format($grand_total); ?></strong>
				</div>
			</td>
		</tr>
		
		<!-- Footer Section (Center Aligned) -->
		<tr>
			<td align="center" style="padding-top: 10px; border-top: 1px dashed #000;">
				<strong style="font-size: 13px;">Rs. <?= store_number_format($grand_total); ?></strong><br><br>
				<strong style="text-transform: uppercase;">THANK YOU VISIT AGAIN!!</strong><br>
				<small>POWERED BY HONEYBILL.IN</small>
			</td>
		</tr>
	</table>

	<center >
  <div class="row no-print" style="padding-top: 15px;">
  <div class="col-md-12">
  <div class="col-md-2 col-md-offset-5 col-xs-4 col-xs-offset-4 form-group">
    <button type="button" id="" class="btn btn-block btn-success btn-xs" onclick="window.print();" title="Print">Print</button>
    <?php if(isset($_GET['redirect'])){ ?>
		<a href="<?= base_url().$_GET['redirect'];?>"><button type="button" class="btn btn-block btn-danger btn-xs" title="Back">Back</button></a>
	<?php } ?>
   </div>
   </div>
   </div>

</center>

</body>
</html>
