<!DOCTYPE html>
<html>
<head>
	<title>Simple POS Invoice Format</title>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<style type="text/css">
	body{
		font-family: arial;
		font-size: 12px;
		font-weight: normal;
		padding-top:10px;
	}
	.invoice-header {
		text-align: center;
		border-bottom: 2px solid #000;
		padding-bottom: 10px;
		margin-bottom: 15px;
	}
	.invoice-details {
		margin: 10px 0;
	}
	.items-table {
		width: 100%;
		border-collapse: collapse;
		margin: 15px 0;
	}
	.items-table th, .items-table td {
		border: 1px solid #000;
		padding: 5px;
		text-align: left;
	}
	.items-table th {
		background-color: #f0f0f0;
		font-weight: bold;
	}
	.total-section {
		margin-top: 15px;
		border-top: 1px solid #000;
		padding-top: 10px;
	}
	.footer-section {
		margin-top: 20px;
		text-align: center;
		border-top: 1px dashed #000;
		padding-top: 10px;
	}
	@media print {
        .no-print { display: none; }
    }
</style>
</head>
<body onload="window.print();">
	<?php
	$CI =& get_instance();
	
    
  	$q3=$this->db->query("SELECT b.coupon_id,b.coupon_amt, b.created_by, b.customer_previous_due,b.customer_total_due,b.store_id,a.customer_name,a.mobile,a.phone,a.gstin,a.tax_number,a.email,a.delete_bit,b.invoice_terms,
                           a.opening_balance,a.country_id,a.state_id,
                           a.postcode,a.address,b.sales_date,b.created_time,b.reference_no,
                           b.sales_code,b.sales_note,a.sales_due,
                           coalesce(b.grand_total,0) as grand_total,
                           coalesce(b.subtotal,0) as subtotal,
                           coalesce(b.paid_amount,0) as paid_amount,
                           coalesce(b.other_charges_input,0) as other_charges_input,
                           other_charges_tax_id,
                           coalesce(b.other_charges_amt,0) as other_charges_amt,
                           discount_to_all_input,
                           b.discount_to_all_type,
                           coalesce(b.tot_discount_to_all_amt,0) as tot_discount_to_all_amt,
                           coalesce(b.round_off,0) as round_off,
                           b.payment_status

                           FROM db_customers a,
                           db_sales b 
                           WHERE 
                           a.`id`=b.`customer_id` AND 
                           b.`id`='$sales_id' 
                           ");
                        
    
    $res3=$q3->row();
    $customer_name=$res3->customer_name;
    $customer_mobile=$res3->mobile;
    $customer_phone=$res3->phone;
    $customer_email=$res3->email;
    $customer_country=$res3->country_id;
    $customer_state=$res3->state_id;
    $customer_address=$res3->address;
    $customer_postcode=$res3->postcode;
    $customer_gst_no=$res3->gstin;
    $customer_tax_number=$res3->tax_number;
    $customer_opening_balance=$res3->opening_balance;
    $sales_date=show_date($res3->sales_date);
    $reference_no=$res3->reference_no;
    $created_time=show_time($res3->created_time);
    $sales_code=$res3->sales_code;
    $sales_note=$res3->sales_note;
    $customer_delete_bit=$res3->delete_bit;

    $previous_due=$res3->sales_due-($res3->grand_total-$res3->paid_amount);
    $previous_due = ($previous_due>0) ? $previous_due : 0;
    $total_due=$res3->sales_due;

    $coupon_id=$res3->coupon_id;
    $coupon_amt=$res3->coupon_amt;

    $coupon_code = '';
    $coupon_type = '';
    $coupon_value=0;
    if(!empty($coupon_id)){
    	$coupon_details =get_customer_coupon_details($coupon_id);
    	$coupon_code =$coupon_details->code;
    	$coupon_value =$coupon_details->value;
    	$coupon_type =$coupon_details->type;
    } 

    $subtotal=$res3->subtotal;
    $grand_total=$res3->grand_total;
    $other_charges_input=$res3->other_charges_input;
    $other_charges_tax_id=$res3->other_charges_tax_id;
    $other_charges_amt=$res3->other_charges_amt;
    $paid_amount=$res3->paid_amount;
    $discount_to_all_input=$res3->discount_to_all_input;
    $discount_to_all_type=$res3->discount_to_all_type;
    $tot_discount_to_all_amt=$res3->tot_discount_to_all_amt;
    $round_off=$res3->round_off;
    $payment_status=$res3->payment_status;
    
    if($discount_to_all_input>0){
    	$str="($discount_to_all_input%)";
    }else{
    	$str="(Fixed)";
    }

    if(!empty($customer_state)){
      $q6 = $this->db->query("select state from db_states where id='$customer_state'");
      if($q6->num_rows()>0){
      	$customer_state = $q6->row()->state;
      }
    }

    $overall_discounted = $tot_discount_to_all_amt + $coupon_amt;

    $q1=$this->db->query("select * from db_store where id=".$res3->store_id." ");
    $res1=$q1->row();
    $store_name		=$res1->store_name;
    $company_mobile		=$res1->mobile;
    $company_phone		=$res1->phone;
    $company_email		=$res1->email;
    $company_country	=$res1->country;
    $company_state		=$res1->state;
    $company_city		=$res1->city;
    $company_address	=$res1->address;
    $company_postcode	=$res1->postcode;
    $company_gst_no		=$res1->gst_no;
    $company_vat_number		=$res1->vat_no;
    $store_logo=(!empty($res1->store_logo)) ? $res1->store_logo : store_demo_logo();
    $store_website		=$res1->store_website;
    $mrp_column		=$res1->mrp_column;
    $previous_balance_bit	=$res1->previous_balance_bit;
    $pos_invoice_format_id	=$res1->pos_invoice_format_id;
    $t_and_c_status_pos	=$res1->t_and_c_status_pos;

    ?>

	<!-- Invoice Header -->
	<div class="invoice-header">
		<img src="<?= base_url($store_logo);?>" width="80" height="auto" style="margin-bottom: 10px;">
		<h2 style="margin: 5px 0;"><?= $store_name; ?></h2>
		<p style="margin: 2px 0;">
			<?php echo (!empty(trim($company_address))) ? $company_address : '';?>
			<?php echo (!empty(trim($company_city))) ? $company_city : '';?>
			<?php echo (!empty(trim($company_postcode))) ? " - ".$company_postcode : '';?>
		</p>
		<p style="margin: 2px 0;">
			<?php if(!empty(trim($company_mobile))) { 
				echo $this->lang->line('phone').": ".$company_mobile;
				if(!empty($company_phone)){
					echo ", ".$company_phone;
				}
			} ?>
		</p>
		<?php if(!empty($company_email)) { ?>
			<p style="margin: 2px 0;"><?= $company_email; ?></p>
		<?php } ?>
	</div>

	<!-- Invoice Details -->
	<div class="invoice-details">
		<table width="100%">
			<tr>
				<td><strong><?= $this->lang->line('invoice'); ?>:</strong> <?= $sales_code; ?></td>
				<td style="text-align: right;"><strong><?= $this->lang->line('date'); ?>:</strong> <?= $sales_date; ?></td>
			</tr>
			<tr>
				<td><strong><?= $this->lang->line('customer'); ?>:</strong> <?= $customer_name; ?></td>
				<td style="text-align: right;"><strong><?= $this->lang->line('time'); ?>:</strong> <?= $created_time; ?></td>
			</tr>
			<?php if(!empty($customer_mobile)) { ?>
			<tr>
				<td><strong><?= $this->lang->line('mobile'); ?>:</strong> <?= $customer_mobile; ?></td>
				<td style="text-align: right;"><strong><?= $this->lang->line('seller'); ?>:</strong> <?= ucfirst($res3->created_by) ?></td>
			</tr>
			<?php } ?>
		</table>
	</div>

	<!-- Items Table -->
	<table class="items-table">
		<thead>
			<tr>
				<th style="width: 5%;">#</th>
				<th style="width: 45%;"><?= $this->lang->line('item'); ?></th>
				<th style="width: 12%; text-align: center;"><?= $this->lang->line('qty'); ?></th>
				<?php if($mrp_column){ ?>
				<th style="width: 15%; text-align: right;"><?= $this->lang->line('mrp'); ?></th>
				<?php } ?>
				<th style="width: 15%; text-align: right;"><?= $this->lang->line('rate'); ?></th>
				<th style="width: 18%; text-align: right;"><?= $this->lang->line('total'); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
              $i=0;
              $tot_qty=0;
              $subtotal=0;
              $tax_amt=0;
              $this->db->select(" a.description,c.mrp,c.item_name, a.sales_qty,a.tax_type,
                          a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
                          a.discount_input,a.discount_amt, a.unit_total_cost,
                          a.total_cost , d.unit_name,c.sku,c.hsn
                      ");
              $this->db->where("a.sales_id",$sales_id);
              $this->db->from("db_salesitems a");
              $this->db->join("db_tax b","b.id=a.tax_id","left");
              $this->db->join("db_items c","c.id=a.item_id","left");
              $this->db->join("db_units d","d.id = c.unit_id","left");
              $q2=$this->db->get();
              foreach ($q2->result() as $res2) {
                  echo "<tr>";  
                  echo "<td>".++$i."</td>";
                  echo "<td>".$res2->item_name."</td>";
                  echo "<td style='text-align: center;'>".format_qty($res2->sales_qty)."</td>";
                  if($mrp_column){
                  	echo "<td style='text-align: right;'>".store_number_format($res2->mrp)."</td>";
                  }
                  echo "<td style='text-align: right;'>".store_number_format($res2->unit_total_cost)."</td>";
                  echo "<td style='text-align: right;'>".store_number_format($res2->total_cost)."</td>";
                  echo "</tr>";  
                  $subtotal+=($res2->total_cost);
                  $tax_amt+=$res2->tax_amt;
                  $overall_discounted+=$res2->discount_amt;
              }
              $before_tax = $subtotal-$tax_amt;
              ?>
		</tbody>
	</table>

	<!-- Total Section -->
	<div class="total-section">
		<table width="100%">
			<tr>
				<td width="60%"></td>
				<td width="25%" style="text-align: right;"><strong><?= $this->lang->line('subtotal'); ?>:</strong></td>
				<td width="15%" style="text-align: right;"><strong><?= store_number_format($before_tax);?></strong></td>
			</tr>
			<?php if($tax_amt > 0) { ?>
			<tr>
				<td></td>
				<td style="text-align: right;"><?= $this->lang->line('tax_amount'); ?>:</td>
				<td style="text-align: right;"><?= store_number_format($tax_amt);?></td>
			</tr>
			<?php } ?>
			<?php if(!empty($coupon_code) && $coupon_amt > 0) {?>
			<tr>
				<td></td>
				<td style="text-align: right;"><?= $this->lang->line('couponDiscount'); ?>:</td>
				<td style="text-align: right;"><?= store_number_format($coupon_amt); ?></td>
			</tr>
			<?php } ?>
			<?php if(!empty($tot_discount_to_all_amt) && $tot_discount_to_all_amt!=0) {?>
			<tr>
				<td></td>
				<td style="text-align: right;"><?= $this->lang->line('discount'); ?>:</td>
				<td style="text-align: right;"><?= store_number_format($tot_discount_to_all_amt); ?></td>
			</tr>
			<?php } ?>
			<tr style="border-top: 1px solid #000;">
				<td></td>
				<td style="text-align: right;"><strong><?= $this->lang->line('total'); ?>:</strong></td>
				<td style="text-align: right;"><strong><?= store_number_format($grand_total); ?></strong></td>
			</tr>
			<tr>
				<td></td>
				<td style="text-align: right;"><?= $this->lang->line('paid_amount'); ?>:</td>
				<td style="text-align: right;"><?= store_number_format($paid_amount); ?></td>
			</tr>
			<?php if($previous_balance_bit==1 && $total_due > 0) {?>
			<tr>
				<td></td>
				<td style="text-align: right;"><?= $this->lang->line('total_due_amount'); ?>:</td>
				<td style="text-align: right;"><?= store_number_format($total_due); ?></td>
			</tr>
			<?php } ?>
		</table>
	</div>

	<!-- Payment Details -->
	<?php if(isset($sales_id)){ 
		$q4 = $this->db->query("select * from db_salespayments where sales_id=$sales_id");
		if($q4->num_rows()>0){ ?>
	<div style="margin-top: 15px;">
		<strong><?= $this->lang->line('payment_details'); ?>:</strong>
		<table style="width: 100%; margin-top: 5px; border-collapse: collapse;">
			<tr style="background-color: #f0f0f0;">
				<th style="border: 1px solid #000; padding: 3px; text-align: left;"><?= $this->lang->line('payment_type'); ?></th>
				<th style="border: 1px solid #000; padding: 3px; text-align: right;"><?= $this->lang->line('amount'); ?></th>
			</tr>
			<?php 
			$total_paid = 0;
			foreach ($q4->result() as $res4) {
				echo "<tr>";
				echo '<td style="border: 1px solid #000; padding: 3px;">'.$res4->payment_type.'</td>';
				echo '<td style="border: 1px solid #000; padding: 3px; text-align: right;">'.store_number_format($res4->payment).'</td>';
				echo "</tr>";
				$total_paid +=$res4->payment;
			} ?>
		</table>
	</div>
	<?php }} ?>

	<!-- Notes -->
	<?php if(!empty($sales_note)) { ?>
	<div style="margin-top: 15px;">
		<strong><?= $this->lang->line('notes'); ?>:</strong> <?= $sales_note; ?>
	</div>
	<?php } ?>

	<!-- Terms and Conditions -->
	<?php if($t_and_c_status_pos){ ?>
	<div style="margin-top: 15px;">
		<strong><?= $this->lang->line('invoiceTerms'); ?>:</strong><br>
		<small><?=nl2br(get_invoice_terms_for_pos());?></small>
	</div>
	<?php } ?>

	<!-- Footer -->
	<div class="footer-section">
		<p><strong><?= $this->lang->line('thanks_you_visit_again'); ?></strong></p>
		<?php 
		$sales_code_encoded = str_replace('=', '-', str_replace('/', '_', base64_encode($sales_code)));
		echo $CI->print_qr($sales_code_encoded);
		?>
	</div>

	<!-- Print Controls -->
	<center>
		<div class="row no-print">
			<div class="col-md-12">
				<div class="col-md-2 col-md-offset-5 col-xs-4 col-xs-offset-4 form-group">
					<button type="button" class="btn btn-block btn-success btn-xs" onclick="window.print();" title="Print">Print</button>
					<?php if(isset($_GET['redirect'])){ ?>
						<a href="<?= base_url().$_GET['redirect'];?>"><button type="button" class="btn btn-block btn-danger btn-xs" title="Back">Back</button></a>
					<?php } ?>
				</div>
			</div>
		</div>
	</center>
</body>
</html>
