<!DOCTYPE html>
<html>
<head>
	<title>A5 Simple POS Invoice Format</title>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<style type="text/css">
	@page {
		size: A5;
		margin: 5mm;
	}
	
	body{
		font-family: 'Times New Roman', serif;
		font-size: 12pt;
		line-height: 1.1;
		margin: 0;
		padding: 0;
		color: #333;
		background: #fff;
	}
	
	.invoice-container {
		width: 100%;
		max-width: 148mm;
		margin: 0 auto;
		background: #fff;
		border: 1px solid #ddd;
	}
	
	.invoice-header {
		background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
		color: white;
		padding: 5px 8px;
		display: flex;
		align-items: center;
		border-bottom: 2px solid #4a5568;
	}
	
	.header-logo {
		flex: 0 0 auto;
		margin-right: 10px;
	}
	
	.header-content {
		flex: 1;
		text-align: center;
	}
	
	.invoice-header h1 {
		margin: 0 0 2px 0;
		font-size: 14pt;
		font-weight: bold;
		text-transform: uppercase;
		letter-spacing: 0.5px;
	}
	
	.invoice-header .company-details {
		font-size: 9pt;
		opacity: 0.9;
		line-height: 1.0;
	}
	
	.customer-invoice-section {
		display: flex;
		padding: 5px 8px;
		background: #fff;
		border-bottom: 1px solid #e9ecef;
		gap: 10px;
	}
	
	.customer-left {
		width: 50%;
		flex: 1;
	}
	
	.invoice-right {
		width: 50%;
		flex: 1;
	}
	
	.customer-left h3, .invoice-right h3 {
		margin: 0 0 3px 0;
		font-size: 10pt;
		color: #495057;
		border-bottom: 1px solid #667eea;
		padding-bottom: 1px;
		display: inline-block;
	}
	
	.customer-details .detail-item {
		margin-bottom: 1px;
		font-size: 9pt;
		line-height: 1.1;
	}
	
	.invoice-details-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 9pt;
	}
	
	.invoice-details-table td {
		padding: 1px 3px;
		border-bottom: 1px solid #e9ecef;
		line-height: 1.1;
	}
	
	.invoice-details-table .detail-label {
		font-weight: bold;
		color: #6c757d;
		width: 40%;
	}
	
	.invoice-details-table .detail-value {
		color: #495057;
		width: 60%;
	}
	
	.items-section {
		padding: 5px 8px;
	}
	
	.items-table {
		width: 100%;
		border-collapse: collapse;
		margin-bottom: 5px;
		font-size: 9pt;
	}
	
	.items-table thead {
		background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
		color: white;
	}
	
	.items-table th {
		padding: 2px 3px;
		text-align: left;
		font-weight: bold;
		font-size: 8pt;
		text-transform: uppercase;
		letter-spacing: 0.2px;
		line-height: 1.0;
	}
	
	.items-table td {
		padding: 1px 3px;
		border-bottom: 1px solid #e9ecef;
		vertical-align: top;
		line-height: 1.1;
	}
	
	.items-table tbody tr:nth-child(even) {
		background: #f8f9fa;
	}
	
	.items-table .text-right {
		text-align: right;
	}
	
	.items-table .text-center {
		text-align: center;
	}
	
	.grand-total-section {
		padding: 5px 8px;
		text-align: right;
		background: #f8f9fa;
		border-top: 2px solid #667eea;
	}
	
	.grand-total {
		font-size: 12pt;
		font-weight: bold;
		color: #495057;
		display: inline-block;
		background: white;
		padding: 5px 10px;
		border: 2px solid #667eea;
		border-radius: 3px;
	}
	
	@media print {
		.no-print { display: none !important; }
		body { margin: 0; }
		.invoice-container { 
			box-shadow: none; 
			border: none; 
			margin: 0;
			max-width: none;
			width: 100%;
		}
	}
	
	.print-controls {
		text-align: center;
		padding: 10px;
		background: #f8f9fa;
		border-top: 1px solid #e9ecef;
	}
	
	.btn {
		display: inline-block;
		padding: 6px 12px;
		margin: 0 3px;
		border: none;
		border-radius: 3px;
		text-decoration: none;
		font-size: 10pt;
		font-weight: bold;
		cursor: pointer;
		transition: all 0.3s ease;
	}
	
	.btn-success {
		background: #28a745;
		color: white;
	}
	
	.btn-success:hover {
		background: #218838;
	}
	
	.btn-danger {
		background: #dc3545;
		color: white;
	}
	
	.btn-danger:hover {
		background: #c82333;
	}
</style>
</head>
<body onload="window.print();">
	<?php
	$CI =& get_instance();
	
    
  	$q3=$this->db->query("SELECT b.coupon_id,b.coupon_amt, b.created_by, b.customer_previous_due,b.customer_total_due,b.store_id,a.customer_name,a.mobile,a.phone,a.gstin,a.tax_number,a.email,a.delete_bit,b.invoice_terms,
                           a.opening_balance,a.country_id,a.state_id,
                           a.postcode,a.address,b.sales_date,b.created_time,b.reference_no,
                           b.sales_code,b.sales_note,a.sales_due,
                           coalesce(b.grand_total,0) as grand_total,
                           coalesce(b.subtotal,0) as subtotal,
                           coalesce(b.paid_amount,0) as paid_amount,
                           coalesce(b.other_charges_input,0) as other_charges_input,
                           other_charges_tax_id,
                           coalesce(b.other_charges_amt,0) as other_charges_amt,
                           discount_to_all_input,
                           b.discount_to_all_type,
                           coalesce(b.tot_discount_to_all_amt,0) as tot_discount_to_all_amt,
                           coalesce(b.round_off,0) as round_off,
                           b.payment_status

                           FROM db_customers a,
                           db_sales b 
                           WHERE 
                           a.`id`=b.`customer_id` AND 
                           b.`id`='$sales_id' 
                           ");
                        
    
    $res3=$q3->row();
    $customer_name=$res3->customer_name;
    $customer_mobile=$res3->mobile;
    $customer_phone=$res3->phone;
    $customer_email=$res3->email;
    $customer_country=$res3->country_id;
    $customer_state=$res3->state_id;
    $customer_address=$res3->address;
    $customer_postcode=$res3->postcode;
    $customer_gst_no=$res3->gstin;
    $customer_tax_number=$res3->tax_number;
    $customer_opening_balance=$res3->opening_balance;
    $sales_date=show_date($res3->sales_date);
    $reference_no=$res3->reference_no;
    $created_time=show_time($res3->created_time);
    $sales_code=$res3->sales_code;
    $sales_note=$res3->sales_note;
    $customer_delete_bit=$res3->delete_bit;

    $previous_due=$res3->sales_due-($res3->grand_total-$res3->paid_amount);
    $previous_due = ($previous_due>0) ? $previous_due : 0;
    $total_due=$res3->sales_due;

    $coupon_id=$res3->coupon_id;
    $coupon_amt=$res3->coupon_amt;

    $coupon_code = '';
    $coupon_type = '';
    $coupon_value=0;
    if(!empty($coupon_id)){
    	$coupon_details =get_customer_coupon_details($coupon_id);
    	$coupon_code =$coupon_details->code;
    	$coupon_value =$coupon_details->value;
    	$coupon_type =$coupon_details->type;
    } 

    $subtotal=$res3->subtotal;
    $grand_total=$res3->grand_total;
    $other_charges_input=$res3->other_charges_input;
    $other_charges_tax_id=$res3->other_charges_tax_id;
    $other_charges_amt=$res3->other_charges_amt;
    $paid_amount=$res3->paid_amount;
    $discount_to_all_input=$res3->discount_to_all_input;
    $discount_to_all_type=$res3->discount_to_all_type;
    $tot_discount_to_all_amt=$res3->tot_discount_to_all_amt;
    $round_off=$res3->round_off;
    $payment_status=$res3->payment_status;
    
    if($discount_to_all_input>0){
    	$str="($discount_to_all_input%)";
    }else{
    	$str="(Fixed)";
    }

    if(!empty($customer_state)){
      $q6 = $this->db->query("select state from db_states where id='$customer_state'");
      if($q6->num_rows()>0){
      	$customer_state = $q6->row()->state;
      }
    }

    $overall_discounted = $tot_discount_to_all_amt + $coupon_amt;

    $q1=$this->db->query("select * from db_store where id=".$res3->store_id." ");
    $res1=$q1->row();
    $store_name		=$res1->store_name;
    $company_mobile		=$res1->mobile;
    $company_phone		=$res1->phone;
    $company_email		=$res1->email;
    $company_country	=$res1->country;
    $company_state		=$res1->state;
    $company_city		=$res1->city;
    $company_address	=$res1->address;
    $company_postcode	=$res1->postcode;
    $company_gst_no		=$res1->gst_no;
    $company_vat_number		=$res1->vat_no;
    $store_logo=(!empty($res1->store_logo)) ? $res1->store_logo : store_demo_logo();
    $store_website		=$res1->store_website;
    $mrp_column		=$res1->mrp_column;
    $previous_balance_bit	=$res1->previous_balance_bit;
    $pos_invoice_format_id	=$res1->pos_invoice_format_id;
    $t_and_c_status_pos	=$res1->t_and_c_status_pos;

    ?>

	<div class="invoice-container">
		<!-- Invoice Header -->
		<div class="invoice-header">
			<?php if(!empty($store_logo)) { ?>
			<div class="header-logo">
				<img src="<?= base_url($store_logo);?>" width="45" height="auto">
			</div>
			<?php } ?>
			<div class="header-content">
				<h1><?= $store_name; ?></h1>
				<div class="company-details">
					<?php echo (!empty(trim($company_address))) ? $company_address : '';?>
					<?php echo (!empty(trim($company_city))) ? $company_city : '';?>
					<?php echo (!empty(trim($company_postcode))) ? " - ".$company_postcode : '';?><br>
					
					<?php if(!empty(trim($company_mobile))) { 
						echo "📞 ".$company_mobile;
						if(!empty($company_phone)){
							echo ", ".$company_phone;
						}
						echo "<br>";
					} ?>
					
					<?php if(!empty($company_email)) { ?>
						📧 <?= $company_email; ?>
					<?php } ?>
				</div>
			</div>
		</div>

		<!-- Customer Information and Invoice Details -->
		<div class="customer-invoice-section">
			<div class="customer-left">
				<h3>Customer Details</h3>
				<div class="customer-details">
					<div class="detail-item">
						<strong>Name:</strong> <?= $customer_name; ?>
					</div>
					<?php if(!empty($customer_mobile)) { ?>
					<div class="detail-item">
						<strong>Mobile:</strong> <?= $customer_mobile; ?>
					</div>
					<?php } ?>
					<?php if(!empty($customer_address)) { ?>
					<div class="detail-item">
						<strong>Address:</strong> <?= $customer_address; ?>
					</div>
					<?php } ?>
				</div>
			</div>
			
			<div class="invoice-right">
				<h3>Invoice Details</h3>
				<table class="invoice-details-table">
					<tr>
						<td class="detail-label">Invoice:</td>
						<td class="detail-value"><?= $sales_code; ?></td>
					</tr>
					<tr>
						<td class="detail-label">Date:</td>
						<td class="detail-value"><?= $sales_date; ?></td>
					</tr>
					<tr>
						<td class="detail-label">Time:</td>
						<td class="detail-value"><?= $created_time; ?></td>
					</tr>
				</table>
			</div>
		</div>

		<!-- Items Section -->
		<div class="items-section">
			<table class="items-table">
				<thead>
					<tr>
						<th style="width: 8%;">#</th>
						<th style="width: 50%;">Item</th>
						<th style="width: 12%; text-align: center;">Qty</th>
						<th style="width: 15%; text-align: right;">Rate</th>
						<th style="width: 15%; text-align: right;">Total</th>
					</tr>
				</thead>
				<tbody>
					<?php
		              $i=0;
		              $tot_qty=0;
		              $subtotal=0;
		              $tax_amt=0;
		              $this->db->select(" a.description,c.mrp,c.item_name, a.sales_qty,a.tax_type,
		                          a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
		                          a.discount_input,a.discount_amt, a.unit_total_cost,
		                          a.total_cost , d.unit_name,c.sku,c.hsn
		                      ");
		              $this->db->where("a.sales_id",$sales_id);
		              $this->db->from("db_salesitems a");
		              $this->db->join("db_tax b","b.id=a.tax_id","left");
		              $this->db->join("db_items c","c.id=a.item_id","left");
		              $this->db->join("db_units d","d.id = c.unit_id","left");
		              $q2=$this->db->get();
		              foreach ($q2->result() as $res2) {
		                  echo "<tr>";  
		                  echo "<td class='text-center'>".++$i."</td>";
		                  echo "<td>".$res2->item_name."</td>";
		                  echo "<td class='text-center'>".format_qty($res2->sales_qty)."</td>";
		                  echo "<td class='text-right'>".store_number_format($res2->unit_total_cost)."</td>";
		                  echo "<td class='text-right'>".store_number_format($res2->total_cost)."</td>";
		                  echo "</tr>";  
		                  $subtotal+=($res2->total_cost);
		                  $tax_amt+=$res2->tax_amt;
		                  $overall_discounted+=$res2->discount_amt;
		              }
		              $before_tax = $subtotal-$tax_amt;
		              ?>
				</tbody>
			</table>
		</div>

		<!-- Grand Total Section -->
		<div class="grand-total-section">
			<div class="grand-total">
				GRAND TOTAL: <?= store_number_format($grand_total); ?>
			</div>
		</div>

		<!-- Print Controls -->
		<div class="print-controls no-print">
			<button type="button" class="btn btn-success" onclick="window.print();" title="Print">🖨️ Print Invoice</button>
			<?php if(isset($_GET['redirect'])){ ?>
				<a href="<?= base_url().$_GET['redirect'];?>" class="btn btn-danger" title="Back">↩️ Back</a>
			<?php } ?>
		</div>
	</div>

</body>
</html>
