<div class="modal fade" id="expense-modal" tabindex='-1'>
    <?= form_open('#', array('class' => '', 'id' => 'expense-form-modal')); ?>
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header header-custom">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <label aria-hidden="true">&times;</label>
                </button>
                <h4 class="modal-title text-center"><i class="fa fa-money"></i> <?= $this->lang->line('expense'); ?></h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_expense_date"><?= $this->lang->line('expense_date'); ?> <span class="text-danger">*</span></label>
                            <label id="modal_expense_date_msg" class="text-danger text-right pull-right"></label>
                            <div class="input-group date">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input type="text" class="form-control pull-right datepicker" value="<?php echo show_date(date('d-m-Y')); ?>" id="modal_expense_date" name="expense_date" readonly>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_category_id"><?= $this->lang->line('category'); ?> <span class="text-danger">*</span></label>
                            <label id="modal_category_id_msg" class="text-danger text-right pull-right"></label>
                            <select class="form-control select2" id="modal_category_id" name="category_id" style="width: 100%;">
                                <option value="">-Select-</option>
                                <?php
                                $query1="select * from db_expense_category where status=1 and store_id=".get_current_store_id();
                                $q1=$this->db->query($query1);
                                if($q1->num_rows($q1)>0) {
                                    foreach($q1->result() as $res1) {
                                        echo "<option value='".$res1->id."'>".$res1->category_name."</option>";
                                    }
                                } else {
                                    echo '<option value="">No Records Found</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_expense_for"><?= $this->lang->line('expense_for'); ?> <span class="text-danger">*</span></label>
                            <label id="modal_expense_for_msg" class="text-danger text-right pull-right"></label>
                            <input type="text" class="form-control" id="modal_expense_for" name="expense_for" placeholder="Enter expense description">
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_expense_amt"><?= $this->lang->line('amount'); ?> <span class="text-danger">*</span></label>
                            <label id="modal_expense_amt_msg" class="text-danger text-right pull-right"></label>
                            <input type="text" class="form-control only_currency" id="modal_expense_amt" name="expense_amt" placeholder="0.00">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_payment_type"><?= $this->lang->line('payment_type'); ?> <span class="text-danger">*</span></label>
                            <label id="modal_payment_type_msg" class="text-danger text-right pull-right"></label>
                            <select class="form-control select2" id="modal_payment_type" name="payment_type">
                                <option value="">-Select-</option>
                                <?php
                                $q1=$this->db->query("select * from db_paymenttypes where status=1 and store_id=".get_current_store_id());
                                if($q1->num_rows()>0){
                                    foreach($q1->result() as $res1){
                                        echo "<option value='".$res1->payment_type."'>".$res1->payment_type ."</option>";
                                    }
                                } else {
                                    echo "<option>None</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_account_id"><?= $this->lang->line('account'); ?></label>
                            <label id="modal_account_id_msg" class="text-danger text-right pull-right"></label>
                            <select class="form-control select2" id="modal_account_id" name="account_id">
                                <option value="">-None-</option>
                                <?= get_accounts_select_list(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_reference_no"><?= $this->lang->line('reference_no'); ?></label>
                            <label id="modal_reference_no_msg" class="text-danger text-right pull-right"></label>
                            <input type="text" class="form-control" id="modal_reference_no" name="reference_no" placeholder="">
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="modal_note"><?= $this->lang->line('note'); ?></label>
                            <label id="modal_note_msg" class="text-danger text-right pull-right"></label>
                            <textarea class="form-control" id="modal_note" name="note" rows="3" placeholder="Additional notes..."></textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Hidden field for store_id -->
                <input type="hidden" name="store_id" id="modal_store_id" value="<?= get_current_store_id(); ?>">
                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary add_expense">Save Expense</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
    <?= form_close();?>
</div>
<!-- /.modal -->
