<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daily Summary - <?= $date ?></title>
    <style>
        @media print {
            @page {
                size: 80mm auto;
                margin: 1mm;
            }
            body { 
                margin: 0; 
                padding: 0;
                font-family: 'Courier New', monospace;
                font-size: 9px;
                line-height: 1.1;
            }
            .no-print { display: none !important; }
        }
        
        body { 
            width: 74mm;
            margin: 0 auto;
            padding: 1mm;
            font-family: 'Courier New', monospace;
            font-size: 9px;
            line-height: 1.1;
            background: white;
            color: #000;
        }
        
        .header {
            text-align: center;
            border-bottom: 1px dashed #000;
            padding-bottom: 2px;
            margin-bottom: 3px;
        }
        
        .company-name {
            font-size: 11px;
            font-weight: bold;
            margin-bottom: 1px;
            text-transform: uppercase;
        }
        
        .report-title {
            font-size: 10px;
            font-weight: bold;
            margin: 1px 0;
            text-decoration: underline;
        }
        
        .date-time {
            font-size: 8px;
            margin-bottom: 1px;
        }
        
        .section {
            margin: 3px 0;
            border-bottom: 1px dashed #ccc;
            padding-bottom: 2px;
        }
        
        .section-title {
            font-size: 9px;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 1px;
            text-transform: uppercase;
        }
        
        .line-item {
            display: flex;
            justify-content: space-between;
            margin: 0.5px 0;
            font-size: 8px;
        }
        
        .line-item .label {
            flex: 1;
            padding-right: 5px;
        }
        
        .line-item .value {
            text-align: right;
            min-width: 20mm;
            font-weight: normal;
        }
        
        .total-line {
            font-weight: bold;
            border-top: 1px solid #000;
            margin-top: 1px;
            padding-top: 1px;
        }
        
        .balance-profit {
            background: #000;
            color: #fff;
            padding: 1px;
            text-align: center;
            font-weight: bold;
            font-size: 8px;
            margin: 2px 0;
        }
        
        .balance-loss {
            background: #000;
            color: #fff;
            padding: 1px;
            text-align: center;
            font-weight: bold;
            font-size: 8px;
            margin: 2px 0;
        }
        
        .footer {
            margin-top: 5px;
            text-align: center;
            font-size: 7px;
            border-top: 1px dashed #000;
            padding-top: 2px;
        }
        
        .separator {
            text-align: center;
            margin: 2px 0;
            font-size: 7px;
            color: #000;
            overflow: hidden;
        }
        
        .payment-method {
            font-size: 7px;
            margin: 0.5px 0;
        }
        
        .print-button {
            background: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            margin: 15px auto;
            display: block;
            font-size: 14px;
        }
        
        .print-button:hover {
            background: #0056b3;
        }
        
        @media screen {
            body {
                border: 1px solid #ddd;
                max-width: 80mm;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                margin: 20px auto;
            }
        }
        
        .separator {
            text-align: center;
            margin: 2px 0;
            font-size: 8px;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="print-button" onclick="window.print();">
            <i class="fa fa-print"></i> Print Receipt
        </button>
    </div>

    <div class="header">
        <div class="company-name"><?= $this->session->userdata('store_name'); ?></div>
        <div class="report-title">DAILY SUMMARY</div>
        <div class="date-time"><?= date('d-M-Y', strtotime($date)); ?> | <?= date('h:i A'); ?></div>
        <div class="separator">===============================</div>
    </div>

    <!-- Sales Section -->
    <div class="section">
        <div class="section-title">SALES</div>
        <div class="line-item">
            <span class="label">Total Sales:</span>
            <span class="value"><?= $sales['count']; ?> bills</span>
        </div>
        <div class="line-item">
            <span class="label">Sales Amount:</span>
            <span class="value"><?= store_number_format($sales['amount']); ?></span>
        </div>
        <div class="line-item">
            <span class="label">Collected:</span>
            <span class="value"><?= store_number_format($sales['paid_amount']); ?></span>
        </div>
        <div class="line-item">
            <span class="label">Pending:</span>
            <span class="value"><?= store_number_format($sales['due_amount']); ?></span>
        </div>
    </div>

    <!-- Expenses Section -->
    <div class="section">
        <div class="section-title">EXPENSES</div>
        <div class="line-item">
            <span class="label">Total Expenses:</span>
            <span class="value"><?= $expenses['count']; ?> items</span>
        </div>
        <div class="line-item total-line">
            <span class="label">Expense Amount:</span>
            <span class="value"><?= store_number_format($expenses['amount']); ?></span>
        </div>
    </div>

    <!-- Balance Section -->
    <div class="section">
        <div class="section-title">NET BALANCE</div>
        <div class="line-item">
            <span class="label">Sales:</span>
            <span class="value"><?= store_number_format($sales['amount']); ?></span>
        </div>
        <div class="line-item">
            <span class="label">Expenses:</span>
            <span class="value"><?= store_number_format($expenses['amount']); ?></span>
        </div>
        <div class="separator">-------------------------------</div>
        <div class="line-item total-line">
            <span class="label">Net P&L:</span>
            <span class="value"><?= store_number_format($balance); ?></span>
        </div>
        <?php if($balance >= 0): ?>
            <div class="balance-profit">*** PROFIT ***</div>
        <?php else: ?>
            <div class="balance-loss">*** LOSS ***</div>
        <?php endif; ?>
    </div>

    <!-- Payment Methods Section -->
    <?php if(!empty($payment_modes)): ?>
    <div class="section">
        <div class="section-title">PAYMENT METHODS</div>
        <?php foreach($payment_modes as $mode): ?>
        <div class="payment-method">
            <div class="line-item">
                <span class="label"><?= $mode->payment_type; ?>:</span>
                <span class="value"><?= store_number_format($mode->payment_amount); ?></span>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <!-- Customer Dues Section -->
    <div class="section">
        <div class="section-title">CUSTOMER DUES</div>
        <div class="line-item">
            <span class="label">Customers:</span>
            <span class="value"><?= $customer_dues['customers_count']; ?></span>
        </div>
        <div class="line-item">
            <span class="label">Total Due:</span>
            <span class="value"><?= store_number_format($customer_dues['total_amount']); ?></span>
        </div>
    </div>

    <div class="separator">===============================</div>
    <div class="footer">
        <div>Printed: <?= date('d-M-Y h:i A'); ?></div>
        <div>User: <?= $this->session->userdata('inv_username'); ?></div>
        <div class="separator">-------------------------------</div>
        <div>*** END OF REPORT ***</div>
    </div>

    <script>
        // Auto print when page loads if opened for printing
        if(window.location.search.includes('autoprint=1')) {
            window.onload = function() {
                setTimeout(function() {
                    window.print();
                }, 500);
            }
        }
    </script>
</body>
</html>
