<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sales_types_model extends CI_Model {

    protected $table = 'db_sales_types';
    protected $column_order = array(null, 'sales_type_name', 'short_code', 'description', 'status', null);
    protected $column_search = array('sales_type_name', 'short_code', 'description');
    protected $order = array('id' => 'asc');

    public function __construct() {
        parent::__construct();
        $this->data=array();
    }

    public function get_sales_types() {
        $this->db->where('store_id', get_current_store_id());
        $query = $this->db->get($this->table);
        return $query->result();
    }

    public function get_sales_type($id) {
        $this->db->where('id', $id);
        $this->db->where('store_id', get_current_store_id());
        $query = $this->db->get($this->table);
        return $query->row();
    }

    private function _get_datatables_query() {
        $this->db->from($this->table);
        $this->db->where("store_id", get_current_store_id());

        $i = 0;
        foreach ($this->column_search as $item) {
            if ($_POST['search']['value']) {
                if ($i === 0) {
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                } else {
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i) {
                    $this->db->group_end();
                }
            }
            $i++;
        }

        if (isset($_POST['order'])) {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables() {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1) {
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered() {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all() {
        $this->db->where("store_id", get_current_store_id());
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

    public function verify_and_save(){
        //Filtering XSS and html escape from user inputs 
        extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
        $store_id=(store_module() && is_admin()) ? $store_id : get_current_store_id();  	
        //Validate This sales type already exist or not
        $query=$this->db->query("select * from db_sales_types where (upper(sales_type_name)=upper('$sales_type_name') OR upper(short_code)=upper('$short_code')) and store_id=$store_id");
        if($query->num_rows()>0){
            return "This Sales Type Name or Short Code Already Exist.";
            
        }
        else{
            $info = array(
                        'store_id' 				=> $store_id, 
                        'type_name'             => $sales_type_name,
                        'sales_type_name' 		=> $sales_type_name, 
                        'short_code'            => $short_code,
                        'description' 			=> $description,
                        'status' 				=> 1,
                    );
            
            $q1 = $this->db->insert('db_sales_types', $info);
            if ($q1){
                    $this->session->set_flashdata('success', 'Success!! Sales Type Added Successfully!');
                    return "success";
            }
            else{
                    return "failed";
            }
        }
    }

    //Get sales_types_details
    public function get_details($id,$data){
        //Validate This sales type already exist or not
        $query=$this->db->query("select * from db_sales_types where upper(id)=upper('$id')");
        if($query->num_rows()==0){
            show_404();exit;
        }
        else{
            $query=$query->row();
            $data['q_id']=$query->id;
            $data['sales_type_name']=$query->sales_type_name;
            $data['short_code']=$query->short_code;
            $data['description']=$query->description;
            $data['store_id']=$query->store_id;
            return $data;
        }
    }
    public function update_sales_type(){
        //Filtering XSS and html escape from user inputs 
        extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
        $store_id=(store_module() && is_admin()) ? $store_id : get_current_store_id();  	
        //Validate This sales type already exist or not
        $query=$this->db->query("select * from db_sales_types where (upper(sales_type_name)=upper('$sales_type_name') OR upper(short_code)=upper('$short_code')) and id<>$q_id and store_id=$store_id");
        if($query->num_rows()>0){
            return "This Sales Type Name or Short Code already Exist.";
            
        }
        else{
            $info = array(
                        'type_name'             => $sales_type_name,
                        'sales_type_name' 		=> $sales_type_name, 
                        'short_code'            => $short_code,
                        'description' 			=> $description,
                    );
            
            $info['store_id']=(store_module() && is_admin()) ? $store_id : get_current_store_id();

            $q1 = $this->db->where('id',$q_id)->where('store_id',$store_id)->update('db_sales_types', $info);
        
            if ($q1){
                    $this->session->set_flashdata('success', 'Success!! Sales Type Updated Successfully!');
                    return "success";
            }
            else{
                    return "failed";
            }
        }
    }
    public function update_status($id,$status){
       if (set_status_of_table($id,$status,'db_sales_types')){
            echo "success";
        }
        else{
            echo "failed";
        }
    }
    public function delete_sales_type($id){
        $this->db->where("id",$id);
        //if not admin
        if(!is_admin()){
            $this->db->where("store_id",get_current_store_id());
        }

        $query1=$this->db->delete("db_sales_types");
        if ($query1){
            echo "success";
        }
        else{
            echo "failed";
        }
    }

}
