<!DOCTYPE html>
<html>
<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- </copy> -->  
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

 
  <!-- Left side column. contains the logo and sidebar -->
  <?php include"sidebar.php"; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <?=$page_title;?>
        <small>Add/Update Sales Return Type</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="<?php echo $base_url; ?>sales_return_types">Sales Return Types</a></li>
        <li class="active"><?=$page_title;?></li>
      </ol>
    </section>
    
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <!-- right column -->
        <div class="col-md-12">
          <!-- Horizontal Form -->
          <div class="box box-info ">
            <div class="box-header with-border">
              <h3 class="box-title">Please Enter Valid Information</h3>
            </div>
            <!-- /.box-header -->
            <!-- form start -->
            <form class="form-horizontal" id="sales-return-types-form">
              <input type="hidden" id='base_url' value="<?=$base_url;?>">
              <div class="box-body">
                <div class="form-group">
                  <label for="sales_return_type_name" class="col-sm-2 control-label">Sales Return Type Name <span class="text-red">*</span></label>
                  <div class="col-sm-4">
                    <input type="text" class="form-control" id="sales_return_type_name" name="sales_return_type_name" placeholder="Enter Sales Return Type Name" value="<?php print @$sales_return_type_name; ?>">
                    <span id="sales_return_type_name_msg" style="display:none" class="text-red"></span>
                  </div>
                  
                  <label for="sales_return_type_initial" class="col-sm-2 control-label">Initial <span class="text-red">*</span></label>
                  <div class="col-sm-4">
                    <input type="text" class="form-control" id="sales_return_type_initial" name="sales_return_type_initial" placeholder="Enter Initial" value="<?php print @$sales_return_type_initial; ?>" maxlength="10" style="text-transform:uppercase">
                    <span id="sales_return_type_initial_msg" style="display:none" class="text-red"></span>
                  </div>
                </div>
                <div class="form-group">
                  <label for="description" class="col-sm-2 control-label">Description</label>
                  <div class="col-sm-10">
                    <textarea class="form-control" id="description" name="description" placeholder="Enter Description (Optional)" rows="3"><?php print @$description; ?></textarea>
                    <span id="description_msg" style="display:none" class="text-red"></span>
                  </div>
                </div>
                
                <?php 
                if(store_module() && is_admin()){ ?>
                <div class="form-group">
                  <label for="store_id" class="col-sm-2 control-label">Store <span class="text-red">*</span></label>
                  <div class="col-sm-4">
                    <select class="form-control select2" id="store_id" name="store_id" style="width: 100%;" >
                      <?= get_store_select_list(@$store_id); ?>
                    </select>
                    <span id="store_id_msg" style="display:none" class="text-red"></span>
                  </div>
                </div>
                <?php } ?>
                
              </div>
              <!-- /.box-body -->
              <div class="box-footer">
                <div class="col-sm-8 col-sm-offset-2 text-center">
                   <div class="col-md-3 col-md-offset-3">
                      <button type="button" id="<?php echo isset($q_id) ? 'update' : 'save'; ?>" class=" btn btn-block btn-success" title="Save Data">Save</button>
                   </div>
                   <div class="col-md-3">
                      <a href="<?=base_url('sales_return_types');?>">
                        <button type="button" class="col-sm-3 btn btn-block btn-warning close_button" title="Go Back">Back</button>
                      </a>
                   </div>
                </div>
              </div>
              <!-- /.box-footer -->
              <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
              <input type="hidden" name="q_id" id="q_id" value="<?php echo @$q_id;?>"/>
            </form>
          </div>
          <!-- /.box -->
        </div>
        <!--/.col (right) -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include"footer.php"; ?>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>

<script src="<?php echo $theme_link; ?>js/sales_return_types.js"></script>
<script type="text/javascript">
  <?php if(isset($q_id)){ ?>
  $("#store_id").attr('readonly',true);
  <?php }?>
</script>
<!-- Make sidebar less active -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>

</body>
</html>
