<!DOCTYPE html>
<html>

<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <!-- Left side column. contains the logo and sidebar -->
  
  <?php include"sidebar.php"; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Sales Types List
        <small>View/Search Sales Types</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Sales Types List</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <!-- ********** ALERT MESSAGE START******* -->
        <?php include"comman/code_flashdata.php"; ?>
        <!-- ********** ALERT MESSAGE END******* -->
        <input type="hidden" id='base_url' value="<?=$base_url;?>">
        <div class="col-xs-12">
          <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title">Sales Types List</h3>
              <?php if($CI->permissions('sales_types_add')) { ?>
              <div class="box-tools">
                <a class="btn btn-block btn-info" href="<?php echo $base_url; ?>sales_types/add">
                <i class="fa fa-plus"></i> New Sales Type</a>
              </div>
              <?php } ?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example2" class="table table-bordered custom_hover" width="100%">
                <thead class="bg-gray ">
                <tr>
                  <!-- <th>Store Name</th> -->
                  <th>Sales Type Name</th>
                  <th>Initial</th>
                  <th>Description</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
				
                </tbody>
               
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include"footer.php"; ?>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
<!-- TABLES Script -->
<?php include"comman/code_js.php"; ?>


<script type="text/javascript">
  var base_url=$("#base_url").val();
//datatables
$(document).ready(function() {

  $('#example2').DataTable({
    "paging": true,
    "lengthChange": true,
    "searching": true,
    "ordering": true,
    "info": true,
    "autoWidth": false,
    "responsive": true,
    "processing": true, //Feature control the processing indicator.
    "serverSide": true, //Feature control DataTables' server-side processing mode.
    "order": [], //Initial no order.

    // Load data for the table's content from an Ajax source
    "ajax": {
        "url": base_url+"sales_types/ajax_list",
        "type": "POST"
    },

    //Set column definition initialisation properties.
    "columnDefs": [
    { 
        "targets": [ -1 ], //last column
        "orderable": false, //set not orderable
    },
    ],

  });

});

function update_status(id,status)
{
  if(confirm("Do You Wants to Change Status ?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url+"sales_types/update_status",{id:id,status:status},function(result){
      if(result=="success")
              {
                 //alert("Status Updated Successfully!");
                toastr["success"]("Status Updated Successfully!");
                 $('#example2').DataTable().ajax.reload();
              }
              else if(result=="failed"){
                toastr["error"]("Status Update Failed!");
              }
              else{
                toastr["error"](result);
              }
              $(".overlay").remove();
    });
  }
  //e.preventDefault
}

function delete_sales_type(q_id)
{
    if(confirm("Do You Wants to Delete Record ?")){
      $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
      $.post(base_url+"sales_types/delete_sales_type",{q_id:q_id},function(result){
      //alert(result);return;
        if(result=="success")
                {
                   //alert("Record Deleted Successfully!");
                  toastr["success"]("Record Deleted Successfully!");
                   $('#example2').DataTable().ajax.reload();
                }
                else if(result=="failed"){
                  toastr["error"]("Failed to Delete Record!");
                }
                else{
                  toastr["error"](result);
                }
                $(".overlay").remove();
      });
    }
    //e.preventDefault
}
</script>

<!-- Make sidebar menu hughlighter/selector -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>

</body>
</html>
