<!DOCTYPE html>
<html>
<head>
	<title>Invoice Template 1</title>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<style type="text/css">
	/* Thermal Printer 3-inch (80mm) Optimized Styles */
	body{
		font-family: 'Courier New', monospace;
		font-size: 10px;
		line-height: 1.2;
		margin: 0;
		padding: 5px;
		background: white;
		color: black;
		width: 75mm; /* 3 inch = ~75mm usable width */
	}

	.invoice-container {
		width: 100%;
		margin: 0;
		background: white;
		border: none;
		box-shadow: none;
	}

	.invoice-header {
		text-align: center;
		border-bottom: 1px solid #000;
		padding-bottom: 5px;
		margin-bottom: 8px;
	}

	.invoice-header h1 {
		margin: 0;
		font-size: 14px;
		font-weight: bold;
		text-transform: uppercase;
	}

	.invoice-body {
		padding: 0;
	}

	.company-info {
		text-align: center;
		border-bottom: 1px dashed #000;
		padding-bottom: 8px;
		margin-bottom: 8px;
	}

	.company-info h2 {
		margin: 0 0 3px 0;
		font-size: 12px;
		font-weight: bold;
	}

	.company-info p {
		margin: 1px 0;
		font-size: 9px;
	}

	.section {
		margin-bottom: 8px;
		border-bottom: 1px dashed #000;
		padding-bottom: 5px;
	}

	.section h3 {
		margin: 0 0 3px 0;
		font-size: 10px;
		font-weight: bold;
		text-transform: uppercase;
	}

	.section p {
		margin: 1px 0;
		font-size: 9px;
	}

	.items-table {
		width: 100%;
		border-collapse: collapse;
		margin: 5px 0;
		font-size: 8px;
	}

	.items-table th {
		padding: 2px 1px;
		text-align: left;
		font-weight: bold;
		font-size: 8px;
		border-bottom: 1px solid #000;
	}

	.items-table td {
		padding: 1px;
		font-size: 8px;
		vertical-align: top;
	}

	.items-table .item-row {
		border-bottom: 1px dotted #000;
	}

	.totals-section {
		margin-top: 8px;
		border-top: 1px solid #000;
		padding-top: 5px;
	}

	.total-row {
		display: flex;
		justify-content: space-between;
		margin: 1px 0;
		font-size: 9px;
	}

	.total-row.grand-total {
		font-size: 11px;
		font-weight: bold;
		border-top: 1px solid #000;
		padding-top: 3px;
		margin-top: 5px;
	}

	.payment-status {
		display: inline-block;
		padding: 1px 3px;
		font-size: 8px;
		font-weight: bold;
		text-transform: uppercase;
		border: 1px solid #000;
	}

	.invoice-footer {
		text-align: center;
		margin-top: 10px;
		border-top: 1px dashed #000;
		padding-top: 5px;
		font-size: 8px;
	}

	.text-right {
		text-align: right;
	}

	.text-center {
		text-align: center;
	}

	.text-left {
		text-align: left;
	}

	.bold {
		font-weight: bold;
	}

	/* Remove all rounded corners, gradients, and shadows for thermal printing */
	.badge {
		display: inline-block;
		padding: 1px 3px;
		background: black;
		color: white;
		font-size: 8px;
		font-weight: bold;
	}

	/* Print optimizations */
	@media print {
		body {
			margin: 0;
			padding: 2px;
		}
		.no-print { 
			display: none; 
		}
	}

	/* Ensure single column layout always */
	.info-grid {
		display: block;
	}

	.info-section {
		margin-bottom: 8px;
		padding: 3px 0;
		border-bottom: 1px dashed #000;
	}

	/* Simplify table for thermal printing */
	.thermal-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 8px;
	}

	.thermal-table td {
		padding: 1px 2px;
		border: none;
	}

	/* Line separator */
	.line-separator {
		border-bottom: 1px dashed #000;
		margin: 5px 0;
		height: 1px;
	}

	.double-line {
		border-bottom: 2px solid #000;
		margin: 5px 0;
		height: 2px;
	}
</style>
</head>
<body onload="window.print();">
	<?php
	$CI =& get_instance();
	
	// Add function existence checks to prevent errors
	if (!function_exists('show_date')) {
		function show_date($date = '') {
			return date('Y-m-d', strtotime($date));
		}
	}
	if (!function_exists('show_time')) {
		function show_time($time = '') {
			return date('H:i:s', strtotime($time));
		}
	}
	if (!function_exists('store_number_format')) {
		function store_number_format($value = 0, $comma = true) {
			return number_format($value, 2);
		}
	}
	if (!function_exists('get_country')) {
		function get_country($country_id = '') {
			if(empty($country_id)) return '';
			$CI =& get_instance();
			$query = $CI->db->query("SELECT country FROM db_country WHERE id = ?", array($country_id));
			return $query->num_rows() > 0 ? $query->row()->country : '';
		}
	}
	if (!function_exists('get_state')) {
		function get_state($state_id = '') {
			if(empty($state_id)) return '';
			$CI =& get_instance();
			$query = $CI->db->query("SELECT state FROM db_states WHERE id = ?", array($state_id));
			return $query->num_rows() > 0 ? $query->row()->state : '';
		}
	}
	
	$q3=$this->db->query("SELECT b.coupon_id,b.coupon_amt, b.created_by, b.customer_previous_due,b.customer_total_due,b.store_id,a.customer_name,a.mobile,a.phone,a.gstin,a.tax_number,a.email,a.delete_bit,b.invoice_terms,
                           a.opening_balance,a.country_id,a.state_id,
                           a.postcode,a.address,b.sales_date,b.created_time,b.reference_no,
                           b.sales_code,b.sales_note,a.sales_due,
                           coalesce(b.grand_total,0) as grand_total,
                           coalesce(b.subtotal,0) as subtotal,
                           coalesce(b.paid_amount,0) as paid_amount,
                           coalesce(b.other_charges_input,0) as other_charges_input,
                           other_charges_tax_id,
                           coalesce(b.other_charges_amt,0) as other_charges_amt,
                           discount_to_all_input,
                           b.discount_to_all_type,
                           coalesce(b.tot_discount_to_all_amt,0) as tot_discount_to_all_amt,
                           coalesce(b.round_off,0) as round_off,
                           b.payment_status

                           FROM db_customers a,
                           db_sales b 
                           WHERE 
                           a.`id`=b.`customer_id` AND 
                           b.`id`='$sales_id' 
                           ");
                        
    $res3=$q3->row();
    $customer_name=$res3->customer_name;
    $customer_mobile=$res3->mobile;
    $customer_phone=$res3->phone;
    $customer_email=$res3->email;
    $customer_country=isset($res3->country_id) ? get_country($res3->country_id) : '';
    $customer_state=isset($res3->state_id) ? get_state($res3->state_id) : '';
    $customer_address=$res3->address;
    $customer_postcode=$res3->postcode;
    $customer_city=''; // Initialize customer_city variable
    $customer_gst_no=$res3->gstin;
    $customer_tax_number=$res3->tax_number;
    $customer_opening_balance=$res3->opening_balance;
    $sales_date=show_date($res3->sales_date);
    $created_time=show_time($res3->created_time);
    $sales_code=$res3->sales_code;
    $sales_note=$res3->sales_note;
    $reference_no=$res3->reference_no;
    $invoice_terms=$res3->invoice_terms;
    
    $subtotal=$res3->subtotal;
    $grand_total=$res3->grand_total;
    $other_charges_input=$res3->other_charges_input;
    $other_charges_tax_id=$res3->other_charges_tax_id;
    $other_charges_amt=$res3->other_charges_amt;
    $paid_amount=$res3->paid_amount;
    $discount_to_all_input=$res3->discount_to_all_input;
    $discount_to_all_type=$res3->discount_to_all_type;
    $tot_discount_to_all_amt=$res3->tot_discount_to_all_amt;
    $round_off=$res3->round_off;
    $payment_status=$res3->payment_status;
    $customer_previous_due=$res3->customer_previous_due;
    $customer_total_due=$res3->customer_total_due;
    
    $q1=$this->db->query("select * from db_store where id=".$res3->store_id." ");
    $res1=$q1->row();
    $store_name=$res1->store_name;
    $company_mobile=$res1->mobile;
    $company_phone=$res1->phone;
    $company_email=$res1->email;
    $company_city=$res1->city;
    $company_address=$res1->address;
    $company_postcode=$res1->postcode;
    $company_state=isset($res1->state_id) ? get_state($res1->state_id) : '';
    $company_country=isset($res1->country_id) ? get_country($res1->country_id) : '';
    $company_gst_no=$res1->gst_no;
    $store_logo=$res1->store_logo;
    $store_website=$res1->store_website;
    
    $previous_due=0;
    // Use customer_previous_due from database query instead of undefined function
    $previous_due = isset($res3->customer_previous_due) ? $res3->customer_previous_due : 0;
    
    // Payment status styling
    $status_class = '';
    $status_text = '';
    if($payment_status == 'Paid') {
        $status_class = 'status-paid';
        $status_text = 'PAID';
    } elseif($payment_status == 'Partial') {
        $status_class = 'status-partial';
        $status_text = 'PARTIALLY PAID';
    } else {
        $status_class = 'status-pending';
        $status_text = 'PENDING';
    }
    ?>

    <div class="invoice-container">
        <!-- Header -->
        <div class="invoice-header">
            <h1>SALES INVOICE</h1>
            <span class="badge"><?= $sales_code ?></span>
            <span class="payment-status"><?= $status_text ?></span>
        </div>

        <div class="invoice-body">
            <!-- Company Information -->
            <div class="company-info">
                <h2><?= $store_name ?></h2>
                <p><?= $company_address ?></p>
                <p><?= $company_city ?>, <?= $company_state ?> <?= $company_postcode ?></p>
                <p><?= $company_country ?></p>
                <p>Ph: <?= $company_mobile ?></p>
                <p>Email: <?= $company_email ?></p>
                <?php if(!empty($company_gst_no)): ?>
                <p>GST: <?= $company_gst_no ?></p>
                <?php endif; ?>
            </div>

            <!-- Customer Info -->
            <div class="section">
                <h3>BILL TO</h3>
                <p class="bold"><?= $customer_name ?></p>
                <?php if(!empty($customer_address)): ?>
                <p><?= $customer_address ?></p>
                <?php endif; ?>
                <?php if(!empty($customer_mobile)): ?>
                <p>Ph: <?= $customer_mobile ?></p>
                <?php endif; ?>
                <?php if(!empty($customer_gst_no)): ?>
                <p>GST: <?= $customer_gst_no ?></p>
                <?php endif; ?>
            </div>

            <!-- Invoice Details -->
            <div class="section">
                <table class="thermal-table">
                    <tr>
                        <td class="bold">Invoice #:</td>
                        <td><?= $sales_code ?></td>
                    </tr>
                    <tr>
                        <td class="bold">Date:</td>
                        <td><?= $sales_date ?></td>
                    </tr>
                    <tr>
                        <td class="bold">Time:</td>
                        <td><?= $created_time ?></td>
                    </tr>
                    <?php if(!empty($reference_no)): ?>
                    <tr>
                        <td class="bold">Ref #:</td>
                        <td><?= $reference_no ?></td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>

            <!-- Items -->
            <div class="double-line"></div>
            <table class="items-table">
                <thead>
                    <tr>
                        <th style="width: 50%">ITEM</th>
                        <th style="width: 15%" class="text-center">QTY</th>
                        <th style="width: 20%" class="text-right">RATE</th>
                        <th style="width: 15%" class="text-right">AMT</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 1;
                    // Use the same query structure as the working sal-invoice-pos.php
                    $this->db->select("a.description, c.item_name, a.sales_qty, a.tax_type, a.price_per_unit, b.tax, b.tax_name, a.tax_amt, a.discount_input, a.discount_amt, a.unit_total_cost, a.total_cost, d.unit_name, c.sku, c.hsn");
                    $this->db->where("a.sales_id", $sales_id);
                    $this->db->from("db_salesitems a");
                    $this->db->join("db_tax b", "b.id=a.tax_id", "left");
                    $this->db->join("db_items c", "c.id=a.item_id", "left");
                    $this->db->join("db_units d", "d.id = c.unit_id", "left");
                    $q2 = $this->db->get();
                    $subtotal_amt = 0;
                    $total_tax_amt = 0;

                    foreach($q2->result() as $res2):
                        $item_name = $res2->item_name;
                        $unit_name = isset($res2->unit_name) ? $res2->unit_name : '';
                        $item_total_cost = $res2->unit_total_cost; // Use unit_total_cost from salesitems
                        $item_tax_amount = $res2->tax_amt;
                        $item_final_total = $res2->total_cost; // Use total_cost from salesitems
                        
                        $subtotal_amt += $item_total_cost;
                        $total_tax_amt += $item_tax_amount;
                    ?>
                    <tr class="item-row">
                        <td>
                            <div class="bold"><?= $item_name ?></div>
                            <?php if(!empty($res2->description)): ?>
                            <div style="font-size: 7px;"><?= $res2->description ?></div>
                            <?php endif; ?>
                            <?php if($res2->tax_amt > 0): ?>
                            <div style="font-size: 7px;">Tax: <?= store_number_format($res2->tax_amt) ?></div>
                            <?php endif; ?>
                        </td>
                        <td class="text-center"><?= store_number_format($res2->sales_qty, false) ?><?= !empty($unit_name) ? ' '.$unit_name : '' ?></td>
                        <td class="text-right"><?= store_number_format($res2->price_per_unit) ?></td>
                        <td class="text-right bold"><?= store_number_format($item_final_total) ?></td>
                    </tr>
                    <?php 
                    $i++; 
                    endforeach; 
                    ?>
                </tbody>
            </table>

            <!-- Totals Section -->
            <div class="double-line"></div>
            <div class="totals-section">
                <div class="total-row">
                    <span>Subtotal:</span>
                    <span><?= store_number_format($subtotal) ?></span>
                </div>
                
                <?php if($discount_to_all_input > 0): ?>
                <div class="total-row">
                    <span>Discount<?php 
                        if($discount_to_all_type == 'in_percentage') {
                            echo " ($discount_to_all_input%)";
                        }
                    ?>:</span>
                    <span>-<?= store_number_format($tot_discount_to_all_amt) ?></span>
                </div>
                <?php endif; ?>
                
                <?php if($other_charges_input > 0): ?>
                <div class="total-row">
                    <span>Other Charges:</span>
                    <span><?= store_number_format($other_charges_amt) ?></span>
                </div>
                <?php endif; ?>
                
                <?php if($round_off != 0): ?>
                <div class="total-row">
                    <span>Round Off:</span>
                    <span><?= store_number_format($round_off) ?></span>
                </div>
                <?php endif; ?>
                
                <div class="total-row grand-total">
                    <span>GRAND TOTAL:</span>
                    <span><?= store_number_format($grand_total) ?></span>
                </div>
                
                <div class="total-row">
                    <span>Paid Amount:</span>
                    <span><?= store_number_format($paid_amount) ?></span>
                </div>
                
                <?php 
                $due_amount = $grand_total - $paid_amount;
                if($due_amount > 0): 
                ?>
                <div class="total-row bold">
                    <span>Due Amount:</span>
                    <span><?= store_number_format($due_amount) ?></span>
                </div>
                <?php endif; ?>
                
                <?php if($previous_due > 0): ?>
                <div class="total-row">
                    <span>Previous Due:</span>
                    <span><?= store_number_format($previous_due) ?></span>
                </div>
                <?php endif; ?>
            </div>

            <?php if(!empty($sales_note)): ?>
            <div class="line-separator"></div>
            <div class="section">
                <h3>NOTES:</h3>
                <p style="font-size: 8px;"><?= $sales_note ?></p>
            </div>
            <?php endif; ?>

            <?php if(!empty($invoice_terms)): ?>
            <div class="line-separator"></div>
            <div class="section">
                <h3>TERMS & CONDITIONS:</h3>
                <p style="font-size: 8px;"><?= $invoice_terms ?></p>
            </div>
            <?php endif; ?>
        </div>

        <!-- Footer -->
        <div class="invoice-footer">
            <div class="double-line"></div>
            <p class="text-center bold">Thank you for your business!</p>
            <p class="text-center" style="font-size: 7px;">
                Generated: <?= date('Y-m-d H:i:s') ?>
            </p>
            <p class="text-center" style="font-size: 7px;">
                Powered by <?= $store_name ?>
            </p>
        </div>
    </div>

</body>
</html>
