<!DOCTYPE html>
<html>
<head>
    <?php include"comman/code_css.php"; ?>
    <link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/datatables/dataTables.bootstrap.css">
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php include"sidebar.php"; ?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Purchase Return Types List <small>View/Search Purchase Return Types</small></h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Purchase Return Types List</li>
            </ol>
        </section>

        <section class="content">
            <div class="row">
                <?php include"comman/code_flashdata.php"; ?>
                <input type="hidden" id='base_url' value="<?=$base_url;?>">
                
                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Purchase Return Types List</h3>
                            <?php if($CI->permissions('purchase_return_types_add')) { ?>
                            <div class="box-tools">
                                <a class="btn btn-block btn-info" href="<?php echo $base_url; ?>purchase_return_types/add">
                                    <i class="fa fa-plus"></i> New Purchase Return Type
                                </a>
                            </div>
                            <?php } ?>
                        </div>
                        
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="example2" class="table table-bordered table-hover" width="100%">
                                    <thead class="bg-gray">
                                        <tr>
                                            <th>Return Type Name</th>
                                            <th>Initial</th>
                                            <th>Description</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    
    <?php include"footer.php"; ?>
    <div class="control-sidebar-bg"></div>
</div>

<?php include"comman/code_js.php"; ?>
<script src="<?php echo $theme_link; ?>plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo $theme_link; ?>plugins/datatables/dataTables.bootstrap.min.js"></script>

<script type="text/javascript">
var base_url = $("#base_url").val();

$(document).ready(function() {
    $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "processing": true,
        "serverSide": true,
        "order": [],
        "ajax": {
            "url": base_url + "purchase_return_types/ajax_list",
            "type": "POST"
        },
        "columnDefs": [
            { 
                "targets": [-1, -2],
                "orderable": false,
            },
        ],
        "language": {
            "processing": "Loading data...",
            "lengthMenu": "Show _MENU_ entries",
            "zeroRecords": "No matching records found",
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "infoEmpty": "Showing 0 to 0 of 0 entries",
            "infoFiltered": "(filtered from _MAX_ total entries)",
            "search": "Search:",
            "paginate": {
                "first": "First",
                "last": "Last",
                "next": "Next",
                "previous": "Previous"
            }
        }
    });
});

/**
 * Update record status
 */
function update_status(id, status){
    if(confirm("Do you want to change the status?")) {
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $.post(base_url + "purchase_return_types/update_status", {id: id, status: status}, function(result){
            if(result == "success") {
                toastr["success"]("Status updated successfully!");
                $('#example2').DataTable().ajax.reload();
            } else if(result == "failed"){
                toastr["error"]("Status update failed!");
            } else {
                toastr["error"](result);
            }
            $(".overlay").remove();
        });
    }
}

/**
 * Delete record
 */
function delete_purchase_return_type(q_id){
    if(confirm("Do you want to delete this record?")) {
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $.post(base_url + "purchase_return_types/delete_purchase_return_type", {q_id: q_id}, function(result){
            if(result == "success") {
                toastr["success"]("Record deleted successfully!");
                $('#example2').DataTable().ajax.reload();
            } else if(result == "failed"){
                toastr["error"]("Failed to delete record!");
            } else {
                toastr["error"](result);
            }
            $(".overlay").remove();
        });
    }
}
</script>

<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
</body>
</html>
