<!DOCTYPE html>
<html>
<title><?= $page_title;?> - Modern Professional Template</title>
<head>
<meta charset="UTF-8">
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', 'Segoe UI Emoji', 'Segoe UI Symbol', system-ui, -apple-system, sans-serif;
        font-size: 12px;
        line-height: 1.4;
        color: #1a1a1a;
        background: #ffffff;
        word-wrap: break-word;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
    }

    @page {
        size: A4;
        margin: 15mm 15mm 20mm 15mm;
    }

    /* Header Styles */
    .invoice-header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 40px;
        padding-bottom: 30px;
        border-bottom: 3px solid #2563eb;
    }

    .company-info {
        flex: 1;
        max-width: 60%;
    }

    .company-logo {
        max-width: 180px;
        max-height: 80px;
        margin-bottom: 15px;
        object-fit: contain;
    }

    .company-name {
        font-size: 24px;
        font-weight: 700;
        color: #1e3a8a;
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .company-details {
        font-size: 11px;
        color: #4b5563;
        line-height: 1.5;
    }

    .invoice-meta {
        flex: 0 0 35%;
        text-align: right;
    }

    .invoice-title {
        font-size: 32px;
        font-weight: 700;
        color: #1e3a8a;
        margin-bottom: 15px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .invoice-number {
        background: linear-gradient(135deg, #2563eb, #1d4ed8);
        color: white;
        padding: 12px 20px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        margin-bottom: 10px;
        box-shadow: 0 4px 6px rgba(37, 99, 235, 0.1);
    }

    .invoice-date {
        font-size: 11px;
        color: #6b7280;
        margin-bottom: 5px;
    }

    /* Address Section */
    .address-section {
        display: flex;
        justify-content: space-between;
        margin-bottom: 40px;
        gap: 30px;
    }

    .address-block {
        flex: 1;
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        padding: 20px;
        position: relative;
    }

    .address-block::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #2563eb, #3b82f6);
        border-radius: 12px 12px 0 0;
    }

    .address-title {
        font-size: 14px;
        font-weight: 600;
        color: #1e3a8a;
        margin-bottom: 12px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .address-content {
        font-size: 11px;
        color: #374151;
        line-height: 1.6;
    }

    .address-content strong {
        color: #1f2937;
        font-weight: 600;
    }

    /* Items Table */
    .items-table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 30px;
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    }

    .items-table thead {
        background: linear-gradient(135deg, #1e3a8a, #2563eb);
        color: white;
    }

    .items-table th {
        padding: 15px 12px;
        text-align: left;
        font-weight: 600;
        font-size: 11px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border: none;
    }

    .items-table th:first-child { border-radius: 12px 0 0 0; }
    .items-table th:last-child { border-radius: 0 12px 0 0; }

    .items-table tbody tr {
        border-bottom: 1px solid #f1f5f9;
        transition: background-color 0.2s ease;
    }

    .items-table tbody tr:hover {
        background-color: #f8fafc;
    }

    .items-table tbody tr:last-child {
        border-bottom: none;
    }

    .items-table td {
        padding: 12px;
        font-size: 11px;
        vertical-align: top;
        border: none;
    }

    .text-center { text-align: center; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }

    .item-description {
        font-weight: 500;
        color: #1f2937;
        margin-bottom: 4px;
    }

    .item-details {
        font-size: 10px;
        color: #6b7280;
        font-style: italic;
    }

    /* Summary Section */
    .summary-section {
        display: flex;
        justify-content: flex-end;
        margin-bottom: 40px;
    }

    .summary-table {
        width: 350px;
        border-collapse: collapse;
        background: #f8fafc;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    }

    .summary-table tr {
        border-bottom: 1px solid #e2e8f0;
    }

    .summary-table tr:last-child {
        border-bottom: none;
        background: linear-gradient(135deg, #1e3a8a, #2563eb);
        color: white;
        font-weight: 700;
    }

    .summary-table td {
        padding: 12px 15px;
        font-size: 12px;
        border: none;
    }

    .summary-table .label {
        font-weight: 500;
    }

    .summary-table .amount {
        text-align: right;
        font-weight: 600;
    }

    /* Tax Breakdown */
    .tax-breakdown {
        margin: 30px 0;
        background: #f8fafc;
        border-radius: 12px;
        padding: 20px;
        border: 1px solid #e2e8f0;
    }

    .tax-breakdown-title {
        font-size: 14px;
        font-weight: 600;
        color: #1e3a8a;
        margin-bottom: 15px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .tax-table {
        width: 100%;
        border-collapse: collapse;
    }

    .tax-table th {
        background: #e2e8f0;
        padding: 10px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
        color: #374151;
        border: 1px solid #cbd5e1;
    }

    .tax-table td {
        padding: 8px 10px;
        font-size: 11px;
        border: 1px solid #e2e8f0;
        text-align: center;
    }

    /* Bank Details & Terms */
    .footer-section {
        display: flex;
        gap: 30px;
        margin-bottom: 40px;
    }

    .bank-details, .terms-conditions {
        flex: 1;
        background: #f8fafc;
        border-radius: 12px;
        padding: 20px;
        border: 1px solid #e2e8f0;
    }

    .section-title {
        font-size: 14px;
        font-weight: 600;
        color: #1e3a8a;
        margin-bottom: 12px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .section-content {
        font-size: 11px;
        color: #374151;
        line-height: 1.6;
    }

    /* Signatures */
    .signatures {
        display: flex;
        justify-content: space-between;
        margin-top: 60px;
        padding-top: 20px;
        border-top: 1px solid #e2e8f0;
    }

    .signature-block {
        text-align: center;
        width: 200px;
    }

    .signature-line {
        border-top: 2px solid #374151;
        margin-bottom: 8px;
        height: 60px;
        display: flex;
        align-items: flex-end;
    }

    .signature-label {
        font-size: 11px;
        font-weight: 600;
        color: #374151;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Footer */
    .invoice-footer {
        text-align: center;
        margin-top: 40px;
        padding-top: 20px;
        border-top: 2px solid #2563eb;
        font-size: 11px;
        color: #6b7280;
    }

    .footer-message {
        font-size: 14px;
        font-weight: 600;
        color: #1e3a8a;
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Utility Classes */
    .font-bold { font-weight: 600; }
    .font-semibold { font-weight: 500; }
    .mb-2 { margin-bottom: 8px; }
    .mb-4 { margin-bottom: 16px; }
    
    /* Print Styles */
    @media print {
        body { margin: 0; }
        .invoice-header { page-break-inside: avoid; }
        .items-table { page-break-inside: avoid; }
        .summary-section { page-break-inside: avoid; }
    }

    /* Responsive adjustments for different paper sizes */
    @media (max-width: 210mm) {
        .company-name { font-size: 20px; }
        .invoice-title { font-size: 28px; }
        .address-section { flex-direction: column; gap: 20px; }
        .footer-section { flex-direction: column; gap: 20px; }
    }
</style>
</head>
<body onload="window.print();">

<?php
    // Current Store Records
    $store_rec = get_store_details();
    $store_logo = (!empty($store_rec->store_logo)) ? $store_rec->store_logo : store_demo_logo();

    // Sales Records
    $sales_rec = get_sales_details($sales_id);
    $customer_rec = get_customer_details($sales_rec->customer_id);

    // Customer Records
    $state_rec = (!empty($customer_rec->state_id)) ? get_state_details($customer_rec->state_id) : '';
    $customer_state_name = (!empty($state_rec)) ? $state_rec->state : $store_rec->state;
    
    // Customer Find Previous Due & Total Due
    $previous_due = ($customer_rec->sales_due) - ($sales_rec->grand_total - $sales_rec->paid_amount);
    $previous_due = ($previous_due > 0) ? $previous_due : 0;
    $total_due = $customer_rec->sales_due;

    // Customer Shipping Address Records
    $shipping_country = '';
    $shipping_state = '';
    $shipping_city = '';
    $shipping_address = '';
    $shipping_postcode = '';
    if (!empty($customer_rec->shippingaddress_id)) {
        $Q2 = $this->db->select("c.country,s.state,a.city,a.postcode,a.address")
                        ->where("a.id", $customer_rec->shippingaddress_id)
                        ->from("db_shippingaddress a")
                        ->join("db_country c", "c.id = a.country_id", 'left')
                        ->join("db_states s", "s.id = a.state_id", 'left')
                        ->get();                    
        if ($Q2->num_rows() > 0) {
            $shipping_country = $Q2->row()->country;
            $shipping_state = $Q2->row()->state;
            $shipping_city = $Q2->row()->city;
            $shipping_address = $Q2->row()->address;
            $shipping_postcode = $Q2->row()->postcode;
        }
    }

    // Customer if Coupon Code applied, then get Records
    $coupon_code = '';
    $coupon_type = '';
    $coupon_value = 0;
    if (!empty($sales_rec->coupon_id)) {
        $coupon_details = get_customer_coupon_details($sales_rec->coupon_id);
        $coupon_code = $coupon_details->code;
        $coupon_value = $coupon_details->value;
        $coupon_type = $coupon_details->type;
    }
?>

<div class="invoice-container">
    <!-- Header Section -->
    <div class="invoice-header">
        <div class="company-info">
            <img src="<?= base_url($store_logo); ?>" alt="Company Logo" class="company-logo">
            <div class="company-name"><?php echo $store_rec->store_name; ?></div>
            <div class="company-details">
                <strong><?= $this->lang->line('address'); ?>:</strong> <?php echo $store_rec->address; ?><br>
                <strong><?= $this->lang->line('mobile'); ?>:</strong> <?php echo $store_rec->mobile; ?><br>
                <?php if (!empty(trim($store_rec->email))) { ?>
                    <strong><?= $this->lang->line('email'); ?>:</strong> <?php echo $store_rec->email; ?><br>
                <?php } ?>
                <?php if (!empty(trim($store_rec->gst_no))) { ?>
                    <strong><?= $this->lang->line('gst_number'); ?>:</strong> <?php echo $store_rec->gst_no; ?><br>
                <?php } ?>
                <?php if (!empty(trim($store_rec->store_website))) { ?>
                    <strong>Website:</strong> <?php echo $store_rec->store_website; ?>
                <?php } ?>
            </div>
        </div>
        
        <div class="invoice-meta">
            <div class="invoice-title">Tax Invoice</div>
            <div class="invoice-number">
                Invoice #<?php echo $sales_rec->sales_code; ?>
            </div>
            <div class="invoice-date">
                <strong>Date:</strong> <?php echo show_date($sales_rec->sales_date); ?>
            </div>
            <?php if (!empty($sales_rec->reference_no)) { ?>
                <div class="invoice-date">
                    <strong>Reference:</strong> <?php echo $sales_rec->reference_no; ?>
                </div>
            <?php } ?>
        </div>
    </div>

    <!-- Address Section -->
    <div class="address-section">
        <div class="address-block">
            <div class="address-title"><?= $this->lang->line('bill_to'); ?></div>
            <div class="address-content">
                <strong><?php echo $customer_rec->customer_name; ?></strong><br>
                <?php if (!empty(trim($customer_rec->address))) { ?>
                    <?php echo $customer_rec->address; ?><br>
                <?php } ?>
                <?php if (!empty(trim($customer_rec->gstin))) { ?>
                    <strong><?= $this->lang->line('gstin'); ?>:</strong> <?php echo $customer_rec->gstin; ?><br>
                <?php } ?>
                <?php if (!empty(trim($customer_rec->email))) { ?>
                    <strong><?= $this->lang->line('email'); ?>:</strong> <?php echo $customer_rec->email; ?><br>
                <?php } ?>
                <?php if (!empty(trim($customer_rec->mobile))) { ?>
                    <strong><?= $this->lang->line('mobile'); ?>:</strong> <?php echo $customer_rec->mobile; ?>
                <?php } ?>
            </div>
        </div>

        <div class="address-block">
            <div class="address-title"><?= $this->lang->line('ship_to'); ?></div>
            <div class="address-content">
                <strong><?php echo $customer_rec->customer_name; ?></strong><br>
                <?php
                if (!empty($shipping_address)) {
                    echo $shipping_address . "<br>";
                    echo $shipping_city . ", " . $shipping_state . "<br>";
                    echo $shipping_country . " - " . $shipping_postcode;
                } else {
                    echo "Same as billing address";
                }
                ?>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;"><?= $this->lang->line('sl_no'); ?></th>
                <th style="width: 35%;"><?= $this->lang->line('description_of_goods'); ?></th>
                <th style="width: 10%;"><?= $this->lang->line('hsn/sac'); ?></th>
                <th style="width: 8%;" class="text-center"><?= $this->lang->line('qty'); ?></th>
                <th style="width: 8%;" class="text-center"><?= $this->lang->line('gst_rate'); ?></th>
                <th style="width: 12%;" class="text-right"><?= $this->lang->line('rate'); ?></th>
                <th style="width: 10%;" class="text-right"><?= $this->lang->line('discount'); ?></th>
                <th style="width: 12%;" class="text-right"><?= $this->lang->line('amount'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            $i = 0;
            $tot_qty = 0;
            $tot_sales_price = 0;
            $tot_tax_amt = 0;
            $tot_discount_amt = 0;
            $tot_unit_total_cost = 0;
            $tot_total_cost = 0;
            $tot_before_tax = 0;

            $this->db->select("a.description,c.item_name, a.sales_qty,a.tax_type,
                              a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
                              a.discount_input,a.discount_amt, a.unit_total_cost,
                              a.total_cost , d.unit_name,c.sku,c.hsn");
            $this->db->where("a.sales_id", $sales_id);
            $this->db->from("db_salesitems a");
            $this->db->join("db_tax b", "b.id=a.tax_id", "left");
            $this->db->join("db_items c", "c.id=a.item_id", "left");
            $this->db->join("db_units d", "d.id = c.unit_id", "left");
            $q2 = $this->db->get();

            foreach ($q2->result() as $res2) {
                $discount = (empty($res2->discount_input) || $res2->discount_input == 0) ? store_number_format(0) : store_number_format($res2->discount_input) . "%";
                $discount_amt = (empty($res2->discount_amt) || $res2->discount_input == 0) ? '0' : $res2->discount_amt . "";
                $before_tax = $res2->price_per_unit;
                $tot_cost_before_tax = $res2->total_cost;
                
                echo "<tr>";
                echo "<td class='text-center'>" . ++$i . "</td>";
                echo "<td>";
                echo "<div class='item-description'>" . $res2->item_name . "</div>";
                if (!empty($res2->description)) {
                    echo "<div class='item-details'>" . nl2br($res2->description) . "</div>";
                }
                echo "</td>";
                echo "<td class='text-center'>" . $res2->hsn . "</td>";
                echo "<td class='text-center'>" . format_qty($res2->sales_qty) . "</td>";
                echo "<td class='text-center'>" . store_number_format($res2->tax) . "%</td>";
                echo "<td class='text-right'>" . store_number_format($before_tax) . "</td>";
                echo "<td class='text-right'>" . $discount . "</td>";
                echo "<td class='text-right'>" . store_number_format($tot_cost_before_tax) . "</td>";
                echo "</tr>";
                
                $tot_qty += $res2->sales_qty;
                $tot_sales_price += $res2->price_per_unit;
                $tot_tax_amt += $res2->tax_amt;
                $tot_discount_amt += $res2->discount_amt;
                $tot_unit_total_cost += $res2->unit_total_cost;
                $tot_before_tax += $before_tax;
                $tot_total_cost += $tot_cost_before_tax;
            }
            ?>
        </tbody>
    </table>

    <!-- Tax Breakdown -->
    <?php
    $tot_price_before_tax = $tot_price_after_tax = $tot_cgst_amt = $tot_sgst_amt = $tot_igst_amt = 0;

    $this->db->select("c.item_name,
                        COALESCE(SUM(a.price_per_unit),0) AS price_before_tax, 
                        b.tax,
                        b.tax_name,
                        COALESCE(SUM(a.tax_amt),0) AS sum_of_tax_amt,
                        COALESCE(SUM(a.total_cost),0) AS price_after_tax,
                        c.tax_type,
                        c.sku,c.hsn");

    $this->db->where("a.sales_id", $sales_id);
    $this->db->from("db_salesitems a");
    $this->db->join("db_tax b", "b.id=a.tax_id", "left");
    $this->db->join("db_items c", "c.id=a.item_id", "left");
    $this->db->join("db_units d", "d.id = c.unit_id", "left");

    $q2 = $this->db->get();
    foreach ($q2->result() as $res2) {
        $hsn = $res2->hsn;
        $price_before_tax = $res2->price_before_tax;
        $price_after_tax = $res2->price_after_tax;
        $tax_per = $res2->tax;
        $sum_of_tax_amt = $res2->sum_of_tax_amt;
        $price_before_tax = $price_after_tax - $sum_of_tax_amt;

        if ($customer_rec->id == 1 || (strtoupper($customer_state_name) == strtoupper($store_rec->state))) {
            $sgst_per = $cgst_per = $tax_per . "%";
            $sgst_amt = $cgst_amt = $sum_of_tax_amt / 2;
            $igst_per = $igst_amt = '';
        } else {
            $sgst_per = $cgst_per = '';
            $sgst_amt = $cgst_amt = '';
            $igst_per = $tax_per . "%";
            $igst_amt = $sum_of_tax_amt;
        }

        $tot_price_before_tax += $price_before_tax;
        $tot_price_after_tax += (!empty($price_after_tax)) ? $price_after_tax : 0;
        $tot_cgst_amt += (!empty($cgst_amt)) ? $cgst_amt : 0;
        $tot_sgst_amt += (!empty($sgst_amt)) ? $sgst_amt : 0;
        $tot_igst_amt += (!empty($igst_amt)) ? $igst_amt : 0;
    }
    ?>

    <div class="tax-breakdown">
        <div class="tax-breakdown-title">Tax Breakdown</div>
        <table class="tax-table">
            <thead>
                <tr>
                    <th>Taxable Amount</th>
                    <?php if (!empty($cgst_per)) { ?>
                        <th>CGST (<?= $cgst_per ?>)</th>
                        <th>SGST (<?= $sgst_per ?>)</th>
                    <?php } ?>
                    <?php if (!empty($igst_per)) { ?>
                        <th>IGST (<?= $igst_per ?>)</th>
                    <?php } ?>
                    <th>Total Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?= store_number_format($tot_price_before_tax) ?></td>
                    <?php if (!empty($cgst_per)) { ?>
                        <td><?= store_number_format($tot_cgst_amt) ?></td>
                        <td><?= store_number_format($tot_sgst_amt) ?></td>
                    <?php } ?>
                    <?php if (!empty($igst_per)) { ?>
                        <td><?= store_number_format($tot_igst_amt) ?></td>
                    <?php } ?>
                    <td><strong><?= store_number_format($sales_rec->grand_total) ?></strong></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <table class="summary-table">
            <tr>
                <td class="label">Subtotal:</td>
                <td class="amount"><?= store_number_format($tot_total_cost) ?></td>
            </tr>
            <?php if ($sales_rec->other_charges_amt != 0) { ?>
                <tr>
                    <td class="label"><?= $sales_rec->other_charges_input ?></td>
                    <td class="amount"><?= store_number_format($sales_rec->other_charges_amt) ?></td>
                </tr>
            <?php } ?>
            <?php if ($sales_rec->discount_to_all_amt != 0) { ?>
                <tr>
                    <td class="label">Discount:</td>
                    <td class="amount">-<?= store_number_format($sales_rec->discount_to_all_amt) ?></td>
                </tr>
            <?php } ?>
            <?php if ($tot_tax_amt != 0) { ?>
                <tr>
                    <td class="label">Total Tax:</td>
                    <td class="amount"><?= store_number_format($tot_tax_amt) ?></td>
                </tr>
            <?php } ?>
            <tr>
                <td class="label">Grand Total:</td>
                <td class="amount"><?= store_number_format($sales_rec->grand_total) ?></td>
            </tr>
            <tr>
                <td class="label">Paid Amount:</td>
                <td class="amount"><?= store_number_format($sales_rec->paid_amount) ?></td>
            </tr>
            <tr>
                <td class="label">Due Amount:</td>
                <td class="amount"><?= store_number_format($sales_rec->grand_total - $sales_rec->paid_amount) ?></td>
            </tr>
        </table>
    </div>

    <!-- Bank Details & Terms -->
    <div class="footer-section">
        <?php if (!empty(trim($store_rec->bank_details))) { ?>
            <div class="bank-details">
                <div class="section-title"><?= $this->lang->line('bank_details'); ?></div>
                <div class="section-content">
                    <?= nl2br($store_rec->bank_details); ?>
                </div>
            </div>
        <?php } ?>

        <?php if (!empty(trim($store_rec->sales_terms_and_conditions))) { ?>
            <div class="terms-conditions">
                <div class="section-title">Terms & Conditions</div>
                <div class="section-content">
                    <?= nl2br($store_rec->sales_terms_and_conditions); ?>
                </div>
            </div>
        <?php } ?>
    </div>

    <!-- Signatures -->
    <div class="signatures">
        <div class="signature-block">
            <div class="signature-line"></div>
            <div class="signature-label"><?= $this->lang->line('customer_signature'); ?></div>
        </div>
        <div class="signature-block">
            <div class="signature-line"></div>
            <div class="signature-label"><?= $this->lang->line('authorised_signatory'); ?></div>
        </div>
    </div>

    <!-- Footer -->
    <div class="invoice-footer">
        <?php if (!empty($store_rec->sales_invoice_footer_text)) { ?>
            <div class="footer-message"><?= $store_rec->sales_invoice_footer_text; ?></div>
        <?php } ?>
        <div class="footer-message">Thank You For Your Business!</div>
        <div>This is a computer generated invoice</div>
    </div>
</div>

</body>
</html>
