<!DOCTYPE html>
<html>
<title><?= $page_title;?>- GST Format</title>
<head>
<link rel='shortcut icon' href='<?php echo $theme_link; ?>images/favicon.ico' />

<style>
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', -apple-system, BlinkMacSystemFont, 'Inter', 'Arial', sans-serif;
    font-size: 10pt;
    color: #2c3e50;
    line-height: 1.6;
    background: white;
}

.invoice-container {
    max-width: 210mm;
    margin: 0 auto;
    padding: 10mm;
    background: white;
}

/* Header Styles */
.invoice-header {
    display: flex;
    justify-content: space-between;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 2px solid #f0f0f0;
}

.company-details {
    flex: 1;
}

.company-logo {
    max-width: 180px;
    height: auto;
    margin-bottom: 15px;
}

.company-info {
    color: #666;
    font-size: 9pt;
    line-height: 1.5;
}

.company-name {
    font-size: 18pt;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 8px;
}

.invoice-details {
    text-align: right;
    min-width: 250px;
}

.invoice-title {
    font-size: 24pt;
    font-weight: 300;
    color: #1a1a1a;
    margin-bottom: 15px;
    letter-spacing: -0.5px;
}

.invoice-meta {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 10px;
}

.invoice-meta-item {
    display: flex;
    justify-content: space-between;
    margin-bottom: 8px;
    font-size: 9pt;
}

.invoice-meta-item:last-child {
    margin-bottom: 0;
}

.meta-label {
    color: #666;
    font-weight: 500;
}

.meta-value {
    font-weight: 600;
    color: #1a1a1a;
}

/* Customer Section */
.customer-section {
    display: flex;
    gap: 30px;
    margin-bottom: 30px;
    background: #fafbfc;
    padding: 20px;
    border-radius: 8px;
    border: 1px solid #e1e4e8;
}

.customer-block {
    flex: 1;
}

.section-title {
    font-size: 11pt;
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 10px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.customer-info {
    font-size: 9pt;
    color: #666;
    line-height: 1.6;
}

.customer-info strong {
    color: #2c3e50;
    font-weight: 600;
}

/* Table Styles */
.items-table {
    width: 100%;
    border-collapse: separate;
    border-spacing: 0;
    margin-bottom: 30px;
    overflow: hidden;
    border-radius: 8px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.items-table thead {
    background: #2c3e50;
    color: white;
}

.items-table th {
    padding: 12px 15px;
    font-weight: 600;
    text-align: left;
    font-size: 9pt;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.items-table tbody tr {
    border-bottom: 1px solid #f0f0f0;
}

.items-table tbody tr:hover {
    background: #f8f9fa;
}

.items-table td {
    padding: 12px 15px;
    font-size: 9pt;
    vertical-align: top;
}

.text-center {
    text-align: center;
}

.text-right {
    text-align: right;
}

.item-name {
    font-weight: 600;
    color: #1a1a1a;
}

.item-description {
    font-size: 8pt;
    color: #666;
    font-style: italic;
    margin-top: 4px;
}

/* Summary Section */
.invoice-summary {
    display: flex;
    justify-content: flex-end;
    margin-bottom: 30px;
}

.summary-table {
    width: 350px;
    border-collapse: collapse;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    padding: 8px 0;
    border-bottom: 1px solid #f0f0f0;
}

.summary-label {
    font-size: 9pt;
    color: #666;
    font-weight: 500;
}

.summary-value {
    font-size: 9pt;
    color: #1a1a1a;
    font-weight: 600;
}

.summary-total {
    background: #f8f9fa;
    padding: 12px 15px;
    border-radius: 6px;
    margin-top: 10px;
}

.summary-total .summary-label {
    font-size: 11pt;
    color: #1a1a1a;
    font-weight: 600;
}

.summary-total .summary-value {
    font-size: 14pt;
    color: #2c3e50;
    font-weight: 700;
}

/* Amount in Words */
.amount-words {
    background: #e3f2fd;
    padding: 15px;
    border-radius: 6px;
    margin-bottom: 20px;
    border-left: 4px solid #2196f3;
}

.amount-words-label {
    font-weight: 600;
    color: #1565c0;
    margin-right: 10px;
}

/* Tax Summary Table */
.tax-summary {
    margin-bottom: 30px;
}

.tax-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 8pt;
    border: 1px solid #e1e4e8;
    border-radius: 6px;
    overflow: hidden;
}

.tax-table thead {
    background: #f6f8fa;
}

.tax-table th, .tax-table td {
    padding: 10px;
    border-right: 1px solid #e1e4e8;
    border-bottom: 1px solid #e1e4e8;
}

.tax-table th:last-child, .tax-table td:last-child {
    border-right: none;
}

.tax-table tbody tr:last-child td {
    border-bottom: none;
}

/* Footer Section */
.invoice-footer {
    margin-top: 40px;
    padding-top: 30px;
    border-top: 2px solid #f0f0f0;
}

.signature-section {
    display: flex;
    justify-content: space-between;
    margin-bottom: 30px;
}

.signature-block {
    width: 200px;
    text-align: center;
}

.signature-line {
    border-top: 1px solid #ddd;
    margin-top: 60px;
    padding-top: 10px;
    font-size: 9pt;
    color: #666;
    font-weight: 500;
}

.footer-notes {
    text-align: center;
    font-size: 8pt;
    color: #999;
    margin-top: 20px;
}

.bank-details {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 6px;
    font-size: 9pt;
    margin-bottom: 10px;
}

.bank-details-title {
    font-weight: 600;
    color: #1a1a1a;
    margin-bottom: 8px;
}

/* Print Styles */
@media print {
    body {
        margin: 0;
        padding: 0;
    }
    
    .invoice-container {
        padding: 0;
        max-width: 100%;
    }
    
    .items-table {
        box-shadow: none;
    }
    
    @page {
        size: A4;
        margin: 10mm;
    }
}

/* Utility Classes */
.mt-10 { margin-top: 10px; }
.mt-20 { margin-top: 20px; }
.mb-10 { margin-bottom: 10px; }
.mb-20 { margin-bottom: 20px; }
.font-bold { font-weight: 600; }

</style>
</head>
<body onload="window.print();">
<?php
   
    //Current Store Records
    $store_rec = get_store_details();
    $store_logo=(!empty($store_rec->store_logo)) ? $store_rec->store_logo : store_demo_logo();

    //Sales Records
    $sales_rec = get_sales_details($sales_id);
    $customer_rec = get_customer_details($sales_rec->customer_id);

    //Customer Records
    $state_rec = (!empty($customer_rec->state_id)) ? get_state_details($customer_rec->state_id) : '';
    $customer_state_name = (!empty($state_rec)) ? $state_rec->state : $store_rec->state;
    
    //Customer Find Previous Due & Total Due
    $previous_due=($customer_rec->sales_due)-($sales_rec->grand_total-$sales_rec->paid_amount);
    $previous_due = ($previous_due>0) ? $previous_due : 0;
    $total_due=$customer_rec->sales_due;

    //Customer Shipping Address Records
    $shipping_country='';
    $shipping_state='';
    $shipping_city='';
    $shipping_address='';
    $shipping_postcode='';
    if(!empty($customer_rec->shippingaddress_id)){
        $Q2 = $this->db->select("c.country,s.state,a.city,a.postcode,a.address")
                        ->where("a.id",$customer_rec->shippingaddress_id)
                        ->from("db_shippingaddress a")
                        ->join("db_country c","c.id = a.country_id",'left')
                        ->join("db_states s","s.id = a.state_id",'left')
                        ->get();                    
        if($Q2->num_rows()>0){
          $shipping_country=$Q2->row()->country;
          $shipping_state=$Q2->row()->state;
          $shipping_city=$Q2->row()->city;
          $shipping_address=$Q2->row()->address;
          $shipping_postcode=$Q2->row()->postcode;
        }
      }

    //Customer if Coupon Code applied, then get Records
    $coupon_code = '';
    $coupon_type = '';
    $coupon_value=0;
    if(!empty($sales_rec->coupon_id)){
      $coupon_details =get_customer_coupon_details($sales_rec->coupon_id);
      $coupon_code =$coupon_details->code;
      $coupon_value =$coupon_details->value;
      $coupon_type =$coupon_details->type;
    }

    ?>

<div class="invoice-container">
    <!-- Header Section -->
    <div class="invoice-header">
        <div class="company-details">
            <?php if(!empty($store_logo)): ?>
                <img src="<?= base_url($store_logo);?>" class="company-logo" alt="Logo">
            <?php endif; ?>
            <div class="company-name"><?= $store_rec->store_name; ?></div>
            <div class="company-info">
                <?= $store_rec->address; ?><br>
                <?= $this->lang->line('mobile').": ".$store_rec->mobile; ?>
                <?php if(!empty(trim($store_rec->email))): ?>
                    <br><?= $this->lang->line('email').": ".$store_rec->email; ?>
                <?php endif; ?>
                <?php if(!empty(trim($store_rec->gst_no))): ?>
                    <br><?= $this->lang->line('gst_number').": ".$store_rec->gst_no; ?>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="invoice-details">
            <h1 class="invoice-title">TAX INVOICE</h1>
            <div class="invoice-meta">
                <div class="invoice-meta-item">
                    <span class="meta-label">Invoice No:</span>
                    <span class="meta-value"><?= $sales_rec->sales_code; ?></span>
                </div>
                <div class="invoice-meta-item">
                    <span class="meta-label">Date:</span>
                    <span class="meta-value"><?= show_date($sales_rec->sales_date); ?></span>
                </div>
                <?php if(!empty($sales_rec->reference_no)): ?>
                <div class="invoice-meta-item">
                    <span class="meta-label">Reference:</span>
                    <span class="meta-value"><?= $sales_rec->reference_no; ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Customer Section -->
    <div class="customer-section">
        <div class="customer-block">
            <h3 class="section-title">Bill To</h3>
            <div class="customer-info">
                <strong><?= $customer_rec->customer_name; ?></strong><br>
                <?php if(!empty(trim($customer_rec->address))): ?>
                    <?= $customer_rec->address; ?><br>
                <?php endif; ?>
                <?php if(!empty(trim($customer_rec->mobile))): ?>
                    <?= $this->lang->line('mobile').": ".$customer_rec->mobile; ?><br>
                <?php endif; ?>
                <?php if(!empty(trim($customer_rec->email))): ?>
                    <?= $this->lang->line('email').": ".$customer_rec->email; ?><br>
                <?php endif; ?>
                <?php if(!empty(trim($customer_rec->gstin))): ?>
                    <?= $this->lang->line('gstin').": ".$customer_rec->gstin; ?>
                <?php endif; ?>
            </div>
        </div>

        <?php if(!empty($shipping_address)): ?>
        <div class="customer-block">
            <h3 class="section-title">Ship To</h3>
            <div class="customer-info">
                <strong><?= $customer_rec->customer_name; ?></strong><br>
                <?= $shipping_address; ?><br>
                <?= $shipping_city.", ".$shipping_state; ?><br>
                <?= $shipping_country." - ".$shipping_postcode; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th width="5%" class="text-center">#</th>
                <th width="35%">Item & Description</th>
                <th width="10%" class="text-center">HSN/SAC</th>
                <th width="8%" class="text-center">GST</th>
                <th width="8%" class="text-center">Qty</th>
                <th width="10%" class="text-right">Rate</th>
                <th width="10%" class="text-center">Discount</th>
                <th width="14%" class="text-right">Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php
              $i=0;
              $tot_qty=0;
              $tot_sales_price=0;
              $tot_tax_amt=0;
              $tot_discount_amt=0;
              $tot_unit_total_cost=0;
              $tot_total_cost=0;
              $tot_before_tax=0;

              $this->db->select(" a.description,c.item_name, a.sales_qty,a.tax_type,
                                  a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
                                  a.discount_input,a.discount_amt, a.unit_total_cost,
                                  a.total_cost , d.unit_name,c.sku,c.hsn
                              ");
              $this->db->where("a.sales_id",$sales_id);
              $this->db->from("db_salesitems a");
              $this->db->join("db_tax b","b.id=a.tax_id","left");
              $this->db->join("db_items c","c.id=a.item_id","left");
              $this->db->join("db_units d","d.id = c.unit_id","left");
              $q2=$this->db->get();

              foreach ($q2->result() as $res2) {
                  $discount = (empty($res2->discount_input)||$res2->discount_input==0)? "0.00":store_number_format($res2->discount_input)."%";
                  $before_tax=$res2->price_per_unit;
                  $tot_cost_before_tax=$res2->total_cost;
                  echo "<tr>";  
                  echo "<td class='text-center'>".++$i."</td>";
                  echo "<td>";
                  echo $res2->item_name;
                  echo (!empty($res2->description)) ? "<br><i>[".nl2br($res2->description)."]</i>" : '';
                  echo "</td>";
                  echo "<td class='text-center'>".$res2->hsn."</td>";
                  
                  echo "<td class='text-center'>".store_number_format($res2->tax)."%</td>";
                  echo "<td class='text-center'>".format_qty($res2->sales_qty)."</td>";
                  echo "<td class='text-right'>".store_number_format($before_tax)."</td>";
                  echo "<td class='text-center'>".$discount."</td>";
                  echo "<td class='text-right'>".store_number_format($tot_cost_before_tax)."</td>";
                  echo "</tr>";  
                  $tot_qty +=$res2->sales_qty;
                  $tot_sales_price +=$res2->price_per_unit;
                  $tot_tax_amt +=$res2->tax_amt;
                  $tot_discount_amt +=$res2->discount_amt;
                  $tot_unit_total_cost +=$res2->unit_total_cost;
                  $tot_before_tax +=$before_tax;
                  $tot_total_cost +=$tot_cost_before_tax;
              }
              ?>
        </tbody>
    </table>

    <!-- Summary Section -->
    <div class="invoice-summary">
        <div class="summary-table">
            <div class="summary-row">
                <span class="summary-label">Subtotal</span>
                <span class="summary-value"><?= store_number_format($tot_total_cost); ?></span>
            </div>
            
            <?php if($tot_cgst_amt!=0 && !empty($tot_cgst_amt)): ?>
            <div class="summary-row">
                <span class="summary-label">CGST</span>
                <span class="summary-value"><?= store_number_format($tot_cgst_amt); ?></span>
            </div>
            <div class="summary-row">
                <span class="summary-label">SGST</span>
                <span class="summary-value"><?= store_number_format($tot_sgst_amt); ?></span>
            </div>
            <?php else: ?>
            <div class="summary-row">
                <span class="summary-label">IGST</span>
                <span class="summary-value"><?= store_number_format($tot_igst_amt); ?></span>
            </div>
            <?php endif; ?>

            <?php if($sales_rec->other_charges_amt!=0 && !empty($sales_rec->other_charges_amt)): ?>
            <div class="summary-row">
                <span class="summary-label">Other Charges</span>
                <span class="summary-value"><?= store_number_format($sales_rec->other_charges_amt); ?></span>
            </div>
            <?php endif; ?>

            <?php if($sales_rec->round_off!=0): ?>
            <div class="summary-row">
                <span class="summary-label">Round Off</span>
                <span class="summary-value"><?= store_number_format($sales_rec->round_off); ?></span>
            </div>
            <?php endif; ?>

            <div class="summary-total">
                <div class="summary-row" style="border: none;">
                    <span class="summary-label">Grand Total</span>
                    <span class="summary-value"><?= store_number_format($sales_rec->grand_total); ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Amount in Words -->
    <div class="amount-words">
        <span class="amount-words-label">Amount in Words:</span>
        <?= $this->session->userdata('currency_code')." ".no_to_words($sales_rec->grand_total); ?>
    </div>

    <!-- Bank Details -->
    <?php if(!empty($store_rec->bank_details)): ?>
    <div class="bank-details">
        <div class="bank-details-title">Bank Details</div>
        <?= nl2br($store_rec->bank_details); ?>
    </div>
    <?php endif; ?>

    <!-- Notes -->
    <?php if(!empty($sales_rec->sales_note)): ?>
    <div class="mt-20 mb-20">
        <strong>Note:</strong> <?= nl2br($sales_rec->sales_note); ?>
    </div>
    <?php endif; ?>

    <!-- Footer -->
    <div class="invoice-footer">
        <div class="signature-section">
            <div class="signature-block">
                <div class="signature-line">Customer Signature</div>
            </div>
            <div class="signature-block">
                <div class="signature-line">Authorized Signatory</div>
            </div>
        </div>

        <div class="footer-notes">
            <?php if(!empty($store_rec->sales_invoice_footer_text)): ?>
                <?= $store_rec->sales_invoice_footer_text; ?><br>
            <?php endif; ?>
            Thank You For Your Business!
        </div>
    </div>
</div>

</body>
</html>