<?php
/**
 * POS System PHP 8+ Compatibility Layer
 */

// Function to handle null values in calculations
if (!function_exists('safe_number')) {
    function safe_number($value, $default = 0) {
        return is_numeric($value) ? (float)$value : (float)$default;
    }
}

// Function to handle array access safely
if (!function_exists('safe_array_get')) {
    function safe_array_get($array, $key, $default = null) {
        return isset($array[$key]) ? $array[$key] : $default;
    }
}

// Function to handle string operations safely
if (!function_exists('safe_string')) {
    function safe_string($value, $default = '') {
        return is_string($value) ? $value : (string)$default;
    }
}

// Handle POST data safely for PHP 8+
if (!function_exists('safe_post')) {
    function safe_post($key, $default = null) {
        return isset($_POST[$key]) ? $_POST[$key] : $default;
    }
}

// Handle GET data safely for PHP 8+
if (!function_exists('safe_get')) {
    function safe_get($key, $default = null) {
        return isset($_GET[$key]) ? $_GET[$key] : $default;
    }
}
?>