<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Test_woo extends CI_Controller {
    
    public function index() {
        // Test WooCommerce database connection
        echo "<h2>WooCommerce Database Connection Test</h2>";
        
        try {
            // Load the database config
            $this->load->database('woocommerce');
            
            // Test basic connection with mysqli
            $connection = new mysqli('lightning.megpanel.com', 'porpatas_smacam_usr25', 'C%Scl%RQvFxVFR2{', 'porpatas_smacam_db25');
            
            if ($connection->connect_error) {
                echo "✗ Connection failed: " . $connection->connect_error . "<br>";
            } else {
                echo "✓ Direct mysqli connection: SUCCESS<br>";
                
                // Test if wp_posts table exists
                $result = $connection->query("SHOW TABLES LIKE 'wp_posts'");
                if($result && $result->num_rows > 0) {
                    echo "✓ wp_posts table found<br>";
                    
                    // Count orders
                    $orders = $connection->query("SELECT COUNT(*) as count FROM wp_posts WHERE post_type = 'shop_order'");
                    if($orders) {
                        $count = $orders->fetch_assoc()['count'];
                        echo "✓ Found $count WooCommerce orders<br>";
                        
                        // Show recent order
                        $recent = $connection->query("SELECT ID, post_date, post_status FROM wp_posts WHERE post_type = 'shop_order' ORDER BY post_date DESC LIMIT 5");
                        if($recent && $recent->num_rows > 0) {
                            echo "<h3>Recent Orders:</h3>";
                            echo "<table border='1' style='border-collapse:collapse; padding:5px;'>";
                            echo "<tr><th>Order ID</th><th>Date</th><th>Status</th></tr>";
                            while($order = $recent->fetch_assoc()) {
                                echo "<tr><td>#{$order['ID']}</td><td>{$order['post_date']}</td><td>{$order['post_status']}</td></tr>";
                            }
                            echo "</table>";
                        }
                    }
                } else {
                    echo "✗ wp_posts table not found<br>";
                    echo "<h3>Available tables:</h3>";
                    $all_tables = $connection->query("SHOW TABLES");
                    echo "<ul>";
                    while($table = $all_tables->fetch_array()) {
                        echo "<li>" . $table[0] . "</li>";
                    }
                    echo "</ul>";
                }
                
                $connection->close();
            }
            
            // Now test with CodeIgniter database
            echo "<hr><h3>Testing CodeIgniter Database Connection:</h3>";
            $woo_db = $this->load->database('woocommerce', TRUE);
            
            $query = $woo_db->query("SELECT COUNT(*) as count FROM wp_posts WHERE post_type = 'shop_order'");
            if($query) {
                $count = $query->row()->count;
                echo "✓ CodeIgniter DB connection works. Found $count orders<br>";
            } else {
                echo "✗ CodeIgniter DB connection failed<br>";
            }
            
        } catch(Exception $e) {
            echo "✗ Error: " . $e->getMessage() . "<br>";
            echo "✗ Stack trace: " . $e->getTraceAsString();
        }
        
        echo "<hr>";
        echo "<p><a href='" . base_url('reports/woocommerce_orders') . "'>Go to WooCommerce Orders Report</a></p>";
        echo "<p><a href='" . base_url('dashboard') . "'>Go to Dashboard</a></p>";
    }
}
?>
