<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sales_types extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('sales_types_model','sales_types');
	}

	public function add(){
		// $this->permission_check('sales_types_add'); // Temporarily disabled for testing
		$data=$this->data;
		$data['page_title']='Sales Types'; // $this->lang->line('sales_types');
		$this->load->view('sales_type', $data);
	}
	public function new_sales_type(){

		$this->form_validation->set_rules('sales_type_name', 'Sales Type Name', 'trim|required');
		$this->form_validation->set_rules('sales_type_initial', 'Sales Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			
			$result=$this->sales_types->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Sales Type Name and Initial.";
		}
	}
	public function update($id){
		// $this->belong_to('db_sales_types',$id); // Temporarily disabled
		// $this->permission_check('sales_types_edit'); // Temporarily disabled
		$data=$this->data;
		$result=$this->sales_types->get_details($id,$data);
		$data=array_merge($data,$result);
		$data['page_title']='Sales Types'; // $this->lang->line('sales_types');
		$this->load->view('sales_type', $data);
	}
	public function update_sales_type(){
		$this->form_validation->set_rules('sales_type_name', 'Sales Type Name', 'trim|required');
		$this->form_validation->set_rules('sales_type_initial', 'Sales Type Initial', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$result=$this->sales_types->update_sales_type();
			echo $result;
		} else {
			echo "Please Enter Sales Type name and Initial.";
		}
	}
	public function index(){
		// $this->permission_check('sales_types_view'); // Temporarily disabled for testing
		$data=$this->data;
		$data['page_title']='Sales Types List'; // $this->lang->line('sales_types_list');
		$this->load->view('sales-types-list', $data);
	}

	public function ajax_list()
	{
		$list = $this->sales_types->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $sales_type) {
			$no++;
			$row = array();
			
			$row[] = $sales_type->sales_type_name;
			$row[] = $sales_type->sales_type_initial;
			$row[] = $sales_type->description;

			 		if($sales_type->status==1){ 
			 			$str= "<span onclick='update_status(".$sales_type->id.",0)' id='span_".$sales_type->id."'  class='label label-success' style='cursor:pointer'>Active </span>";}
					else{ 
						$str = "<span onclick='update_status(".$sales_type->id.",1)' id='span_".$sales_type->id."'  class='label label-danger' style='cursor:pointer'> Inactive </span>";
					}
			$row[] = $str;			
			         $str2 = '<div class="btn-group" title="View Account">
										<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
											Action <span class="caret"></span>
										</a>
										<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

											if($this->permissions('sales_types_edit'))
											$str2.='<li>
												<a title="Edit Record ?" href="'.base_url('sales_types/update/'.$sales_type->id).'">
													<i class="fa fa-fw fa-edit text-blue"></i>Edit
												</a>
											</li>';

											if($this->permissions('sales_types_delete'))
											$str2.='<li>
												<a style="cursor:pointer" title="Delete Record ?" onclick="delete_sales_type('.$sales_type->id.')">
													<i class="fa fa-fw fa-trash text-red"></i>Delete
												</a>
											</li>
											
										</ul>
									</div>';			
			$row[] = $str2;

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->sales_types->count_all(),
						"recordsFiltered" => $this->sales_types->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}

	public function update_status(){
		// $this->permission_check_with_msg('sales_types_edit'); // Temporarily disabled
		$id=$this->input->post('id');
		$status=$this->input->post('status');
		$result=$this->sales_types->update_status($id,$status);
		return $result;
	}
	public function delete_sales_type(){
		// $this->permission_check_with_msg('sales_types_delete'); // Temporarily disabled
		$id=$this->input->post('q_id');
		$result=$this->sales_types->delete_sales_type($id);
		return $result;
	}
	//ITS FROM POP UP MODAL
   public function add_sales_type_modal(){
      $this->form_validation->set_rules('sales_type_name', 'Sales Type Name', 'trim|required');
      $this->form_validation->set_rules('sales_type_initial', 'Sales Type Initial', 'trim|required');
      if ($this->form_validation->run() == TRUE) {
         $result=$this->sales_types->verify_and_save();
         //fetch latest sales type details
         $res=array();
         $query=$this->db->select("id,sales_type_name,sales_type_initial")
                  ->where('store_id',get_current_store_id())
                  ->from('db_sales_types')
                  ->order_by('id','desc')
                  ->limit(1)->get();
         $res['id']=$query->row()->id;
         $res['sales_type']=$query->row()->sales_type_name;
         $res['sales_type_initial']=$query->row()->sales_type_initial;
         $res['result']=$result;
         
         echo json_encode($res);

      } 
      else {
         echo "Please Fill Compulsory(* marked) Fields.";
      }
   }
   //END
}
